/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.CompletedFetch;
import org.apache.kafka.clients.consumer.internals.ConsumerUtils;
import org.apache.kafka.clients.consumer.internals.FetchBuffer;
import org.apache.kafka.clients.consumer.internals.FetchMetricsAggregator;
import org.apache.kafka.clients.consumer.internals.FetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FetchBufferTest {
    private final Time time = new MockTime(0L, 0L, 0L);
    private final TopicPartition topicAPartition0 = new TopicPartition("topic-a", 0);
    private final TopicPartition topicAPartition1 = new TopicPartition("topic-a", 1);
    private final TopicPartition topicAPartition2 = new TopicPartition("topic-a", 2);
    private final Set<TopicPartition> allPartitions = FetchBufferTest.partitions(this.topicAPartition0, this.topicAPartition1, this.topicAPartition2);
    private LogContext logContext;
    private SubscriptionState subscriptions;
    private FetchMetricsManager metricsManager;

    @BeforeEach
    public void setup() {
        this.logContext = new LogContext();
        Properties p = new Properties();
        p.put("bootstrap.servers", "localhost:9092");
        p.put("key.deserializer", StringSerializer.class.getName());
        p.put("value.deserializer", StringSerializer.class.getName());
        ConsumerConfig config = new ConsumerConfig(p);
        this.subscriptions = ConsumerUtils.createSubscriptionState((ConsumerConfig)config, (LogContext)this.logContext);
        Metrics metrics = ConsumerUtils.createMetrics((ConsumerConfig)config, (Time)this.time);
        this.metricsManager = ConsumerUtils.createFetchMetricsManager((Metrics)metrics);
    }

    @Test
    public void testBasicPeekAndPoll() {
        try (FetchBuffer fetchBuffer = new FetchBuffer(this.logContext);){
            CompletedFetch completedFetch = this.completedFetch(this.topicAPartition0);
            Assertions.assertTrue((boolean)fetchBuffer.isEmpty());
            fetchBuffer.add(completedFetch);
            Assertions.assertTrue((boolean)fetchBuffer.hasCompletedFetches(p -> true));
            Assertions.assertFalse((boolean)fetchBuffer.isEmpty());
            Assertions.assertNotNull((Object)fetchBuffer.peek());
            Assertions.assertSame((Object)completedFetch, (Object)fetchBuffer.peek());
            Assertions.assertSame((Object)completedFetch, (Object)fetchBuffer.poll());
            Assertions.assertNull((Object)fetchBuffer.peek());
        }
    }

    @Test
    public void testCloseClearsData() {
        try (FetchBuffer fetchBuffer = null;){
            fetchBuffer = new FetchBuffer(this.logContext);
            Assertions.assertNull((Object)fetchBuffer.nextInLineFetch());
            Assertions.assertTrue((boolean)fetchBuffer.isEmpty());
            fetchBuffer.add(this.completedFetch(this.topicAPartition0));
            Assertions.assertFalse((boolean)fetchBuffer.isEmpty());
            fetchBuffer.setNextInLineFetch(this.completedFetch(this.topicAPartition0));
            Assertions.assertNotNull((Object)fetchBuffer.nextInLineFetch());
        }
        Assertions.assertNull((Object)fetchBuffer.nextInLineFetch());
        Assertions.assertTrue((boolean)fetchBuffer.isEmpty());
    }

    @Test
    public void testBufferedPartitions() {
        try (FetchBuffer fetchBuffer = new FetchBuffer(this.logContext);){
            fetchBuffer.setNextInLineFetch(this.completedFetch(this.topicAPartition0));
            fetchBuffer.add(this.completedFetch(this.topicAPartition1));
            fetchBuffer.add(this.completedFetch(this.topicAPartition2));
            Assertions.assertEquals(this.allPartitions, (Object)fetchBuffer.bufferedPartitions());
            fetchBuffer.setNextInLineFetch(null);
            Assertions.assertEquals(FetchBufferTest.partitions(this.topicAPartition1, this.topicAPartition2), (Object)fetchBuffer.bufferedPartitions());
            fetchBuffer.poll();
            Assertions.assertEquals(FetchBufferTest.partitions(this.topicAPartition2), (Object)fetchBuffer.bufferedPartitions());
            fetchBuffer.poll();
            Assertions.assertEquals(FetchBufferTest.partitions(new TopicPartition[0]), (Object)fetchBuffer.bufferedPartitions());
        }
    }

    @Test
    public void testAddAllAndRetainAll() {
        try (FetchBuffer fetchBuffer = new FetchBuffer(this.logContext);){
            fetchBuffer.setNextInLineFetch(this.completedFetch(this.topicAPartition0));
            fetchBuffer.addAll(Arrays.asList(this.completedFetch(this.topicAPartition1), this.completedFetch(this.topicAPartition2)));
            Assertions.assertEquals(this.allPartitions, (Object)fetchBuffer.bufferedPartitions());
            fetchBuffer.retainAll(FetchBufferTest.partitions(this.topicAPartition1, this.topicAPartition2));
            Assertions.assertEquals(FetchBufferTest.partitions(this.topicAPartition1, this.topicAPartition2), (Object)fetchBuffer.bufferedPartitions());
            fetchBuffer.retainAll(FetchBufferTest.partitions(this.topicAPartition2));
            Assertions.assertEquals(FetchBufferTest.partitions(this.topicAPartition2), (Object)fetchBuffer.bufferedPartitions());
            fetchBuffer.retainAll(FetchBufferTest.partitions(new TopicPartition[0]));
            Assertions.assertEquals(FetchBufferTest.partitions(new TopicPartition[0]), (Object)fetchBuffer.bufferedPartitions());
        }
    }

    @Test
    public void testWakeup() throws Exception {
        try (FetchBuffer fetchBuffer = new FetchBuffer(this.logContext);){
            Thread waitingThread = new Thread(() -> {
                Timer timer = this.time.timer(Duration.ofMinutes(1L));
                fetchBuffer.awaitNotEmpty(timer);
            });
            waitingThread.start();
            fetchBuffer.wakeup();
            waitingThread.join(Duration.ofSeconds(30L).toMillis());
            Assertions.assertFalse((boolean)waitingThread.isAlive());
        }
    }

    private CompletedFetch completedFetch(TopicPartition tp) {
        FetchResponseData.PartitionData partitionData = new FetchResponseData.PartitionData();
        FetchMetricsAggregator metricsAggregator = new FetchMetricsAggregator(this.metricsManager, this.allPartitions);
        return new CompletedFetch(this.logContext.logger(CompletedFetch.class), this.subscriptions, BufferSupplier.create(), tp, partitionData, metricsAggregator, Long.valueOf(0L));
    }

    private static Set<TopicPartition> partitions(TopicPartition ... partitions) {
        return new HashSet<TopicPartition>(Arrays.asList(partitions));
    }
}

