/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.clients.consumer.internals.ShareAcknowledgementMode;
import org.apache.kafka.common.config.ConfigException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ShareAcknowledgementModeTest {
    ShareAcknowledgementModeTest() {
    }

    @Test
    public void testFromString() {
        Assertions.assertEquals((Object)ShareAcknowledgementMode.IMPLICIT, (Object)ShareAcknowledgementMode.fromString((String)"implicit"));
        Assertions.assertEquals((Object)ShareAcknowledgementMode.EXPLICIT, (Object)ShareAcknowledgementMode.fromString((String)"explicit"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShareAcknowledgementMode.fromString((String)"invalid"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShareAcknowledgementMode.fromString((String)"IMPLICIT"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShareAcknowledgementMode.fromString((String)"EXPLICIT"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShareAcknowledgementMode.fromString((String)""));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ShareAcknowledgementMode.fromString(null));
    }

    @Test
    public void testValidator() {
        ShareAcknowledgementMode.Validator validator = new ShareAcknowledgementMode.Validator();
        Assertions.assertDoesNotThrow(() -> validator.ensureValid("test", (Object)"implicit"));
        Assertions.assertDoesNotThrow(() -> validator.ensureValid("test", (Object)"explicit"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)"invalid"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)"IMPLICIT"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)"EXPLICIT"));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", (Object)""));
        Assertions.assertThrows(ConfigException.class, () -> validator.ensureValid("test", null));
    }

    @Test
    public void testEqualsAndHashCode() {
        ShareAcknowledgementMode mode1 = ShareAcknowledgementMode.IMPLICIT;
        ShareAcknowledgementMode mode2 = ShareAcknowledgementMode.IMPLICIT;
        ShareAcknowledgementMode mode3 = ShareAcknowledgementMode.EXPLICIT;
        Assertions.assertEquals((Object)mode1, (Object)mode2);
        Assertions.assertNotEquals((Object)mode1, (Object)mode3);
        Assertions.assertNotEquals((Object)mode2, (Object)mode3);
        Assertions.assertEquals((int)mode1.hashCode(), (int)mode2.hashCode());
        Assertions.assertNotEquals((int)mode1.hashCode(), (int)mode3.hashCode());
    }
}

