/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.AcknowledgeType;
import org.apache.kafka.clients.consumer.internals.Acknowledgements;
import org.apache.kafka.clients.consumer.internals.FetchConfig;
import org.apache.kafka.clients.consumer.internals.ShareSessionHandler;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ShareFetchRequestData;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ShareFetchRequest;
import org.apache.kafka.common.requests.ShareFetchResponse;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

@Timeout(value=120L)
public class ShareSessionHandlerTest {
    private static final LogContext LOG_CONTEXT = new LogContext("[ShareSessionHandler]=");
    private final FetchConfig fetchConfig = new FetchConfig(1, 0x3200000, 500, 0x100000, 500, true, "", IsolationLevel.READ_UNCOMMITTED);

    private static LinkedHashMap<TopicPartition, TopicIdPartition> reqMap(TopicIdPartition ... entries) {
        LinkedHashMap<TopicPartition, TopicIdPartition> map = new LinkedHashMap<TopicPartition, TopicIdPartition>();
        for (TopicIdPartition entry : entries) {
            map.put(entry.topicPartition(), entry);
        }
        return map;
    }

    private static ArrayList<TopicIdPartition> reqFetchList(ShareFetchRequestData requestData, Map<Uuid, String> topicNames) {
        ArrayList<TopicIdPartition> tips = new ArrayList<TopicIdPartition>();
        requestData.topics().forEach(topic -> topic.partitions().forEach(partition -> tips.add(new TopicIdPartition(topic.topicId(), partition.partitionIndex(), (String)topicNames.get(topic.topicId())))));
        return tips;
    }

    private static ArrayList<TopicIdPartition> reqForgetList(ShareFetchRequestData requestData, Map<Uuid, String> topicNames) {
        ArrayList<TopicIdPartition> tips = new ArrayList<TopicIdPartition>();
        requestData.forgottenTopicsData().forEach(topic -> topic.partitions().forEach(partition -> tips.add(new TopicIdPartition(topic.topicId(), partition.intValue(), (String)topicNames.get(topic.topicId())))));
        return tips;
    }

    private static void assertMapEquals(Map<TopicPartition, TopicIdPartition> expected, Map<TopicPartition, TopicIdPartition> actual) {
        Iterator<Map.Entry<TopicPartition, TopicIdPartition>> expectedIter = expected.entrySet().iterator();
        Iterator<Map.Entry<TopicPartition, TopicIdPartition>> actualIter = actual.entrySet().iterator();
        int i = 1;
        while (expectedIter.hasNext()) {
            Map.Entry<TopicPartition, TopicIdPartition> expectedEntry = expectedIter.next();
            if (!actualIter.hasNext()) {
                Assertions.fail((String)("Element " + i + " not found."));
            }
            Map.Entry<TopicPartition, TopicIdPartition> actualEntry = actualIter.next();
            Assertions.assertEquals((Object)expectedEntry.getKey(), (Object)actualEntry.getKey(), (String)("Element " + i + " had a different TopicPartition than expected."));
            Assertions.assertEquals((Object)expectedEntry.getValue(), (Object)actualEntry.getValue(), (String)("Element " + i + " had different PartitionData than expected."));
            ++i;
        }
        if (actualIter.hasNext()) {
            Assertions.fail((String)("Unexpected element " + i + " found."));
        }
    }

    @SafeVarargs
    private static void assertMapsEqual(Map<TopicPartition, TopicIdPartition> expected, Map<TopicPartition, TopicIdPartition> ... actuals) {
        for (Map<TopicPartition, TopicIdPartition> actual : actuals) {
            ShareSessionHandlerTest.assertMapEquals(expected, actual);
        }
    }

    private static void assertListEquals(List<TopicIdPartition> expected, List<TopicIdPartition> actual) {
        for (TopicIdPartition expectedPart : expected) {
            if (actual.contains(expectedPart)) continue;
            Assertions.fail((String)("Failed to find expected partition " + String.valueOf(expectedPart)));
        }
        for (TopicIdPartition actualPart : actual) {
            if (expected.contains(actualPart)) continue;
            Assertions.fail((String)("Found unexpected partition " + String.valueOf(actualPart)));
        }
    }

    private static LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> buildResponseData(RespEntry ... entries) {
        LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData> topicIdPartitionToPartition = new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        for (RespEntry entry : entries) {
            ShareFetchResponseData.PartitionData partitionData = new ShareFetchResponseData.PartitionData().setPartitionIndex(entry.part.partition());
            topicIdPartitionToPartition.put(entry.part, partitionData);
        }
        return topicIdPartitionToPartition;
    }

    @ParameterizedTest
    @EnumSource(value=Errors.class, names={"INVALID_SHARE_SESSION_EPOCH", "SHARE_SESSION_NOT_FOUND", "SHARE_SESSION_LIMIT_REACHED"})
    public void testShareSession(Errors error) {
        String groupId = "G1";
        Uuid memberId = Uuid.randomUuid();
        ShareSessionHandler handler = new ShareSessionHandler(LOG_CONTEXT, 1, memberId);
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        Uuid fooId = this.addTopicId(topicNames, "foo");
        TopicIdPartition foo0 = new TopicIdPartition(fooId, 0, "foo");
        TopicIdPartition foo1 = new TopicIdPartition(fooId, 1, "foo");
        handler.addPartitionToFetch(foo0, null);
        handler.addPartitionToFetch(foo1, null);
        ShareFetchRequestData requestData1 = ((ShareFetchRequest)handler.newShareFetchBuilder(groupId, this.fetchConfig).build()).data();
        ArrayList<TopicIdPartition> expectedToSend1 = new ArrayList<TopicIdPartition>();
        expectedToSend1.add(new TopicIdPartition(fooId, 0, "foo"));
        expectedToSend1.add(new TopicIdPartition(fooId, 1, "foo"));
        ShareSessionHandlerTest.assertListEquals(expectedToSend1, ShareSessionHandlerTest.reqFetchList(requestData1, topicNames));
        Assertions.assertEquals((Object)memberId.toString(), (Object)requestData1.memberId());
        ShareFetchResponse resp = ShareFetchResponse.of((Errors)Errors.NONE, (int)0, ShareSessionHandlerTest.buildResponseData(new RespEntry("foo", 0, fooId), new RespEntry("foo", 1, fooId)), List.of(), (int)0);
        handler.handleResponse(resp, ApiKeys.SHARE_FETCH.latestVersion(true));
        Uuid barId = this.addTopicId(topicNames, "bar");
        TopicIdPartition bar0 = new TopicIdPartition(barId, 0, "bar");
        handler.addPartitionToFetch(foo0, null);
        handler.addPartitionToFetch(foo1, null);
        handler.addPartitionToFetch(bar0, null);
        ShareFetchRequestData requestData2 = ((ShareFetchRequest)handler.newShareFetchBuilder(groupId, this.fetchConfig).build()).data();
        ShareSessionHandlerTest.assertMapsEqual(ShareSessionHandlerTest.reqMap(new TopicIdPartition(fooId, 0, "foo"), new TopicIdPartition(fooId, 1, "foo"), new TopicIdPartition(barId, 0, "bar")), handler.sessionPartitionMap());
        ArrayList<TopicIdPartition> expectedToSend2 = new ArrayList<TopicIdPartition>();
        expectedToSend2.add(new TopicIdPartition(barId, 0, "bar"));
        ShareSessionHandlerTest.assertListEquals(expectedToSend2, ShareSessionHandlerTest.reqFetchList(requestData2, topicNames));
        ShareFetchResponse resp2 = ShareFetchResponse.of((Errors)Errors.NONE, (int)0, ShareSessionHandlerTest.buildResponseData(new RespEntry("foo", 1, fooId)), List.of(), (int)0);
        handler.handleResponse(resp2, ApiKeys.SHARE_FETCH.latestVersion(true));
        ShareFetchResponse resp3 = ShareFetchResponse.of((Errors)error, (int)0, new LinkedHashMap(), List.of(), (int)0);
        handler.handleResponse(resp3, ApiKeys.SHARE_FETCH.latestVersion(true));
        ShareFetchRequestData requestData4 = ((ShareFetchRequest)handler.newShareFetchBuilder(groupId, this.fetchConfig).build()).data();
        Assertions.assertEquals((Object)requestData2.memberId(), (Object)requestData4.memberId());
        Assertions.assertEquals((int)0, (int)requestData4.shareSessionEpoch());
        ShareSessionHandlerTest.assertMapsEqual(ShareSessionHandlerTest.reqMap(new TopicIdPartition(fooId, 0, "foo"), new TopicIdPartition(fooId, 1, "foo"), new TopicIdPartition(barId, 0, "bar")), handler.sessionPartitionMap());
        ArrayList<TopicIdPartition> expectedToSend4 = new ArrayList<TopicIdPartition>();
        expectedToSend4.add(new TopicIdPartition(fooId, 0, "foo"));
        expectedToSend4.add(new TopicIdPartition(fooId, 1, "foo"));
        expectedToSend4.add(new TopicIdPartition(barId, 0, "bar"));
        ShareSessionHandlerTest.assertListEquals(expectedToSend4, ShareSessionHandlerTest.reqFetchList(requestData4, topicNames));
    }

    @Test
    public void testPartitionRemoval() {
        String groupId = "G1";
        Uuid memberId = Uuid.randomUuid();
        ShareSessionHandler handler = new ShareSessionHandler(LOG_CONTEXT, 1, memberId);
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        Uuid fooId = this.addTopicId(topicNames, "foo");
        Uuid barId = this.addTopicId(topicNames, "bar");
        TopicIdPartition foo0 = new TopicIdPartition(fooId, 0, "foo");
        TopicIdPartition foo1 = new TopicIdPartition(fooId, 1, "foo");
        TopicIdPartition bar0 = new TopicIdPartition(barId, 0, "bar");
        handler.addPartitionToFetch(foo0, null);
        handler.addPartitionToFetch(foo1, null);
        handler.addPartitionToFetch(bar0, null);
        ShareFetchRequestData requestData1 = ((ShareFetchRequest)handler.newShareFetchBuilder(groupId, this.fetchConfig).build()).data();
        ShareSessionHandlerTest.assertMapsEqual(ShareSessionHandlerTest.reqMap(new TopicIdPartition(fooId, 0, "foo"), new TopicIdPartition(fooId, 1, "foo"), new TopicIdPartition(barId, 0, "bar")), handler.sessionPartitionMap());
        ArrayList<TopicIdPartition> expectedToSend1 = new ArrayList<TopicIdPartition>();
        expectedToSend1.add(new TopicIdPartition(fooId, 0, "foo"));
        expectedToSend1.add(new TopicIdPartition(fooId, 1, "foo"));
        expectedToSend1.add(new TopicIdPartition(barId, 0, "bar"));
        ShareSessionHandlerTest.assertListEquals(expectedToSend1, ShareSessionHandlerTest.reqFetchList(requestData1, topicNames));
        Assertions.assertEquals((Object)memberId.toString(), (Object)requestData1.memberId());
        ShareFetchResponse resp = ShareFetchResponse.of((Errors)Errors.NONE, (int)0, ShareSessionHandlerTest.buildResponseData(new RespEntry("foo", 0, fooId), new RespEntry("foo", 1, fooId), new RespEntry("bar", 0, barId)), List.of(), (int)0);
        handler.handleResponse(resp, ApiKeys.SHARE_FETCH.latestVersion(true));
        handler.addPartitionToFetch(foo1, null);
        ShareFetchRequestData requestData2 = ((ShareFetchRequest)handler.newShareFetchBuilder(groupId, this.fetchConfig).build()).data();
        Assertions.assertEquals((Object)memberId.toString(), (Object)requestData2.memberId());
        Assertions.assertEquals((int)1, (int)requestData2.shareSessionEpoch());
        ShareSessionHandlerTest.assertMapsEqual(ShareSessionHandlerTest.reqMap(new TopicIdPartition(fooId, 1, "foo")), handler.sessionPartitionMap());
        Assertions.assertTrue((boolean)requestData2.topics().isEmpty());
        ArrayList<TopicIdPartition> expectedToForget2 = new ArrayList<TopicIdPartition>();
        expectedToForget2.add(new TopicIdPartition(fooId, 0, "foo"));
        expectedToForget2.add(new TopicIdPartition(barId, 0, "bar"));
        ShareSessionHandlerTest.assertListEquals(expectedToForget2, ShareSessionHandlerTest.reqForgetList(requestData2, topicNames));
        ShareFetchResponse resp2 = ShareFetchResponse.of((Errors)Errors.INVALID_SHARE_SESSION_EPOCH, (int)0, new LinkedHashMap(), List.of(), (int)0);
        handler.handleResponse(resp2, ApiKeys.SHARE_FETCH.latestVersion(true));
        handler.addPartitionToFetch(foo1, null);
        ShareFetchRequestData requestData3 = ((ShareFetchRequest)handler.newShareFetchBuilder(groupId, this.fetchConfig).build()).data();
        Assertions.assertEquals((Object)memberId.toString(), (Object)requestData3.memberId());
        Assertions.assertEquals((int)0, (int)requestData3.shareSessionEpoch());
        ShareSessionHandlerTest.assertMapsEqual(ShareSessionHandlerTest.reqMap(new TopicIdPartition(fooId, 1, "foo")), handler.sessionPartitionMap());
        ArrayList<TopicIdPartition> expectedToSend3 = new ArrayList<TopicIdPartition>();
        expectedToSend3.add(new TopicIdPartition(fooId, 1, "foo"));
        ShareSessionHandlerTest.assertListEquals(expectedToSend3, ShareSessionHandlerTest.reqFetchList(requestData3, topicNames));
    }

    @Test
    public void testTopicIdReplaced() {
        String groupId = "G1";
        Uuid memberId = Uuid.randomUuid();
        ShareSessionHandler handler = new ShareSessionHandler(LOG_CONTEXT, 1, memberId);
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        Uuid topicId1 = this.addTopicId(topicNames, "foo");
        TopicIdPartition tp = new TopicIdPartition(topicId1, 0, "foo");
        handler.addPartitionToFetch(tp, null);
        ShareFetchRequestData requestData1 = ((ShareFetchRequest)handler.newShareFetchBuilder(groupId, this.fetchConfig).build()).data();
        ShareSessionHandlerTest.assertMapsEqual(ShareSessionHandlerTest.reqMap(new TopicIdPartition(topicId1, 0, "foo")), handler.sessionPartitionMap());
        ArrayList<TopicIdPartition> expectedToSend1 = new ArrayList<TopicIdPartition>();
        expectedToSend1.add(new TopicIdPartition(topicId1, 0, "foo"));
        ShareSessionHandlerTest.assertListEquals(expectedToSend1, ShareSessionHandlerTest.reqFetchList(requestData1, topicNames));
        ShareFetchResponse resp = ShareFetchResponse.of((Errors)Errors.NONE, (int)0, ShareSessionHandlerTest.buildResponseData(new RespEntry("foo", 0, topicId1)), List.of(), (int)0);
        handler.handleResponse(resp, ApiKeys.SHARE_FETCH.latestVersion(true));
        Uuid topicId2 = this.addTopicId(topicNames, "foo");
        TopicIdPartition tp2 = new TopicIdPartition(topicId2, 0, "foo");
        handler.addPartitionToFetch(tp2, null);
        ShareFetchRequestData requestData2 = ((ShareFetchRequest)handler.newShareFetchBuilder(groupId, this.fetchConfig).build()).data();
        Assertions.assertEquals(Collections.singletonList(tp), ShareSessionHandlerTest.reqForgetList(requestData2, topicNames));
        ShareSessionHandlerTest.assertMapsEqual(ShareSessionHandlerTest.reqMap(new TopicIdPartition(topicId2, 0, "foo")), handler.sessionPartitionMap());
        ShareSessionHandlerTest.assertListEquals(Collections.singletonList(tp2), ShareSessionHandlerTest.reqFetchList(requestData2, topicNames));
        Assertions.assertEquals((Object)memberId.toString(), (Object)requestData2.memberId(), (String)"Did not use same session");
        Assertions.assertEquals((int)1, (int)requestData2.shareSessionEpoch(), (String)"Did not have correct epoch");
    }

    @Test
    public void testPartitionForgottenOnAcknowledgeOnly() {
        String groupId = "G1";
        Uuid memberId = Uuid.randomUuid();
        ShareSessionHandler handler = new ShareSessionHandler(LOG_CONTEXT, 1, memberId);
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        Uuid topicId = this.addTopicId(topicNames, "foo");
        TopicIdPartition foo0 = new TopicIdPartition(topicId, 0, "foo");
        handler.addPartitionToFetch(foo0, null);
        ShareFetchRequestData requestData1 = ((ShareFetchRequest)handler.newShareFetchBuilder(groupId, this.fetchConfig).build()).data();
        ShareSessionHandlerTest.assertMapsEqual(ShareSessionHandlerTest.reqMap(foo0), handler.sessionPartitionMap());
        ArrayList<TopicIdPartition> expectedToSend1 = new ArrayList<TopicIdPartition>();
        expectedToSend1.add(new TopicIdPartition(topicId, 0, "foo"));
        ShareSessionHandlerTest.assertListEquals(expectedToSend1, ShareSessionHandlerTest.reqFetchList(requestData1, topicNames));
        ShareFetchResponse resp = ShareFetchResponse.of((Errors)Errors.NONE, (int)0, ShareSessionHandlerTest.buildResponseData(new RespEntry("foo", 0, topicId)), List.of(), (int)0);
        handler.handleResponse(resp, ApiKeys.SHARE_FETCH.latestVersion(true));
        ShareFetchRequestData requestData2 = ((ShareFetchRequest)handler.newShareFetchBuilder(groupId, this.fetchConfig).build()).data();
        handler.addPartitionToAcknowledgeOnly(foo0, Acknowledgements.empty());
        Assertions.assertEquals(Collections.singletonList(foo0), ShareSessionHandlerTest.reqForgetList(requestData2, topicNames));
        Assertions.assertEquals((Object)memberId.toString(), (Object)requestData2.memberId(), (String)"Did not use same session");
        Assertions.assertEquals((int)1, (int)requestData2.shareSessionEpoch(), (String)"Did not have correct epoch");
    }

    @Test
    public void testForgottenPartitions() {
        String groupId = "G1";
        Uuid memberId = Uuid.randomUuid();
        ShareSessionHandler handler = new ShareSessionHandler(LOG_CONTEXT, 1, memberId);
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        Uuid topicId = this.addTopicId(topicNames, "foo");
        TopicIdPartition foo0 = new TopicIdPartition(topicId, 0, "foo");
        handler.addPartitionToFetch(foo0, null);
        ShareFetchRequestData requestData1 = ((ShareFetchRequest)handler.newShareFetchBuilder(groupId, this.fetchConfig).build()).data();
        ShareSessionHandlerTest.assertMapsEqual(ShareSessionHandlerTest.reqMap(foo0), handler.sessionPartitionMap());
        ArrayList<TopicIdPartition> expectedToSend1 = new ArrayList<TopicIdPartition>();
        expectedToSend1.add(new TopicIdPartition(topicId, 0, "foo"));
        ShareSessionHandlerTest.assertListEquals(expectedToSend1, ShareSessionHandlerTest.reqFetchList(requestData1, topicNames));
        ShareFetchResponse resp = ShareFetchResponse.of((Errors)Errors.NONE, (int)0, ShareSessionHandlerTest.buildResponseData(new RespEntry("foo", 0, topicId)), List.of(), (int)0);
        handler.handleResponse(resp, ApiKeys.SHARE_FETCH.latestVersion(true));
        ShareFetchRequestData requestData2 = ((ShareFetchRequest)handler.newShareFetchBuilder(groupId, this.fetchConfig).build()).data();
        Assertions.assertEquals(Collections.singletonList(foo0), ShareSessionHandlerTest.reqForgetList(requestData2, topicNames));
        Assertions.assertEquals((Object)memberId.toString(), (Object)requestData2.memberId(), (String)"Did not use same session");
        Assertions.assertEquals((int)1, (int)requestData2.shareSessionEpoch(), (String)"Did not have correct epoch");
    }

    @Test
    public void testAddNewIdAfterTopicRemovedFromSession() {
        String groupId = "G1";
        Uuid memberId = Uuid.randomUuid();
        ShareSessionHandler handler = new ShareSessionHandler(LOG_CONTEXT, 1, memberId);
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        Uuid topicId = this.addTopicId(topicNames, "foo");
        handler.addPartitionToFetch(new TopicIdPartition(topicId, 0, "foo"), null);
        ShareFetchRequestData requestData1 = ((ShareFetchRequest)handler.newShareFetchBuilder(groupId, this.fetchConfig).build()).data();
        ShareSessionHandlerTest.assertMapsEqual(ShareSessionHandlerTest.reqMap(new TopicIdPartition(topicId, 0, "foo")), handler.sessionPartitionMap());
        ArrayList<TopicIdPartition> expectedToSend1 = new ArrayList<TopicIdPartition>();
        expectedToSend1.add(new TopicIdPartition(topicId, 0, "foo"));
        ShareSessionHandlerTest.assertListEquals(expectedToSend1, ShareSessionHandlerTest.reqFetchList(requestData1, topicNames));
        ShareFetchResponse resp = ShareFetchResponse.of((Errors)Errors.NONE, (int)0, ShareSessionHandlerTest.buildResponseData(new RespEntry("foo", 0, topicId)), List.of(), (int)0);
        handler.handleResponse(resp, ApiKeys.SHARE_FETCH.latestVersion(true));
        ShareFetchRequestData requestData2 = ((ShareFetchRequest)handler.newShareFetchBuilder(groupId, this.fetchConfig).build()).data();
        Assertions.assertTrue((boolean)handler.sessionPartitionMap().isEmpty());
        Assertions.assertTrue((boolean)requestData2.topics().isEmpty());
        ShareFetchResponse resp2 = ShareFetchResponse.of((Errors)Errors.NONE, (int)0, new LinkedHashMap(), List.of(), (int)0);
        handler.handleResponse(resp2, ApiKeys.SHARE_FETCH.latestVersion(true));
        Uuid topicId2 = this.addTopicId(topicNames, "foo");
        handler.addPartitionToFetch(new TopicIdPartition(topicId2, 0, "foo"), null);
        ShareFetchRequestData requestData3 = ((ShareFetchRequest)handler.newShareFetchBuilder(groupId, this.fetchConfig).build()).data();
        Assertions.assertEquals((Object)memberId.toString(), (Object)requestData3.memberId(), (String)"Did not use same session");
        Assertions.assertEquals((int)2, (int)requestData3.shareSessionEpoch(), (String)"Did not have the correct session epoch");
    }

    @Test
    public void testNextAcknowledgementsClearedOnInvalidRequest() {
        String groupId = "G1";
        Uuid memberId = Uuid.randomUuid();
        ShareSessionHandler handler = new ShareSessionHandler(LOG_CONTEXT, 1, memberId);
        HashMap<Uuid, String> topicNames = new HashMap<Uuid, String>();
        Uuid fooId = this.addTopicId(topicNames, "foo");
        TopicIdPartition foo0 = new TopicIdPartition(fooId, 0, "foo");
        Acknowledgements acknowledgements = Acknowledgements.empty();
        acknowledgements.add(0L, AcknowledgeType.ACCEPT);
        handler.addPartitionToFetch(foo0, acknowledgements);
        Assertions.assertNull((Object)handler.newShareAcknowledgeBuilder(groupId, this.fetchConfig));
        TopicIdPartition foo1 = new TopicIdPartition(fooId, 1, "foo");
        handler.addPartitionToFetch(foo1, null);
        ShareFetchRequestData requestData = ((ShareFetchRequest)handler.newShareFetchBuilder(groupId, this.fetchConfig).build()).data();
        Assertions.assertEquals((int)0, (int)((ShareFetchRequestData.FetchPartition)((ShareFetchRequestData.FetchTopic)requestData.topics().stream().findFirst().get()).partitions().stream().findFirst().get()).acknowledgementBatches().size());
        ArrayList<TopicIdPartition> expectedToSend1 = new ArrayList<TopicIdPartition>();
        expectedToSend1.add(new TopicIdPartition(fooId, 1, "foo"));
        ShareSessionHandlerTest.assertListEquals(expectedToSend1, ShareSessionHandlerTest.reqFetchList(requestData, topicNames));
        Assertions.assertEquals((Object)memberId.toString(), (Object)requestData.memberId());
    }

    private Uuid addTopicId(Map<Uuid, String> topicNames, String name) {
        Uuid id = Uuid.randomUuid();
        topicNames.put(id, name);
        return id;
    }

    private static final class RespEntry {
        final TopicIdPartition part;
        final ShareFetchResponseData.PartitionData data;

        RespEntry(String topic, int partition, Uuid topicId) {
            this.part = new TopicIdPartition(topicId, partition, topic);
            this.data = new ShareFetchResponseData.PartitionData().setPartitionIndex(partition);
        }
    }
}

