/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.provider;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.apache.kafka.common.config.provider.DirectoryConfigProvider;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class DirectoryConfigProviderTest {
    private DirectoryConfigProvider provider;
    @TempDir
    private Path parent;
    private String dir;
    private final String bar = "bar";
    private final String foo = "foo";
    private String subdir;
    private final String subdirFileName = "subdirFile";
    private String siblingDir;
    private final String siblingDirFileName = "siblingDirFile";
    private final String siblingFileName = "siblingFile";

    private static Path writeFile(Path path) throws IOException {
        return Files.write(path, String.valueOf(path.getFileName()).toUpperCase(Locale.ENGLISH).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @BeforeEach
    public void setup() throws IOException {
        this.provider = new DirectoryConfigProvider();
        this.provider.configure(Collections.emptyMap());
        this.dir = Files.createDirectory(Paths.get(this.parent.toString(), "dir"), new FileAttribute[0]).toString();
        DirectoryConfigProviderTest.writeFile(Files.createFile(Paths.get(this.dir, "foo"), new FileAttribute[0]));
        DirectoryConfigProviderTest.writeFile(Files.createFile(Paths.get(this.dir, "bar"), new FileAttribute[0]));
        this.subdir = Files.createDirectory(Paths.get(this.dir, "subdir"), new FileAttribute[0]).toString();
        DirectoryConfigProviderTest.writeFile(Files.createFile(Paths.get(this.subdir, "subdirFile"), new FileAttribute[0]));
        this.siblingDir = Files.createDirectory(Paths.get(this.parent.toString(), "siblingDir"), new FileAttribute[0]).toString();
        DirectoryConfigProviderTest.writeFile(Files.createFile(Paths.get(this.siblingDir, "siblingDirFile"), new FileAttribute[0]));
        DirectoryConfigProviderTest.writeFile(Files.createFile(Paths.get(this.parent.toString(), "siblingFile"), new FileAttribute[0]));
    }

    @AfterEach
    public void close() throws IOException {
        this.provider.close();
    }

    @Test
    public void testGetAllKeysAtPath() {
        ConfigData configData = this.provider.get(this.dir);
        Assertions.assertEquals(Set.of("foo", "bar"), configData.data().keySet());
        Assertions.assertEquals((Object)"FOO", configData.data().get("foo"));
        Assertions.assertEquals((Object)"BAR", configData.data().get("bar"));
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testGetSetOfKeysAtPath() {
        Set<String> keys = Set.of("foo", "baz");
        ConfigData configData = this.provider.get(this.dir, keys);
        Assertions.assertEquals(Collections.singleton("foo"), configData.data().keySet());
        Assertions.assertEquals((Object)"FOO", configData.data().get("foo"));
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testNoSubdirs() {
        Set<String> keys = Set.of(this.subdir, String.join((CharSequence)File.separator, this.subdir, "subdirFile"));
        ConfigData configData = this.provider.get(this.dir, keys);
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testNoTraversal() {
        Set<String> keys = Set.of(String.join((CharSequence)File.separator, "..", "siblingFile"), String.join((CharSequence)File.separator, "..", this.siblingDir), String.join((CharSequence)File.separator, "..", this.siblingDir, "siblingDirFile"));
        ConfigData configData = this.provider.get(this.dir, keys);
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testEmptyPath() {
        ConfigData configData = this.provider.get("");
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testEmptyPathWithKey() {
        ConfigData configData = this.provider.get("", Collections.singleton("foo"));
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testNullPath() {
        ConfigData configData = this.provider.get(null);
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testNullPathWithKey() {
        ConfigData configData = this.provider.get(null, Collections.singleton("foo"));
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testServiceLoaderDiscovery() {
        ServiceLoader<ConfigProvider> serviceLoader = ServiceLoader.load(ConfigProvider.class);
        Assertions.assertTrue((boolean)StreamSupport.stream(serviceLoader.spliterator(), false).anyMatch(configProvider -> configProvider instanceof DirectoryConfigProvider));
    }

    @Test
    public void testAllowedPath() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("allowed.paths", this.parent.toString());
        this.provider.configure(configs);
        ConfigData configData = this.provider.get(this.dir);
        Assertions.assertEquals(Set.of("foo", "bar"), configData.data().keySet());
        Assertions.assertEquals((Object)"FOO", configData.data().get("foo"));
        Assertions.assertEquals((Object)"BAR", configData.data().get("bar"));
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testMultipleAllowedPaths() {
        HashMap<String, CallSite> configs = new HashMap<String, CallSite>();
        configs.put("allowed.paths", (CallSite)((Object)(this.dir + "," + this.siblingDir)));
        this.provider.configure(configs);
        ConfigData configData = this.provider.get(this.subdir);
        Assertions.assertEquals(Set.of("subdirFile"), configData.data().keySet());
        Assertions.assertEquals((Object)"SUBDIRFILE", configData.data().get("subdirFile"));
        Assertions.assertNull((Object)configData.ttl());
        configData = this.provider.get(this.siblingDir);
        Assertions.assertEquals(Set.of("siblingDirFile"), configData.data().keySet());
        Assertions.assertEquals((Object)"SIBLINGDIRFILE", configData.data().get("siblingDirFile"));
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testNotAllowedPath() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("allowed.paths", this.dir);
        this.provider.configure(configs);
        ConfigData configData = this.provider.get(this.siblingDir);
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testNoTraversalAllowedPath() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("allowed.paths", this.dir);
        this.provider.configure(configs);
        ConfigData configData = this.provider.get(Paths.get(this.dir, "..", "siblingDir").toString());
        Assertions.assertTrue((boolean)configData.data().isEmpty());
        Assertions.assertNull((Object)configData.ttl());
    }

    @Test
    public void testNonConfiguredProvider() {
        DirectoryConfigProvider provider2 = new DirectoryConfigProvider();
        IllegalStateException ise = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> provider2.get(Paths.get(this.dir, new String[0]).toString()));
        Assertions.assertEquals((Object)"The provider has not been configured yet.", (Object)ise.getMessage());
    }
}

