/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.internals;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Monitorable;
import org.apache.kafka.common.metrics.PluginMetrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PluginTest {
    private static final String CONFIG = "some.config";
    private static final Metrics METRICS = new Metrics();

    @Test
    void testWrapInstance() throws Exception {
        SomeMonitorablePlugin someMonitorablePlugin = new SomeMonitorablePlugin();
        Plugin pluginMonitorable = Plugin.wrapInstance((Object)someMonitorablePlugin, (Metrics)METRICS, (String)CONFIG);
        this.checkPlugin((Plugin<SomeMonitorablePlugin>)pluginMonitorable, someMonitorablePlugin, true);
        someMonitorablePlugin = new SomeMonitorablePlugin();
        Assertions.assertFalse((boolean)someMonitorablePlugin.closed);
        pluginMonitorable = Plugin.wrapInstance((Object)someMonitorablePlugin, null, (String)CONFIG);
        this.checkPlugin((Plugin<SomeMonitorablePlugin>)pluginMonitorable, someMonitorablePlugin, false);
        SomePlugin somePlugin = new SomePlugin();
        Assertions.assertFalse((boolean)somePlugin.closed);
        Plugin plugin = Plugin.wrapInstance((Object)somePlugin, null, (String)CONFIG);
        Assertions.assertSame((Object)somePlugin, (Object)plugin.get());
        Assertions.assertNull((Object)somePlugin.pluginMetrics);
        plugin.close();
        Assertions.assertTrue((boolean)somePlugin.closed);
    }

    @Test
    void testWrapInstances() throws Exception {
        SomeMonitorablePlugin somePlugin;
        Plugin plugin;
        int i;
        List<SomeMonitorablePlugin> someMonitorablePlugins = Arrays.asList(new SomeMonitorablePlugin(), new SomeMonitorablePlugin());
        List pluginsMonitorable = Plugin.wrapInstances(someMonitorablePlugins, (Metrics)METRICS, (String)CONFIG);
        Assertions.assertEquals((int)someMonitorablePlugins.size(), (int)pluginsMonitorable.size());
        for (i = 0; i < pluginsMonitorable.size(); ++i) {
            plugin = (Plugin)pluginsMonitorable.get(i);
            somePlugin = someMonitorablePlugins.get(i);
            this.checkPlugin((Plugin<SomeMonitorablePlugin>)plugin, somePlugin, true);
        }
        someMonitorablePlugins = Arrays.asList(new SomeMonitorablePlugin(), new SomeMonitorablePlugin());
        pluginsMonitorable = Plugin.wrapInstances(someMonitorablePlugins, null, (String)CONFIG);
        Assertions.assertEquals((int)someMonitorablePlugins.size(), (int)pluginsMonitorable.size());
        for (i = 0; i < pluginsMonitorable.size(); ++i) {
            plugin = (Plugin)pluginsMonitorable.get(i);
            somePlugin = someMonitorablePlugins.get(i);
            this.checkPlugin((Plugin<SomeMonitorablePlugin>)plugin, somePlugin, false);
        }
        List<SomePlugin> somePlugins = Arrays.asList(new SomePlugin(), new SomePlugin());
        List plugins = Plugin.wrapInstances(somePlugins, (Metrics)METRICS, (String)CONFIG);
        Assertions.assertEquals((int)somePlugins.size(), (int)plugins.size());
        for (int i2 = 0; i2 < plugins.size(); ++i2) {
            Plugin plugin2 = (Plugin)plugins.get(i2);
            SomePlugin somePlugin2 = somePlugins.get(i2);
            Assertions.assertSame((Object)somePlugin2, (Object)plugin2.get());
            Assertions.assertNull((Object)somePlugin2.pluginMetrics);
            plugin2.close();
            Assertions.assertTrue((boolean)somePlugin2.closed);
        }
    }

    @Test
    public void testCloseThrows() {
        SomePlugin somePlugin = new SomePlugin();
        somePlugin.throwOnClose = true;
        Plugin plugin = Plugin.wrapInstance((Object)somePlugin, (Metrics)METRICS, (String)CONFIG);
        Assertions.assertThrows(KafkaException.class, () -> ((Plugin)plugin).close());
    }

    @Test
    public void testUsePluginMetricsAfterClose() throws Exception {
        Plugin plugin = Plugin.wrapInstance((Object)new SomeMonitorablePlugin(), (Metrics)METRICS, (String)CONFIG);
        PluginMetrics pluginMetrics = ((SomeMonitorablePlugin)plugin.get()).pluginMetrics;
        plugin.close();
        Assertions.assertThrows(IllegalStateException.class, () -> pluginMetrics.metricName("", "", new LinkedHashMap()));
        Assertions.assertThrows(IllegalStateException.class, () -> pluginMetrics.addMetric(null, null));
        Assertions.assertThrows(IllegalStateException.class, () -> pluginMetrics.removeMetric(null));
        Assertions.assertThrows(IllegalStateException.class, () -> pluginMetrics.addSensor(""));
        Assertions.assertThrows(IllegalStateException.class, () -> pluginMetrics.removeSensor(""));
    }

    private void checkPlugin(Plugin<SomeMonitorablePlugin> plugin, SomeMonitorablePlugin instance, boolean metricsSet) throws Exception {
        Assertions.assertSame((Object)instance, (Object)plugin.get());
        if (metricsSet) {
            Assertions.assertNotNull((Object)instance.pluginMetrics);
        } else {
            Assertions.assertNull((Object)instance.pluginMetrics);
        }
        plugin.close();
        Assertions.assertTrue((boolean)instance.closed);
    }

    static class SomeMonitorablePlugin
    extends SomePlugin
    implements Monitorable {
        SomeMonitorablePlugin() {
        }

        public void withPluginMetrics(PluginMetrics metrics) {
            this.pluginMetrics = metrics;
        }
    }

    static class SomePlugin
    implements Closeable {
        PluginMetrics pluginMetrics;
        boolean closed;
        boolean throwOnClose = false;

        SomePlugin() {
        }

        @Override
        public void close() throws IOException {
            if (this.throwOnClose) {
                throw new RuntimeException("throw on close");
            }
            this.closed = true;
        }
    }
}

