/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.MemoryRecords;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;

public final class InvalidMemoryRecordsProvider
implements ArgumentsProvider {
    private static final long BASE_OFFSET = 1234L;
    private static final int EPOCH = 4321;

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        return Stream.of(Arguments.of((Object[])new Object[]{MemoryRecords.readableRecords((ByteBuffer)InvalidMemoryRecordsProvider.notEnoughBytes()), Optional.empty()}), Arguments.of((Object[])new Object[]{MemoryRecords.readableRecords((ByteBuffer)InvalidMemoryRecordsProvider.recordsSizeTooSmall()), Optional.of(CorruptRecordException.class)}), Arguments.of((Object[])new Object[]{MemoryRecords.readableRecords((ByteBuffer)InvalidMemoryRecordsProvider.notEnoughBytesToMagic()), Optional.empty()}), Arguments.of((Object[])new Object[]{MemoryRecords.readableRecords((ByteBuffer)InvalidMemoryRecordsProvider.negativeMagic()), Optional.of(CorruptRecordException.class)}), Arguments.of((Object[])new Object[]{MemoryRecords.readableRecords((ByteBuffer)InvalidMemoryRecordsProvider.largeMagic()), Optional.of(CorruptRecordException.class)}), Arguments.of((Object[])new Object[]{MemoryRecords.readableRecords((ByteBuffer)InvalidMemoryRecordsProvider.lessBytesThanRecordSize()), Optional.empty()}));
    }

    private static ByteBuffer notEnoughBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(11);
        buffer.limit(buffer.capacity());
        return buffer;
    }

    private static ByteBuffer recordsSizeTooSmall() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        buffer.putLong(1234L);
        buffer.putInt(13);
        buffer.position(0);
        buffer.limit(buffer.capacity());
        return buffer;
    }

    private static ByteBuffer notEnoughBytesToMagic() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        buffer.putLong(1234L);
        buffer.putInt(buffer.capacity() - 12);
        buffer.position(0);
        buffer.limit(16);
        return buffer;
    }

    private static ByteBuffer negativeMagic() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        buffer.putLong(1234L);
        buffer.putInt(buffer.capacity() - 12);
        buffer.putInt(4321);
        buffer.put((byte)-1);
        buffer.position(0);
        buffer.limit(buffer.capacity());
        return buffer;
    }

    private static ByteBuffer largeMagic() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        buffer.putLong(1234L);
        buffer.putInt(buffer.capacity() - 12);
        buffer.putInt(4321);
        buffer.put((byte)3);
        buffer.position(0);
        buffer.limit(buffer.capacity());
        return buffer;
    }

    private static ByteBuffer lessBytesThanRecordSize() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        buffer.putLong(1234L);
        buffer.putInt(buffer.capacity() - 12);
        buffer.putInt(4321);
        buffer.put((byte)2);
        buffer.position(0);
        buffer.limit(buffer.capacity() - 12 - 1);
        return buffer;
    }
}

