/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import org.apache.kafka.common.security.oauthbearer.JwtValidator;
import org.apache.kafka.common.security.oauthbearer.JwtValidatorException;
import org.apache.kafka.common.security.oauthbearer.internals.secured.AccessTokenBuilder;
import org.apache.kafka.common.security.oauthbearer.internals.secured.OAuthBearerTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class JwtValidatorTest
extends OAuthBearerTest {
    protected abstract JwtValidator createJwtValidator(AccessTokenBuilder var1) throws Exception;

    protected JwtValidator createJwtValidator() throws Exception {
        AccessTokenBuilder builder = new AccessTokenBuilder();
        return this.createJwtValidator(builder);
    }

    @Test
    public void testNull() throws Exception {
        JwtValidator validator = this.createJwtValidator();
        this.assertThrowsWithMessage(JwtValidatorException.class, () -> validator.validate(null), "Malformed JWT provided; expected three sections (header, payload, and signature)");
    }

    @Test
    public void testEmptyString() throws Exception {
        JwtValidator validator = this.createJwtValidator();
        this.assertThrowsWithMessage(JwtValidatorException.class, () -> validator.validate(""), "Malformed JWT provided; expected three sections (header, payload, and signature)");
    }

    @Test
    public void testWhitespace() throws Exception {
        JwtValidator validator = this.createJwtValidator();
        this.assertThrowsWithMessage(JwtValidatorException.class, () -> validator.validate("    "), "Malformed JWT provided; expected three sections (header, payload, and signature)");
    }

    @Test
    public void testEmptySections() throws Exception {
        JwtValidator validator = this.createJwtValidator();
        this.assertThrowsWithMessage(JwtValidatorException.class, () -> validator.validate(".."), "Malformed JWT provided; expected three sections (header, payload, and signature)");
    }

    @Test
    public void testMissingHeader() throws Exception {
        JwtValidator validator = this.createJwtValidator();
        String header = "";
        String payload = this.createBase64JsonJwtSection(node -> {});
        String signature = "";
        String accessToken = String.format("%s.%s.%s", header, payload, signature);
        Assertions.assertThrows(JwtValidatorException.class, () -> validator.validate(accessToken));
    }

    @Test
    public void testMissingPayload() throws Exception {
        JwtValidator validator = this.createJwtValidator();
        String header = this.createBase64JsonJwtSection(node -> node.put("alg", "none"));
        String payload = "";
        String signature = "";
        String accessToken = String.format("%s.%s.%s", header, payload, signature);
        Assertions.assertThrows(JwtValidatorException.class, () -> validator.validate(accessToken));
    }

    @Test
    public void testMissingSignature() throws Exception {
        JwtValidator validator = this.createJwtValidator();
        String header = this.createBase64JsonJwtSection(node -> node.put("alg", "none"));
        String payload = this.createBase64JsonJwtSection(node -> {});
        String signature = "";
        String accessToken = String.format("%s.%s.%s", header, payload, signature);
        Assertions.assertThrows(JwtValidatorException.class, () -> validator.validate(accessToken));
    }
}

