/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import org.apache.kafka.common.utils.Java;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JavaTest {
    private String javaVendor;
    private String javaRuntimeName;

    @BeforeEach
    public void before() {
        this.javaVendor = System.getProperty("java.vendor");
        this.javaRuntimeName = System.getProperty("java.runtime.name");
    }

    @AfterEach
    public void after() {
        System.setProperty("java.vendor", this.javaVendor);
        System.setProperty("java.runtime.name", this.javaRuntimeName);
    }

    @Test
    public void testIsIBMJdk() {
        System.setProperty("java.vendor", "Oracle Corporation");
        Assertions.assertFalse((boolean)Java.isIbmJdk());
        System.setProperty("java.vendor", "IBM Corporation");
        Assertions.assertTrue((boolean)Java.isIbmJdk());
    }

    @Test
    public void testIsIBMJdkSemeru() {
        System.setProperty("java.vendor", "Oracle Corporation");
        Assertions.assertFalse((boolean)Java.isIbmJdkSemeru());
        System.setProperty("java.vendor", "IBM Corporation");
        System.setProperty("java.runtime.name", "Java(TM) SE Runtime Environment");
        Assertions.assertFalse((boolean)Java.isIbmJdkSemeru());
        System.setProperty("java.vendor", "IBM Corporation");
        System.setProperty("java.runtime.name", "IBM Semeru Runtime Certified Edition");
        Assertions.assertTrue((boolean)Java.isIbmJdkSemeru());
    }

    @Test
    public void testLoadKerberosLoginModule() throws ClassNotFoundException {
        String clazz = Java.isIbmJdk() && !Java.isIbmJdkSemeru() ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
        Class.forName(clazz);
    }
}

