/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.ResponseHeader;
import org.junit.Assert;
import org.junit.Test;

public class ProduceResponseTest {
    @Test
    public void produceResponseV5Test() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        TopicPartition tp0 = new TopicPartition("test", 0);
        responseData.put(tp0, new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L, 100L));
        ProduceResponse v5Response = new ProduceResponse(responseData, 10);
        short version = 5;
        ByteBuffer buffer = v5Response.serialize(ApiKeys.PRODUCE, version, 0);
        buffer.rewind();
        ResponseHeader.parse((ByteBuffer)buffer, (short)ApiKeys.PRODUCE.responseHeaderVersion(version));
        Struct deserializedStruct = ApiKeys.PRODUCE.parseResponse(version, buffer);
        ProduceResponse v5FromBytes = (ProduceResponse)AbstractResponse.parseResponse((ApiKeys)ApiKeys.PRODUCE, (Struct)deserializedStruct, (short)version);
        Assert.assertEquals((long)1L, (long)v5FromBytes.responses().size());
        Assert.assertTrue((boolean)v5FromBytes.responses().containsKey(tp0));
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)v5FromBytes.responses().get(tp0);
        Assert.assertEquals((long)100L, (long)partitionResponse.logStartOffset);
        Assert.assertEquals((long)10000L, (long)partitionResponse.baseOffset);
        Assert.assertEquals((long)10L, (long)v5FromBytes.throttleTimeMs());
        Assert.assertEquals(responseData, (Object)v5Response.responses());
    }

    @Test
    public void produceResponseVersionTest() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        responseData.put(new TopicPartition("test", 0), new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L, 100L));
        ProduceResponse v0Response = new ProduceResponse(responseData);
        ProduceResponse v1Response = new ProduceResponse(responseData, 10);
        ProduceResponse v2Response = new ProduceResponse(responseData, 10);
        Assert.assertEquals((String)"Throttle time must be zero", (long)0L, (long)v0Response.throttleTimeMs());
        Assert.assertEquals((String)"Throttle time must be 10", (long)10L, (long)v1Response.throttleTimeMs());
        Assert.assertEquals((String)"Throttle time must be 10", (long)10L, (long)v2Response.throttleTimeMs());
        Assert.assertEquals((String)"Should use schema version 0", (Object)ApiKeys.PRODUCE.responseSchema((short)0), (Object)v0Response.toStruct((short)0).schema());
        Assert.assertEquals((String)"Should use schema version 1", (Object)ApiKeys.PRODUCE.responseSchema((short)1), (Object)v1Response.toStruct((short)1).schema());
        Assert.assertEquals((String)"Should use schema version 2", (Object)ApiKeys.PRODUCE.responseSchema((short)2), (Object)v2Response.toStruct((short)2).schema());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v0Response.responses());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v1Response.responses());
        Assert.assertEquals((String)"Response data does not match", responseData, (Object)v2Response.responses());
    }

    @Test
    public void produceResponseRecordErrorsTest() {
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseData = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        TopicPartition tp = new TopicPartition("test", 0);
        ProduceResponse.PartitionResponse partResponse = new ProduceResponse.PartitionResponse(Errors.NONE, 10000L, -1L, 100L, Collections.singletonList(new ProduceResponse.RecordError(3, "Record error")), "Produce failed");
        responseData.put(tp, partResponse);
        for (short ver = 0; ver <= ApiKeys.PRODUCE.latestVersion(); ver = (short)(ver + 1)) {
            ProduceResponse response = new ProduceResponse(responseData);
            Struct struct = response.toStruct(ver);
            Assert.assertEquals((String)("Should use schema version " + ver), (Object)ApiKeys.PRODUCE.responseSchema(ver), (Object)struct.schema());
            ProduceResponse.PartitionResponse deserialized = (ProduceResponse.PartitionResponse)new ProduceResponse(struct).responses().get(tp);
            if (ver >= 8) {
                Assert.assertEquals((long)1L, (long)deserialized.recordErrors.size());
                Assert.assertEquals((long)3L, (long)((ProduceResponse.RecordError)deserialized.recordErrors.get((int)0)).batchIndex);
                Assert.assertEquals((Object)"Record error", (Object)((ProduceResponse.RecordError)deserialized.recordErrors.get((int)0)).message);
                Assert.assertEquals((Object)"Produce failed", (Object)deserialized.errorMessage);
                continue;
            }
            Assert.assertEquals((long)0L, (long)deserialized.recordErrors.size());
            Assert.assertEquals(null, (Object)deserialized.errorMessage);
        }
    }
}

