/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ConfluentLeaderAndIsrResponseData
implements ApiMessage {
    private short errorCode;
    private List<LeaderAndIsrPartitionError> partitionErrors;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public ConfluentLeaderAndIsrResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ConfluentLeaderAndIsrResponseData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public ConfluentLeaderAndIsrResponseData() {
        this.errorCode = 0;
        this.partitionErrors = new ArrayList<LeaderAndIsrPartitionError>();
    }

    @Override
    public short apiKey() {
        return 32766;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.errorCode = _readable.readShort();
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field partitionErrors was serialized as null");
        }
        ArrayList<LeaderAndIsrPartitionError> newCollection = new ArrayList<LeaderAndIsrPartitionError>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new LeaderAndIsrPartitionError(_readable, _version));
        }
        this.partitionErrors = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeShort(this.errorCode);
        _writable.writeInt(this.partitionErrors.size());
        for (LeaderAndIsrPartitionError partitionErrorsElement : this.partitionErrors) {
            partitionErrorsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.errorCode = struct.getShort("error_code");
        Object[] _nestedObjects = struct.getArray("partition_errors");
        this.partitionErrors = new ArrayList<LeaderAndIsrPartitionError>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.partitionErrors.add(new LeaderAndIsrPartitionError((Struct)nestedObject, _version));
        }
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("error_code", (Object)this.errorCode);
        Struct[] _nestedObjects = new Struct[this.partitionErrors.size()];
        int i = 0;
        for (LeaderAndIsrPartitionError element : this.partitionErrors) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("partition_errors", (Object)_nestedObjects);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 2;
        int _arraySize = 0;
        _arraySize += 4;
        for (LeaderAndIsrPartitionError partitionErrorsElement : this.partitionErrors) {
            _arraySize += partitionErrorsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConfluentLeaderAndIsrResponseData)) {
            return false;
        }
        ConfluentLeaderAndIsrResponseData other = (ConfluentLeaderAndIsrResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        return !(this.partitionErrors == null ? other.partitionErrors != null : !this.partitionErrors.equals(other.partitionErrors));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.partitionErrors == null ? 0 : this.partitionErrors.hashCode());
        return hashCode;
    }

    public String toString() {
        return "ConfluentLeaderAndIsrResponseData(errorCode=" + this.errorCode + ", partitionErrors=" + MessageUtil.deepToString(this.partitionErrors.iterator()) + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public List<LeaderAndIsrPartitionError> partitionErrors() {
        return this.partitionErrors;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ConfluentLeaderAndIsrResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public ConfluentLeaderAndIsrResponseData setPartitionErrors(List<LeaderAndIsrPartitionError> v) {
        this.partitionErrors = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("partition_errors", new ArrayOf(LeaderAndIsrPartitionError.SCHEMA_0), "Each partition."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class LeaderAndIsrPartitionError
    implements Message {
        private String topicName;
        private int partitionIndex;
        private short errorCode;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public LeaderAndIsrPartitionError(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public LeaderAndIsrPartitionError(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public LeaderAndIsrPartitionError() {
            this.topicName = "";
            this.partitionIndex = 0;
            this.errorCode = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderAndIsrPartitionError");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topicName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topicName had invalid length " + length);
            }
            this.topicName = _readable.readString(length);
            this.partitionIndex = _readable.readInt();
            this.errorCode = _readable.readShort();
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of LeaderAndIsrPartitionError");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.topicName);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            _writable.writeInt(this.partitionIndex);
            _writable.writeShort(this.errorCode);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderAndIsrPartitionError");
            }
            this._unknownTaggedFields = null;
            this.topicName = struct.getString("topic_name");
            this.partitionIndex = struct.getInt("partition_index");
            this.errorCode = struct.getShort("error_code");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of LeaderAndIsrPartitionError");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("topic_name", (Object)this.topicName);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("error_code", (Object)this.errorCode);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of LeaderAndIsrPartitionError");
            }
            byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topicName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topicName, _stringBytes);
            _size += _stringBytes.length + 2;
            _size += 4;
            _size += 2;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderAndIsrPartitionError)) {
                return false;
            }
            LeaderAndIsrPartitionError other = (LeaderAndIsrPartitionError)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            return this.errorCode == other.errorCode;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            return hashCode;
        }

        public String toString() {
            return "LeaderAndIsrPartitionError(topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public LeaderAndIsrPartitionError setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public LeaderAndIsrPartitionError setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public LeaderAndIsrPartitionError setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topic_name", Type.STRING, "The topic name."), new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The partition error code, or 0 if there was no error."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

