/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AlterMirrorsRequestData
implements ApiMessage {
    private List<OpData> ops;
    private boolean validateOnly;
    private int timeoutMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("ops", new CompactArrayOf(OpData.SCHEMA_0), "The mirror control operations."), new Field("validate_only", Type.BOOLEAN, "Whether to validate that the cluster links can be created, but not actually create them."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

    public AlterMirrorsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public AlterMirrorsRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public AlterMirrorsRequestData() {
        this.ops = new ArrayList<OpData>(0);
        this.validateOnly = false;
        this.timeoutMs = 0;
    }

    @Override
    public short apiKey() {
        return 10006;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field ops was serialized as null");
        }
        ArrayList<OpData> newCollection = new ArrayList<OpData>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new OpData(_readable, _version));
        }
        this.ops = newCollection;
        this.validateOnly = _readable.readByte() != 0;
        this.timeoutMs = _readable.readInt();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.ops.size() + 1);
        for (OpData opsElement : this.ops) {
            opsElement.write(_writable, _cache, _version);
        }
        _writable.writeByte(this.validateOnly ? (byte)1 : 0);
        _writable.writeInt(this.timeoutMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        Object[] _nestedObjects = struct.getArray("ops");
        this.ops = new ArrayList<OpData>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.ops.add(new OpData((Struct)nestedObject, _version));
        }
        this.validateOnly = struct.getBoolean("validate_only");
        this.timeoutMs = struct.getInt("timeout_ms");
        if (!_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        _taggedFields = new TreeMap();
        Struct struct = new Struct(SCHEMAS[_version]);
        Struct[] _nestedObjects = new Struct[this.ops.size()];
        int i = 0;
        for (OpData element : this.ops) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("ops", (Object)_nestedObjects);
        struct.set("validate_only", (Object)this.validateOnly);
        struct.set("timeout_ms", (Object)this.timeoutMs);
        struct.set("_tagged_fields", _taggedFields);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _arraySize = 0;
        _arraySize += ByteUtils.sizeOfUnsignedVarint(this.ops.size() + 1);
        for (OpData opsElement : this.ops) {
            _arraySize += opsElement.size(_cache, _version);
        }
        _size += _arraySize;
        ++_size;
        _size += 4;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        return _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterMirrorsRequestData)) {
            return false;
        }
        AlterMirrorsRequestData other = (AlterMirrorsRequestData)obj;
        if (this.ops == null ? other.ops != null : !this.ops.equals(other.ops)) {
            return false;
        }
        if (this.validateOnly != other.validateOnly) {
            return false;
        }
        return this.timeoutMs == other.timeoutMs;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.ops == null ? 0 : this.ops.hashCode());
        hashCode = 31 * hashCode + (this.validateOnly ? 1231 : 1237);
        hashCode = 31 * hashCode + this.timeoutMs;
        return hashCode;
    }

    @Override
    public AlterMirrorsRequestData duplicate() {
        AlterMirrorsRequestData _duplicate = new AlterMirrorsRequestData();
        ArrayList<OpData> newOps = new ArrayList<OpData>(this.ops.size());
        for (OpData _element : this.ops) {
            newOps.add(_element.duplicate());
        }
        _duplicate.ops = newOps;
        _duplicate.validateOnly = this.validateOnly;
        _duplicate.timeoutMs = this.timeoutMs;
        return _duplicate;
    }

    public String toString() {
        return "AlterMirrorsRequestData(ops=" + MessageUtil.deepToString(this.ops.iterator()) + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ", timeoutMs=" + this.timeoutMs + ")";
    }

    public List<OpData> ops() {
        return this.ops;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterMirrorsRequestData setOps(List<OpData> v) {
        this.ops = v;
        return this;
    }

    public AlterMirrorsRequestData setValidateOnly(boolean v) {
        this.validateOnly = v;
        return this;
    }

    public AlterMirrorsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public static class ClearTopicMirrorData
    implements Message {
        private String topic;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public ClearTopicMirrorData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ClearTopicMirrorData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public ClearTopicMirrorData() {
            this.topic = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ClearTopicMirrorData");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.topic);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ClearTopicMirrorData");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            this.topic = struct.getString("topic");
            if (!_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ClearTopicMirrorData");
            }
            TreeMap _taggedFields = null;
            _taggedFields = new TreeMap();
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("topic", (Object)this.topic);
            struct.set("_tagged_fields", _taggedFields);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ClearTopicMirrorData");
            }
            byte[] _stringBytes = this.topic.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            return _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClearTopicMirrorData)) {
                return false;
            }
            ClearTopicMirrorData other = (ClearTopicMirrorData)obj;
            return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            return hashCode;
        }

        @Override
        public ClearTopicMirrorData duplicate() {
            ClearTopicMirrorData _duplicate = new ClearTopicMirrorData();
            _duplicate.topic = this.topic;
            return _duplicate;
        }

        public String toString() {
            return "ClearTopicMirrorData(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ")";
        }

        public String topic() {
            return this.topic;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ClearTopicMirrorData setTopic(String v) {
            this.topic = v;
            return this;
        }
    }

    public static class StopTopicMirrorData
    implements Message {
        private String topic;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public StopTopicMirrorData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public StopTopicMirrorData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public StopTopicMirrorData() {
            this.topic = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of StopTopicMirrorData");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.topic);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of StopTopicMirrorData");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            this.topic = struct.getString("topic");
            if (!_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of StopTopicMirrorData");
            }
            TreeMap _taggedFields = null;
            _taggedFields = new TreeMap();
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("topic", (Object)this.topic);
            struct.set("_tagged_fields", _taggedFields);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of StopTopicMirrorData");
            }
            byte[] _stringBytes = this.topic.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            return _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StopTopicMirrorData)) {
                return false;
            }
            StopTopicMirrorData other = (StopTopicMirrorData)obj;
            return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            return hashCode;
        }

        @Override
        public StopTopicMirrorData duplicate() {
            StopTopicMirrorData _duplicate = new StopTopicMirrorData();
            _duplicate.topic = this.topic;
            return _duplicate;
        }

        public String toString() {
            return "StopTopicMirrorData(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ")";
        }

        public String topic() {
            return this.topic;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public StopTopicMirrorData setTopic(String v) {
            this.topic = v;
            return this;
        }
    }

    public static class OpData
    implements Message {
        private List<StopTopicMirrorData> stopTopicMirror;
        private List<ClearTopicMirrorData> clearTopicMirror;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("stop_topic_mirror", CompactArrayOf.nullable(StopTopicMirrorData.SCHEMA_0), "Stops a topic's mirroring to become a writable topic."), new Field("clear_topic_mirror", CompactArrayOf.nullable(ClearTopicMirrorData.SCHEMA_0), "Clears a topic's mirror information."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public OpData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public OpData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public OpData() {
            this.stopTopicMirror = null;
            this.clearTopicMirror = null;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ArrayList<StopTopicMirrorData> newCollection;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OpData");
            }
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.stopTopicMirror = null;
            } else {
                newCollection = new ArrayList<StopTopicMirrorData>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new StopTopicMirrorData(_readable, _version));
                }
                this.stopTopicMirror = newCollection;
            }
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.clearTopicMirror = null;
            } else {
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add((StopTopicMirrorData)((Object)new ClearTopicMirrorData(_readable, _version)));
                }
                this.clearTopicMirror = newCollection;
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (this.stopTopicMirror == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.stopTopicMirror.size() + 1);
                for (StopTopicMirrorData stopTopicMirrorElement : this.stopTopicMirror) {
                    stopTopicMirrorElement.write(_writable, _cache, _version);
                }
            }
            if (this.clearTopicMirror == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.clearTopicMirror.size() + 1);
                for (ClearTopicMirrorData clearTopicMirrorElement : this.clearTopicMirror) {
                    clearTopicMirrorElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OpData");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            Object[] _nestedObjects = struct.getArray("stop_topic_mirror");
            if (_nestedObjects == null) {
                this.stopTopicMirror = null;
            } else {
                this.stopTopicMirror = new ArrayList<StopTopicMirrorData>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.stopTopicMirror.add(new StopTopicMirrorData((Struct)nestedObject, _version));
                }
            }
            _nestedObjects = struct.getArray("clear_topic_mirror");
            if (_nestedObjects == null) {
                this.clearTopicMirror = null;
            } else {
                this.clearTopicMirror = new ArrayList<ClearTopicMirrorData>(_nestedObjects.length);
                for (Object nestedObject : _nestedObjects) {
                    this.clearTopicMirror.add(new ClearTopicMirrorData((Struct)nestedObject, _version));
                }
            }
            if (!_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            int i;
            Struct[] _nestedObjects;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OpData");
            }
            TreeMap _taggedFields = null;
            _taggedFields = new TreeMap();
            Struct struct = new Struct(SCHEMAS[_version]);
            if (this.stopTopicMirror == null) {
                struct.set("stop_topic_mirror", null);
            } else {
                _nestedObjects = new Struct[this.stopTopicMirror.size()];
                i = 0;
                for (StopTopicMirrorData stopTopicMirrorData : this.stopTopicMirror) {
                    _nestedObjects[i++] = stopTopicMirrorData.toStruct(_version);
                }
                struct.set("stop_topic_mirror", (Object)_nestedObjects);
            }
            if (this.clearTopicMirror == null) {
                struct.set("clear_topic_mirror", null);
            } else {
                _nestedObjects = new Struct[this.clearTopicMirror.size()];
                i = 0;
                for (ClearTopicMirrorData clearTopicMirrorData : this.clearTopicMirror) {
                    _nestedObjects[i++] = clearTopicMirrorData.toStruct(_version);
                }
                struct.set("clear_topic_mirror", (Object)_nestedObjects);
            }
            struct.set("_tagged_fields", _taggedFields);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _arraySize;
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of OpData");
            }
            if (this.stopTopicMirror == null) {
                ++_size;
            } else {
                _arraySize = 0;
                _arraySize += ByteUtils.sizeOfUnsignedVarint(this.stopTopicMirror.size() + 1);
                for (StopTopicMirrorData stopTopicMirrorElement : this.stopTopicMirror) {
                    _arraySize += stopTopicMirrorElement.size(_cache, _version);
                }
                _size += _arraySize;
            }
            if (this.clearTopicMirror == null) {
                ++_size;
            } else {
                _arraySize = 0;
                _arraySize += ByteUtils.sizeOfUnsignedVarint(this.clearTopicMirror.size() + 1);
                for (ClearTopicMirrorData clearTopicMirrorElement : this.clearTopicMirror) {
                    _arraySize += clearTopicMirrorElement.size(_cache, _version);
                }
                _size += _arraySize;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            return _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OpData)) {
                return false;
            }
            OpData other = (OpData)obj;
            if (this.stopTopicMirror == null ? other.stopTopicMirror != null : !this.stopTopicMirror.equals(other.stopTopicMirror)) {
                return false;
            }
            return !(this.clearTopicMirror == null ? other.clearTopicMirror != null : !this.clearTopicMirror.equals(other.clearTopicMirror));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.stopTopicMirror == null ? 0 : this.stopTopicMirror.hashCode());
            hashCode = 31 * hashCode + (this.clearTopicMirror == null ? 0 : this.clearTopicMirror.hashCode());
            return hashCode;
        }

        @Override
        public OpData duplicate() {
            OpData _duplicate = new OpData();
            if (this.stopTopicMirror == null) {
                _duplicate.stopTopicMirror = null;
            } else {
                ArrayList<StopTopicMirrorData> newStopTopicMirror = new ArrayList<StopTopicMirrorData>(this.stopTopicMirror.size());
                for (StopTopicMirrorData stopTopicMirrorData : this.stopTopicMirror) {
                    newStopTopicMirror.add(stopTopicMirrorData.duplicate());
                }
                _duplicate.stopTopicMirror = newStopTopicMirror;
            }
            if (this.clearTopicMirror == null) {
                _duplicate.clearTopicMirror = null;
            } else {
                ArrayList<ClearTopicMirrorData> newClearTopicMirror = new ArrayList<ClearTopicMirrorData>(this.clearTopicMirror.size());
                for (ClearTopicMirrorData clearTopicMirrorData : this.clearTopicMirror) {
                    newClearTopicMirror.add(clearTopicMirrorData.duplicate());
                }
                _duplicate.clearTopicMirror = newClearTopicMirror;
            }
            return _duplicate;
        }

        public String toString() {
            return "OpData(stopTopicMirror=" + (this.stopTopicMirror == null ? "null" : MessageUtil.deepToString(this.stopTopicMirror.iterator())) + ", clearTopicMirror=" + (this.clearTopicMirror == null ? "null" : MessageUtil.deepToString(this.clearTopicMirror.iterator())) + ")";
        }

        public List<StopTopicMirrorData> stopTopicMirror() {
            return this.stopTopicMirror;
        }

        public List<ClearTopicMirrorData> clearTopicMirror() {
            return this.clearTopicMirror;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OpData setStopTopicMirror(List<StopTopicMirrorData> v) {
            this.stopTopicMirror = v;
            return this;
        }

        public OpData setClearTopicMirror(List<ClearTopicMirrorData> v) {
            this.clearTopicMirror = v;
            return this;
        }
    }
}

