/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.AlterMirrorsRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterMirrorsResponse;

public class AlterMirrorsRequest
extends AbstractRequest {
    private final AlterMirrorsRequestData data;

    public AlterMirrorsRequest(AlterMirrorsRequestData data, short version) {
        super(ApiKeys.ALTER_MIRRORS, version);
        this.data = data;
    }

    public AlterMirrorsRequest(Struct struct, short version) {
        super(ApiKeys.ALTER_MIRRORS, version);
        this.data = new AlterMirrorsRequestData(struct, version);
    }

    public List<Op> ops() {
        ArrayList<Op> ops = new ArrayList<Op>(this.data.ops().size());
        for (AlterMirrorsRequestData.OpData opData : this.data.ops()) {
            if ((opData.stopTopicMirror() != null ? 1 : 0) + (opData.clearTopicMirror() != null ? 1 : 0) != 1) {
                throw new InvalidRequestException("Unexpected request data");
            }
            if (opData.stopTopicMirror() != null) {
                if (opData.stopTopicMirror().size() != 1) {
                    throw new InvalidRequestException("Unexpected request size");
                }
                AlterMirrorsRequestData.StopTopicMirrorData stopTopicMirrorData = opData.stopTopicMirror().get(0);
                ops.add(new StopTopicMirrorOp(stopTopicMirrorData.topic()));
                continue;
            }
            if (opData.clearTopicMirror() != null) {
                if (opData.clearTopicMirror().size() != 1) {
                    throw new InvalidRequestException("Unexpected request size");
                }
                AlterMirrorsRequestData.ClearTopicMirrorData clearTopicMirrorData = opData.clearTopicMirror().get(0);
                ops.add(new ClearTopicMirrorOp(clearTopicMirrorData.topic()));
                continue;
            }
            throw new InvalidRequestException("Unexpected mirror control op type");
        }
        return ops;
    }

    public boolean validateOnly() {
        return this.data.validateOnly();
    }

    public int timeoutMs() {
        return this.data.timeoutMs();
    }

    @Override
    public AlterMirrorsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new AlterMirrorsResponse(this.ops(), throttleTimeMs, e);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterMirrorsRequest> {
        private final AlterMirrorsRequestData data;

        public Builder(List<Op> ops, boolean validateOnly, int timeoutMs) {
            super(ApiKeys.ALTER_MIRRORS);
            ArrayList<AlterMirrorsRequestData.OpData> opDatas = new ArrayList<AlterMirrorsRequestData.OpData>(ops.size());
            for (Op op : ops) {
                Op subOp;
                AlterMirrorsRequestData.OpData opData = new AlterMirrorsRequestData.OpData();
                if (op instanceof StopTopicMirrorOp) {
                    subOp = (StopTopicMirrorOp)op;
                    opData.setStopTopicMirror(Collections.singletonList(new AlterMirrorsRequestData.StopTopicMirrorData().setTopic(((StopTopicMirrorOp)subOp).topic())));
                } else if (op instanceof ClearTopicMirrorOp) {
                    subOp = (ClearTopicMirrorOp)op;
                    opData.setClearTopicMirror(Collections.singletonList(new AlterMirrorsRequestData.ClearTopicMirrorData().setTopic(((ClearTopicMirrorOp)subOp).topic())));
                } else {
                    throw new InvalidRequestException("Unexpected mirror control op type");
                }
                opDatas.add(opData);
            }
            this.data = new AlterMirrorsRequestData().setOps(opDatas).setValidateOnly(validateOnly).setTimeoutMs(timeoutMs);
        }

        @Override
        public AlterMirrorsRequest build(short version) {
            return new AlterMirrorsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }

    public static class ClearTopicMirrorOp
    implements Op {
        private final String topic;

        public ClearTopicMirrorOp(String topic) {
            this.topic = Objects.requireNonNull(topic, "Topic not specified");
        }

        public String topic() {
            return this.topic;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClearTopicMirrorOp that = (ClearTopicMirrorOp)o;
            return Objects.equals(this.topic, that.topic);
        }

        public int hashCode() {
            return Objects.hash(this.topic);
        }

        public String toString() {
            return "ClearTopicMirrorOp(topic=" + this.topic + ")";
        }
    }

    public static class StopTopicMirrorOp
    implements Op {
        private final String topic;

        public StopTopicMirrorOp(String topic) {
            this.topic = Objects.requireNonNull(topic, "Topic not specified");
        }

        public String topic() {
            return this.topic;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StopTopicMirrorOp that = (StopTopicMirrorOp)o;
            return Objects.equals(this.topic, that.topic);
        }

        public int hashCode() {
            return Objects.hash(this.topic);
        }

        public String toString() {
            return "StopTopicMirrorOp(topic=" + this.topic + ")";
        }
    }

    public static interface Op {
    }
}

