/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.message.InitiateShutdownResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;

public class InitiateShutdownResponse
extends AbstractResponse {
    private final InitiateShutdownResponseData data;

    public InitiateShutdownResponse(Struct struct) {
        this(struct, ApiKeys.INITIATE_SHUTDOWN.latestVersion());
    }

    public InitiateShutdownResponse(InitiateShutdownResponseData responseData) {
        this.data = responseData;
    }

    InitiateShutdownResponse(Struct struct, short version) {
        this.data = new InitiateShutdownResponseData(struct, version);
    }

    public static InitiateShutdownResponse parse(ByteBuffer buffer, short version) {
        return new InitiateShutdownResponse(ApiKeys.INITIATE_SHUTDOWN.parseResponse(version, buffer), version);
    }

    public InitiateShutdownResponseData data() {
        return this.data;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public String toString() {
        return this.data.toString();
    }
}

