/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.internals;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.requests.SamplingRequestLogFilter;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.fips.FipsValidator;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.apache.kafka.server.interceptor.DefaultBrokerInterceptor;
import org.apache.kafka.server.license.LicenseValidator;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;

public class ConfluentConfigs {
    private static final String CONFLUENT_PREFIX = "confluent.";
    public static final String BROKER_INTERCEPTOR_CLASS_CONFIG = "broker.interceptor.class";
    public static final Class<?> BROKER_INTERCEPTOR_CLASS_DEFAULT = DefaultBrokerInterceptor.class;
    public static final String MULTITENANT_AUTHORIZER_CLASS_NAME = "io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer";
    public static final String MULTITENANT_METADATA_CLASS_CONFIG = "multitenant.metadata.class";
    public static final String MULTITENANT_METADATA_CLASS_DEFAULT = null;
    public static final String MULTITENANT_METADATA_DIR_CONFIG = "multitenant.metadata.dir";
    public static final String MULTITENANT_METADATA_DIR_DEFAULT = null;
    public static final String MULTITENANT_METADATA_SSL_CERTS_SPEC_CONFIG = "multitenant.metadata.ssl.certs.path";
    public static final String MULTITENANT_METADATA_SSL_CERTS_SPEC_DEFAULT = null;
    public static final String MULTITENANT_METADATA_RELOAD_DELAY_MS_CONFIG = "multitenant.metadata.reload.delay.ms";
    public static final Long MULTITENANT_METADATA_RELOAD_DELAY_MS_DEFAULT = TimeUnit.MINUTES.toMillis(2L);
    public static final String MULTITENANT_METADATA_RELOAD_DELAY_MS_DOC = "Interval (in ms) between full reloads of logical cluster metadata. Defaults to 10 minutes.";
    public static final String MULTITENANT_TENANT_DELETE_DELAY_MS_CONFIG = "multitenant.tenant.delete.delay";
    public static final Long MULTITENANT_TENANT_DELETE_DELAY_MS_DEFAULT = TimeUnit.DAYS.toMillis(7L);
    public static final String MULTITENANT_TENANT_DELETE_DELAY_MS_DOC = "Delay between the time the tenant is marked as deactivated in JSON file, until we actually start deleting topics. This defaults to 7 days to allow plenty of times for operators and users to regret their decisions and do something about it";
    public static final String MULTITENANT_TENANT_DELETE_BATCH_SIZE_CONFIG = "multitenant.tenant.delete.batch.size";
    public static final Integer MULTITENANT_TENANT_DELETE_BATCH_SIZE_DEFAULT = 10;
    public static final String MULTITENANT_TENANT_DELETE_BATCH_SIZE_DOC = "Batch size for topic deletion of deactivated tenants. We wait for each batch to complete before sending another";
    private static final String SCHEMA_REGISTRY_URL = "schema.registry.url";
    public static final String SCHEMA_REGISTRY_URL_CONFIG = "confluent.schema.registry.url";
    public static final String SCHEMA_REGISTRY_URL_DOC = "Comma-separated list of URLs for schema registry instances that can be used to look up schemas.";
    public static final String MAX_CACHE_SIZE_CONFIG = "confluent.schema.registry.max.cache.size";
    public static final String MAX_CACHE_SIZE_DOC = "Maximum size of each LRU cache used to cache responses from the schema registry. There is one cache to hold the ID to schema mappings and another to hold the schemas that are registered to a subject.";
    public static final int MAX_CACHE_SIZE_DEFAULT = 10000;
    public static final String MAX_RETRIES_CONFIG = "confluent.schema.registry.max.retries";
    public static final String MAX_RETRIES_DOC = "Maximum number of times to retry schema registry read operations.";
    public static final int MAX_RETRIES_DEFAULT = 1;
    public static final String RETRIES_WAIT_MS_CONFIG = "confluent.schema.registry.retries.wait.ms";
    public static final String RETRIES_WAIT_MS_DOC = "Time in milliseconds to wait before each retry.";
    public static final int RETRIES_WAIT_MS_DEFAULT = 0;
    public static final String MISSING_ID_QUERY_RANGE_CONFIG = "confluent.missing.id.query.range";
    public static final String MISSING_ID_QUERY_RANGE_DOC = "The range above max schema ID to make calls to Schema Registry";
    public static final int MISSING_ID_QUERY_RANGE_DEFAULT = 200;
    public static final String MISSING_ID_CACHE_TTL_CONFIG = "confluent.missing.id.cache.ttl.sec";
    public static final String MISSING_ID_CACHE_TTL_DOC = "The TTL in seconds for caching missing schema IDs";
    public static final long MISSING_ID_CACHE_TTL_DEFAULT = 60L;
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_CONFIG = "confluent.basic.auth.credentials.source";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DEFAULT = null;
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DOC = "Specify how to pick the credentials for Basic Auth header. The supported values are URL, USER_INFO and SASL_INHERIT";
    public static final String USER_INFO_CONFIG = "confluent.basic.auth.user.info";
    public static final String USER_INFO_DEFAULT = null;
    public static final String USER_INFO_DOC = "Specify the user info for Basic Auth in the form of {username}:{password}";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_CONFIG = "confluent.bearer.auth.credentials.source";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_DEFAULT = null;
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_DOC = "Specify how to pick the credentials for Bearer Auth header. ";
    public static final String BEARER_AUTH_TOKEN_CONFIG = "confluent.bearer.auth.token";
    public static final String BEARER_AUTH_TOKEN_DEFAULT = null;
    public static final String BEARER_AUTH_TOKEN_DOC = "Specify the Bearer token to be used for authentication";
    public static final String SSL_PROTOCOL_CONFIG = "confluent.ssl.protocol";
    public static final String SSL_PROTOCOL_DOC = "The SSL protocol used to generate the SSLContext. Default setting is TLSv1.2, which is fine for most cases. Allowed values in recent JVMs are TLSv1.2 and TLSv1.3. TLS, TLSv1.1, SSL, SSLv2 and SSLv3 may be supported in older JVMs, but their usage is discouraged due to known security vulnerabilities.";
    public static final String SSL_KEYSTORE_TYPE_CONFIG = "confluent.ssl.keystore.type";
    public static final String SSL_KEYSTORE_TYPE_DOC = "The file format of the key store file. This is optional for client.";
    public static final String SSL_KEYSTORE_LOCATION_CONFIG = "confluent.ssl.keystore.location";
    public static final String SSL_KEYSTORE_LOCATION_DOC = "The location of the key store file. This is optional for client and can be used for two-way authentication for client.";
    public static final String SSL_KEYSTORE_PASSWORD_CONFIG = "confluent.ssl.keystore.password";
    public static final String SSL_KEYSTORE_PASSWORD_DOC = "The store password for the key store file. This is optional for client and only needed if ssl.keystore.location is configured. ";
    public static final String SSL_KEY_PASSWORD_CONFIG = "confluent.ssl.key.password";
    public static final String SSL_KEY_PASSWORD_DOC = "The password of the private key in the key store file. This is optional for client.";
    public static final String SSL_TRUSTSTORE_TYPE_CONFIG = "confluent.ssl.truststore.type";
    public static final String SSL_TRUSTSTORE_TYPE_DOC = "The file format of the trust store file.";
    public static final String SSL_TRUSTSTORE_LOCATION_CONFIG = "confluent.ssl.truststore.location";
    public static final String SSL_TRUSTSTORE_LOCATION_DOC = "The location of the trust store file. ";
    public static final String SSL_TRUSTSTORE_PASSWORD_CONFIG = "confluent.ssl.truststore.password";
    public static final String SSL_TRUSTSTORE_PASSWORD_DOC = "The password for the trust store file. If a password is not set access to the truststore is still available, but integrity checking is disabled.";
    public static final String TENANT_QUOTA_CALLBACK_CLASS = "io.confluent.kafka.multitenant.quota.TenantQuotaCallback";
    public static final String BACKPRESSURE_TYPES_CONFIG = "confluent.backpressure.types";
    public static final String BACKPRESSURE_TYPES_DEFAULT = null;
    public static final String BACKPRESSURE_TYPES_DOC = "Comma separated list of resource types for which broker back-pressure is enabled. Backpressure is not enabled by default. Accepted values: 'request', 'produce', 'fetch'.Invalid values are ignored. This config is ignored if client.quota.callback.class is not set, or set to class other than TenantQuotaCallback. In other words, broker back-pressure can be enabled for multi-tenant clusters only.";
    public static final String BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_CONFIG = "confluent.backpressure.request.min.broker.limit";
    public static final Long BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT = 200L;
    public static final String BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DOC = "The minimum broker request quota, i.e., request backpressure would not reduce the broker request quota any further even if the request overload is still detected. Broker-wide request quota, if not unlimited, caps the combined dynamic request quotas of currently active tenants. All values are accepted, but values below 10 will result in the minimum limit of 10.";
    public static final String BACKPRESSURE_REQUEST_QUEUE_SIZE_PERCENTILE_CONFIG = "confluent.backpressure.request.queue.size.percentile";
    public static final String BACKPRESSURE_REQUEST_QUEUE_SIZE_PERCENTILE_DEFAULT = "p95";
    public static final String BACKPRESSURE_REQUEST_QUEUE_SIZE_PERCENTILE_DOC = "Queue size percentile used by request backpressure. For example, p95 means that when the number of requests in the request queue exceeds 80% of `queued.max.requests` in more than 5% of cases, the backpressure mechanism starts reducing the total broker request quota. Accepted values: `p90`, `p95`, `p98`, `p99`. Setting an invalid value will default to `p95`.";
    public static final String BACKPRESSURE_PRODUCE_THROUGHPUT_CONFIG = "confluent.backpressure.disk.produce.bytes.per.second";
    public static final long BACKPRESSURE_PRODUCE_THROUGHPUT_DEFAULT = 131072L;
    public static final String BACKPRESSURE_PRODUCE_THROUGHPUT_DOC = "The cumulative bandwidth (in Bytes/s) available to all the producers in the broker";
    public static final String BACKPRESSURE_DISK_ENABLE_CONFIG = "confluent.backpressure.disk.enable";
    public static final boolean BACKPRESSURE_DISK_ENABLE_DEFAULT = false;
    public static final String BACKPRESSURE_DISK_ENABLE_DOC = "This flag will be used to turn on the disk based backpressure";
    public static final String BACKPRESSURE_DISK_THRESHOLD_BYTES_CONFIG = "confluent.backpressure.disk.free.threshold.bytes";
    public static final long BACKPRESSURE_DISK_THRESHOLD_BYTES_DEFAULT = 0x500000000L;
    public static final String BACKPRESSURE_DISK_THRESHOLD_BYTES_DOC = "The disk space available (in bytes) considered as the minimum across all the log dirs, below which the broker will limit aggregate produce bandwidth from all clients to the bandwidth specified in confluent.backpressure.disk.produce.bytes.per.second";
    public static final String BACKPRESSURE_DISK_RECOVERY_FACTOR_CONFIG = "confluent.backpressure.disk.threshold.recovery.factor";
    public static final double BACKPRESSURE_DISK_RECOVERY_FACTOR_DEFAULT = 1.5;
    public static final String BACKPRESSURE_DISK_RECOVERY_FACTOR_DOC = "The multiplier for the free disk threshold (specified via confluent.backpressure.disk.free.threshold.bytes) above which the throttling would be deactivated";
    public static final String AUTO_ENABLE_TELEMETRY_REPORTER_CONFIG = "confluent.reporters.telemetry.auto.enable";
    public static final String AUTO_ENABLE_TELEMETRY_REPORTER_DOC = "Auto-enable telemetry on the broker. This will add the telemetry reporter to the broker's 'metric.reporters' property if it is not already present. Disabling this property will prevent Self-balancing Clusters from working properly.";
    public static final boolean AUTO_ENABLE_TELEMETRY_REPORTER_DEFAULT = true;
    public static final String CONFLUENT_BALANCER_PREFIX = "confluent.balancer.";
    public static final String BALANCER_CLASS_CONFIG = "confluent.balancer.class";
    public static final String BALANCER_CLASS_DOC = "The class providing DataBalancer services for the Kafka controller.";
    public static final String BALANCER_CLASS_DEFAULT = "io.confluent.databalancer.KafkaDataBalanceManager";
    public static final String BALANCER_ENABLE_SBK_CONFIG = "enable";
    public static final String BALANCER_ENABLE_CONFIG = "confluent.balancer.enable";
    public static final boolean BALANCER_ENABLE_DEFAULT = false;
    public static final String BALANCER_ENABLE_DOC = "This config controls whether the balancer is enabled";
    public static final String BALANCER_AUTO_HEAL_MODE_SBK_CONFIG = "heal.uneven.load.trigger";
    public static final String BALANCER_AUTO_HEAL_MODE_CONFIG = "confluent.balancer.heal.uneven.load.trigger";
    public static final String BALANCER_AUTO_HEAL_MODE_DEFAULT = BalancerSelfHealMode.EMPTY_BROKER.toString();
    public static final String BALANCER_AUTO_HEAL_MODE_DOC = "Controls what causes the Confluent DataBalancer to start rebalance operations. Acceptable values are " + BalancerSelfHealMode.ANY_UNEVEN_LOAD.toString() + " and " + BalancerSelfHealMode.EMPTY_BROKER.toString();
    public static final String BALANCER_BROKER_FAILURE_THRESHOLD_SBK_CONFIG = "heal.broker.failure.threshold.ms";
    public static final String BALANCER_BROKER_FAILURE_THRESHOLD_CONFIG = "confluent.balancer.heal.broker.failure.threshold.ms";
    public static final Long BALANCER_BROKER_FAILURE_THRESHOLD_DEFAULT = Duration.ofHours(1L).toMillis();
    public static final Long BALANCER_BROKER_FAILURE_THRESHOLD_DISABLED = -1L;
    public static final String BALANCER_BROKER_FAILURE_THRESHOLD_DOC = "This config specifies how long the balancer will wait after detecting a broker failure before triggering a balancing action. -1 means that broker failures will not trigger balancing actions";
    public static final String BALANCER_THROTTLE_SBK_CONFIG = "throttle.bytes.per.second";
    public static final String BALANCER_THROTTLE_CONFIG = "confluent.balancer.throttle.bytes.per.second";
    public static final Long BALANCER_THROTTLE_NO_THROTTLE = -1L;
    public static final Long BALANCER_THROTTLE_AUTO_THROTTLE;
    public static final Long BALANCER_THROTTLE_MIN;
    public static final Long BALANCER_THROTTLE_DEFAULT;
    public static final String BALANCER_THROTTLE_DOC = "This config specifies the upper bound for bandwidth in bytes to move replicas around for replica reassignment. A value of -1 disables throttling entirely.";
    public static final String BALANCER_REPLICA_CAPACITY_SBK_CONFIG = "max.replicas";
    public static final String BALANCER_REPLICA_CAPACITY_CONFIG = "confluent.balancer.max.replicas";
    public static final Long BALANCER_REPLICA_CAPACITY_DEFAULT;
    public static final String BALANCER_REPLICA_CAPACITY_DOC = "The replica capacity is the maximum number of replicas the balancer will place on a single broker.";
    public static final String BALANCER_DISK_CAPACITY_THRESHOLD_SBK_CONFIG = "disk.max.load";
    public static final String BALANCER_DISK_CAPACITY_THRESHOLD_CONFIG = "confluent.balancer.disk.max.load";
    public static final Double BALANCER_DISK_CAPACITY_THRESHOLD_DEFAULT;
    public static final String BALANCER_DISK_CAPACITY_THRESHOLD_DOC = "This config specifies the maximum load for disk usage as a proportion of disk capacity. Valid values are between 0 and 1.";
    public static final String BALANCER_NETWORK_IN_CAPACITY_SBK_CONFIG = "network.in.max.bytes.per.second";
    public static final String BALANCER_NETWORK_IN_CAPACITY_CONFIG = "confluent.balancer.network.in.max.bytes.per.second";
    public static final Long BALANCER_NETWORK_IN_CAPACITY_DEFAULT;
    public static final Long BALANCER_NETWORK_IN_CAPACITY_MIN;
    public static final String BALANCER_NETWORK_IN_CAPACITY_DOC = "This config specifies the upper capacity limit for network incoming bytes per second per broker. The Confluent DataBalancer will attempt to keep incoming data throughput below this limit.";
    public static final String BALANCER_NETWORK_OUT_CAPACITY_SBK_CONFIG = "network.out.max.bytes.per.second";
    public static final String BALANCER_NETWORK_OUT_CAPACITY_CONFIG = "confluent.balancer.network.out.max.bytes.per.second";
    public static final Long BALANCER_NETWORK_OUT_CAPACITY_DEFAULT;
    public static final Long BALANCER_NETWORK_OUT_CAPACITY_MIN;
    public static final String BALANCER_NETWORK_OUT_CAPACITY_DOC = "This config specifies the upper capacity limit for network outgoing bytes per second per broker. The Confluent DataBalancer will attempt to keep outgoing data throughput below this limit.";
    public static final String BALANCER_EXCLUDE_TOPIC_NAMES_SBK_CONFIG = "exclude.topic.names";
    public static final String BALANCER_EXCLUDE_TOPIC_NAMES_CONFIG = "confluent.balancer.exclude.topic.names";
    public static final List BALANCER_EXCLUDE_TOPIC_NAMES_DEFAULT;
    public static final String BALANCER_EXCLUDE_TOPIC_NAMES_DOC = "This config accepts a list of topic names that will be excluded from rebalancing. For example, 'confluent.balancer.exclude.topic.names=[topic1, topic2]' ";
    public static final String BALANCER_EXCLUDE_TOPIC_PREFIXES_BASE_CONFIG = "exclude.topic.prefixes";
    public static final String BALANCER_EXCLUDE_TOPIC_PREFIXES_CONFIG = "confluent.balancer.exclude.topic.prefixes";
    public static final List BALANCER_EXCLUDE_TOPIC_PREFIXES_DEFAULT;
    public static final String BALANCER_EXCLUDE_TOPIC_PREFIXES_DOC = "This config accepts a list of topic prefixes that will be excluded from rebalancing. For example, 'confluent.balancer.exclude.topic.prefixes=[prefix1, prefix2]' would exclude topics 'prefix1-suffix1', 'prefix1-suffix2', 'prefix2-suffix3', but not 'abc-prefix1-xyz' and 'def-prefix2'";
    public static final String BALANCER_API_STATE_TOPIC_SBK_CONFIG = "api.state.topic";
    public static final String BALANCER_API_STATE_TOPIC_CONFIG = "confluent.balancer.api.state.topic";
    public static final String BALANCER_API_STATE_TOPIC_DEFAULT = "_confluent_balancer_api_state";
    public static final String BALANCER_API_STATE_TOPIC_DOC = "Name of topic to use to store state of Confluent DataBalancer API. The topic will be used to store progress/failure of the api and will be used in case of recovery to resume long running operations like remove or add broker.";
    public static final String BALANCER_TOPICS_REPLICATION_FACTOR_SBK_CONFIG = "topic.replication.factor";
    public static final String BALANCER_TOPICS_REPLICATION_FACTOR_CONFIG = "confluent.balancer.topic.replication.factor";
    public static final Short BALANCER_TOPICS_REPLICATION_FACTOR_DEFAULT;
    public static final String BALANCER_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor for all topics that are created and needed by the Confluent DataBalancer. This includes Sample Store and API state topics.";
    public static final String BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_SBK_CONFIG = "task.history.retention.days";
    public static final String BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_CONFIG = "confluent.balancer.task.history.retention.days";
    public static final Integer BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DEFAULT;
    public static final String BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DOC = "Number of days for which self balancing cluster's task history will be retained.";
    public static final String OPERATOR_MANAGED_CONFIG = "confluent.operator.managed";
    public static final boolean OPERATOR_MANAGED_DEFAULT = false;
    public static final String OPERATOR_MANAGED_DOC = "This config indicates if the Confluent Operator was involved in generating the broker configuration.";
    public static final String MULTITENANT_LISTENER_NAMES_CONFIG = "confluent.multitenant.listener.names";
    public static final String MULTITENANT_LISTENER_NAMES_DEFAULT;
    public static final String MULTITENANT_LISTENER_NAMES_DOC = "Comma separated list of listener names used for communications with tenants. If this is unset, broker request (time on network and IO threads) backpressure will not be applied.";
    public static final String REQUEST_LOG_FILTER_CLASS_CONFIG = "confluent.request.log.filter.class";
    public static final String REQUEST_LOG_FILTER_DEFAULT;
    public static final String REQUEST_LOG_FILTER_CLASS_DOC = "Class of request log filter which can be used to select a subset of requests for logging. Every request handler thread will get a separate instance of this class and is only consulted if the request log level is set to INFO or higher.";
    public static final String APPLY_CREATE_TOPIC_POLICY_TO_CREATE_PARTITIONS = "confluent.apply.create.topic.policy.to.create.partitions";
    public static final boolean APPLY_CREATE_TOPIC_POLICY_TO_CREATE_PARTITIONS_DEFAULT = false;
    public static final String APPLY_CREATE_TOPIC_POLICY_TO_CREATE_PARTITIONS_DOC = "If this is set, CreateTopicsPolicy will also apply to CreatePartitions.";
    public static final String VERIFY_GROUP_SUBSCRIPTION_PREFIX = "confluent.verify.group.subscription.prefix";
    public static final boolean VERIFY_GROUP_SUBSCRIPTION_PREFIX_DEFAULT = false;
    public static final String VERIFY_GROUP_SUBSCRIPTION_PREFIX_DOC = "If this is set, the group coordinator will verify that the subscriptions are prefixed with the tenant.";
    public static final String STRAY_PARTITION_DELETION_ENABLE_CONFIG = "confluent.enable.stray.partition.deletion";
    public static final boolean STRAY_PARTITION_DELETION_ENABLE_DEFAULT = false;
    public static final String STRAY_PARTITION_DELETION_ENABLE_DOC = "Whether stray partition deletion is enabled";
    public static final String CRN_AUTHORITY_PREFIX = "confluent.authorizer.authority.";
    public static final String CRN_AUTHORITY_NAME_CONFIG = "confluent.authorizer.authority.name";
    public static final String CRN_AUTHORITY_NAME_DEFAULT = "";
    public static final String CRN_AUTHORITY_NAME_DOC = "The DNS name of the authority that this clusteruses to authorize. This should be a name for the cluster hosting metadata topics.";
    public static final String EVENT_LOGGER_PREFIX = "event.logger.";
    public static final String AUDIT_PREFIX = "confluent.security.";
    public static final String AUDIT_EVENT_LOGGER_PREFIX = "confluent.security.event.logger.";
    public static final String AUDIT_EVENT_ROUTER_PREFIX = "confluent.security.event.router.";
    public static final String AUDIT_EVENT_ROUTER_CONFIG = "confluent.security.event.router.config";
    public static final String AUDIT_EVENT_ROUTER_DEFAULT = "";
    public static final String AUDIT_EVENT_ROUTER_DOC = "JSON configuration for routing events to topics";
    public static final String AUDIT_LOGGER_ENABLE_CONFIG = "confluent.security.event.logger.enable";
    public static final String AUDIT_LOGGER_ENABLE_DEFAULT = "true";
    public static final String AUDIT_LOGGER_ENABLE_DOC = "Whether the event logger is enabled";
    public static final String ENABLE_AUTHENTICATION_AUDIT_LOGS = "confluent.security.event.logger.authentication.enable";
    public static final String ENABLE_AUTHENTICATION_AUDIT_LOGS_DEFAULT = "false";
    public static final String ENABLE_AUTHENTICATION_AUDIT_LOGS_DOC = "Enable authentication audit logs";
    public static final String CLUSTER_REGISTRY_CONFIG = "confluent.metadata.server.cluster.registry.clusters";
    public static final String CLUSTER_REGISTRY_CONFIG_DEFAULT = "[]";
    public static final String CLUSTER_REGISTRY_CONFIG_DOC = "JSON defining initial state of Cluster Registry. This should not be set manually, instead Cluster Registry http apis should be used.";
    public static final String ENABLE_FIPS_CONFIG = "enable.fips";
    public static final String ENABLE_FIPS_DEFAULT = "false";
    public static final String ENABLE_FIPS_DOC = "Enable FIPS mode on the server. If FIPS mode is enabled, broker listener security protocols, TLS versions and cipher suites will be validated based on FIPS compliance requirement.";
    public static final String CLUSTER_LINK_ENABLE_CONFIG = "confluent.cluster.link.enable";
    public static final boolean CLUSTER_LINK_ENABLE_DEFAULT = false;
    public static final String CLUSTER_LINK_ENABLE_DOC = "Enable cluster linking feature.";
    public static final String NUM_CLUSTER_LINK_REPLICATION_QUOTAS_SAMPLES_CONFIG = "confluent.cluster.link.replication.quota.window.num";
    public static final String NUM_CLUSTER_LINK_REPLICATION_QUOTAS_SAMPLES_DOC = "The number of samples to retain in memory for cluster link replication quotas";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_WINDOW_SIZE_SECONDS_CONFIG = "confluent.cluster.link.replication.quota.window.size.seconds";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_WINDOW_SIZE_SECONDS_DOC = "The time span of each sample for cluster link replication quotas";
    public static final String INTERNAL_REST_SERVER_BIND_PORT_CONFIG = "confluent.internal.rest.server.bind.port";
    public static final Integer INTERNAL_REST_SERVER_BIND_PORT_DEFAULT;
    public static final String INTERNAL_REST_SERVER_BIND_PORT_DOC = "The port to bind the internal rest server to.";
    public static final String HTTP_SERVER_START_TIMEOUT_MS_CONFIG = "confluent.http.server.start.timeout.ms";
    public static final Long HTTP_SERVER_START_TIMEOUT_MS_DEFAULT;
    public static final String HTTP_SERVER_START_TIMEOUT_MS_DOC = "How long to wait for the Kafka HTTP server to start up, in milliseconds. Default is 30s.";
    public static final String HTTP_SERVER_STOP_TIMEOUT_MS_CONFIG = "confluent.http.server.stop.timeout.ms";
    public static final Long HTTP_SERVER_STOP_TIMEOUT_MS_DEFAULT;
    public static final String HTTP_SERVER_STOP_TIMEOUT_MS_DOC = "How long to wait for the Kafka HTTP server to shutdown, in milliseconds. Default is 30s.";
    public static final String RESOURCE_LABEL_PREFIX = "resource.";
    public static final String RESOURCE_LABEL_TYPE = "resource.type";
    public static final String RESOURCE_LABEL_VERSION = "resource.version";
    public static final String RESOURCE_LABEL_COMMIT_ID = "resource.commit.id";
    public static final String MAX_BROKER_TENANT_PRODUCER_BYTE_RATE_CONFIG = "confluent.quota.tenant.broker.max.producer.rate";
    public static final String MAX_BROKER_TENANT_PRODUCER_BYTE_RATE_DOC = "Maximum producer quota in bytes/s per tenant per broker";
    public static final long MAX_BROKER_TENANT_PRODUCER_BYTE_RATE_DEFAULT = 0xC80000L;
    public static final String MAX_BROKER_TENANT_CONSUMER_BYTE_RATE_CONFIG = "confluent.quota.tenant.broker.max.consumer.rate";
    public static final String MAX_BROKER_TENANT_CONSUMER_BYTE_RATE_DOC = "Maximum consumer quota in bytes/s per tenant per broker";
    public static final long MAX_BROKER_TENANT_CONSUMER_BYTE_RATE_DEFAULT = 0xC80000L;
    public static final String MIN_FOLLOWER_BROKER_TENANT_PRODUCER_BYTE_RATE_CONFIG = "confluent.quota.tenant.follower.broker.min.producer.rate";
    public static final String MIN_FOLLOWER_BROKER_TENANT_PRODUCER_BYTE_RATE_DOC = "Minimum producer quota in bytes/s per tenant per broker that has no leaders for tenant's partitions";
    public static final long MIN_FOLLOWER_BROKER_TENANT_PRODUCER_BYTE_RATE_DEFAULT = 0xA00000L;
    public static final String MIN_FOLLOWER_BROKER_TENANT_CONSUMER_BYTE_RATE_CONFIG = "confluent.quota.tenant.follower.broker.min.consumer.rate";
    public static final String MIN_FOLLOWER_BROKER_TENANT_CONSUMER_BYTE_RATE_DOC = "Minimum consumer quota in bytes/s per tenant per broker that has no leaders for tenant's partitions";
    public static final long MIN_FOLLOWER_BROKER_TENANT_CONSUMER_BYTE_RATE_DEFAULT = 0xA00000L;

    public static BrokerInterceptor buildBrokerInterceptor(Mode mode, Map<String, ?> configs) {
        if (mode == Mode.CLIENT) {
            return null;
        }
        BrokerInterceptor interceptor = new DefaultBrokerInterceptor();
        if (configs.containsKey(BROKER_INTERCEPTOR_CLASS_CONFIG)) {
            Class interceptorClass = (Class)configs.get(BROKER_INTERCEPTOR_CLASS_CONFIG);
            interceptor = (BrokerInterceptor)Utils.newInstance(interceptorClass);
        }
        interceptor.configure(configs);
        return interceptor;
    }

    public static MultiTenantMetadata buildMultitenantMetadata(Map<String, ?> configs) {
        MultiTenantMetadata meta = null;
        if (configs.get(MULTITENANT_METADATA_CLASS_CONFIG) != null) {
            Class multitenantMetadataClass = (Class)configs.get(MULTITENANT_METADATA_CLASS_CONFIG);
            meta = (MultiTenantMetadata)Utils.newInstance(multitenantMetadataClass);
            meta.configure(configs);
        }
        return meta;
    }

    public static LicenseValidator buildLicenseValidator(AbstractConfig config, Endpoint interBrokerEndpoint) {
        Configurable licenseValidator = null;
        ServiceLoader<LicenseValidator> validators = ServiceLoader.load(LicenseValidator.class);
        for (LicenseValidator validator : validators) {
            if (!validator.enabled()) continue;
            licenseValidator = validator;
            break;
        }
        if (licenseValidator == null) {
            throw new IllegalStateException("License validator not found");
        }
        licenseValidator.configure(ConfluentConfigs.interBrokerClientConfigs(config, interBrokerEndpoint));
        return licenseValidator;
    }

    public static Map<String, Object> interBrokerClientConfigs(AbstractConfig brokerConfig, Endpoint interBrokerEndpoint) {
        return ConfluentConfigs.interBrokerClientConfigs(brokerConfig.originals(), brokerConfig.values(), interBrokerEndpoint);
    }

    public static Map<String, Object> interBrokerClientConfigs(Map<String, Object> originals, Endpoint interBrokerEndpoint) {
        return ConfluentConfigs.interBrokerClientConfigs(originals, Collections.emptyMap(), interBrokerEndpoint);
    }

    public static Map<String, Object> interBrokerClientConfigs(Map<String, Object> originals, Map<String, ?> values, Endpoint interBrokerEndpoint) {
        HashMap<String, Object> clientConfigs = new HashMap<String, Object>(originals);
        Set<String> brokerConfigNames = values.keySet();
        clientConfigs.keySet().removeIf(n -> brokerConfigNames.contains(n) && !AdminClientConfig.configNames().contains(n) || n.startsWith("listener.name."));
        ListenerName listenerName = new ListenerName(interBrokerEndpoint.listenerName().get());
        String listenerPrefix = listenerName.configPrefix();
        SecurityProtocol securityProtocol = interBrokerEndpoint.securityProtocol();
        if (securityProtocol == SecurityProtocol.SASL_PLAINTEXT || securityProtocol == SecurityProtocol.SASL_SSL) {
            String saslMechanism = (String)originals.get("sasl.mechanism.inter.broker.protocol");
            saslMechanism = saslMechanism != null ? saslMechanism : "GSSAPI";
            clientConfigs.put("sasl.mechanism", saslMechanism);
            String mechanismPrefix = listenerName.saslMechanismConfigPrefix(saslMechanism);
            ConfluentConfigs.updatePrefixedConfigs(originals, clientConfigs, mechanismPrefix);
            if (!clientConfigs.containsKey("sasl.jaas.config")) {
                String jaasConfig = JaasContext.listenerSaslJaasConfig(listenerName, saslMechanism);
                clientConfigs.put("sasl.jaas.config", jaasConfig);
            }
        }
        ConfluentConfigs.updatePrefixedConfigs(originals, clientConfigs, listenerPrefix);
        String ibpHost = interBrokerEndpoint.host() == null ? "" : interBrokerEndpoint.host();
        clientConfigs.put("bootstrap.servers", ibpHost + ":" + interBrokerEndpoint.port());
        clientConfigs.put("security.protocol", securityProtocol.name);
        return clientConfigs;
    }

    public static Map<String, Object> clientConfigs(AbstractConfig config, String configPrefix, ClientType clientType, String topicPrefix, String componentId) {
        Map<String, Object> srcConfigs = config.originals();
        srcConfigs.keySet().removeAll(config.values().keySet());
        HashMap<String, Object> clientConfigs = new HashMap<String, Object>(srcConfigs);
        clientConfigs.remove("metric.reporters");
        clientConfigs.put("client.id", String.format("%s-%s-%s", topicPrefix, clientType.type, componentId));
        ConfluentConfigs.updatePrefixedConfigs(srcConfigs, clientConfigs, configPrefix + clientType.type + ".");
        ConfluentConfigs.updatePrefixedConfigs(srcConfigs, clientConfigs, configPrefix);
        return clientConfigs;
    }

    public static FipsValidator buildFipsValidator() {
        FipsValidator fipsValidator = null;
        ServiceLoader<FipsValidator> validators = ServiceLoader.load(FipsValidator.class);
        for (FipsValidator validator : validators) {
            if (!validator.fipsEnabled()) continue;
            fipsValidator = validator;
            break;
        }
        if (fipsValidator == null) {
            throw new IllegalStateException("FIPS validator not found");
        }
        return fipsValidator;
    }

    private static void updatePrefixedConfigs(Map<String, Object> configs, Map<String, Object> dstConfigs, String prefix) {
        Set<String> prefixed = configs.keySet().stream().filter(n -> n.startsWith(prefix)).collect(Collectors.toSet());
        prefixed.forEach(name -> {
            dstConfigs.remove(name);
            dstConfigs.put(name.substring(prefix.length()), configs.get(name));
        });
        configs.keySet().removeAll(prefixed);
    }

    static {
        BALANCER_THROTTLE_MIN = BALANCER_THROTTLE_AUTO_THROTTLE = Long.valueOf(-2L);
        BALANCER_THROTTLE_DEFAULT = 0xA00000L;
        BALANCER_REPLICA_CAPACITY_DEFAULT = Integer.MAX_VALUE;
        BALANCER_DISK_CAPACITY_THRESHOLD_DEFAULT = 0.85;
        BALANCER_NETWORK_IN_CAPACITY_DEFAULT = Long.MAX_VALUE;
        BALANCER_NETWORK_IN_CAPACITY_MIN = 1L;
        BALANCER_NETWORK_OUT_CAPACITY_DEFAULT = Long.MAX_VALUE;
        BALANCER_NETWORK_OUT_CAPACITY_MIN = 1L;
        BALANCER_EXCLUDE_TOPIC_NAMES_DEFAULT = Collections.EMPTY_LIST;
        BALANCER_EXCLUDE_TOPIC_PREFIXES_DEFAULT = Collections.EMPTY_LIST;
        BALANCER_TOPICS_REPLICATION_FACTOR_DEFAULT = 3;
        BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DEFAULT = 30;
        MULTITENANT_LISTENER_NAMES_DEFAULT = null;
        REQUEST_LOG_FILTER_DEFAULT = SamplingRequestLogFilter.class.getName();
        INTERNAL_REST_SERVER_BIND_PORT_DEFAULT = null;
        HTTP_SERVER_START_TIMEOUT_MS_DEFAULT = Duration.ofSeconds(30L).toMillis();
        HTTP_SERVER_STOP_TIMEOUT_MS_DEFAULT = Duration.ofSeconds(30L).toMillis();
    }

    public static enum ClientType {
        PRODUCER("producer", ProducerConfig.configNames()),
        CONSUMER("consumer", ConsumerConfig.configNames()),
        ADMIN("admin", AdminClientConfig.configNames()),
        COORDINATOR("coordinator", ConsumerConfig.configNames());

        final String type;
        final Set<String> configNames;

        private ClientType(String type, Set<String> configNames) {
            this.type = type;
            this.configNames = configNames;
        }
    }

    public static enum BalancerSelfHealMode {
        EMPTY_BROKER,
        ANY_UNEVEN_LOAD;

    }
}

