/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class RemoveBrokersRequestData
implements ApiMessage {
    private int timeoutMs;
    private List<BrokerId> brokersToRemove;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("timeout_ms", Type.INT32, "The time in ms to wait for the request to complete."), new Field("brokers_to_remove", new ArrayOf(BrokerId.SCHEMA_0), "Broker IDs to remove."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

    public RemoveBrokersRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public RemoveBrokersRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public RemoveBrokersRequestData() {
        this.timeoutMs = 60000;
        this.brokersToRemove = new ArrayList<BrokerId>(0);
    }

    @Override
    public short apiKey() {
        return 10001;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.timeoutMs = _readable.readInt();
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field brokersToRemove was serialized as null");
        }
        ArrayList<BrokerId> newCollection = new ArrayList<BrokerId>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new BrokerId(_readable, _version));
        }
        this.brokersToRemove = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.timeoutMs);
        _writable.writeInt(this.brokersToRemove.size());
        for (BrokerId brokersToRemoveElement : this.brokersToRemove) {
            brokersToRemoveElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.timeoutMs = struct.getInt("timeout_ms");
        Object[] _nestedObjects = struct.getArray("brokers_to_remove");
        this.brokersToRemove = new ArrayList<BrokerId>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.brokersToRemove.add(new BrokerId((Struct)nestedObject, _version));
        }
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("timeout_ms", (Object)this.timeoutMs);
        Struct[] _nestedObjects = new Struct[this.brokersToRemove.size()];
        int i = 0;
        for (BrokerId element : this.brokersToRemove) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("brokers_to_remove", (Object)_nestedObjects);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        int _arraySize = 0;
        _arraySize += 4;
        for (BrokerId brokersToRemoveElement : this.brokersToRemove) {
            _arraySize += brokersToRemoveElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RemoveBrokersRequestData)) {
            return false;
        }
        RemoveBrokersRequestData other = (RemoveBrokersRequestData)obj;
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return !(this.brokersToRemove == null ? other.brokersToRemove != null : !this.brokersToRemove.equals(other.brokersToRemove));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + (this.brokersToRemove == null ? 0 : this.brokersToRemove.hashCode());
        return hashCode;
    }

    @Override
    public RemoveBrokersRequestData duplicate() {
        RemoveBrokersRequestData _duplicate = new RemoveBrokersRequestData();
        _duplicate.timeoutMs = this.timeoutMs;
        ArrayList<BrokerId> newBrokersToRemove = new ArrayList<BrokerId>(this.brokersToRemove.size());
        for (BrokerId _element : this.brokersToRemove) {
            newBrokersToRemove.add(_element.duplicate());
        }
        _duplicate.brokersToRemove = newBrokersToRemove;
        return _duplicate;
    }

    public String toString() {
        return "RemoveBrokersRequestData(timeoutMs=" + this.timeoutMs + ", brokersToRemove=" + MessageUtil.deepToString(this.brokersToRemove.iterator()) + ")";
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public List<BrokerId> brokersToRemove() {
        return this.brokersToRemove;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public RemoveBrokersRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public RemoveBrokersRequestData setBrokersToRemove(List<BrokerId> v) {
        this.brokersToRemove = v;
        return this;
    }

    public static class BrokerId
    implements Message {
        private int brokerId;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The Broker ID to remove"));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};

        public BrokerId(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public BrokerId(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public BrokerId() {
            this.brokerId = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BrokerId");
            }
            this.brokerId = _readable.readInt();
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.brokerId);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BrokerId");
            }
            this._unknownTaggedFields = null;
            this.brokerId = struct.getInt("broker_id");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of BrokerId");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("broker_id", (Object)this.brokerId);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of BrokerId");
            }
            _size += 4;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BrokerId)) {
                return false;
            }
            BrokerId other = (BrokerId)obj;
            return this.brokerId == other.brokerId;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.brokerId;
            return hashCode;
        }

        @Override
        public BrokerId duplicate() {
            BrokerId _duplicate = new BrokerId();
            _duplicate.brokerId = this.brokerId;
            return _duplicate;
        }

        public String toString() {
            return "BrokerId(brokerId=" + this.brokerId + ")";
        }

        public int brokerId() {
            return this.brokerId;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public BrokerId setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }
    }
}

