/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxReporter
implements MetricsReporter {
    public static final String METRICS_CONFIG_PREFIX = "metrics.jmx.";
    public static final String BLACKLIST_CONFIG = "metrics.jmx.blacklist";
    public static final String WHITELIST_CONFIG = "metrics.jmx.whitelist";
    public static final Set<String> RECONFIGURABLE_CONFIGS = Utils.mkSet("metrics.jmx.whitelist", "metrics.jmx.blacklist");
    public static final String DEFAULT_WHITELIST = ".*";
    public static final String DEFAULT_BLACKLIST = "";
    private static final Logger log = LoggerFactory.getLogger(JmxReporter.class);
    private static final Object LOCK = new Object();
    public static final String JMX_IGNORE_TAG = "io-confluent-jmx-ignore";
    private String prefix;
    private final Map<String, KafkaMbean> mbeans = new HashMap<String, KafkaMbean>();
    private Predicate<String> mbeanPredicate = s -> true;

    public JmxReporter() {
        this(DEFAULT_BLACKLIST);
    }

    @Deprecated
    public JmxReporter(String prefix) {
        this.prefix = prefix != null ? prefix : DEFAULT_BLACKLIST;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        this.reconfigure(configs);
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return RECONFIGURABLE_CONFIGS;
    }

    @Override
    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
        JmxReporter.compilePredicate(configs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconfigure(Map<String, ?> configs) {
        Object object = LOCK;
        synchronized (object) {
            this.mbeanPredicate = JmxReporter.compilePredicate(configs);
            this.mbeans.forEach((name, mbean) -> {
                if (this.mbeanPredicate.test((String)name)) {
                    this.reregister((KafkaMbean)mbean);
                } else {
                    this.unregister((KafkaMbean)mbean);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(List<KafkaMetric> metrics) {
        Object object = LOCK;
        synchronized (object) {
            for (KafkaMetric metric : metrics) {
                this.addAttribute(metric);
            }
            this.mbeans.forEach((name, mbean) -> {
                if (this.mbeanPredicate.test((String)name)) {
                    this.reregister((KafkaMbean)mbean);
                }
            });
        }
    }

    public boolean containsMbean(String mbeanName) {
        return this.mbeans.containsKey(mbeanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void metricChange(KafkaMetric metric) {
        Object object = LOCK;
        synchronized (object) {
            String mbeanName = this.addAttribute(metric);
            if (mbeanName != null && this.mbeanPredicate.test(mbeanName)) {
                this.reregister(this.mbeans.get(mbeanName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void metricRemoval(KafkaMetric metric) {
        Object object = LOCK;
        synchronized (object) {
            MetricName metricName = metric.metricName();
            String mBeanName = JmxReporter.getMBeanName(this.prefix, metricName);
            KafkaMbean mbean = this.removeAttribute(metric, mBeanName);
            if (mbean != null) {
                if (mbean.metrics.isEmpty()) {
                    this.unregister(mbean);
                    this.mbeans.remove(mBeanName);
                } else if (this.mbeanPredicate.test(mBeanName)) {
                    this.reregister(mbean);
                }
            }
        }
    }

    private KafkaMbean removeAttribute(KafkaMetric metric, String mBeanName) {
        MetricName metricName = metric.metricName();
        KafkaMbean mbean = this.mbeans.get(mBeanName);
        if (mbean != null) {
            mbean.removeAttribute(metricName.name());
        }
        return mbean;
    }

    private String addAttribute(KafkaMetric metric) {
        try {
            MetricName metricName = metric.metricName();
            if (metricName.tags().containsKey(JMX_IGNORE_TAG)) {
                return null;
            }
            String mBeanName = JmxReporter.getMBeanName(this.prefix, metricName);
            if (!this.mbeans.containsKey(mBeanName)) {
                this.mbeans.put(mBeanName, new KafkaMbean(mBeanName));
            }
            KafkaMbean mbean = this.mbeans.get(mBeanName);
            mbean.setAttribute(metricName.name(), metric);
            return mBeanName;
        }
        catch (JMException e) {
            throw new KafkaException("Error creating mbean attribute for metricName :" + metric.metricName(), e);
        }
    }

    static String getMBeanName(String prefix, MetricName metricName) {
        StringBuilder mBeanName = new StringBuilder();
        mBeanName.append(prefix);
        mBeanName.append(":type=");
        mBeanName.append(metricName.group());
        for (Map.Entry<String, String> entry : metricName.tags().entrySet()) {
            if (entry.getKey().length() <= 0 || entry.getValue().length() <= 0) continue;
            mBeanName.append(",");
            mBeanName.append(entry.getKey());
            mBeanName.append("=");
            mBeanName.append(Sanitizer.jmxSanitize(entry.getValue()));
        }
        return mBeanName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = LOCK;
        synchronized (object) {
            for (KafkaMbean mbean : this.mbeans.values()) {
                this.unregister(mbean);
            }
        }
    }

    private void unregister(KafkaMbean mbean) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            if (server.isRegistered(mbean.name())) {
                server.unregisterMBean(mbean.name());
            }
        }
        catch (JMException e) {
            throw new KafkaException("Error unregistering mbean", e);
        }
    }

    private void reregister(KafkaMbean mbean) {
        this.unregister(mbean);
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(mbean, mbean.name());
        }
        catch (JMException e) {
            throw new KafkaException("Error registering mbean " + mbean.name(), e);
        }
    }

    public static Predicate<String> compilePredicate(Map<String, ?> configs) {
        String whitelist = (String)configs.get(WHITELIST_CONFIG);
        String blacklist = (String)configs.get(BLACKLIST_CONFIG);
        if (whitelist == null) {
            whitelist = DEFAULT_WHITELIST;
        }
        if (blacklist == null) {
            blacklist = DEFAULT_BLACKLIST;
        }
        try {
            Pattern whitelistPattern = Pattern.compile(whitelist);
            Pattern blacklistPattern = Pattern.compile(blacklist);
            return s -> whitelistPattern.matcher((CharSequence)s).matches() && !blacklistPattern.matcher((CharSequence)s).matches();
        }
        catch (PatternSyntaxException e) {
            throw new ConfigException("JMX filter for configurationmetrics.jmx..(whitelist/blacklist) is not a valid regular expression");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contextChange(MetricsContext metricsContext) {
        String namespace = metricsContext.contextLabels().get("_namespace");
        Objects.requireNonNull(namespace);
        Object object = LOCK;
        synchronized (object) {
            if (!this.mbeans.isEmpty()) {
                throw new IllegalStateException("JMX MetricsContext can only be updated before JMX metrics are created");
            }
            if (namespace.isEmpty()) {
                return;
            }
            this.prefix = namespace;
        }
    }

    private static class KafkaMbean
    implements DynamicMBean {
        private final ObjectName objectName;
        private final Map<String, KafkaMetric> metrics = new HashMap<String, KafkaMetric>();

        KafkaMbean(String mbeanName) throws MalformedObjectNameException {
            this.objectName = new ObjectName(mbeanName);
        }

        public ObjectName name() {
            return this.objectName;
        }

        void setAttribute(String name, KafkaMetric metric) {
            this.metrics.put(name, metric);
        }

        @Override
        public Object getAttribute(String name) throws AttributeNotFoundException {
            if (this.metrics.containsKey(name)) {
                return this.metrics.get(name).metricValue();
            }
            throw new AttributeNotFoundException("Could not find attribute " + name);
        }

        @Override
        public AttributeList getAttributes(String[] names) {
            AttributeList list = new AttributeList();
            for (String name : names) {
                try {
                    list.add(new Attribute(name, this.getAttribute(name)));
                }
                catch (Exception e) {
                    log.warn("Error getting JMX attribute '{}'", (Object)name, (Object)e);
                }
            }
            return list;
        }

        KafkaMetric removeAttribute(String name) {
            return this.metrics.remove(name);
        }

        @Override
        public MBeanInfo getMBeanInfo() {
            MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[this.metrics.size()];
            int i = 0;
            for (Map.Entry<String, KafkaMetric> entry : this.metrics.entrySet()) {
                String attribute = entry.getKey();
                KafkaMetric metric = entry.getValue();
                attrs[i] = new MBeanAttributeInfo(attribute, Double.TYPE.getName(), metric.metricName().description(), true, false, false);
                ++i;
            }
            return new MBeanInfo(this.getClass().getName(), JmxReporter.DEFAULT_BLACKLIST, attrs, null, null, null);
        }

        @Override
        public Object invoke(String name, Object[] params, String[] sig) {
            throw new UnsupportedOperationException("Set not allowed.");
        }

        @Override
        public void setAttribute(Attribute attribute) {
            throw new UnsupportedOperationException("Set not allowed.");
        }

        @Override
        public AttributeList setAttributes(AttributeList list) {
            throw new UnsupportedOperationException("Set not allowed.");
        }
    }
}

