/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.ListClusterLinksResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ClusterLinkListing;

public class ListClusterLinksResponse
extends AbstractResponse {
    private final ListClusterLinksResponseData data;

    public ListClusterLinksResponse(ListClusterLinksResponseData data) {
        this.data = data;
    }

    public ListClusterLinksResponse(Collection<ClusterLinkListing> clusterLinks, int throttleTimeMs) {
        ArrayList<ListClusterLinksResponseData.EntryData> entryDatas = new ArrayList<ListClusterLinksResponseData.EntryData>(clusterLinks.size());
        for (ClusterLinkListing clusterLink : clusterLinks) {
            entryDatas.add(new ListClusterLinksResponseData.EntryData().setLinkName(clusterLink.linkName()).setLinkId(clusterLink.linkId()).setClusterId(clusterLink.clusterId()).setTopics(clusterLink.topics().map(topics -> new ArrayList(topics)).orElse(null)));
        }
        this.data = new ListClusterLinksResponseData().setThrottleTimeMs(throttleTimeMs).setEntries(entryDatas);
    }

    public ListClusterLinksResponse(int throttleTimeMs, Throwable e) {
        this.data = new ListClusterLinksResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(e).code()).setErrorMessage(e.getMessage());
    }

    public ListClusterLinksResponse(Struct struct, short version) {
        this.data = new ListClusterLinksResponseData(struct, version);
    }

    public void complete(KafkaFutureImpl<Collection<ClusterLinkListing>> result) {
        Errors error = Errors.forCode(this.data.errorCode());
        if (error != Errors.NONE) {
            result.completeExceptionally(error.exception(this.data.errorMessage()));
            return;
        }
        ArrayList<ClusterLinkListing> clusterLinks = new ArrayList<ClusterLinkListing>(this.data.entries().size());
        for (ListClusterLinksResponseData.EntryData entryData : this.data.entries()) {
            clusterLinks.add(new ClusterLinkListing(entryData.linkName(), entryData.linkId(), entryData.clusterId(), Optional.ofNullable(entryData.topics())));
        }
        result.complete(clusterLinks);
    }

    public ListClusterLinksResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }
}

