/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Map;
import java.util.Objects;

public class NewClusterLink {
    private final String linkName;
    private final String clusterId;
    private final Map<String, String> configs;

    public NewClusterLink(String linkName, String clusterId, Map<String, String> configs) {
        this.linkName = Objects.requireNonNull(linkName, "Linked cluster name must not be null");
        this.clusterId = clusterId;
        this.configs = Objects.requireNonNull(configs, "Linked cluster configs must not be null");
    }

    public String linkName() {
        return this.linkName;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Map<String, String> configs() {
        return this.configs;
    }

    public String toString() {
        return "NewClusterLink(linkName=" + this.linkName + ", clusterId=" + this.clusterId + ", configs=" + this.configs + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewClusterLink that = (NewClusterLink)o;
        return Objects.equals(this.linkName, that.linkName) && Objects.equals(this.clusterId, that.clusterId) && Objects.equals(this.configs, that.configs);
    }

    public int hashCode() {
        return Objects.hash(this.linkName, this.clusterId, this.configs);
    }
}

