/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class CreateClusterLinksRequestData
implements ApiMessage {
    List<EntryData> entries;
    boolean validateOnly;
    boolean validateLink;
    int timeoutMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("entries", new CompactArrayOf(EntryData.SCHEMA_0), "The cluster link entries to create."), new Field("validate_only", Type.BOOLEAN, "Whether to validate that the cluster links can be created, but not actually create them."), new Field("validate_link", Type.BOOLEAN, "Whether to validate the links to the clusters before creation."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public CreateClusterLinksRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public CreateClusterLinksRequestData(Struct _struct, short _version) {
        this.fromStruct(_struct, _version);
    }

    public CreateClusterLinksRequestData() {
        this.entries = new ArrayList<EntryData>(0);
        this.validateOnly = false;
        this.validateLink = false;
        this.timeoutMs = 0;
    }

    @Override
    public short apiKey() {
        return 10002;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field entries was serialized as null");
        }
        ArrayList<EntryData> newCollection = new ArrayList<EntryData>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new EntryData(_readable, _version));
        }
        this.entries = newCollection;
        this.validateOnly = _readable.readByte() != 0;
        this.validateLink = _readable.readByte() != 0;
        this.timeoutMs = _readable.readInt();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.entries.size() + 1);
        for (EntryData entriesElement : this.entries) {
            entriesElement.write(_writable, _cache, _version);
        }
        _writable.writeByte(this.validateOnly ? (byte)1 : 0);
        _writable.writeByte(this.validateLink ? (byte)1 : 0);
        _writable.writeInt(this.timeoutMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        Object[] _nestedObjects = struct.getArray("entries");
        this.entries = new ArrayList<EntryData>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.entries.add(new EntryData((Struct)nestedObject, _version));
        }
        this.validateOnly = struct.getBoolean("validate_only");
        this.validateLink = struct.getBoolean("validate_link");
        this.timeoutMs = struct.getInt("timeout_ms");
        if (!_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        _taggedFields = new TreeMap();
        Struct struct = new Struct(SCHEMAS[_version]);
        Struct[] _nestedObjects = new Struct[this.entries.size()];
        int i = 0;
        for (EntryData element : this.entries) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("entries", (Object)_nestedObjects);
        struct.set("validate_only", (Object)this.validateOnly);
        struct.set("validate_link", (Object)this.validateLink);
        struct.set("timeout_ms", (Object)this.timeoutMs);
        struct.set("_tagged_fields", _taggedFields);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _arraySize = 0;
        _arraySize += ByteUtils.sizeOfUnsignedVarint(this.entries.size() + 1);
        for (EntryData entriesElement : this.entries) {
            _arraySize += entriesElement.size(_cache, _version);
        }
        _size += _arraySize;
        ++_size;
        ++_size;
        _size += 4;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        return _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreateClusterLinksRequestData)) {
            return false;
        }
        CreateClusterLinksRequestData other = (CreateClusterLinksRequestData)obj;
        if (this.entries == null ? other.entries != null : !this.entries.equals(other.entries)) {
            return false;
        }
        if (this.validateOnly != other.validateOnly) {
            return false;
        }
        if (this.validateLink != other.validateLink) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.entries == null ? 0 : this.entries.hashCode());
        hashCode = 31 * hashCode + (this.validateOnly ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.validateLink ? 1231 : 1237);
        hashCode = 31 * hashCode + this.timeoutMs;
        return hashCode;
    }

    @Override
    public CreateClusterLinksRequestData duplicate() {
        CreateClusterLinksRequestData _duplicate = new CreateClusterLinksRequestData();
        ArrayList<EntryData> newEntries = new ArrayList<EntryData>(this.entries.size());
        for (EntryData _element : this.entries) {
            newEntries.add(_element.duplicate());
        }
        _duplicate.entries = newEntries;
        _duplicate.validateOnly = this.validateOnly;
        _duplicate.validateLink = this.validateLink;
        _duplicate.timeoutMs = this.timeoutMs;
        return _duplicate;
    }

    public String toString() {
        return "CreateClusterLinksRequestData(entries=" + MessageUtil.deepToString(this.entries.iterator()) + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ", validateLink=" + (this.validateLink ? "true" : "false") + ", timeoutMs=" + this.timeoutMs + ")";
    }

    public List<EntryData> entries() {
        return this.entries;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    public boolean validateLink() {
        return this.validateLink;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public CreateClusterLinksRequestData setEntries(List<EntryData> v) {
        this.entries = v;
        return this;
    }

    public CreateClusterLinksRequestData setValidateOnly(boolean v) {
        this.validateOnly = v;
        return this;
    }

    public CreateClusterLinksRequestData setValidateLink(boolean v) {
        this.validateLink = v;
        return this;
    }

    public CreateClusterLinksRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public static class ConfigData
    implements Message {
        String key;
        String value;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("key", Type.COMPACT_STRING, "The configuration key."), new Field("value", Type.COMPACT_STRING, "The configuration value."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public ConfigData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public ConfigData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public ConfigData() {
            this.key = "";
            this.value = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ConfigData");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field key was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field key had invalid length " + length);
            }
            this.key = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field value was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field value had invalid length " + length);
            }
            this.value = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.key);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.value);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ConfigData");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            this.key = struct.getString("key");
            this.value = struct.getString("value");
            if (!_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ConfigData");
            }
            TreeMap _taggedFields = null;
            _taggedFields = new TreeMap();
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("key", (Object)this.key);
            struct.set("value", (Object)this.value);
            struct.set("_tagged_fields", _taggedFields);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ConfigData");
            }
            byte[] _stringBytes = this.key.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'key' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.key, _stringBytes);
            _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
            _stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'value' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.value, _stringBytes);
            _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            return _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ConfigData)) {
                return false;
            }
            ConfigData other = (ConfigData)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.key == null ? 0 : this.key.hashCode());
            hashCode = 31 * hashCode + (this.value == null ? 0 : this.value.hashCode());
            return hashCode;
        }

        @Override
        public ConfigData duplicate() {
            ConfigData _duplicate = new ConfigData();
            _duplicate.key = this.key;
            _duplicate.value = this.value;
            return _duplicate;
        }

        public String toString() {
            return "ConfigData(key=" + (this.key == null ? "null" : "'" + this.key.toString() + "'") + ", value=" + (this.value == null ? "null" : "'" + this.value.toString() + "'") + ")";
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ConfigData setKey(String v) {
            this.key = v;
            return this;
        }

        public ConfigData setValue(String v) {
            this.value = v;
            return this;
        }
    }

    public static class EntryData
    implements Message {
        String linkName;
        String clusterId;
        List<ConfigData> configs;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("link_name", Type.COMPACT_STRING, "The name assigned to the cluster link."), new Field("cluster_id", Type.COMPACT_NULLABLE_STRING, "The ID of the cluster link, or null if it should not be validated."), new Field("configs", new CompactArrayOf(ConfigData.SCHEMA_0), "The initial configuration values."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public EntryData(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public EntryData(Struct _struct, short _version) {
            this.fromStruct(_struct, _version);
        }

        public EntryData() {
            this.linkName = "";
            this.clusterId = null;
            this.configs = new ArrayList<ConfigData>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EntryData");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field linkName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field linkName had invalid length " + length);
            }
            this.linkName = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.clusterId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field clusterId had invalid length " + length);
                }
                this.clusterId = _readable.readString(length);
            }
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field configs was serialized as null");
            }
            ArrayList<ConfigData> newCollection = new ArrayList<ConfigData>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new ConfigData(_readable, _version));
            }
            this.configs = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.linkName);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            if (this.clusterId == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.clusterId);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            _writable.writeUnsignedVarint(this.configs.size() + 1);
            _stringBytes = this.configs.iterator();
            while (_stringBytes.hasNext()) {
                ConfigData configsElement = (ConfigData)_stringBytes.next();
                configsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EntryData");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            this.linkName = struct.getString("link_name");
            this.clusterId = struct.getString("cluster_id");
            Object[] _nestedObjects = struct.getArray("configs");
            this.configs = new ArrayList<ConfigData>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.configs.add(new ConfigData((Struct)nestedObject, _version));
            }
            if (!_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of EntryData");
            }
            TreeMap _taggedFields = null;
            _taggedFields = new TreeMap();
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("link_name", (Object)this.linkName);
            struct.set("cluster_id", (Object)this.clusterId);
            Struct[] _nestedObjects = new Struct[this.configs.size()];
            int i = 0;
            for (ConfigData element : this.configs) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("configs", (Object)_nestedObjects);
            struct.set("_tagged_fields", _taggedFields);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of EntryData");
            }
            byte[] _stringBytes = this.linkName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'linkName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.linkName, _stringBytes);
            _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
            if (this.clusterId == null) {
                ++_size;
            } else {
                _stringBytes = this.clusterId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'clusterId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.clusterId, _stringBytes);
                _size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1);
            }
            int _arraySize = 0;
            _arraySize += ByteUtils.sizeOfUnsignedVarint(this.configs.size() + 1);
            for (ConfigData configsElement : this.configs) {
                _arraySize += configsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            return _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntryData)) {
                return false;
            }
            EntryData other = (EntryData)obj;
            if (this.linkName == null ? other.linkName != null : !this.linkName.equals(other.linkName)) {
                return false;
            }
            if (this.clusterId == null ? other.clusterId != null : !this.clusterId.equals(other.clusterId)) {
                return false;
            }
            if (this.configs == null ? other.configs != null : !this.configs.equals(other.configs)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.linkName == null ? 0 : this.linkName.hashCode());
            hashCode = 31 * hashCode + (this.clusterId == null ? 0 : this.clusterId.hashCode());
            hashCode = 31 * hashCode + (this.configs == null ? 0 : this.configs.hashCode());
            return hashCode;
        }

        @Override
        public EntryData duplicate() {
            EntryData _duplicate = new EntryData();
            _duplicate.linkName = this.linkName;
            _duplicate.clusterId = this.clusterId == null ? null : this.clusterId;
            ArrayList<ConfigData> newConfigs = new ArrayList<ConfigData>(this.configs.size());
            for (ConfigData _element : this.configs) {
                newConfigs.add(_element.duplicate());
            }
            _duplicate.configs = newConfigs;
            return _duplicate;
        }

        public String toString() {
            return "EntryData(linkName=" + (this.linkName == null ? "null" : "'" + this.linkName.toString() + "'") + ", clusterId=" + (this.clusterId == null ? "null" : "'" + this.clusterId.toString() + "'") + ", configs=" + MessageUtil.deepToString(this.configs.iterator()) + ")";
        }

        public String linkName() {
            return this.linkName;
        }

        public String clusterId() {
            return this.clusterId;
        }

        public List<ConfigData> configs() {
            return this.configs;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public EntryData setLinkName(String v) {
            this.linkName = v;
            return this;
        }

        public EntryData setClusterId(String v) {
            this.clusterId = v;
            return this;
        }

        public EntryData setConfigs(List<ConfigData> v) {
            this.configs = v;
            return this;
        }
    }
}

