/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.CreateClusterLinksResponse;
import org.apache.kafka.common.requests.NewClusterLink;

public class CreateClusterLinksRequest
extends AbstractRequest {
    private final CreateClusterLinksRequestData data;

    public CreateClusterLinksRequest(CreateClusterLinksRequestData data, short version) {
        super(ApiKeys.CREATE_CLUSTER_LINKS, version);
        this.data = data;
    }

    public CreateClusterLinksRequest(Struct struct, short version) {
        super(ApiKeys.CREATE_CLUSTER_LINKS, version);
        this.data = new CreateClusterLinksRequestData(struct, version);
    }

    public Collection<NewClusterLink> newClusterLinks() {
        ArrayList<NewClusterLink> newClusterLinks = new ArrayList<NewClusterLink>(this.data.entries().size());
        for (CreateClusterLinksRequestData.EntryData entryData : this.data.entries()) {
            HashMap<String, String> configs = new HashMap<String, String>(entryData.configs().size());
            for (CreateClusterLinksRequestData.ConfigData configData : entryData.configs()) {
                configs.put(configData.key(), configData.value());
            }
            newClusterLinks.add(new NewClusterLink(entryData.linkName(), entryData.clusterId(), configs));
        }
        return newClusterLinks;
    }

    public boolean validateOnly() {
        return this.data.validateOnly();
    }

    public boolean validateLink() {
        return this.data.validateLink();
    }

    public int timeoutMs() {
        return this.data.timeoutMs();
    }

    @Override
    public CreateClusterLinksResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ArrayList<String> linkNames = new ArrayList<String>(this.data.entries().size());
        for (CreateClusterLinksRequestData.EntryData entryData : this.data.entries()) {
            linkNames.add(entryData.linkName());
        }
        return new CreateClusterLinksResponse(linkNames, throttleTimeMs, e);
    }

    public CreateClusterLinksRequestData data() {
        return this.data;
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static class Builder
    extends AbstractRequest.Builder<CreateClusterLinksRequest> {
        private final CreateClusterLinksRequestData data;

        public Builder(Collection<NewClusterLink> newClusterLinks, boolean validateOnly, boolean validateLink, int timeoutMs) {
            super(ApiKeys.CREATE_CLUSTER_LINKS);
            ArrayList<CreateClusterLinksRequestData.EntryData> entryDatas = new ArrayList<CreateClusterLinksRequestData.EntryData>(newClusterLinks.size());
            for (NewClusterLink newClusterLink : newClusterLinks) {
                ArrayList<CreateClusterLinksRequestData.ConfigData> configDatas = new ArrayList<CreateClusterLinksRequestData.ConfigData>(newClusterLink.configs().size());
                for (Map.Entry<String, String> configsEntry : newClusterLink.configs().entrySet()) {
                    configDatas.add(new CreateClusterLinksRequestData.ConfigData().setKey(configsEntry.getKey()).setValue(configsEntry.getValue()));
                }
                entryDatas.add(new CreateClusterLinksRequestData.EntryData().setLinkName(newClusterLink.linkName()).setClusterId(newClusterLink.clusterId()).setConfigs(configDatas));
            }
            this.data = new CreateClusterLinksRequestData().setEntries(entryDatas).setValidateOnly(validateOnly).setValidateLink(validateLink).setTimeoutMs(timeoutMs);
        }

        @Override
        public CreateClusterLinksRequest build(short version) {
            return new CreateClusterLinksRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

