/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.message.ListClusterLinksRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListClusterLinksResponse;

public class ListClusterLinksRequest
extends AbstractRequest {
    private final ListClusterLinksRequestData data;

    public ListClusterLinksRequest(ListClusterLinksRequestData data, short version) {
        super(ApiKeys.LIST_CLUSTER_LINKS, version);
        this.data = data;
    }

    public ListClusterLinksRequest(Struct struct, short version) {
        super(ApiKeys.LIST_CLUSTER_LINKS, version);
        this.data = new ListClusterLinksRequestData(struct, version);
    }

    public Optional<List<String>> linkNames() {
        return Optional.ofNullable(this.data.linkNames());
    }

    public boolean includeTopics() {
        return this.data.includeTopics();
    }

    public int timeoutMs() {
        return this.data.timeoutMs();
    }

    @Override
    public ListClusterLinksResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new ListClusterLinksResponse(throttleTimeMs, e);
    }

    public ListClusterLinksRequestData data() {
        return this.data;
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static class Builder
    extends AbstractRequest.Builder<ListClusterLinksRequest> {
        private final ListClusterLinksRequestData data;

        public Builder(Optional<Collection<String>> linkNames, boolean includeTopics, int timeoutMs) {
            super(ApiKeys.LIST_CLUSTER_LINKS);
            this.data = new ListClusterLinksRequestData().setLinkNames(linkNames.map(names -> new ArrayList(names)).orElse(null)).setIncludeTopics(includeTopics).setTimeoutMs(timeoutMs);
        }

        @Override
        public ListClusterLinksRequest build(short version) {
            return new ListClusterLinksRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

