/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListOffsetRequestData;
import org.apache.kafka.common.message.ListOffsetResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ListOffsetResponse;

public class ListOffsetRequest
extends AbstractRequest {
    public static final long EARLIEST_TIMESTAMP = -2L;
    public static final long LATEST_TIMESTAMP = -1L;
    public static final long LOCAL_START_OFFSET = -10000L;
    public static final long LOCAL_END_OFFSET = -10001L;
    public static final int CONSUMER_REPLICA_ID = -1;
    public static final int DEBUGGING_REPLICA_ID = -2;
    private final ListOffsetRequestData data;
    private final Set<TopicPartition> duplicatePartitions;

    private ListOffsetRequest(short version, ListOffsetRequestData data) {
        super(ApiKeys.LIST_OFFSETS, version);
        this.data = data;
        this.duplicatePartitions = Collections.emptySet();
    }

    public ListOffsetRequest(Struct struct, short version) {
        super(ApiKeys.LIST_OFFSETS, version);
        this.data = new ListOffsetRequestData(struct, version);
        this.duplicatePartitions = new HashSet<TopicPartition>();
        HashSet<TopicPartition> partitions = new HashSet<TopicPartition>();
        for (ListOffsetRequestData.ListOffsetTopic topic : this.data.topics()) {
            for (ListOffsetRequestData.ListOffsetPartition partition : topic.partitions()) {
                TopicPartition tp = new TopicPartition(topic.name(), partition.partitionIndex());
                if (partitions.add(tp)) continue;
                this.duplicatePartitions.add(tp);
            }
        }
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        short errorCode = Errors.forException(e).code();
        ArrayList<ListOffsetResponseData.ListOffsetTopicResponse> responses = new ArrayList<ListOffsetResponseData.ListOffsetTopicResponse>();
        for (ListOffsetRequestData.ListOffsetTopic topic : this.data.topics()) {
            ListOffsetResponseData.ListOffsetTopicResponse topicResponse = new ListOffsetResponseData.ListOffsetTopicResponse().setName(topic.name());
            ArrayList<ListOffsetResponseData.ListOffsetPartitionResponse> partitions = new ArrayList<ListOffsetResponseData.ListOffsetPartitionResponse>();
            for (ListOffsetRequestData.ListOffsetPartition partition : topic.partitions()) {
                ListOffsetResponseData.ListOffsetPartitionResponse partitionResponse = new ListOffsetResponseData.ListOffsetPartitionResponse().setErrorCode(errorCode).setPartitionIndex(partition.partitionIndex());
                if (versionId == 0) {
                    partitionResponse.setOldStyleOffsets(Collections.emptyList());
                } else {
                    partitionResponse.setOffset(-1L).setTimestamp(-1L);
                }
                partitions.add(partitionResponse);
            }
            topicResponse.setPartitions(partitions);
            responses.add(topicResponse);
        }
        ListOffsetResponseData responseData = new ListOffsetResponseData().setThrottleTimeMs(throttleTimeMs).setTopics(responses);
        return new ListOffsetResponse(responseData);
    }

    public ListOffsetRequestData data() {
        return this.data;
    }

    public int replicaId() {
        return this.data.replicaId();
    }

    public IsolationLevel isolationLevel() {
        return IsolationLevel.forId(this.data.isolationLevel());
    }

    public List<ListOffsetRequestData.ListOffsetTopic> topics() {
        return this.data.topics();
    }

    public Set<TopicPartition> duplicatePartitions() {
        return this.duplicatePartitions;
    }

    public static ListOffsetRequest parse(ByteBuffer buffer, short version) {
        return new ListOffsetRequest(ApiKeys.LIST_OFFSETS.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static List<ListOffsetRequestData.ListOffsetTopic> toListOffsetTopics(Map<TopicPartition, ListOffsetRequestData.ListOffsetPartition> timestampsToSearch) {
        HashMap<String, ListOffsetRequestData.ListOffsetTopic> topics = new HashMap<String, ListOffsetRequestData.ListOffsetTopic>();
        for (Map.Entry<TopicPartition, ListOffsetRequestData.ListOffsetPartition> entry : timestampsToSearch.entrySet()) {
            TopicPartition tp = entry.getKey();
            ListOffsetRequestData.ListOffsetTopic topic = topics.computeIfAbsent(tp.topic(), k -> new ListOffsetRequestData.ListOffsetTopic().setName(tp.topic()));
            topic.partitions().add(entry.getValue());
        }
        return new ArrayList<ListOffsetRequestData.ListOffsetTopic>(topics.values());
    }

    public static ListOffsetRequestData.ListOffsetTopic singletonRequestData(String topic, int partitionIndex, long timestamp, int maxNumOffsets) {
        return new ListOffsetRequestData.ListOffsetTopic().setName(topic).setPartitions(Collections.singletonList(new ListOffsetRequestData.ListOffsetPartition().setPartitionIndex(partitionIndex).setTimestamp(timestamp).setMaxNumOffsets(maxNumOffsets)));
    }

    public static class Builder
    extends AbstractRequest.Builder<ListOffsetRequest> {
        private final ListOffsetRequestData data;

        public static Builder forReplica(short allowedVersion, int replicaId) {
            return new Builder(0, allowedVersion, replicaId, IsolationLevel.READ_UNCOMMITTED);
        }

        public static Builder forConsumer(boolean requireTimestamp, IsolationLevel isolationLevel) {
            short minVersion = 0;
            if (isolationLevel == IsolationLevel.READ_COMMITTED) {
                minVersion = 2;
            } else if (requireTimestamp) {
                minVersion = 1;
            }
            return new Builder(minVersion, ApiKeys.LIST_OFFSETS.latestVersion(), -1, isolationLevel);
        }

        private Builder(short oldestAllowedVersion, short latestAllowedVersion, int replicaId, IsolationLevel isolationLevel) {
            super(ApiKeys.LIST_OFFSETS, oldestAllowedVersion, latestAllowedVersion);
            this.data = new ListOffsetRequestData().setIsolationLevel(isolationLevel.id()).setReplicaId(replicaId);
        }

        public Builder setTargetTimes(List<ListOffsetRequestData.ListOffsetTopic> topics) {
            this.data.setTopics(topics);
            return this;
        }

        @Override
        public ListOffsetRequest build(short version) {
            return new ListOffsetRequest(version, this.data);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

