/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Objects;
import java.util.UUID;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class TopicMirrorDescription {
    private final String linkName;
    private final UUID linkId;
    private final String mirrorTopic;
    private final State state;
    private final long stateTimeMs;

    public TopicMirrorDescription(String linkName, UUID linkId, String mirrorTopic, State state, long stateTimeMs) {
        this.linkName = Objects.requireNonNull(linkName);
        this.linkId = Objects.requireNonNull(linkId);
        this.mirrorTopic = Objects.requireNonNull(mirrorTopic);
        this.state = Objects.requireNonNull(state);
        this.stateTimeMs = stateTimeMs;
    }

    public String linkName() {
        return this.linkName;
    }

    public UUID linkId() {
        return this.linkId;
    }

    public String mirrorTopic() {
        return this.mirrorTopic;
    }

    public State state() {
        return this.state;
    }

    public long stateTimeMs() {
        return this.stateTimeMs;
    }

    public String toString() {
        return "(linkName=" + this.linkName + ", linkName=" + this.linkId + ", mirrorTopic=" + this.mirrorTopic + ", state=" + (Object)((Object)this.state) + ", stateTimeMs=" + this.stateTimeMs + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicMirrorDescription that = (TopicMirrorDescription)o;
        return Objects.equals(this.linkName, that.linkName) && Objects.equals(this.linkId, that.linkId) && Objects.equals(this.mirrorTopic, that.mirrorTopic) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.stateTimeMs, that.stateTimeMs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.linkName, this.linkId, this.mirrorTopic, this.state, this.stateTimeMs});
    }

    public static enum State {
        UNKNOWN,
        ACTIVE,
        STOPPED,
        FAILED;

    }
}

