/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.message.AlterIsrRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class AlterIsrRequestDataJsonConverter {
    public static AlterIsrRequestData read(JsonNode _node, short _version) {
        AlterIsrRequestData _object = new AlterIsrRequestData();
        JsonNode _brokerIdNode = _node.get("brokerId");
        if (_brokerIdNode == null) {
            throw new RuntimeException("AlterIsrRequestData: unable to locate field 'brokerId', which is mandatory in version " + _version);
        }
        _object.brokerId = MessageUtil.jsonNodeToInt(_brokerIdNode, "AlterIsrRequestData");
        JsonNode _brokerEpochNode = _node.get("brokerEpoch");
        if (_brokerEpochNode == null) {
            throw new RuntimeException("AlterIsrRequestData: unable to locate field 'brokerEpoch', which is mandatory in version " + _version);
        }
        _object.brokerEpoch = MessageUtil.jsonNodeToLong(_brokerEpochNode, "AlterIsrRequestData");
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("AlterIsrRequestData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("AlterIsrRequestData expected a JSON array, but got " + _node.getNodeType());
        }
        ArrayList<AlterIsrRequestData.TopicData> _collection = new ArrayList<AlterIsrRequestData.TopicData>();
        _object.topics = _collection;
        for (JsonNode _element : _topicsNode) {
            _collection.add(TopicDataJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(AlterIsrRequestData _object, short _version) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("brokerId", (JsonNode)new IntNode(_object.brokerId));
        _node.set("brokerEpoch", (JsonNode)new LongNode(_object.brokerEpoch));
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (AlterIsrRequestData.TopicData _element : _object.topics) {
            _topicsArray.add(TopicDataJsonConverter.write(_element, _version));
        }
        _node.set("topics", (JsonNode)_topicsArray);
        return _node;
    }

    public static class TopicDataJsonConverter {
        public static AlterIsrRequestData.TopicData read(JsonNode _node, short _version) {
            AlterIsrRequestData.TopicData _object = new AlterIsrRequestData.TopicData();
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("TopicData expected a string type, but got " + _node.getNodeType());
            }
            _object.name = _nameNode.asText();
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("TopicData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<AlterIsrRequestData.PartitionData> _collection = new ArrayList<AlterIsrRequestData.PartitionData>();
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(PartitionDataJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(AlterIsrRequestData.TopicData _object, short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(_object.name));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (AlterIsrRequestData.PartitionData _element : _object.partitions) {
                _partitionsArray.add(PartitionDataJsonConverter.write(_element, _version));
            }
            _node.set("partitions", (JsonNode)_partitionsArray);
            return _node;
        }
    }

    public static class PartitionDataJsonConverter {
        public static AlterIsrRequestData.PartitionData read(JsonNode _node, short _version) {
            AlterIsrRequestData.PartitionData _object = new AlterIsrRequestData.PartitionData();
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            _object.partitionIndex = MessageUtil.jsonNodeToInt(_partitionIndexNode, "PartitionData");
            JsonNode _leaderEpochNode = _node.get("leaderEpoch");
            if (_leaderEpochNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'leaderEpoch', which is mandatory in version " + _version);
            }
            _object.leaderEpoch = MessageUtil.jsonNodeToInt(_leaderEpochNode, "PartitionData");
            JsonNode _newIsrNode = _node.get("newIsr");
            if (_newIsrNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'newIsr', which is mandatory in version " + _version);
            }
            if (!_newIsrNode.isArray()) {
                throw new RuntimeException("PartitionData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>();
            _object.newIsr = _collection;
            for (JsonNode _element : _newIsrNode) {
                _collection.add(MessageUtil.jsonNodeToInt(_element, "PartitionData element"));
            }
            JsonNode _currentIsrVersionNode = _node.get("currentIsrVersion");
            if (_currentIsrVersionNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'currentIsrVersion', which is mandatory in version " + _version);
            }
            _object.currentIsrVersion = MessageUtil.jsonNodeToInt(_currentIsrVersionNode, "PartitionData");
            JsonNode _isUncleanNode = _node.get("isUnclean");
            if (_isUncleanNode == null) {
                _object.isUnclean = false;
            } else {
                if (!_isUncleanNode.isBoolean()) {
                    throw new RuntimeException("PartitionData expected Boolean type, but got " + _node.getNodeType());
                }
                _object.isUnclean = _isUncleanNode.asBoolean();
            }
            JsonNode _clusterLinkStateNode = _node.get("clusterLinkState");
            _object.clusterLinkState = _clusterLinkStateNode == null ? new AlterIsrRequestData.ClusterLinkState() : ClusterLinkStateJsonConverter.read(_clusterLinkStateNode, _version);
            return _object;
        }

        public static JsonNode write(AlterIsrRequestData.PartitionData _object, short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", (JsonNode)new IntNode(_object.partitionIndex));
            _node.set("leaderEpoch", (JsonNode)new IntNode(_object.leaderEpoch));
            ArrayNode _newIsrArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : _object.newIsr) {
                _newIsrArray.add((JsonNode)new IntNode(_element.intValue()));
            }
            _node.set("newIsr", (JsonNode)_newIsrArray);
            _node.set("currentIsrVersion", (JsonNode)new IntNode(_object.currentIsrVersion));
            if (_object.isUnclean) {
                _node.set("isUnclean", (JsonNode)BooleanNode.valueOf((boolean)_object.isUnclean));
            }
            if (!_object.clusterLinkState.equals(new AlterIsrRequestData.ClusterLinkState())) {
                _node.set("clusterLinkState", ClusterLinkStateJsonConverter.write(_object.clusterLinkState, _version));
            }
            return _node;
        }
    }

    public static class ClusterLinkStateJsonConverter {
        public static AlterIsrRequestData.ClusterLinkState read(JsonNode _node, short _version) {
            AlterIsrRequestData.ClusterLinkState _object = new AlterIsrRequestData.ClusterLinkState();
            JsonNode _linkedLeaderEpochNode = _node.get("linkedLeaderEpoch");
            if (_linkedLeaderEpochNode == null) {
                throw new RuntimeException("ClusterLinkState: unable to locate field 'linkedLeaderEpoch', which is mandatory in version " + _version);
            }
            _object.linkedLeaderEpoch = MessageUtil.jsonNodeToInt(_linkedLeaderEpochNode, "ClusterLinkState");
            JsonNode _linkFailedNode = _node.get("linkFailed");
            if (_linkFailedNode == null) {
                throw new RuntimeException("ClusterLinkState: unable to locate field 'linkFailed', which is mandatory in version " + _version);
            }
            if (!_linkFailedNode.isBoolean()) {
                throw new RuntimeException("ClusterLinkState expected Boolean type, but got " + _node.getNodeType());
            }
            _object.linkFailed = _linkFailedNode.asBoolean();
            return _object;
        }

        public static JsonNode write(AlterIsrRequestData.ClusterLinkState _object, short _version) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("linkedLeaderEpoch", (JsonNode)new IntNode(_object.linkedLeaderEpoch));
            _node.set("linkFailed", (JsonNode)BooleanNode.valueOf((boolean)_object.linkFailed));
            return _node;
        }
    }
}

