/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.internals;

import java.util.function.Function;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.internals.AbstractGaugeSuite;
import org.slf4j.Logger;

public final class IntGaugeSuite<K>
extends AbstractGaugeSuite<K> {
    public IntGaugeSuite(Logger log, String suiteName, Metrics metrics, Function<K, MetricName> metricNameCalculator) {
        super(log, suiteName, metrics, metricNameCalculator);
        log.trace("{}: created new gauge suite.", (Object)suiteName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(K key, int value) {
        IntGaugeSuite intGaugeSuite = this;
        synchronized (intGaugeSuite) {
            if (this.closed) {
                this.log.warn("{}: Attempted to update {}, but the gauge map was closed.", (Object)this.suiteName, (Object)key.toString());
                return;
            }
            AbstractGaugeSuite.StoredIntGauge gauge = (AbstractGaugeSuite.StoredIntGauge)this.gauges.get(key);
            if (gauge != null) {
                gauge.update(value);
            } else {
                this.addGauge(key, value);
            }
        }
        this.performPendingMetricsOperations();
    }

    public synchronized void remove(K key) {
        if (this.closed) {
            this.log.warn("{}: Attempted to remove {}, but the gauge map was closed.", (Object)this.suiteName, (Object)key.toString());
            return;
        }
        AbstractGaugeSuite.StoredIntGauge gauge = (AbstractGaugeSuite.StoredIntGauge)this.gauges.get(key);
        if (gauge == null) {
            this.log.debug("{}: Attempted to remove {}, but no such metric was registered.", (Object)this.suiteName, (Object)key.toString());
        } else {
            this.log.trace("{}: Marked {} for removal.", (Object)this.suiteName, (Object)key.toString());
            gauge.update(0);
            this.removeGauge(key);
        }
    }
}

