/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.message.DescribeBrokerAdditionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeBrokerAdditionsResponse
extends AbstractResponse {
    private final DescribeBrokerAdditionsResponseData data;

    public DescribeBrokerAdditionsResponse(Struct struct) {
        this(struct, ApiKeys.DESCRIBE_BROKER_ADDITIONS.latestVersion());
    }

    public DescribeBrokerAdditionsResponse(DescribeBrokerAdditionsResponseData data) {
        this.data = data;
    }

    public DescribeBrokerAdditionsResponse(Struct struct, short version) {
        this.data = new DescribeBrokerAdditionsResponseData(struct, version);
    }

    public DescribeBrokerAdditionsResponseData data() {
        return this.data;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    public static DescribeBrokerAdditionsResponse parse(ByteBuffer buffer, short version) {
        return new DescribeBrokerAdditionsResponse(ApiKeys.DESCRIBE_BROKER_ADDITIONS.parseResponse(version, buffer), version);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public String toString() {
        return this.data.toString();
    }
}

