/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.AbstractStickyAssignor;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.CollectionUtils;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public abstract class AbstractStickyAssignorTest {
    protected AbstractStickyAssignor assignor;
    protected String consumerId = "consumer";
    protected Map<String, ConsumerPartitionAssignor.Subscription> subscriptions;
    protected String topic = "topic";

    protected abstract AbstractStickyAssignor createAssignor();

    protected abstract ConsumerPartitionAssignor.Subscription buildSubscription(List<String> var1, List<TopicPartition> var2);

    @BeforeEach
    public void setUp() {
        this.assignor = this.createAssignor();
        if (this.subscriptions != null) {
            this.subscriptions.clear();
        } else {
            this.subscriptions = new HashMap<String, ConsumerPartitionAssignor.Subscription>();
        }
    }

    @Test
    public void testOneConsumerNoTopic() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        this.subscriptions = Collections.singletonMap(this.consumerId, new ConsumerPartitionAssignor.Subscription(Collections.emptyList()));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(Collections.singleton(this.consumerId), assignment.keySet());
        Assertions.assertTrue((boolean)((List)assignment.get(this.consumerId)).isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testOneConsumerNonexistentTopic() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 0);
        this.subscriptions = Collections.singletonMap(this.consumerId, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics(this.topic)));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(Collections.singleton(this.consumerId), assignment.keySet());
        Assertions.assertTrue((boolean)((List)assignment.get(this.consumerId)).isEmpty());
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testOneConsumerOneTopic() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 3);
        this.subscriptions = Collections.singletonMap(this.consumerId, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics(this.topic)));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 1), AbstractStickyAssignorTest.tp(this.topic, 2)), assignment.get(this.consumerId));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testOnlyAssignsPartitionsFromSubscribedTopics() {
        String otherTopic = "other";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 2);
        this.subscriptions = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)this.consumerId, (Object)this.buildSubscription(AbstractStickyAssignorTest.topics(this.topic), Arrays.asList(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 1), AbstractStickyAssignorTest.tp(otherTopic, 0), AbstractStickyAssignorTest.tp(otherTopic, 1))))});
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 1)), assignment.get(this.consumerId));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testOneConsumerMultipleTopics() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic1, 1);
        partitionsPerTopic.put(topic2, 2);
        this.subscriptions = Collections.singletonMap(this.consumerId, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics(topic1, topic2)));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(topic1, 0), AbstractStickyAssignorTest.tp(topic2, 0), AbstractStickyAssignorTest.tp(topic2, 1)), assignment.get(this.consumerId));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testTwoConsumersOneTopicOnePartition() {
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 1);
        this.subscriptions.put(consumer1, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics(this.topic)));
        this.subscriptions.put(consumer2, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics(this.topic)));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testTwoConsumersOneTopicTwoPartitions() {
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 2);
        this.subscriptions.put(consumer1, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics(this.topic)));
        this.subscriptions.put(consumer2, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics(this.topic)));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0)), assignment.get(consumer1));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 1)), assignment.get(consumer2));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testMultipleConsumersMixedTopicSubscriptions() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        String consumer3 = "consumer3";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic1, 3);
        partitionsPerTopic.put(topic2, 2);
        this.subscriptions.put(consumer1, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics(topic1)));
        this.subscriptions.put(consumer2, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics(topic1, topic2)));
        this.subscriptions.put(consumer3, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics(topic1)));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(topic1, 0), AbstractStickyAssignorTest.tp(topic1, 2)), assignment.get(consumer1));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(topic2, 0), AbstractStickyAssignorTest.tp(topic2, 1)), assignment.get(consumer2));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(topic1, 1)), assignment.get(consumer3));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testTwoConsumersTwoTopicsSixPartitions() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        String consumer1 = "consumer1";
        String consumer2 = "consumer2";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(topic1, 3);
        partitionsPerTopic.put(topic2, 3);
        this.subscriptions.put(consumer1, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics(topic1, topic2)));
        this.subscriptions.put(consumer2, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics(topic1, topic2)));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(topic1, 0), AbstractStickyAssignorTest.tp(topic1, 2), AbstractStickyAssignorTest.tp(topic2, 1)), assignment.get(consumer1));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(topic1, 1), AbstractStickyAssignorTest.tp(topic2, 0), AbstractStickyAssignorTest.tp(topic2, 2)), assignment.get(consumer2));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testAddRemoveConsumerOneTopic() {
        String consumer1 = "consumer1";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 3);
        this.subscriptions.put(consumer1, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics(this.topic)));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 1), AbstractStickyAssignorTest.tp(this.topic, 2)), assignment.get(consumer1));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
        String consumer2 = "consumer2";
        this.subscriptions.put(consumer1, this.buildSubscription(AbstractStickyAssignorTest.topics(this.topic), (List)assignment.get(consumer1)));
        this.subscriptions.put(consumer2, this.buildSubscription(AbstractStickyAssignorTest.topics(this.topic), Collections.emptyList()));
        assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 0), AbstractStickyAssignorTest.tp(this.topic, 1)), assignment.get(consumer1));
        Assertions.assertEquals(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 2)), assignment.get(consumer2));
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
        this.subscriptions.remove(consumer1);
        this.subscriptions.put(consumer2, this.buildSubscription(AbstractStickyAssignorTest.topics(this.topic), (List)assignment.get(consumer2)));
        assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals(new HashSet<TopicPartition>(AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp(this.topic, 2), AbstractStickyAssignorTest.tp(this.topic, 1), AbstractStickyAssignorTest.tp(this.topic, 0))), new HashSet((Collection)assignment.get(consumer2)));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testPoorRoundRobinAssignmentScenario() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        for (int i = 1; i <= 5; ++i) {
            partitionsPerTopic.put(String.format("topic%d", i), i % 2 + 1);
        }
        this.subscriptions.put("consumer1", new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics("topic1", "topic2", "topic3", "topic4", "topic5")));
        this.subscriptions.put("consumer2", new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics("topic1", "topic3", "topic5")));
        this.subscriptions.put("consumer3", new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics("topic1", "topic3", "topic5")));
        this.subscriptions.put("consumer4", new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics("topic1", "topic2", "topic3", "topic4", "topic5")));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
    }

    @Test
    public void testAddRemoveTopicTwoConsumers() {
        String consumer1 = "consumer";
        String consumer2 = "consumer2";
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 3);
        this.subscriptions.put(consumer1, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics(this.topic)));
        this.subscriptions.put(consumer2, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics(this.topic)));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        List consumer1Assignment1 = (List)assignment.get(consumer1);
        List consumer2Assignment1 = (List)assignment.get(consumer2);
        Assertions.assertTrue((consumer1Assignment1.size() == 1 && consumer2Assignment1.size() == 2 || consumer1Assignment1.size() == 2 && consumer2Assignment1.size() == 1 ? 1 : 0) != 0);
        String topic2 = "topic2";
        partitionsPerTopic.put(topic2, 3);
        this.subscriptions.put(consumer1, this.buildSubscription(AbstractStickyAssignorTest.topics(this.topic, topic2), (List)assignment.get(consumer1)));
        this.subscriptions.put(consumer2, this.buildSubscription(AbstractStickyAssignorTest.topics(this.topic, topic2), (List)assignment.get(consumer2)));
        assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
        List consumer1assignment = (List)assignment.get(consumer1);
        List consumer2assignment = (List)assignment.get(consumer2);
        Assertions.assertTrue((consumer1assignment.size() == 3 && consumer2assignment.size() == 3 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)consumer1assignment.containsAll(consumer1Assignment1));
        Assertions.assertTrue((boolean)consumer2assignment.containsAll(consumer2Assignment1));
        partitionsPerTopic.remove(this.topic);
        this.subscriptions.put(consumer1, this.buildSubscription(AbstractStickyAssignorTest.topics(topic2), (List)assignment.get(consumer1)));
        this.subscriptions.put(consumer2, this.buildSubscription(AbstractStickyAssignorTest.topics(topic2), (List)assignment.get(consumer2)));
        assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
        List consumer1Assignment3 = (List)assignment.get(consumer1);
        List consumer2Assignment3 = (List)assignment.get(consumer2);
        Assertions.assertTrue((consumer1Assignment3.size() == 1 && consumer2Assignment3.size() == 2 || consumer1Assignment3.size() == 2 && consumer2Assignment3.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)consumer1assignment.containsAll(consumer1Assignment3));
        Assertions.assertTrue((boolean)consumer2assignment.containsAll(consumer2Assignment3));
    }

    @Test
    public void testReassignmentAfterOneConsumerLeaves() {
        int i;
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        for (i = 1; i < 20; ++i) {
            partitionsPerTopic.put(this.getTopicName(i, 20), i);
        }
        for (i = 1; i < 20; ++i) {
            ArrayList<String> topics = new ArrayList<String>();
            for (int j = 1; j <= i; ++j) {
                topics.add(this.getTopicName(j, 20));
            }
            this.subscriptions.put(this.getConsumerName(i, 20), new ConsumerPartitionAssignor.Subscription(topics));
        }
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        for (int i2 = 1; i2 < 20; ++i2) {
            String consumer = this.getConsumerName(i2, 20);
            this.subscriptions.put(consumer, this.buildSubscription(this.subscriptions.get(consumer).topics(), (List)assignment.get(consumer)));
        }
        this.subscriptions.remove("consumer10");
        assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)this.assignor.isSticky());
    }

    @Test
    public void testReassignmentAfterOneConsumerAdded() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put("topic", 20);
        for (int i = 1; i < 10; ++i) {
            this.subscriptions.put(this.getConsumerName(i, 10), new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics("topic")));
        }
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        this.subscriptions.put(this.getConsumerName(10, 10), new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics("topic")));
        assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
    }

    @Test
    public void testSameSubscriptions() {
        int i;
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        for (i = 1; i < 15; ++i) {
            partitionsPerTopic.put(this.getTopicName(i, 15), i);
        }
        for (i = 1; i < 9; ++i) {
            ArrayList<String> topics = new ArrayList<String>();
            for (int j = 1; j <= partitionsPerTopic.size(); ++j) {
                topics.add(this.getTopicName(j, 15));
            }
            this.subscriptions.put(this.getConsumerName(i, 9), new ConsumerPartitionAssignor.Subscription(topics));
        }
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        for (int i2 = 1; i2 < 9; ++i2) {
            String consumer = this.getConsumerName(i2, 9);
            this.subscriptions.put(consumer, this.buildSubscription(this.subscriptions.get(consumer).topics(), (List)assignment.get(consumer)));
        }
        this.subscriptions.remove(this.getConsumerName(5, 9));
        assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
    }

    @Timeout(value=30L)
    @Test
    public void testLargeAssignmentAndGroupWithUniformSubscription() {
        int i;
        int topicCount = 500;
        int partitionCount = 2000;
        int consumerCount = 2000;
        ArrayList<String> topics = new ArrayList<String>();
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        for (i = 0; i < topicCount; ++i) {
            String topicName = this.getTopicName(i, topicCount);
            topics.add(topicName);
            partitionsPerTopic.put(topicName, partitionCount);
        }
        for (i = 0; i < consumerCount; ++i) {
            this.subscriptions.put(this.getConsumerName(i, consumerCount), new ConsumerPartitionAssignor.Subscription(topics));
        }
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        for (int i2 = 1; i2 < consumerCount; ++i2) {
            String consumer = this.getConsumerName(i2, consumerCount);
            this.subscriptions.put(consumer, this.buildSubscription(topics, (List)assignment.get(consumer)));
        }
        this.assignor.assign(partitionsPerTopic, this.subscriptions);
    }

    @Test
    public void testLargeAssignmentWithMultipleConsumersLeavingAndRandomSubscription() {
        int i;
        int i2;
        Random rand = new Random();
        int topicCount = 40;
        int consumerCount = 200;
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        for (i2 = 0; i2 < topicCount; ++i2) {
            partitionsPerTopic.put(this.getTopicName(i2, topicCount), rand.nextInt(10) + 1);
        }
        for (i2 = 0; i2 < consumerCount; ++i2) {
            ArrayList<String> topics = new ArrayList<String>();
            for (int j = 0; j < rand.nextInt(20); ++j) {
                topics.add(this.getTopicName(rand.nextInt(topicCount), topicCount));
            }
            this.subscriptions.put(this.getConsumerName(i2, consumerCount), new ConsumerPartitionAssignor.Subscription(topics));
        }
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        for (i = 1; i < consumerCount; ++i) {
            String consumer = this.getConsumerName(i, consumerCount);
            this.subscriptions.put(consumer, this.buildSubscription(this.subscriptions.get(consumer).topics(), (List)assignment.get(consumer)));
        }
        for (i = 0; i < 50; ++i) {
            String c = this.getConsumerName(rand.nextInt(consumerCount), consumerCount);
            this.subscriptions.remove(c);
        }
        assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)this.assignor.isSticky());
    }

    @Test
    public void testNewSubscription() {
        int i;
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        for (i = 1; i < 5; ++i) {
            partitionsPerTopic.put(this.getTopicName(i, 5), 1);
        }
        for (i = 0; i < 3; ++i) {
            ArrayList<String> topics = new ArrayList<String>();
            for (int j = i; j <= 3 * i - 2; ++j) {
                topics.add(this.getTopicName(j, 5));
            }
            this.subscriptions.put(this.getConsumerName(i, 3), new ConsumerPartitionAssignor.Subscription(topics));
        }
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        this.subscriptions.get(this.getConsumerName(0, 3)).topics().add(this.getTopicName(1, 5));
        assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        Assertions.assertTrue((boolean)this.assignor.isSticky());
    }

    @Test
    public void testMoveExistingAssignments() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        for (int i = 1; i <= 6; ++i) {
            partitionsPerTopic.put(String.format("topic%02d", i), 1);
        }
        this.subscriptions.put("consumer01", this.buildSubscription(AbstractStickyAssignorTest.topics("topic01", "topic02"), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp("topic01", 0))));
        this.subscriptions.put("consumer02", this.buildSubscription(AbstractStickyAssignorTest.topics("topic01", "topic02", "topic03", "topic04"), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp("topic02", 0), AbstractStickyAssignorTest.tp("topic03", 0))));
        this.subscriptions.put("consumer03", this.buildSubscription(AbstractStickyAssignorTest.topics("topic02", "topic03", "topic04", "topic05", "topic06"), AbstractStickyAssignorTest.partitions(AbstractStickyAssignorTest.tp("topic04", 0), AbstractStickyAssignorTest.tp("topic05", 0), AbstractStickyAssignorTest.tp("topic06", 0))));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
    }

    @Test
    public void testStickiness() {
        List topicPartitions;
        String consumer;
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put("topic01", 3);
        String consumer1 = "consumer01";
        String consumer2 = "consumer02";
        String consumer3 = "consumer03";
        String consumer4 = "consumer04";
        this.subscriptions.put(consumer1, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics("topic01")));
        this.subscriptions.put(consumer2, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics("topic01")));
        this.subscriptions.put(consumer3, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics("topic01")));
        this.subscriptions.put(consumer4, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics("topic01")));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        HashMap partitionsAssigned = new HashMap();
        Set assignments = assignment.entrySet();
        for (Map.Entry entry : assignments) {
            consumer = (String)entry.getKey();
            topicPartitions = (List)entry.getValue();
            int size = topicPartitions.size();
            Assertions.assertTrue((size <= 1 ? 1 : 0) != 0, (String)("Consumer " + consumer + " is assigned more topic partitions than expected."));
            if (size != 1) continue;
            partitionsAssigned.put(consumer, topicPartitions.get(0));
        }
        this.subscriptions.remove(consumer1);
        this.subscriptions.put(consumer2, this.buildSubscription(AbstractStickyAssignorTest.topics("topic01"), (List)assignment.get(consumer2)));
        this.subscriptions.put(consumer3, this.buildSubscription(AbstractStickyAssignorTest.topics("topic01"), (List)assignment.get(consumer3)));
        this.subscriptions.put(consumer4, this.buildSubscription(AbstractStickyAssignorTest.topics("topic01"), (List)assignment.get(consumer4)));
        assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
        assignments = assignment.entrySet();
        for (Map.Entry entry : assignments) {
            consumer = (String)entry.getKey();
            topicPartitions = (List)entry.getValue();
            Assertions.assertEquals((int)1, (int)topicPartitions.size(), (String)("Consumer " + consumer + " is assigned more topic partitions than expected."));
            Assertions.assertTrue((!partitionsAssigned.containsKey(consumer) || ((List)assignment.get(consumer)).contains(partitionsAssigned.get(consumer)) ? 1 : 0) != 0, (String)("Stickiness was not honored for consumer " + consumer));
        }
    }

    @Test
    public void testAssignmentUpdatedForDeletedTopic() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put("topic01", 1);
        partitionsPerTopic.put("topic03", 100);
        this.subscriptions = Collections.singletonMap(this.consumerId, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics("topic01", "topic02", "topic03")));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        Assertions.assertEquals((int)assignment.values().stream().mapToInt(List::size).sum(), (int)101);
        Assertions.assertEquals(Collections.singleton(this.consumerId), assignment.keySet());
        Assertions.assertTrue((boolean)AbstractStickyAssignorTest.isFullyBalanced(assignment));
    }

    @Test
    public void testNoExceptionThrownWhenOnlySubscribedTopicDeleted() {
        HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
        partitionsPerTopic.put(this.topic, 3);
        this.subscriptions.put(this.consumerId, new ConsumerPartitionAssignor.Subscription(AbstractStickyAssignorTest.topics(this.topic)));
        Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
        this.subscriptions.put(this.consumerId, this.buildSubscription(AbstractStickyAssignorTest.topics(this.topic), (List)assignment.get(this.consumerId)));
        assignment = this.assignor.assign(Collections.emptyMap(), this.subscriptions);
        Assertions.assertEquals((int)assignment.size(), (int)1);
        Assertions.assertTrue((boolean)((List)assignment.get(this.consumerId)).isEmpty());
    }

    @Test
    public void testReassignmentWithRandomSubscriptionsAndChanges() {
        int minNumConsumers = 20;
        int maxNumConsumers = 40;
        int minNumTopics = 10;
        int maxNumTopics = 20;
        for (int round = 1; round <= 100; ++round) {
            int numTopics = 10 + new Random().nextInt(10);
            ArrayList<String> topics = new ArrayList<String>();
            for (int i = 0; i < numTopics; ++i) {
                topics.add(this.getTopicName(i, 20));
            }
            HashMap<String, Integer> partitionsPerTopic = new HashMap<String, Integer>();
            for (int i = 0; i < numTopics; ++i) {
                partitionsPerTopic.put(this.getTopicName(i, 20), i + 1);
            }
            int numConsumers = 20 + new Random().nextInt(20);
            for (int i = 0; i < numConsumers; ++i) {
                List sub = Utils.sorted(AbstractStickyAssignorTest.getRandomSublist(topics));
                this.subscriptions.put(this.getConsumerName(i, 40), new ConsumerPartitionAssignor.Subscription(sub));
            }
            this.assignor = this.createAssignor();
            Map assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
            this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
            this.subscriptions.clear();
            for (int i = 0; i < numConsumers; ++i) {
                List sub = Utils.sorted(AbstractStickyAssignorTest.getRandomSublist(topics));
                String consumer = this.getConsumerName(i, 40);
                this.subscriptions.put(consumer, this.buildSubscription(sub, (List)assignment.get(consumer)));
            }
            assignment = this.assignor.assign(partitionsPerTopic, this.subscriptions);
            this.verifyValidityAndBalance(this.subscriptions, assignment, partitionsPerTopic);
            Assertions.assertTrue((boolean)this.assignor.isSticky());
        }
    }

    private String getTopicName(int i, int maxNum) {
        return this.getCanonicalName("t", i, maxNum);
    }

    private String getConsumerName(int i, int maxNum) {
        return this.getCanonicalName("c", i, maxNum);
    }

    private String getCanonicalName(String str, int i, int maxNum) {
        return str + this.pad(i, Integer.toString(maxNum).length());
    }

    private String pad(int num, int digits) {
        StringBuilder sb = new StringBuilder();
        int iDigits = Integer.toString(num).length();
        for (int i = 1; i <= digits - iDigits; ++i) {
            sb.append("0");
        }
        sb.append(num);
        return sb.toString();
    }

    protected static List<String> topics(String ... topics) {
        return Arrays.asList(topics);
    }

    protected static List<TopicPartition> partitions(TopicPartition ... partitions) {
        return Arrays.asList(partitions);
    }

    protected static TopicPartition tp(String topic, int partition) {
        return new TopicPartition(topic, partition);
    }

    protected static boolean isFullyBalanced(Map<String, List<TopicPartition>> assignment) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (List<TopicPartition> topicPartitions : assignment.values()) {
            int size = topicPartitions.size();
            if (size < min) {
                min = size;
            }
            if (size <= max) continue;
            max = size;
        }
        return max - min <= 1;
    }

    protected static List<String> getRandomSublist(ArrayList<String> list) {
        ArrayList<String> selectedItems = new ArrayList<String>(list);
        int len = list.size();
        Random random = new Random();
        int howManyToRemove = random.nextInt(len);
        for (int i = 1; i <= howManyToRemove; ++i) {
            selectedItems.remove(random.nextInt(selectedItems.size()));
        }
        return selectedItems;
    }

    protected void verifyValidityAndBalance(Map<String, ConsumerPartitionAssignor.Subscription> subscriptions, Map<String, List<TopicPartition>> assignments, Map<String, Integer> partitionsPerTopic) {
        int size = subscriptions.size();
        assert (size == assignments.size());
        List consumers = Utils.sorted(assignments.keySet());
        for (int i = 0; i < size; ++i) {
            String consumer = (String)consumers.get(i);
            List<TopicPartition> partitions = assignments.get(consumer);
            for (TopicPartition partition : partitions) {
                Assertions.assertTrue((boolean)subscriptions.get(consumer).topics().contains(partition.topic()), (String)("Error: Partition " + partition + "is assigned to c" + i + ", but it is not subscribed to Topic t" + partition.topic() + "\nSubscriptions: " + subscriptions + "\nAssignments: " + assignments));
            }
            if (i == size - 1) continue;
            for (int j = i + 1; j < size; ++j) {
                String otherConsumer = (String)consumers.get(j);
                List<TopicPartition> otherPartitions = assignments.get(otherConsumer);
                HashSet<TopicPartition> intersection = new HashSet<TopicPartition>(partitions);
                intersection.retainAll(otherPartitions);
                Assertions.assertTrue((boolean)intersection.isEmpty(), (String)("Error: Consumers c" + i + " and c" + j + " have common partitions assigned to them: " + intersection + "\nSubscriptions: " + subscriptions + "\nAssignments: " + assignments));
                int len = partitions.size();
                int otherLen = otherPartitions.size();
                if (Math.abs(len - otherLen) <= 1) continue;
                Map map = CollectionUtils.groupPartitionsByTopic(partitions);
                Map otherMap = CollectionUtils.groupPartitionsByTopic(otherPartitions);
                int moreLoaded = len > otherLen ? i : j;
                int lessLoaded = len > otherLen ? j : i;
                for (String topic : map.keySet()) {
                    Assertions.assertFalse((boolean)otherMap.containsKey(topic), (String)("Error: Some partitions can be moved from c" + moreLoaded + " to c" + lessLoaded + " to achieve a better balance\nc" + i + " has " + len + " partitions, and c" + j + " has " + otherLen + " partitions.\nSubscriptions: " + subscriptions + "\nAssignments: " + assignments));
                }
            }
        }
    }
}

