/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ControlledShutdownRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ControlledShutdownRequest;
import org.apache.kafka.common.requests.ControlledShutdownResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ControlledShutdownRequestTest {
    @Test
    public void testUnsupportedVersion() {
        ControlledShutdownRequest.Builder builder = new ControlledShutdownRequest.Builder(new ControlledShutdownRequestData().setBrokerId(1), (short)(ApiKeys.CONTROLLED_SHUTDOWN.latestVersion() + 1));
        Assertions.assertThrows(UnsupportedVersionException.class, () -> ((ControlledShutdownRequest.Builder)builder).build());
    }

    @Test
    public void testGetErrorResponse() {
        for (short version = ApiKeys.CONTROLLED_SHUTDOWN.oldestVersion(); version < ApiKeys.CONTROLLED_SHUTDOWN.latestVersion(); version = (short)(version + 1)) {
            ControlledShutdownRequest.Builder builder = new ControlledShutdownRequest.Builder(new ControlledShutdownRequestData().setBrokerId(1), version);
            ControlledShutdownRequest request = (ControlledShutdownRequest)builder.build();
            ControlledShutdownResponse response = request.getErrorResponse(0, (Throwable)new ClusterAuthorizationException("Not authorized"));
            Assertions.assertEquals((Object)Errors.CLUSTER_AUTHORIZATION_FAILED, (Object)response.error());
        }
    }
}

