/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.utils.Utils;

public class ConfluentNode
extends Node {
    private final Map<String, String> tags;

    public ConfluentNode(int id, String host, int port, String rack, Map<String, String> tags) {
        super(id, host, port, rack);
        this.tags = Collections.unmodifiableMap(tags);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public int hashCode() {
        Integer h = this.hash;
        if (h == null) {
            int result = 31 + (this.host == null ? 0 : this.host.hashCode());
            result = 31 * result + this.id;
            result = 31 * result + this.port;
            result = 31 * result + (this.rack == null ? 0 : this.rack.hashCode());
            result = 31 * result + this.tags.hashCode();
            this.hash = result;
            return result;
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConfluentNode other = (ConfluentNode)obj;
        return this.id == other.id && this.port == other.port && Objects.equals(this.host, other.host) && Objects.equals(this.rack, other.rack) && Objects.equals(this.tags, other.tags);
    }

    @Override
    public String toString() {
        return this.host + ":" + this.port + " (id: " + this.idString + " rack: " + this.rack + " tags: " + Utils.mkString(this.tags, "[", "]", "=", ", ") + ")";
    }

    public static Map<String, String> tags(Node node) {
        if (node instanceof ConfluentNode) {
            return ((ConfluentNode)node).tags();
        }
        return null;
    }
}

