/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterMirrorsRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class AlterMirrorsRequestDataJsonConverter {
    public static AlterMirrorsRequestData read(JsonNode _node, short _version) {
        AlterMirrorsRequestData _object = new AlterMirrorsRequestData();
        JsonNode _opsNode = _node.get("ops");
        if (_opsNode == null) {
            if (_version <= 1) {
                throw new RuntimeException("AlterMirrorsRequestData: unable to locate field 'ops', which is mandatory in version " + _version);
            }
            _object.ops = new ArrayList<AlterMirrorsRequestData.OpData>(0);
        } else {
            if (!_opsNode.isArray()) {
                throw new RuntimeException("AlterMirrorsRequestData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<AlterMirrorsRequestData.OpData> _collection = new ArrayList<AlterMirrorsRequestData.OpData>(_opsNode.size());
            _object.ops = _collection;
            for (Object _element : _opsNode) {
                _collection.add(OpDataJsonConverter.read((JsonNode)_element, _version));
            }
        }
        JsonNode _mirrorOperationsNode = _node.get("mirrorOperations");
        if (_mirrorOperationsNode == null) {
            if (_version >= 2) {
                throw new RuntimeException("AlterMirrorsRequestData: unable to locate field 'mirrorOperations', which is mandatory in version " + _version);
            }
            _object.mirrorOperations = new ArrayList<AlterMirrorsRequestData.MirrorOperation>(0);
        } else {
            if (!_mirrorOperationsNode.isArray()) {
                throw new RuntimeException("AlterMirrorsRequestData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<AlterMirrorsRequestData.MirrorOperation> _collection = new ArrayList<AlterMirrorsRequestData.MirrorOperation>(_mirrorOperationsNode.size());
            _object.mirrorOperations = _collection;
            for (JsonNode _element : _mirrorOperationsNode) {
                _collection.add(MirrorOperationJsonConverter.read(_element, _version));
            }
        }
        JsonNode _validateOnlyNode = _node.get("validateOnly");
        if (_validateOnlyNode == null) {
            throw new RuntimeException("AlterMirrorsRequestData: unable to locate field 'validateOnly', which is mandatory in version " + _version);
        }
        if (!_validateOnlyNode.isBoolean()) {
            throw new RuntimeException("AlterMirrorsRequestData expected Boolean type, but got " + _node.getNodeType());
        }
        _object.validateOnly = _validateOnlyNode.asBoolean();
        JsonNode _timeoutMsNode = _node.get("timeoutMs");
        if (_timeoutMsNode == null) {
            throw new RuntimeException("AlterMirrorsRequestData: unable to locate field 'timeoutMs', which is mandatory in version " + _version);
        }
        _object.timeoutMs = MessageUtil.jsonNodeToInt(_timeoutMsNode, "AlterMirrorsRequestData");
        return _object;
    }

    public static JsonNode write(AlterMirrorsRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        if (_version <= 1) {
            ArrayNode _opsArray = new ArrayNode(JsonNodeFactory.instance);
            for (AlterMirrorsRequestData.OpData opData : _object.ops) {
                _opsArray.add(OpDataJsonConverter.write(opData, _version, _serializeRecords));
            }
            _node.set("ops", (JsonNode)_opsArray);
        } else if (!_object.ops.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default ops at version " + _version);
        }
        if (_version >= 2) {
            ArrayNode _mirrorOperationsArray = new ArrayNode(JsonNodeFactory.instance);
            for (AlterMirrorsRequestData.MirrorOperation mirrorOperation : _object.mirrorOperations) {
                _mirrorOperationsArray.add(MirrorOperationJsonConverter.write(mirrorOperation, _version, _serializeRecords));
            }
            _node.set("mirrorOperations", (JsonNode)_mirrorOperationsArray);
        } else if (!_object.mirrorOperations.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default mirrorOperations at version " + _version);
        }
        _node.set("validateOnly", (JsonNode)BooleanNode.valueOf((boolean)_object.validateOnly));
        _node.set("timeoutMs", (JsonNode)new IntNode(_object.timeoutMs));
        return _node;
    }

    public static JsonNode write(AlterMirrorsRequestData _object, short _version) {
        return AlterMirrorsRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class StopTopicMirrorDataJsonConverter {
        public static AlterMirrorsRequestData.StopTopicMirrorData read(JsonNode _node, short _version) {
            AlterMirrorsRequestData.StopTopicMirrorData _object = new AlterMirrorsRequestData.StopTopicMirrorData();
            JsonNode _topicNode = _node.get("topic");
            if (_topicNode == null) {
                throw new RuntimeException("StopTopicMirrorData: unable to locate field 'topic', which is mandatory in version " + _version);
            }
            if (!_topicNode.isTextual()) {
                throw new RuntimeException("StopTopicMirrorData expected a string type, but got " + _node.getNodeType());
            }
            _object.topic = _topicNode.asText();
            JsonNode _synchronizeNode = _node.get("synchronize");
            if (_synchronizeNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("StopTopicMirrorData: unable to locate field 'synchronize', which is mandatory in version " + _version);
                }
                _object.synchronize = true;
            } else {
                if (!_synchronizeNode.isBoolean()) {
                    throw new RuntimeException("StopTopicMirrorData expected Boolean type, but got " + _node.getNodeType());
                }
                _object.synchronize = _synchronizeNode.asBoolean();
            }
            return _object;
        }

        public static JsonNode write(AlterMirrorsRequestData.StopTopicMirrorData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topic", (JsonNode)new TextNode(_object.topic));
            if (_version >= 1) {
                _node.set("synchronize", (JsonNode)BooleanNode.valueOf((boolean)_object.synchronize));
            } else if (!_object.synchronize) {
                throw new UnsupportedVersionException("Attempted to write a non-default synchronize at version " + _version);
            }
            return _node;
        }

        public static JsonNode write(AlterMirrorsRequestData.StopTopicMirrorData _object, short _version) {
            return StopTopicMirrorDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class PauseTopicMirrorDataJsonConverter {
        public static AlterMirrorsRequestData.PauseTopicMirrorData read(JsonNode _node, short _version) {
            AlterMirrorsRequestData.PauseTopicMirrorData _object = new AlterMirrorsRequestData.PauseTopicMirrorData();
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PauseTopicMirrorData");
            }
            JsonNode _topicNode = _node.get("topic");
            if (_topicNode == null) {
                throw new RuntimeException("PauseTopicMirrorData: unable to locate field 'topic', which is mandatory in version " + _version);
            }
            if (!_topicNode.isTextual()) {
                throw new RuntimeException("PauseTopicMirrorData expected a string type, but got " + _node.getNodeType());
            }
            _object.topic = _topicNode.asText();
            JsonNode _enableNode = _node.get("enable");
            if (_enableNode == null) {
                throw new RuntimeException("PauseTopicMirrorData: unable to locate field 'enable', which is mandatory in version " + _version);
            }
            if (!_enableNode.isBoolean()) {
                throw new RuntimeException("PauseTopicMirrorData expected Boolean type, but got " + _node.getNodeType());
            }
            _object.enable = _enableNode.asBoolean();
            JsonNode _linkLevelNode = _node.get("linkLevel");
            if (_linkLevelNode == null) {
                throw new RuntimeException("PauseTopicMirrorData: unable to locate field 'linkLevel', which is mandatory in version " + _version);
            }
            if (!_linkLevelNode.isBoolean()) {
                throw new RuntimeException("PauseTopicMirrorData expected Boolean type, but got " + _node.getNodeType());
            }
            _object.linkLevel = _linkLevelNode.asBoolean();
            return _object;
        }

        public static JsonNode write(AlterMirrorsRequestData.PauseTopicMirrorData _object, short _version, boolean _serializeRecords) {
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of PauseTopicMirrorData");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topic", (JsonNode)new TextNode(_object.topic));
            _node.set("enable", (JsonNode)BooleanNode.valueOf((boolean)_object.enable));
            _node.set("linkLevel", (JsonNode)BooleanNode.valueOf((boolean)_object.linkLevel));
            return _node;
        }

        public static JsonNode write(AlterMirrorsRequestData.PauseTopicMirrorData _object, short _version) {
            return PauseTopicMirrorDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class OpDataJsonConverter {
        public static AlterMirrorsRequestData.OpData read(JsonNode _node, short _version) {
            AlterMirrorsRequestData.OpData _object = new AlterMirrorsRequestData.OpData();
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OpData");
            }
            JsonNode _stopTopicMirrorNode = _node.get("stopTopicMirror");
            if (_stopTopicMirrorNode == null) {
                throw new RuntimeException("OpData: unable to locate field 'stopTopicMirror', which is mandatory in version " + _version);
            }
            if (_stopTopicMirrorNode.isNull()) {
                _object.stopTopicMirror = null;
            } else {
                if (!_stopTopicMirrorNode.isArray()) {
                    throw new RuntimeException("OpData expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<AlterMirrorsRequestData.StopTopicMirrorData> _collection = new ArrayList<AlterMirrorsRequestData.StopTopicMirrorData>(_stopTopicMirrorNode.size());
                _object.stopTopicMirror = _collection;
                for (Object _element : _stopTopicMirrorNode) {
                    _collection.add(StopTopicMirrorDataJsonConverter.read((JsonNode)_element, _version));
                }
            }
            JsonNode _clearTopicMirrorNode = _node.get("clearTopicMirror");
            if (_clearTopicMirrorNode == null) {
                throw new RuntimeException("OpData: unable to locate field 'clearTopicMirror', which is mandatory in version " + _version);
            }
            if (_clearTopicMirrorNode.isNull()) {
                _object.clearTopicMirror = null;
            } else {
                if (!_clearTopicMirrorNode.isArray()) {
                    throw new RuntimeException("OpData expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<AlterMirrorsRequestData.ClearTopicMirrorData> _collection = new ArrayList<AlterMirrorsRequestData.ClearTopicMirrorData>(_clearTopicMirrorNode.size());
                _object.clearTopicMirror = _collection;
                for (JsonNode _element : _clearTopicMirrorNode) {
                    _collection.add(ClearTopicMirrorDataJsonConverter.read(_element, _version));
                }
            }
            JsonNode _pauseTopicMirrorNode = _node.get("pauseTopicMirror");
            if (_pauseTopicMirrorNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("OpData: unable to locate field 'pauseTopicMirror', which is mandatory in version " + _version);
                }
                _object.pauseTopicMirror = null;
            } else if (_pauseTopicMirrorNode.isNull()) {
                _object.pauseTopicMirror = null;
            } else {
                if (!_pauseTopicMirrorNode.isArray()) {
                    throw new RuntimeException("OpData expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<AlterMirrorsRequestData.PauseTopicMirrorData> _collection = new ArrayList<AlterMirrorsRequestData.PauseTopicMirrorData>(_pauseTopicMirrorNode.size());
                _object.pauseTopicMirror = _collection;
                for (JsonNode _element : _pauseTopicMirrorNode) {
                    _collection.add(PauseTopicMirrorDataJsonConverter.read(_element, _version));
                }
            }
            return _object;
        }

        public static JsonNode write(AlterMirrorsRequestData.OpData _object, short _version, boolean _serializeRecords) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of OpData");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            if (_object.stopTopicMirror == null) {
                _node.set("stopTopicMirror", (JsonNode)NullNode.instance);
            } else {
                ArrayNode _stopTopicMirrorArray = new ArrayNode(JsonNodeFactory.instance);
                for (AlterMirrorsRequestData.StopTopicMirrorData stopTopicMirrorData : _object.stopTopicMirror) {
                    _stopTopicMirrorArray.add(StopTopicMirrorDataJsonConverter.write(stopTopicMirrorData, _version, _serializeRecords));
                }
                _node.set("stopTopicMirror", (JsonNode)_stopTopicMirrorArray);
            }
            if (_object.clearTopicMirror == null) {
                _node.set("clearTopicMirror", (JsonNode)NullNode.instance);
            } else {
                ArrayNode _clearTopicMirrorArray = new ArrayNode(JsonNodeFactory.instance);
                for (AlterMirrorsRequestData.ClearTopicMirrorData clearTopicMirrorData : _object.clearTopicMirror) {
                    _clearTopicMirrorArray.add(ClearTopicMirrorDataJsonConverter.write(clearTopicMirrorData, _version, _serializeRecords));
                }
                _node.set("clearTopicMirror", (JsonNode)_clearTopicMirrorArray);
            }
            if (_version >= 1) {
                if (_object.pauseTopicMirror == null) {
                    _node.set("pauseTopicMirror", (JsonNode)NullNode.instance);
                } else {
                    ArrayNode _pauseTopicMirrorArray = new ArrayNode(JsonNodeFactory.instance);
                    for (AlterMirrorsRequestData.PauseTopicMirrorData pauseTopicMirrorData : _object.pauseTopicMirror) {
                        _pauseTopicMirrorArray.add(PauseTopicMirrorDataJsonConverter.write(pauseTopicMirrorData, _version, _serializeRecords));
                    }
                    _node.set("pauseTopicMirror", (JsonNode)_pauseTopicMirrorArray);
                }
            } else if (_object.pauseTopicMirror != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default pauseTopicMirror at version " + _version);
            }
            return _node;
        }

        public static JsonNode write(AlterMirrorsRequestData.OpData _object, short _version) {
            return OpDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class MirrorOperationJsonConverter {
        public static AlterMirrorsRequestData.MirrorOperation read(JsonNode _node, short _version) {
            AlterMirrorsRequestData.MirrorOperation _object = new AlterMirrorsRequestData.MirrorOperation();
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MirrorOperation");
            }
            JsonNode _topicNode = _node.get("topic");
            if (_topicNode == null) {
                throw new RuntimeException("MirrorOperation: unable to locate field 'topic', which is mandatory in version " + _version);
            }
            if (!_topicNode.isTextual()) {
                throw new RuntimeException("MirrorOperation expected a string type, but got " + _node.getNodeType());
            }
            _object.topic = _topicNode.asText();
            JsonNode _operationCodeNode = _node.get("operationCode");
            if (_operationCodeNode == null) {
                throw new RuntimeException("MirrorOperation: unable to locate field 'operationCode', which is mandatory in version " + _version);
            }
            _object.operationCode = MessageUtil.jsonNodeToByte(_operationCodeNode, "MirrorOperation");
            return _object;
        }

        public static JsonNode write(AlterMirrorsRequestData.MirrorOperation _object, short _version, boolean _serializeRecords) {
            if (_version < 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MirrorOperation");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topic", (JsonNode)new TextNode(_object.topic));
            _node.set("operationCode", (JsonNode)new ShortNode((short)_object.operationCode));
            return _node;
        }

        public static JsonNode write(AlterMirrorsRequestData.MirrorOperation _object, short _version) {
            return MirrorOperationJsonConverter.write(_object, _version, true);
        }
    }

    public static class ClearTopicMirrorDataJsonConverter {
        public static AlterMirrorsRequestData.ClearTopicMirrorData read(JsonNode _node, short _version) {
            AlterMirrorsRequestData.ClearTopicMirrorData _object = new AlterMirrorsRequestData.ClearTopicMirrorData();
            JsonNode _topicNode = _node.get("topic");
            if (_topicNode == null) {
                throw new RuntimeException("ClearTopicMirrorData: unable to locate field 'topic', which is mandatory in version " + _version);
            }
            if (!_topicNode.isTextual()) {
                throw new RuntimeException("ClearTopicMirrorData expected a string type, but got " + _node.getNodeType());
            }
            _object.topic = _topicNode.asText();
            return _object;
        }

        public static JsonNode write(AlterMirrorsRequestData.ClearTopicMirrorData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topic", (JsonNode)new TextNode(_object.topic));
            return _node;
        }

        public static JsonNode write(AlterMirrorsRequestData.ClearTopicMirrorData _object, short _version) {
            return ClearTopicMirrorDataJsonConverter.write(_object, _version, true);
        }
    }
}

