/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AlterMirrorsResponseData
implements ApiMessage {
    int throttleTimeMs;
    List<AlterMirrorResult> results;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", new CompactArrayOf(AlterMirrorResult.SCHEMA_0), "The results for alter mirror operations."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", new CompactArrayOf(AlterMirrorResult.SCHEMA_1), "The results for alter mirror operations."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("results", new CompactArrayOf(AlterMirrorResult.SCHEMA_2), "The results for alter mirror operations."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public AlterMirrorsResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public AlterMirrorsResponseData() {
        this.throttleTimeMs = 0;
        this.results = new ArrayList<AlterMirrorResult>(0);
    }

    @Override
    public short apiKey() {
        return 10006;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field results was serialized as null");
        }
        ArrayList<AlterMirrorResult> newCollection = new ArrayList<AlterMirrorResult>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new AlterMirrorResult(_readable, _version, _context));
        }
        this.results = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeUnsignedVarint(this.results.size() + 1);
        for (AlterMirrorResult resultsElement : this.results) {
            resultsElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.results.size() + 1));
        for (AlterMirrorResult resultsElement : this.results) {
            resultsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterMirrorsResponseData)) {
            return false;
        }
        AlterMirrorsResponseData other = (AlterMirrorsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.results == null ? other.results != null : !this.results.equals(other.results)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.results == null ? 0 : this.results.hashCode());
        return hashCode;
    }

    @Override
    public AlterMirrorsResponseData duplicate() {
        AlterMirrorsResponseData _duplicate = new AlterMirrorsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        ArrayList<AlterMirrorResult> newResults = new ArrayList<AlterMirrorResult>(this.results.size());
        for (AlterMirrorResult _element : this.results) {
            newResults.add(_element.duplicate());
        }
        _duplicate.results = newResults;
        return _duplicate;
    }

    public String toString() {
        return "AlterMirrorsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", results=" + MessageUtil.deepToString(this.results.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<AlterMirrorResult> results() {
        return this.results;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterMirrorsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public AlterMirrorsResponseData setResults(List<AlterMirrorResult> v) {
        this.results = v;
        return this;
    }

    public static class PauseTopicMirrorData
    implements Message {
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_1 = new Schema(Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{null, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 1;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public PauseTopicMirrorData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public PauseTopicMirrorData() {
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 1 || _version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of PauseTopicMirrorData");
            }
            int _numTaggedFields = 0;
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PauseTopicMirrorData)) {
                return false;
            }
            PauseTopicMirrorData other = (PauseTopicMirrorData)obj;
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            return hashCode;
        }

        @Override
        public PauseTopicMirrorData duplicate() {
            PauseTopicMirrorData _duplicate = new PauseTopicMirrorData();
            return _duplicate;
        }

        public String toString() {
            return "PauseTopicMirrorData()";
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }
    }

    public static class ClearTopicMirrorData
    implements Message {
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public ClearTopicMirrorData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ClearTopicMirrorData() {
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of ClearTopicMirrorData");
            }
            int _numTaggedFields = 0;
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ClearTopicMirrorData)) {
                return false;
            }
            ClearTopicMirrorData other = (ClearTopicMirrorData)obj;
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            return hashCode;
        }

        @Override
        public ClearTopicMirrorData duplicate() {
            ClearTopicMirrorData _duplicate = new ClearTopicMirrorData();
            return _duplicate;
        }

        public String toString() {
            return "ClearTopicMirrorData()";
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class StopTopicMirrorData
    implements Message {
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public StopTopicMirrorData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public StopTopicMirrorData() {
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of StopTopicMirrorData");
            }
            int _numTaggedFields = 0;
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof StopTopicMirrorData)) {
                return false;
            }
            StopTopicMirrorData other = (StopTopicMirrorData)obj;
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            return hashCode;
        }

        @Override
        public StopTopicMirrorData duplicate() {
            StopTopicMirrorData _duplicate = new StopTopicMirrorData();
            return _duplicate;
        }

        public String toString() {
            return "StopTopicMirrorData()";
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class AlterMirrorResult
    implements Message {
        short errorCode;
        String errorMessage;
        String topic;
        List<StopTopicMirrorData> stopTopicMirror;
        List<ClearTopicMirrorData> clearTopicMirror;
        List<PauseTopicMirrorData> pauseTopicMirror;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or `0` if alter operation succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if alter operation succeeded."), new Field("stop_topic_mirror", CompactArrayOf.nullable(StopTopicMirrorData.SCHEMA_0), "Stops a topic's mirroring to become a writable topic."), new Field("clear_topic_mirror", CompactArrayOf.nullable(ClearTopicMirrorData.SCHEMA_0), "Clears a topic's mirror information."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_1 = new Schema(new Field("error_code", Type.INT16, "The error code, or `0` if alter operation succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if alter operation succeeded."), new Field("stop_topic_mirror", CompactArrayOf.nullable(StopTopicMirrorData.SCHEMA_0), "Stops a topic's mirroring to become a writable topic."), new Field("clear_topic_mirror", CompactArrayOf.nullable(ClearTopicMirrorData.SCHEMA_0), "Clears a topic's mirror information."), new Field("pause_topic_mirror", CompactArrayOf.nullable(PauseTopicMirrorData.SCHEMA_1), "Pauses a mirror topic's replication."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema SCHEMA_2 = new Schema(new Field("error_code", Type.INT16, "The error code, or `0` if alter operation succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or `null` if alter operation succeeded."), new Field("topic", Type.COMPACT_STRING, "The mirror topic's name."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public AlterMirrorResult(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public AlterMirrorResult() {
            this.errorCode = 0;
            this.errorMessage = "";
            this.topic = "";
            this.stopTopicMirror = null;
            this.clearTopicMirror = null;
            this.pauseTopicMirror = null;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            ArrayList<StopTopicMirrorData> newCollection;
            int arrayLength;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AlterMirrorResult");
            }
            this.errorCode = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
            }
            if (_version >= 2) {
                length = _readable.readUnsignedVarint() - 1;
                if (length < 0) {
                    throw new RuntimeException("non-nullable field topic was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field topic had invalid length " + length);
                }
                this.topic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            } else {
                this.topic = "";
            }
            if (_version <= 1) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.stopTopicMirror = null;
                } else {
                    newCollection = new ArrayList<StopTopicMirrorData>(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(new StopTopicMirrorData(_readable, _version, _context));
                    }
                    this.stopTopicMirror = newCollection;
                }
            } else {
                this.stopTopicMirror = null;
            }
            if (_version <= 1) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.clearTopicMirror = null;
                } else {
                    newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add((StopTopicMirrorData)((Object)new ClearTopicMirrorData(_readable, _version, _context)));
                    }
                    this.clearTopicMirror = newCollection;
                }
            } else {
                this.clearTopicMirror = null;
            }
            if (_version >= 1 && _version <= 1) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.pauseTopicMirror = null;
                } else {
                    newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add((StopTopicMirrorData)((Object)new PauseTopicMirrorData(_readable, _version, _context)));
                    }
                    this.pauseTopicMirror = newCollection;
                }
            } else {
                this.pauseTopicMirror = null;
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
            if (_version >= 2) {
                _stringBytes = _cache.getSerializedValue(this.topic);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            } else if (!this.topic.equals("")) {
                throw new UnsupportedVersionException("Attempted to write a non-default topic at version " + _version);
            }
            if (_version <= 1) {
                if (this.stopTopicMirror == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.stopTopicMirror.size() + 1);
                    _stringBytes = this.stopTopicMirror.iterator();
                    while (_stringBytes.hasNext()) {
                        StopTopicMirrorData stopTopicMirrorElement = (StopTopicMirrorData)_stringBytes.next();
                        stopTopicMirrorElement.write(_writable, _cache, _version, _context);
                    }
                }
            } else if (this.stopTopicMirror != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default stopTopicMirror at version " + _version);
            }
            if (_version <= 1) {
                if (this.clearTopicMirror == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.clearTopicMirror.size() + 1);
                    for (ClearTopicMirrorData clearTopicMirrorElement : this.clearTopicMirror) {
                        clearTopicMirrorElement.write(_writable, _cache, _version, _context);
                    }
                }
            } else if (this.clearTopicMirror != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default clearTopicMirror at version " + _version);
            }
            if (_version >= 1 && _version <= 1) {
                if (this.pauseTopicMirror == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.pauseTopicMirror.size() + 1);
                    for (PauseTopicMirrorData pauseTopicMirrorElement : this.pauseTopicMirror) {
                        pauseTopicMirrorElement.write(_writable, _cache, _version, _context);
                    }
                }
            } else if (this.pauseTopicMirror != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default pauseTopicMirror at version " + _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AlterMirrorResult");
            }
            _size.addBytes(2);
            if (this.errorMessage == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            if (_version >= 2) {
                _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topic).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'topic' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.topic, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            if (_version <= 1) {
                if (this.stopTopicMirror == null) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.stopTopicMirror.size() + 1));
                    for (StopTopicMirrorData stopTopicMirrorElement : this.stopTopicMirror) {
                        stopTopicMirrorElement.addSize(_size, _cache, _version, _context);
                    }
                }
            }
            if (_version <= 1) {
                if (this.clearTopicMirror == null) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.clearTopicMirror.size() + 1));
                    for (ClearTopicMirrorData clearTopicMirrorElement : this.clearTopicMirror) {
                        clearTopicMirrorElement.addSize(_size, _cache, _version, _context);
                    }
                }
            }
            if (_version >= 1 && _version <= 1) {
                if (this.pauseTopicMirror == null) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.pauseTopicMirror.size() + 1));
                    for (PauseTopicMirrorData pauseTopicMirrorElement : this.pauseTopicMirror) {
                        pauseTopicMirrorElement.addSize(_size, _cache, _version, _context);
                    }
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterMirrorResult)) {
                return false;
            }
            AlterMirrorResult other = (AlterMirrorResult)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.stopTopicMirror == null ? other.stopTopicMirror != null : !this.stopTopicMirror.equals(other.stopTopicMirror)) {
                return false;
            }
            if (this.clearTopicMirror == null ? other.clearTopicMirror != null : !this.clearTopicMirror.equals(other.clearTopicMirror)) {
                return false;
            }
            if (this.pauseTopicMirror == null ? other.pauseTopicMirror != null : !this.pauseTopicMirror.equals(other.pauseTopicMirror)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.stopTopicMirror == null ? 0 : this.stopTopicMirror.hashCode());
            hashCode = 31 * hashCode + (this.clearTopicMirror == null ? 0 : this.clearTopicMirror.hashCode());
            hashCode = 31 * hashCode + (this.pauseTopicMirror == null ? 0 : this.pauseTopicMirror.hashCode());
            return hashCode;
        }

        @Override
        public AlterMirrorResult duplicate() {
            AlterMirrorResult _duplicate = new AlterMirrorResult();
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            _duplicate.topic = this.topic;
            if (this.stopTopicMirror == null) {
                _duplicate.stopTopicMirror = null;
            } else {
                ArrayList<StopTopicMirrorData> newStopTopicMirror = new ArrayList<StopTopicMirrorData>(this.stopTopicMirror.size());
                for (StopTopicMirrorData stopTopicMirrorData : this.stopTopicMirror) {
                    newStopTopicMirror.add(stopTopicMirrorData.duplicate());
                }
                _duplicate.stopTopicMirror = newStopTopicMirror;
            }
            if (this.clearTopicMirror == null) {
                _duplicate.clearTopicMirror = null;
            } else {
                ArrayList<ClearTopicMirrorData> newClearTopicMirror = new ArrayList<ClearTopicMirrorData>(this.clearTopicMirror.size());
                for (ClearTopicMirrorData clearTopicMirrorData : this.clearTopicMirror) {
                    newClearTopicMirror.add(clearTopicMirrorData.duplicate());
                }
                _duplicate.clearTopicMirror = newClearTopicMirror;
            }
            if (this.pauseTopicMirror == null) {
                _duplicate.pauseTopicMirror = null;
            } else {
                ArrayList<PauseTopicMirrorData> newPauseTopicMirror = new ArrayList<PauseTopicMirrorData>(this.pauseTopicMirror.size());
                for (PauseTopicMirrorData pauseTopicMirrorData : this.pauseTopicMirror) {
                    newPauseTopicMirror.add(pauseTopicMirrorData.duplicate());
                }
                _duplicate.pauseTopicMirror = newPauseTopicMirror;
            }
            return _duplicate;
        }

        public String toString() {
            return "AlterMirrorResult(errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", stopTopicMirror=" + (this.stopTopicMirror == null ? "null" : MessageUtil.deepToString(this.stopTopicMirror.iterator())) + ", clearTopicMirror=" + (this.clearTopicMirror == null ? "null" : MessageUtil.deepToString(this.clearTopicMirror.iterator())) + ", pauseTopicMirror=" + (this.pauseTopicMirror == null ? "null" : MessageUtil.deepToString(this.pauseTopicMirror.iterator())) + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public String topic() {
            return this.topic;
        }

        public List<StopTopicMirrorData> stopTopicMirror() {
            return this.stopTopicMirror;
        }

        public List<ClearTopicMirrorData> clearTopicMirror() {
            return this.clearTopicMirror;
        }

        public List<PauseTopicMirrorData> pauseTopicMirror() {
            return this.pauseTopicMirror;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AlterMirrorResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public AlterMirrorResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public AlterMirrorResult setTopic(String v) {
            this.topic = v;
            return this;
        }

        public AlterMirrorResult setStopTopicMirror(List<StopTopicMirrorData> v) {
            this.stopTopicMirror = v;
            return this;
        }

        public AlterMirrorResult setClearTopicMirror(List<ClearTopicMirrorData> v) {
            this.clearTopicMirror = v;
            return this;
        }

        public AlterMirrorResult setPauseTopicMirror(List<PauseTopicMirrorData> v) {
            this.pauseTopicMirror = v;
            return this;
        }
    }
}

