/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.message.AlterIsrResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class AlterIsrResponse
extends AbstractResponse {
    private final AlterIsrResponseData data;

    public AlterIsrResponse(AlterIsrResponseData data) {
        super(ApiKeys.ALTER_ISR);
        this.data = data;
    }

    @Override
    public AlterIsrResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        this.updateErrorCounts(counts, Errors.forCode(this.data.errorCode()));
        this.data.topics().forEach(topicResponse -> topicResponse.partitions().forEach(partitionResponse -> this.updateErrorCounts(counts, Errors.forCode(partitionResponse.errorCode()))));
        return counts;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public static AlterIsrResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new AlterIsrResponse(new AlterIsrResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

