/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Set;
import org.apache.kafka.common.message.RemoveBrokersRequestData;
import org.apache.kafka.common.message.RemoveBrokersResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.RemoveBrokersResponse;

public class RemoveBrokersRequest
extends AbstractRequest {
    private RemoveBrokersRequestData data;

    private RemoveBrokersRequest(RemoveBrokersRequestData data, short version) {
        super(ApiKeys.REMOVE_BROKERS, version);
        this.data = data;
    }

    @Override
    public RemoveBrokersRequestData data() {
        return this.data;
    }

    @Override
    public RemoveBrokersResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        ArrayList<RemoveBrokersResponseData.RemoveBrokerResponse> brokerResponses = new ArrayList<RemoveBrokersResponseData.RemoveBrokerResponse>();
        if (this.data.brokersToRemove() != null) {
            for (RemoveBrokersRequestData.BrokerId brokerId : this.data.brokersToRemove()) {
                brokerResponses.add(new RemoveBrokersResponseData.RemoveBrokerResponse().setBrokerId(brokerId.brokerId()).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()));
            }
        }
        RemoveBrokersResponseData responseData = new RemoveBrokersResponseData().setBrokersToRemove(brokerResponses).setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setThrottleTimeMs(throttleTimeMs);
        return new RemoveBrokersResponse(responseData);
    }

    public static RemoveBrokersRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new RemoveBrokersRequest(new RemoveBrokersRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<RemoveBrokersRequest> {
        private final RemoveBrokersRequestData data;

        public Builder(Set<RemoveBrokersRequestData.BrokerId> brokersToRemove) {
            super(ApiKeys.REMOVE_BROKERS);
            this.data = new RemoveBrokersRequestData().setBrokersToRemove(new ArrayList<RemoveBrokersRequestData.BrokerId>(brokersToRemove));
        }

        @Override
        public RemoveBrokersRequest build(short version) {
            return new RemoveBrokersRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

