/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.requests.RequestContext;

public interface RequestLogFilter
extends Reconfigurable {
    public static final RequestLogFilter MATCH_NONE = new RequestLogFilter(){

        @Override
        public RequestLogAction processRequest(RequestContext ctx, long currentTimeNanos) {
            return NOT_LOGGED;
        }
    };
    public static final RequestLogAction NOT_LOGGED = () -> false;
    public static final RequestLogAction LOGGED = () -> true;

    default public boolean shouldLogRequest(RequestContext ctx, long currentTimeNanos) {
        RequestLogAction action = this.processRequest(ctx, currentTimeNanos);
        return action.shouldLog();
    }

    default public RequestLogAction processRequest(RequestContext ctx, long currentTimeNanos) {
        if (this.shouldLogRequest(ctx, currentTimeNanos)) {
            return LOGGED;
        }
        return NOT_LOGGED;
    }

    @Override
    default public Set<String> reconfigurableConfigs() {
        return Collections.emptySet();
    }

    @Override
    default public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
    }

    @Override
    default public void reconfigure(Map<String, ?> configs) {
    }

    @Override
    default public void configure(Map<String, ?> configs) {
    }

    public static interface RequestLogAction {
        public boolean shouldLog();
    }
}

