/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.HostResolver;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientUtils {
    private static final Logger log = LoggerFactory.getLogger(ClientUtils.class);

    private ClientUtils() {
    }

    public static String utcDateFor(long timeMs) {
        Date date = new Date(timeMs);
        SimpleDateFormat formatter = new SimpleDateFormat("YYYY-MM-dd_HH:mm:ss z");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return formatter.format(date);
    }

    public static List<InetSocketAddress> parseAndValidateAddresses(List<String> urls, String clientDnsLookupConfig) {
        return ClientUtils.parseAndValidateAddresses(urls, ClientDnsLookup.forConfig(clientDnsLookupConfig));
    }

    public static List<InetSocketAddress> parseAndValidateAddresses(List<String> urls, ClientDnsLookup clientDnsLookup) {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (String url : urls) {
            if (url == null || url.isEmpty()) continue;
            try {
                String host = Utils.getHost(url);
                Integer port = Utils.getPort(url);
                if (host == null || port == null) {
                    throw new ConfigException("Invalid url in bootstrap.servers: " + url);
                }
                if (clientDnsLookup == ClientDnsLookup.RESOLVE_CANONICAL_BOOTSTRAP_SERVERS_ONLY) {
                    InetAddress[] inetAddresses;
                    for (InetAddress inetAddress : inetAddresses = InetAddress.getAllByName(host)) {
                        String resolvedCanonicalName = inetAddress.getCanonicalHostName();
                        InetSocketAddress address = new InetSocketAddress(resolvedCanonicalName, (int)port);
                        if (address.isUnresolved()) {
                            log.warn("Couldn't resolve server {} from {} as DNS resolution of the canonical hostname {} failed for {}", new Object[]{url, "bootstrap.servers", resolvedCanonicalName, host});
                            continue;
                        }
                        addresses.add(address);
                    }
                    continue;
                }
                InetSocketAddress address = new InetSocketAddress(host, (int)port);
                if (address.isUnresolved()) {
                    log.warn("Couldn't resolve server {} from {} as DNS resolution failed for {}", new Object[]{url, "bootstrap.servers", host});
                    continue;
                }
                addresses.add(address);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigException("Invalid port in bootstrap.servers: " + url);
            }
            catch (UnknownHostException e) {
                throw new ConfigException("Unknown host in bootstrap.servers: " + url);
            }
        }
        if (addresses.isEmpty()) {
            throw new ConfigException("No resolvable bootstrap urls given in bootstrap.servers");
        }
        return addresses;
    }

    public static ChannelBuilder createChannelBuilder(AbstractConfig config, Time time, LogContext logContext) {
        SecurityProtocol securityProtocol = SecurityProtocol.forName(config.getString("security.protocol"));
        String clientSaslMechanism = config.getString("sasl.mechanism");
        return ChannelBuilders.clientChannelBuilder(securityProtocol, JaasContext.Type.CLIENT, config, null, clientSaslMechanism, time, true, logContext);
    }

    static List<InetAddress> resolve(String host, HostResolver hostResolver) throws UnknownHostException {
        InetAddress[] addresses = hostResolver.resolve(host);
        return ClientUtils.filterPreferredAddresses(addresses);
    }

    static List<InetAddress> filterPreferredAddresses(InetAddress[] allAddresses) {
        ArrayList<InetAddress> preferredAddresses = new ArrayList<InetAddress>();
        Class<?> clazz = null;
        for (InetAddress address : allAddresses) {
            if (clazz == null) {
                clazz = address.getClass();
            }
            if (!clazz.isInstance(address)) continue;
            preferredAddresses.add(address);
        }
        return preferredAddresses;
    }
}

