/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.function.Supplier;
import org.apache.kafka.common.network.NoOpProxyProtocolEngine;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolEngine;
import org.apache.kafka.common.network.ProxyProtocolV1Engine;
import org.apache.kafka.common.network.ProxyProtocolV2Engine;

public class ProxyProtocolEngineFactory {
    private ProxyProtocol proxyProtocol;
    private final Supplier<ProxyProtocolEngine> proxyProtocolEngineSupplier;

    public ProxyProtocolEngineFactory(ProxyProtocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
        this.proxyProtocolEngineSupplier = this::createFromVersion;
    }

    ProxyProtocolEngineFactory(Supplier<ProxyProtocolEngine> proxyProtocolEngineSupplier) {
        this.proxyProtocolEngineSupplier = proxyProtocolEngineSupplier;
    }

    ProxyProtocolEngine createProxyProtocolEngine() {
        return this.proxyProtocolEngineSupplier.get();
    }

    private ProxyProtocolEngine createFromVersion() {
        switch (this.proxyProtocol) {
            case V1: {
                return new ProxyProtocolV1Engine();
            }
            case V2: {
                return new ProxyProtocolV2Engine();
            }
            case NONE: {
                return new NoOpProxyProtocolEngine();
            }
        }
        throw new IllegalStateException("Unrecognized PROXY protocol version " + (Object)((Object)this.proxyProtocol));
    }
}

