/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.RequestAndSize;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.PathAwareSniHostName;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;

public class RequestContext
implements AuthorizableRequestContext {
    public final RequestHeader header;
    public final String connectionId;
    public final InetAddress clientAddress;
    public final KafkaPrincipal principal;
    public final ListenerName listenerName;
    public final SecurityProtocol securityProtocol;
    public final ClientInformation clientInformation;
    public final PathAwareSniHostName sniHostName;
    public final boolean fromPrivilegedListener;
    public final Optional<KafkaPrincipalSerde> principalSerde;

    public RequestContext(RequestHeader header, String connectionId, InetAddress clientAddress, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, ClientInformation clientInformation, PathAwareSniHostName sniHostName, boolean fromPrivilegedListener) {
        this(header, connectionId, clientAddress, principal, listenerName, securityProtocol, clientInformation, sniHostName, fromPrivilegedListener, Optional.empty());
    }

    public RequestContext(RequestHeader header, String connectionId, InetAddress clientAddress, KafkaPrincipal principal, ListenerName listenerName, SecurityProtocol securityProtocol, ClientInformation clientInformation, PathAwareSniHostName sniHostName, boolean fromPrivilegedListener, Optional<KafkaPrincipalSerde> principalSerde) {
        this.header = header;
        this.connectionId = connectionId;
        this.clientAddress = clientAddress;
        this.principal = principal;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.clientInformation = clientInformation;
        this.sniHostName = sniHostName;
        this.fromPrivilegedListener = fromPrivilegedListener;
        this.principalSerde = principalSerde;
    }

    public RequestAndSize parseRequest(ByteBuffer buffer) {
        if (this.isUnsupportedApiVersionsRequest()) {
            ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(new ApiVersionsRequestData(), 0, this.header.apiVersion());
            return new RequestAndSize(apiVersionsRequest, 0);
        }
        ApiKeys apiKey = this.header.apiKey();
        try {
            short apiVersion = this.header.apiVersion();
            return AbstractRequest.parseRequest(apiKey, apiVersion, buffer, MessageContext.IDENTITY);
        }
        catch (Throwable ex) {
            throw new InvalidRequestException("Error getting request for apiKey: " + (Object)((Object)apiKey) + ", apiVersion: " + this.header.apiVersion() + ", connectionId: " + this.connectionId + ", listenerName: " + this.listenerName + ", principal: " + this.principal, ex);
        }
    }

    public boolean shouldIntercept() {
        return false;
    }

    public AbstractResponse intercept(AbstractRequest request, int throttleTimeMs) {
        throw new UnsupportedOperationException();
    }

    public Send buildResponseSend(AbstractResponse body) {
        return body.toSend(this.header.toResponseHeader(), this.apiVersion());
    }

    public ByteBuffer buildResponseEnvelopePayload(AbstractResponse body) {
        return body.serializeWithHeader(this.header.toResponseHeader(), this.apiVersion());
    }

    private boolean isUnsupportedApiVersionsRequest() {
        return this.header.apiKey() == ApiKeys.API_VERSIONS && !ApiKeys.API_VERSIONS.isVersionSupported(this.header.apiVersion());
    }

    public short apiVersion() {
        if (this.isUnsupportedApiVersionsRequest()) {
            return 0;
        }
        return this.header.apiVersion();
    }

    @Override
    public String listenerName() {
        return this.listenerName.value();
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return this.securityProtocol;
    }

    @Override
    public KafkaPrincipal principal() {
        return this.principal;
    }

    @Override
    public InetAddress clientAddress() {
        return this.clientAddress;
    }

    @Override
    public int requestType() {
        return this.header.apiKey().id;
    }

    @Override
    public int requestVersion() {
        return this.header.apiVersion();
    }

    @Override
    public String clientId() {
        return this.header.clientId();
    }

    @Override
    public int correlationId() {
        return this.header.correlationId();
    }

    public PathAwareSniHostName sniHostName() {
        return this.sniHostName;
    }

    public Optional<String> tenantPrefix() {
        return Optional.empty();
    }

    public String toString() {
        String tenantPrefixString = this.tenantPrefix().map(prefix -> ", tenantPrefix=" + prefix).orElse("");
        return "RequestContext(header=" + this.header + ", connectionId='" + this.connectionId + '\'' + ", clientAddress=" + this.clientAddress + ", principal=" + this.principal + ", listenerName=" + this.listenerName + ", securityProtocol=" + (Object)((Object)this.securityProtocol) + ", clientInformation=" + this.clientInformation + ", fromPrivilegedListener=" + this.fromPrivilegedListener + ", principalSerde=" + this.principalSerde + tenantPrefixString + ')';
    }
}

