/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.internals.AdminApiFuture;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.CoordinatorStrategy;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class ListConsumerGroupOffsetsHandler
implements AdminApiHandler<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> {
    private final Map<String, List<TopicPartition>> groupIdToTopicPartitions;
    private final Logger log;
    private final AdminApiLookupStrategy<CoordinatorKey> lookupStrategy;

    public ListConsumerGroupOffsetsHandler(String groupId, List<TopicPartition> partitions, LogContext logContext) {
        this(Collections.singletonMap(groupId, partitions), logContext);
    }

    public ListConsumerGroupOffsetsHandler(Map<String, List<TopicPartition>> groupIdToTopicPartitions, LogContext logContext) {
        this.log = logContext.logger(ListConsumerGroupOffsetsHandler.class);
        this.lookupStrategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, logContext);
        this.groupIdToTopicPartitions = groupIdToTopicPartitions;
    }

    public static AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> newFuture(List<String> groupIds) {
        return AdminApiFuture.forKeys(groupIds.stream().map(CoordinatorKey::byGroupId).collect(Collectors.toSet()));
    }

    public static AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> newFuture(String groupId) {
        return AdminApiFuture.forKeys(Collections.singleton(CoordinatorKey.byGroupId(groupId)));
    }

    @Override
    public String apiName() {
        return "offsetFetch";
    }

    @Override
    public AdminApiLookupStrategy<CoordinatorKey> lookupStrategy() {
        return this.lookupStrategy;
    }

    private void validateKeys(Set<CoordinatorKey> groupIds) {
        Set keys = this.groupIdToTopicPartitions.keySet().stream().map(CoordinatorKey::byGroupId).collect(Collectors.toSet());
        if (!keys.containsAll(groupIds)) {
            throw new IllegalArgumentException("Received unexpected group ids " + groupIds + " (expected one of" + keys + ")");
        }
    }

    public OffsetFetchRequest.Builder buildRequest(int coordinatorId, Set<CoordinatorKey> groupIds) {
        this.validateKeys(groupIds);
        HashMap<String, List<TopicPartition>> coordinatorGroupIdToTopicPartitions = new HashMap<String, List<TopicPartition>>(groupIds.size());
        groupIds.forEach(g -> coordinatorGroupIdToTopicPartitions.put(g.idValue, this.groupIdToTopicPartitions.get(g.idValue)));
        return new OffsetFetchRequest.Builder(coordinatorGroupIdToTopicPartitions, false, false);
    }

    @Override
    public AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> handleResponse(Node coordinator, Set<CoordinatorKey> groupIds, AbstractResponse abstractResponse) {
        this.validateKeys(groupIds);
        OffsetFetchResponse response = (OffsetFetchResponse)abstractResponse;
        HashMap completed = new HashMap();
        HashMap<CoordinatorKey, Throwable> failed = new HashMap<CoordinatorKey, Throwable>();
        ArrayList<CoordinatorKey> unmapped = new ArrayList<CoordinatorKey>();
        for (CoordinatorKey coordinatorKey : groupIds) {
            String group = coordinatorKey.idValue;
            if (response.groupHasError(group)) {
                this.handleGroupError(CoordinatorKey.byGroupId(group), response.groupLevelError(group), failed, unmapped);
                continue;
            }
            HashMap<TopicPartition, OffsetAndMetadata> groupOffsetsListing = new HashMap<TopicPartition, OffsetAndMetadata>();
            Map<TopicPartition, OffsetFetchResponse.PartitionData> responseData = response.partitionDataMap(group);
            for (Map.Entry<TopicPartition, OffsetFetchResponse.PartitionData> partitionEntry : responseData.entrySet()) {
                TopicPartition topicPartition = partitionEntry.getKey();
                OffsetFetchResponse.PartitionData partitionData = partitionEntry.getValue();
                Errors error = partitionData.error;
                if (error == Errors.NONE) {
                    long offset = partitionData.offset;
                    String metadata = partitionData.metadata;
                    Optional<Integer> leaderEpoch = partitionData.leaderEpoch;
                    if (offset < 0L) {
                        groupOffsetsListing.put(topicPartition, null);
                        continue;
                    }
                    groupOffsetsListing.put(topicPartition, new OffsetAndMetadata(offset, leaderEpoch, metadata));
                    continue;
                }
                this.log.warn("Skipping return offset for {} due to error {}.", (Object)topicPartition, (Object)error);
            }
            completed.put(CoordinatorKey.byGroupId(group), groupOffsetsListing);
        }
        return new AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>>(completed, failed, unmapped);
    }

    private void handleGroupError(CoordinatorKey groupId, Errors error, Map<CoordinatorKey, Throwable> failed, List<CoordinatorKey> groupsToUnmap) {
        switch (error) {
            case GROUP_AUTHORIZATION_FAILED: {
                this.log.debug("`OffsetFetch` request for group id {} failed due to error {}", (Object)groupId.idValue, (Object)error);
                failed.put(groupId, error.exception());
                break;
            }
            case COORDINATOR_LOAD_IN_PROGRESS: {
                this.log.debug("`OffsetFetch` request for group id {} failed because the coordinator is still in the process of loading state. Will retry", (Object)groupId.idValue);
                break;
            }
            case COORDINATOR_NOT_AVAILABLE: 
            case NOT_COORDINATOR: {
                this.log.debug("`OffsetFetch` request for group id {} returned error {}. Will attempt to find the coordinator again and retry", (Object)groupId.idValue, (Object)error);
                groupsToUnmap.add(groupId);
                break;
            }
            default: {
                this.log.error("`OffsetFetch` request for group id {} failed due to unexpected error {}", (Object)groupId.idValue, (Object)error);
                failed.put(groupId, error.exception());
            }
        }
    }
}

