/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class RemoveBrokersRequestData
implements ApiMessage {
    int timeoutMs;
    List<BrokerId> brokersToRemove;
    boolean shouldShutdown;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("timeout_ms", Type.INT32, "The time in ms to wait for the request to complete."), new Field("brokers_to_remove", new ArrayOf(BrokerId.SCHEMA_0), "Broker IDs to remove."));
    public static final Schema SCHEMA_1 = new Schema(new Field("timeout_ms", Type.INT32, "The time in ms to wait for the request to complete."), new Field("brokers_to_remove", new ArrayOf(BrokerId.SCHEMA_0), "Broker IDs to remove."), new Field("should_shutdown", Type.BOOLEAN, "Whether the removal operation should shut down the removed brokers in the end."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public RemoveBrokersRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public RemoveBrokersRequestData() {
        this.timeoutMs = 60000;
        this.brokersToRemove = new ArrayList<BrokerId>(0);
        this.shouldShutdown = true;
    }

    @Override
    public short apiKey() {
        return 10001;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable _readable, short _version, MessageContext _context) {
        this.timeoutMs = _readable.readInt();
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field brokersToRemove was serialized as null");
        }
        ArrayList<BrokerId> newCollection = new ArrayList<BrokerId>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new BrokerId(_readable, _version, _context));
        }
        this.brokersToRemove = newCollection;
        this.shouldShutdown = _version >= 1 ? _readable.readByte() != 0 : true;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.timeoutMs);
        _writable.writeInt(this.brokersToRemove.size());
        for (BrokerId brokersToRemoveElement : this.brokersToRemove) {
            brokersToRemoveElement.write(_writable, _cache, _version, _context);
        }
        if (_version >= 1) {
            _writable.writeByte(this.shouldShutdown ? (byte)1 : 0);
        } else if (!this.shouldShutdown) {
            throw new UnsupportedVersionException("Attempted to write a non-default shouldShutdown at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(4);
        for (BrokerId brokersToRemoveElement : this.brokersToRemove) {
            brokersToRemoveElement.addSize(_size, _cache, _version, _context);
        }
        if (_version >= 1) {
            _size.addBytes(1);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RemoveBrokersRequestData)) {
            return false;
        }
        RemoveBrokersRequestData other = (RemoveBrokersRequestData)obj;
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        if (this.brokersToRemove == null ? other.brokersToRemove != null : !this.brokersToRemove.equals(other.brokersToRemove)) {
            return false;
        }
        if (this.shouldShutdown != other.shouldShutdown) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + (this.brokersToRemove == null ? 0 : this.brokersToRemove.hashCode());
        hashCode = 31 * hashCode + (this.shouldShutdown ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public RemoveBrokersRequestData duplicate() {
        RemoveBrokersRequestData _duplicate = new RemoveBrokersRequestData();
        _duplicate.timeoutMs = this.timeoutMs;
        ArrayList<BrokerId> newBrokersToRemove = new ArrayList<BrokerId>(this.brokersToRemove.size());
        for (BrokerId _element : this.brokersToRemove) {
            newBrokersToRemove.add(_element.duplicate());
        }
        _duplicate.brokersToRemove = newBrokersToRemove;
        _duplicate.shouldShutdown = this.shouldShutdown;
        return _duplicate;
    }

    public String toString() {
        return "RemoveBrokersRequestData(timeoutMs=" + this.timeoutMs + ", brokersToRemove=" + MessageUtil.deepToString(this.brokersToRemove.iterator()) + ", shouldShutdown=" + (this.shouldShutdown ? "true" : "false") + ")";
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public List<BrokerId> brokersToRemove() {
        return this.brokersToRemove;
    }

    public boolean shouldShutdown() {
        return this.shouldShutdown;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public RemoveBrokersRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public RemoveBrokersRequestData setBrokersToRemove(List<BrokerId> v) {
        this.brokersToRemove = v;
        return this;
    }

    public RemoveBrokersRequestData setShouldShutdown(boolean v) {
        this.shouldShutdown = v;
        return this;
    }

    public static class BrokerId
    implements Message {
        int brokerId;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public BrokerId(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public BrokerId() {
            this.brokerId = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BrokerId");
            }
            this.brokerId = _readable.readInt();
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.brokerId);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of BrokerId");
            }
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BrokerId)) {
                return false;
            }
            BrokerId other = (BrokerId)obj;
            if (this.brokerId != other.brokerId) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.brokerId;
            return hashCode;
        }

        @Override
        public BrokerId duplicate() {
            BrokerId _duplicate = new BrokerId();
            _duplicate.brokerId = this.brokerId;
            return _duplicate;
        }

        public String toString() {
            return "BrokerId(brokerId=" + this.brokerId + ")";
        }

        public int brokerId() {
            return this.brokerId;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public BrokerId setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The Broker ID to remove"));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

