/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.internals;

import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;

public class BalancerConfigs {
    public static final String CONFLUENT_BALANCER_PREFIX = "confluent.balancer.";
    public static final String BALANCER_CLASS_CONFIG = "confluent.balancer.class";
    public static final String BALANCER_CLASS_DOC = "The class providing DataBalancer services for the Kafka controller.";
    public static final String BALANCER_CLASS_DEFAULT = "io.confluent.databalancer.KafkaDataBalanceManager";
    public static final String BALANCER_ENABLE_SBK_CONFIG = "enable";
    public static final String BALANCER_ENABLE_CONFIG = "confluent.balancer.enable";
    public static final boolean BALANCER_ENABLE_DEFAULT = false;
    public static final String BALANCER_ENABLE_DOC = "This config controls whether the balancer is enabled";
    public static final String BALANCER_AUTO_HEAL_MODE_SBK_CONFIG = "heal.uneven.load.trigger";
    public static final String BALANCER_AUTO_HEAL_MODE_CONFIG = "confluent.balancer.heal.uneven.load.trigger";
    public static final String BALANCER_AUTO_HEAL_MODE_DEFAULT = BalancerSelfHealMode.EMPTY_BROKER.toString();
    public static final String BALANCER_AUTO_HEAL_MODE_DOC = "Controls what causes the Confluent DataBalancer to start rebalance operations. Acceptable values are " + BalancerSelfHealMode.ANY_UNEVEN_LOAD.toString() + " and " + BalancerSelfHealMode.EMPTY_BROKER.toString();
    public static final String BALANCER_BROKER_FAILURE_THRESHOLD_SBK_CONFIG = "heal.broker.failure.threshold.ms";
    public static final String BALANCER_BROKER_FAILURE_THRESHOLD_CONFIG = "confluent.balancer.heal.broker.failure.threshold.ms";
    public static final Long BALANCER_BROKER_FAILURE_THRESHOLD_DEFAULT = Duration.ofHours(1L).toMillis();
    public static final Long BALANCER_BROKER_FAILURE_THRESHOLD_DISABLED = -1L;
    public static final String BALANCER_BROKER_FAILURE_THRESHOLD_DOC = "This config specifies how long the balancer will wait after detecting a broker failure before triggering a balancing action. -1 means that broker failures will not trigger balancing actions";
    public static final String BALANCER_THROTTLE_SBK_CONFIG = "throttle.bytes.per.second";
    public static final String BALANCER_THROTTLE_CONFIG = "confluent.balancer.throttle.bytes.per.second";
    public static final Long BALANCER_THROTTLE_NO_THROTTLE = -1L;
    public static final Long BALANCER_THROTTLE_AUTO_THROTTLE;
    public static final Long BALANCER_THROTTLE_MIN;
    public static final Long BALANCER_THROTTLE_DEFAULT;
    public static final String BALANCER_THROTTLE_DOC = "This config specifies the upper bound for bandwidth in bytes to move replicas around for replica reassignment. A value of -1 disables throttling entirely.";
    public static final String BALANCER_REPLICA_CAPACITY_SBK_CONFIG = "max.replicas";
    public static final String BALANCER_REPLICA_CAPACITY_CONFIG = "confluent.balancer.max.replicas";
    public static final Long BALANCER_REPLICA_CAPACITY_DEFAULT;
    public static final String BALANCER_REPLICA_CAPACITY_DOC = "The replica capacity is the maximum number of replicas the balancer will place on a single broker.";
    public static final String BALANCER_DISK_CAPACITY_THRESHOLD_SBK_CONFIG = "disk.max.load";
    public static final String BALANCER_DISK_CAPACITY_THRESHOLD_CONFIG = "confluent.balancer.disk.max.load";
    public static final Double BALANCER_DISK_CAPACITY_THRESHOLD_DEFAULT;
    public static final String BALANCER_DISK_CAPACITY_THRESHOLD_DOC = "This config specifies the maximum load for disk usage as a proportion of disk capacity. Valid values are between 0 and 1.";
    public static final String BALANCER_NETWORK_IN_CAPACITY_SBK_CONFIG = "network.in.max.bytes.per.second";
    public static final String BALANCER_NETWORK_IN_CAPACITY_CONFIG = "confluent.balancer.network.in.max.bytes.per.second";
    public static final Long BALANCER_NETWORK_IN_CAPACITY_DEFAULT;
    public static final Long BALANCER_NETWORK_IN_CAPACITY_MIN;
    public static final String BALANCER_NETWORK_IN_CAPACITY_DOC = "This config specifies the upper capacity limit for network incoming bytes per second per broker. The Confluent DataBalancer will attempt to keep incoming data throughput below this limit.";
    public static final String BALANCER_NETWORK_OUT_CAPACITY_SBK_CONFIG = "network.out.max.bytes.per.second";
    public static final String BALANCER_NETWORK_OUT_CAPACITY_CONFIG = "confluent.balancer.network.out.max.bytes.per.second";
    public static final Long BALANCER_NETWORK_OUT_CAPACITY_DEFAULT;
    public static final Long BALANCER_NETWORK_OUT_CAPACITY_MIN;
    public static final String BALANCER_NETWORK_OUT_CAPACITY_DOC = "This config specifies the upper capacity limit for network outgoing bytes per second per broker. The Confluent DataBalancer will attempt to keep outgoing data throughput below this limit.";
    public static final String BALANCER_EXCLUDE_TOPIC_NAMES_SBK_CONFIG = "exclude.topic.names";
    public static final String BALANCER_EXCLUDE_TOPIC_NAMES_CONFIG = "confluent.balancer.exclude.topic.names";
    public static final List BALANCER_EXCLUDE_TOPIC_NAMES_DEFAULT;
    public static final String BALANCER_EXCLUDE_TOPIC_NAMES_DOC = "This config accepts a list of topic names that will be excluded from rebalancing. For example, 'confluent.balancer.exclude.topic.names=[topic1, topic2]' ";
    public static final String BALANCER_EXCLUDE_TOPIC_PREFIXES_BASE_CONFIG = "exclude.topic.prefixes";
    public static final String BALANCER_EXCLUDE_TOPIC_PREFIXES_CONFIG = "confluent.balancer.exclude.topic.prefixes";
    public static final List BALANCER_EXCLUDE_TOPIC_PREFIXES_DEFAULT;
    public static final String BALANCER_EXCLUDE_TOPIC_PREFIXES_DOC = "This config accepts a list of topic prefixes that will be excluded from rebalancing. For example, 'confluent.balancer.exclude.topic.prefixes=[prefix1, prefix2]' would exclude topics 'prefix1-suffix1', 'prefix1-suffix2', 'prefix2-suffix3', but not 'abc-prefix1-xyz' and 'def-prefix2'";
    private static final String BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_MAX_RETRY_MS_SBK_CONFIG = "api.state.persistence.store.startup.max.retry.ms";
    public static final String BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_MAX_RETRY_MS_CONFIG = "confluent.balancer.api.state.persistence.store.startup.max.retry.ms";
    public static final Long BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_MAX_RETRY_MS_DEFAULT;
    public static final String BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_MAX_RETRY_MS_DOC = "The maximum amount of time, in milliseconds, to retry up to when the Confluent DataBalancer's Api State Persistence Store component fails starting up.";
    private static final String BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_RETRY_WAIT_MS_SBK_CONFIG = "api.state.persistence.store.startup.retry.wait.ms";
    public static final String BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_RETRY_WAIT_MS_CONFIG = "confluent.balancer.api.state.persistence.store.startup.retry.wait.ms";
    public static final Long BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_RETRY_WAIT_MS_DEFAULT;
    public static final String BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_RETRY_WAIT_MS_DOC = "The delay, in milliseconds, to wait for in between retries of the Confluent DataBalancer's Api State Persistence Store component startup.";
    public static final String BALANCER_API_STATE_TOPIC_SBK_CONFIG = "api.state.topic";
    public static final String BALANCER_API_STATE_TOPIC_CONFIG = "confluent.balancer.api.state.topic";
    public static final String BALANCER_API_STATE_TOPIC_DEFAULT = "_confluent_balancer_api_state";
    public static final String BALANCER_API_STATE_TOPIC_DOC = "Name of topic to use to store state of Confluent DataBalancer API. The topic will be used to store progress/failure of the api and will be used in case of recovery to resume long running operations like remove or add broker.";
    public static final String BALANCER_TOPICS_REPLICATION_FACTOR_SBK_CONFIG = "topic.replication.factor";
    public static final String BALANCER_TOPICS_REPLICATION_FACTOR_CONFIG = "confluent.balancer.topic.replication.factor";
    public static final Short BALANCER_TOPICS_REPLICATION_FACTOR_DEFAULT;
    public static final String BALANCER_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor for all topics that are created and needed by the Confluent DataBalancer. This includes Sample Store and API state topics.";
    public static final String BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_SBK_CONFIG = "task.history.retention.days";
    public static final String BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_CONFIG = "confluent.balancer.task.history.retention.days";
    public static final Integer BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DEFAULT;
    public static final String BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DOC = "Number of days for which self balancing cluster's task history will be retained.";

    public static ConfigDef defineConfigs(ConfigDef config) {
        config.defineInternal(BALANCER_CLASS_CONFIG, ConfigDef.Type.STRING, BALANCER_CLASS_DEFAULT, ConfigDef.Importance.LOW, BALANCER_CLASS_DOC).define(BALANCER_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.HIGH, BALANCER_ENABLE_DOC).define(BALANCER_AUTO_HEAL_MODE_CONFIG, ConfigDef.Type.STRING, BALANCER_AUTO_HEAL_MODE_DEFAULT, ConfigDef.ValidString.in(BalancerSelfHealMode.ANY_UNEVEN_LOAD.toString(), BalancerSelfHealMode.EMPTY_BROKER.toString()), ConfigDef.Importance.HIGH, BALANCER_AUTO_HEAL_MODE_DOC).define(BALANCER_THROTTLE_CONFIG, ConfigDef.Type.LONG, BALANCER_THROTTLE_DEFAULT, ConfigDef.Range.atLeast(BALANCER_THROTTLE_MIN), ConfigDef.Importance.HIGH, BALANCER_THROTTLE_DOC).define(BALANCER_REPLICA_CAPACITY_CONFIG, ConfigDef.Type.LONG, BALANCER_REPLICA_CAPACITY_DEFAULT, ConfigDef.Range.atLeast(0), ConfigDef.Importance.HIGH, BALANCER_REPLICA_CAPACITY_DOC).define(BALANCER_DISK_CAPACITY_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, BALANCER_DISK_CAPACITY_THRESHOLD_DEFAULT, ConfigDef.Range.between(0.0, 1.0), ConfigDef.Importance.HIGH, BALANCER_DISK_CAPACITY_THRESHOLD_DOC).define(BALANCER_NETWORK_IN_CAPACITY_CONFIG, ConfigDef.Type.LONG, BALANCER_NETWORK_IN_CAPACITY_DEFAULT, ConfigDef.Range.atLeast(BALANCER_NETWORK_IN_CAPACITY_MIN), ConfigDef.Importance.HIGH, BALANCER_NETWORK_IN_CAPACITY_DOC).define(BALANCER_NETWORK_OUT_CAPACITY_CONFIG, ConfigDef.Type.LONG, BALANCER_NETWORK_OUT_CAPACITY_DEFAULT, ConfigDef.Range.atLeast(BALANCER_NETWORK_OUT_CAPACITY_MIN), ConfigDef.Importance.HIGH, BALANCER_NETWORK_OUT_CAPACITY_DOC).define(BALANCER_BROKER_FAILURE_THRESHOLD_CONFIG, ConfigDef.Type.LONG, BALANCER_BROKER_FAILURE_THRESHOLD_DEFAULT, ConfigDef.Range.atLeast(-1), ConfigDef.Importance.HIGH, BALANCER_BROKER_FAILURE_THRESHOLD_DOC).define(BALANCER_EXCLUDE_TOPIC_NAMES_CONFIG, ConfigDef.Type.LIST, BALANCER_EXCLUDE_TOPIC_NAMES_DEFAULT, ConfigDef.Importance.MEDIUM, BALANCER_EXCLUDE_TOPIC_NAMES_DOC).define(BALANCER_EXCLUDE_TOPIC_PREFIXES_CONFIG, ConfigDef.Type.LIST, BALANCER_EXCLUDE_TOPIC_PREFIXES_DEFAULT, ConfigDef.Importance.MEDIUM, BALANCER_EXCLUDE_TOPIC_PREFIXES_DOC).defineInternal(BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_MAX_RETRY_MS_CONFIG, ConfigDef.Type.LONG, BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_MAX_RETRY_MS_DEFAULT, ConfigDef.Importance.LOW, BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_MAX_RETRY_MS_DOC).defineInternal(BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_RETRY_WAIT_MS_CONFIG, ConfigDef.Type.LONG, BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_RETRY_WAIT_MS_DEFAULT, ConfigDef.Importance.LOW, BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_RETRY_WAIT_MS_DOC).defineInternal(BALANCER_API_STATE_TOPIC_CONFIG, ConfigDef.Type.STRING, BALANCER_API_STATE_TOPIC_DEFAULT, ConfigDef.Importance.LOW, BALANCER_API_STATE_TOPIC_DOC).defineInternal(BALANCER_TOPICS_REPLICATION_FACTOR_CONFIG, ConfigDef.Type.SHORT, BALANCER_TOPICS_REPLICATION_FACTOR_DEFAULT, ConfigDef.Importance.LOW, BALANCER_TOPIC_REPLICATION_FACTOR_DOC).defineInternal(BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_CONFIG, ConfigDef.Type.INT, BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DEFAULT, ConfigDef.Importance.LOW, BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DOC);
        return config;
    }

    public static Set<String> reconfigurableConfigs() {
        HashSet<String> configs = new HashSet<String>();
        configs.add(BALANCER_ENABLE_CONFIG);
        configs.add(BALANCER_AUTO_HEAL_MODE_CONFIG);
        configs.add(BALANCER_THROTTLE_CONFIG);
        configs.add(BALANCER_EXCLUDE_TOPIC_NAMES_CONFIG);
        configs.add(BALANCER_EXCLUDE_TOPIC_PREFIXES_CONFIG);
        return configs;
    }

    static {
        BALANCER_THROTTLE_MIN = BALANCER_THROTTLE_AUTO_THROTTLE = Long.valueOf(-2L);
        BALANCER_THROTTLE_DEFAULT = 0xA00000L;
        BALANCER_REPLICA_CAPACITY_DEFAULT = Integer.MAX_VALUE;
        BALANCER_DISK_CAPACITY_THRESHOLD_DEFAULT = 0.85;
        BALANCER_NETWORK_IN_CAPACITY_DEFAULT = Long.MAX_VALUE;
        BALANCER_NETWORK_IN_CAPACITY_MIN = 1L;
        BALANCER_NETWORK_OUT_CAPACITY_DEFAULT = Long.MAX_VALUE;
        BALANCER_NETWORK_OUT_CAPACITY_MIN = 1L;
        BALANCER_EXCLUDE_TOPIC_NAMES_DEFAULT = Collections.EMPTY_LIST;
        BALANCER_EXCLUDE_TOPIC_PREFIXES_DEFAULT = Collections.EMPTY_LIST;
        BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_MAX_RETRY_MS_DEFAULT = 300000L;
        BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_RETRY_WAIT_MS_DEFAULT = 100L;
        BALANCER_TOPICS_REPLICATION_FACTOR_DEFAULT = 3;
        BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DEFAULT = 30;
    }

    public static enum BalancerSelfHealMode {
        EMPTY_BROKER,
        ANY_UNEVEN_LOAD;

    }
}

