/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.internals;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.BalancerConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.requests.SamplingRequestLogFilter;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.fips.FipsValidator;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.apache.kafka.server.interceptor.DefaultBrokerInterceptor;
import org.apache.kafka.server.license.LicenseValidator;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.apache.kafka.server.multitenant.MultiTenantSecretsStore;

public class ConfluentConfigs {
    public static final String CONFLUENT_PREFIX = "confluent.";
    public static final String BROKER_INTERCEPTOR_CLASS_CONFIG = "broker.interceptor.class";
    public static final Class<?> BROKER_INTERCEPTOR_CLASS_DEFAULT = DefaultBrokerInterceptor.class;
    public static final String MULTITENANT_AUTHORIZER_CLASS_NAME = "io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer";
    public static final String MULTITENANT_METADATA_CLASS_CONFIG = "multitenant.metadata.class";
    public static final String MULTITENANT_METADATA_CLASS_DEFAULT = null;
    public static final String MULTITENANT_METADATA_DIR_CONFIG = "multitenant.metadata.dir";
    public static final String MULTITENANT_METADATA_DIR_DEFAULT = null;
    public static final String MULTITENANT_METADATA_SSL_CERTS_SPEC_CONFIG = "multitenant.metadata.ssl.certs.path";
    public static final String MULTITENANT_METADATA_SSL_CERTS_SPEC_DEFAULT = null;
    public static final String MULTITENANT_METADATA_RELOAD_DELAY_MS_CONFIG = "multitenant.metadata.reload.delay.ms";
    public static final Long MULTITENANT_METADATA_RELOAD_DELAY_MS_DEFAULT = TimeUnit.MINUTES.toMillis(2L);
    public static final String MULTITENANT_METADATA_RELOAD_DELAY_MS_DOC = "Interval (in ms) between full reloads of logical cluster metadata. Defaults to 2 minutes.";
    public static final String MULTITENANT_TENANT_DELETE_DELAY_MS_CONFIG = "multitenant.tenant.delete.delay";
    public static final Long MULTITENANT_TENANT_DELETE_DELAY_MS_DEFAULT = TimeUnit.DAYS.toMillis(7L);
    public static final String MULTITENANT_TENANT_DELETE_DELAY_MS_DOC = "Delay between the time the tenant is marked as deactivated in JSON file, until we actually start deleting topics. This defaults to 7 days to allow plenty of times for operators and users to regret their decisions and do something about it";
    public static final String MULTITENANT_TENANT_DELETE_BATCH_SIZE_CONFIG = "multitenant.tenant.delete.batch.size";
    public static final Integer MULTITENANT_TENANT_DELETE_BATCH_SIZE_DEFAULT = 10;
    public static final String MULTITENANT_TENANT_DELETE_BATCH_SIZE_DOC = "Batch size for topic deletion of deactivated tenants. We wait for each batch to complete before sending another";
    public static final String MULTITENANT_SCHEMA_VALIDATION_ENABLED_CONFIG = "confluent.schema.validator.multitenant.enable";
    public static final String MULTITENANT_SCHEMA_VALIDATION_ENABLED_DOC = "Controls enablement of the schema validation plugin in the cloud";
    public static final boolean MULTITENANT_SCHEMA_VALIDATION_ENABLED_DEFAULT = false;
    public static final String MULTITENANT_INTERCEPTOR_BALANCER_APIS_ENABLED_CONFIG = "confluent.multitenant.interceptor.balancer.apis.enabled";
    public static final String MULTITENANT_INTERCEPTOR_BALANCER_APIS_ENABLED_DOC = "Denotes whether the multi-tenant interceptor will enable requests for the Self-Balancing Clusters (SBC) APIs.";
    public static final boolean MULTITENANT_INTERCEPTOR_BALANCER_APIS_ENABLED_DEFAULT = false;
    public static final String MULTITENANT_OAUTH_SUPERUSER_DISABLE = "multitenant.oauth.superuser.disable";
    public static final boolean MULTITENANT_OAUTH_SUPERUSER_DISABLE_DEFAULT = false;
    public static final String ENABLE_DATAPLANE_RBAC_FOR_PKC = "confluent.metadata.kafka.enable.dataplane.rbac";
    public static final boolean ENABLE_DATAPLANE_RBAC_FOR_PKC_DEFAULT = false;
    private static final String SCHEMA_REGISTRY_URL = "schema.registry.url";
    public static final String SCHEMA_REGISTRY_URL_CONFIG = "confluent.schema.registry.url";
    public static final String SCHEMA_REGISTRY_URL_DOC = "Comma-separated list of URLs for schema registry instances that can be used to look up schemas.";
    public static final String SCHEMA_VALIDATION_INTERCEPTOR_CLASS_CONFIG = "confluent.schema.validator.interceptor.class";
    public static final String SCHEMA_VALIDATION_INTERCEPTOR_CLASS_DOC = "Interceptor class used during schema validation";
    public static final String SCHEMA_VALIDATION_INTERCEPTOR_CLASS_DEFAULT = "io.confluent.kafka.schemaregistry.validator.RecordSchemaValidator";
    public static final String SCHEMA_VALIDATION_SAMPLES_PER_MIN_CONFIG = "confluent.schema.validator.samples.per.min";
    public static final String SCHEMA_VALIDATION_SAMPLES_PER_MIN_DOC = "Number of error samples that will be printed per minute during schema validation";
    public static final Integer SCHEMA_VALIDATION_SAMPLES_PER_MIN_DEFAULT = 0;
    public static final String MAX_CACHE_SIZE_CONFIG = "confluent.schema.registry.max.cache.size";
    public static final String MAX_CACHE_SIZE_DOC = "Maximum size of each LRU cache used to cache responses from the schema registry. There is one cache to hold the ID to schema mappings and another to hold the schemas that are registered to a subject.";
    public static final int MAX_CACHE_SIZE_DEFAULT = 10000;
    public static final String MAX_RETRIES_CONFIG = "confluent.schema.registry.max.retries";
    public static final String MAX_RETRIES_DOC = "Maximum number of times to retry schema registry read operations.";
    public static final int MAX_RETRIES_DEFAULT = 1;
    public static final String RETRIES_WAIT_MS_CONFIG = "confluent.schema.registry.retries.wait.ms";
    public static final String RETRIES_WAIT_MS_DOC = "Time in milliseconds to wait before each retry.";
    public static final int RETRIES_WAIT_MS_DEFAULT = 0;
    public static final String MISSING_ID_QUERY_RANGE_CONFIG = "confluent.missing.id.query.range";
    public static final String MISSING_ID_QUERY_RANGE_DOC = "The range above max schema ID to make calls to Schema Registry";
    public static final int MISSING_ID_QUERY_RANGE_DEFAULT = 200;
    public static final String MISSING_ID_CACHE_TTL_CONFIG = "confluent.missing.id.cache.ttl.sec";
    public static final String MISSING_ID_CACHE_TTL_DOC = "The TTL in seconds for caching missing schema IDs";
    public static final long MISSING_ID_CACHE_TTL_DEFAULT = 60L;
    public static final String MISSING_SCHEMA_CACHE_TTL_CONFIG = "confluent.missing.schema.cache.ttl.sec";
    public static final String MISSING_SCHEMA_CACHE_TTL_DOC = "The TTL in seconds for caching missing schemas";
    public static final long MISSING_SCHEMA_CACHE_TTL_DEFAULT = 60L;
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_CONFIG = "confluent.basic.auth.credentials.source";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DEFAULT = null;
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DOC = "Specify how to pick the credentials for Basic Auth header. The supported values are URL, USER_INFO and SASL_INHERIT";
    public static final String USER_INFO_CONFIG = "confluent.basic.auth.user.info";
    public static final String USER_INFO_DEFAULT = null;
    public static final String USER_INFO_DOC = "Specify the user info for Basic Auth in the form of {username}:{password}";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_CONFIG = "confluent.bearer.auth.credentials.source";
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_DEFAULT = null;
    public static final String BEARER_AUTH_CREDENTIALS_SOURCE_DOC = "Specify how to pick the credentials for Bearer Auth header. ";
    public static final String BEARER_AUTH_TOKEN_CONFIG = "confluent.bearer.auth.token";
    public static final String BEARER_AUTH_TOKEN_DEFAULT = null;
    public static final String BEARER_AUTH_TOKEN_DOC = "Specify the Bearer token to be used for authentication";
    public static final String SSL_PROTOCOL_CONFIG = "confluent.ssl.protocol";
    public static final String SSL_PROTOCOL_DOC = "The SSL protocol used to generate the SSLContext. Default setting is TLSv1.2, which is fine for most cases. Allowed values in recent JVMs are TLSv1.2 and TLSv1.3. TLS, TLSv1.1, SSL, SSLv2 and SSLv3 may be supported in older JVMs, but their usage is discouraged due to known security vulnerabilities.";
    public static final String SSL_KEYSTORE_TYPE_CONFIG = "confluent.ssl.keystore.type";
    public static final String SSL_KEYSTORE_TYPE_DOC = "The file format of the key store file. This is optional for client.";
    public static final String SSL_KEYSTORE_LOCATION_CONFIG = "confluent.ssl.keystore.location";
    public static final String SSL_KEYSTORE_LOCATION_DOC = "The location of the key store file. This is optional for client and can be used for two-way authentication for client.";
    public static final String SSL_KEYSTORE_PASSWORD_CONFIG = "confluent.ssl.keystore.password";
    public static final String SSL_KEYSTORE_PASSWORD_DOC = "The store password for the key store file. This is optional for client and only needed if ssl.keystore.location is configured. ";
    public static final String SSL_KEY_PASSWORD_CONFIG = "confluent.ssl.key.password";
    public static final String SSL_KEY_PASSWORD_DOC = "The password of the private key in the key store file. This is optional for client.";
    public static final String SSL_TRUSTSTORE_TYPE_CONFIG = "confluent.ssl.truststore.type";
    public static final String SSL_TRUSTSTORE_TYPE_DOC = "The file format of the trust store file.";
    public static final String SSL_TRUSTSTORE_LOCATION_CONFIG = "confluent.ssl.truststore.location";
    public static final String SSL_TRUSTSTORE_LOCATION_DOC = "The location of the trust store file. ";
    public static final String SSL_TRUSTSTORE_PASSWORD_CONFIG = "confluent.ssl.truststore.password";
    public static final String SSL_TRUSTSTORE_PASSWORD_DOC = "The password for the trust store file. If a password is not set access to the truststore is still available, but integrity checking is disabled.";
    public static final String TENANT_QUOTA_CALLBACK_CLASS = "io.confluent.kafka.multitenant.quota.TenantQuotaCallback";
    public static final String BACKPRESSURE_TYPES_CONFIG = "confluent.backpressure.types";
    public static final String BACKPRESSURE_TYPES_DEFAULT = null;
    public static final String BACKPRESSURE_TYPES_DOC = "Comma separated list of resource types for which broker back-pressure is enabled. Backpressure is not enabled by default. Accepted values: 'request', 'produce', 'fetch'.Invalid values are ignored. This config is ignored if client.quota.callback.class is not set, or set to class other than TenantQuotaCallback. In other words, broker back-pressure can be enabled for multi-tenant clusters only.";
    public static final String BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_CONFIG = "confluent.backpressure.request.min.broker.limit";
    public static final Long BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT = 200L;
    public static final String BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DOC = "The minimum broker request quota, i.e., request backpressure would not reduce the broker request quota any further even if the request overload is still detected. Broker-wide request quota, if not unlimited, caps the combined dynamic request quotas of currently active tenants. All values are accepted, but values below 10 will result in the minimum limit of 10.";
    public static final String BACKPRESSURE_REQUEST_QUEUE_SIZE_PERCENTILE_CONFIG = "confluent.backpressure.request.queue.size.percentile";
    public static final String BACKPRESSURE_REQUEST_QUEUE_SIZE_PERCENTILE_DEFAULT = "p95";
    public static final String BACKPRESSURE_REQUEST_QUEUE_SIZE_PERCENTILE_DOC = "Queue size percentile used by request backpressure. For example, p95 means that when the number of requests in the request queue exceeds 80% of `queued.max.requests` in more than 5% of cases, the backpressure mechanism starts reducing the total broker request quota. Accepted values: `p90`, `p95`, `p98`, `p99`. Setting an invalid value will default to `p95`.";
    public static final String BACKPRESSURE_PRODUCE_THROUGHPUT_CONFIG = "confluent.backpressure.disk.produce.bytes.per.second";
    public static final long BACKPRESSURE_PRODUCE_THROUGHPUT_DEFAULT = 131072L;
    public static final String BACKPRESSURE_PRODUCE_THROUGHPUT_DOC = "The cumulative bandwidth (in Bytes/s) available to all the producers in the broker";
    public static final String BACKPRESSURE_DISK_ENABLE_CONFIG = "confluent.backpressure.disk.enable";
    public static final boolean BACKPRESSURE_DISK_ENABLE_DEFAULT = false;
    public static final String BACKPRESSURE_DISK_ENABLE_DOC = "This flag will be used to turn on the disk based backpressure";
    public static final String BACKPRESSURE_DISK_THRESHOLD_BYTES_CONFIG = "confluent.backpressure.disk.free.threshold.bytes";
    public static final long BACKPRESSURE_DISK_THRESHOLD_BYTES_DEFAULT = 0x500000000L;
    public static final String BACKPRESSURE_DISK_THRESHOLD_BYTES_DOC = "The disk space available (in bytes) considered as the minimum across all the log dirs, below which the broker will limit aggregate produce bandwidth from all clients to the bandwidth specified in confluent.backpressure.disk.produce.bytes.per.second";
    public static final String BACKPRESSURE_DISK_RECOVERY_FACTOR_CONFIG = "confluent.backpressure.disk.threshold.recovery.factor";
    public static final double BACKPRESSURE_DISK_RECOVERY_FACTOR_DEFAULT = 1.5;
    public static final String BACKPRESSURE_DISK_RECOVERY_FACTOR_DOC = "The multiplier for the free disk threshold (specified via confluent.backpressure.disk.free.threshold.bytes) above which the throttling would be deactivated";
    public static final String BROKER_LIMIT_PRODUCER_CONFIG = "confluent.broker.limit.producer.bytes.per.second";
    public static final Long BROKER_LIMIT_PRODUCER_DEFAULT = Long.MAX_VALUE;
    public static final String BROKER_LIMIT_PRODUCER_DOC = "Broker-wide produce bandwidth limit in bytes per second. Broker will throttle produce requests to ensure that the cumulative bandwidth does not exceed this limit. Default setting is no limit.";
    public static final String BROKER_LIMIT_CONSUMER_CONFIG = "confluent.broker.limit.consumer.bytes.per.second";
    public static final Long BROKER_LIMIT_CONSUMER_DEFAULT = Long.MAX_VALUE;
    public static final String BROKER_LIMIT_CONSUMER_DOC = "Broker-wide consumer bandwidth limit in bytes per second. Broker will throttle fetch requests to ensure that the cumulative bandwidth does not exceed this limit. Default setting is no limit.";
    public static final String TENANT_PRODUCE_QUOTA_MULTIPLIER_CONFIG = "confluent.quota.tenant.produce.multiplier";
    public static final Double TENANT_PRODUCE_QUOTA_MULTIPLIER_DEFAULT = 1.0;
    public static final String TENANT_PRODUCE_QUOTA_MULTIPLIER_DOC = "Broker-wide produce bandwidth limit multiplier for tenant quotas.";
    public static final String TENANT_FETCH_QUOTA_MULTIPLIER_CONFIG = "confluent.quota.tenant.fetch.multiplier";
    public static final Double TENANT_FETCH_QUOTA_MULTIPLIER_DEFAULT = 1.0;
    public static final String TENANT_FETCH_QUOTA_MULTIPLIER_DOC = "Broker-wide fetch bandwidth limit multiplier for tenant quotas.";
    public static final String QUOTA_DYNAMIC_REPORTING_ENABLE_CONFIG = "confluent.quota.dynamic.reporting.enable";
    public static final boolean QUOTA_DYNAMIC_REPORTING_ENABLE_DEFAULT = false;
    public static final String QUOTA_DYNAMIC_REPORTING_ENABLE_DOC = "Enable quota consumption reporting.";
    public static final String QUOTA_DYNAMIC_REPORTING_INTERVAL_MS_CONFIG = "confluent.quota.dynamic.reporting.interval.ms";
    public static final Long QUOTA_DYNAMIC_REPORTING_INTERVAL_MS_DEFAULT = Duration.ofSeconds(30L).toMillis();
    public static final String QUOTA_DYNAMIC_REPORTING_INTERVAL_MS_DOC = "Broker-wide quota consumption reporting interval, in milli seconds.";
    public static final String CONNECTION_CREATION_RATE_FLOOR_CONFIG = "floor.max.connection.creation.rate";
    public static final String CONNECTION_CREATION_RATE_FLOOR_DOC = "The minimum rate that self-tuned connection creation rate quota will reduce to. This property can only be configured at a per-listener level. If unconfigured, connection rate auto-tuning will be disabled.";
    public static final String AUTO_ENABLE_TELEMETRY_REPORTER_CONFIG = "confluent.reporters.telemetry.auto.enable";
    public static final String AUTO_ENABLE_TELEMETRY_REPORTER_DOC = "Auto-enable telemetry on the broker. This will add the telemetry reporter to the broker's 'metric.reporters' property if it is not already present. Disabling this property will prevent Self-balancing Clusters from working properly.";
    public static final boolean AUTO_ENABLE_TELEMETRY_REPORTER_DEFAULT = true;
    public static final String TELEMETRY_ENABLED_CONFIG = "confluent.telemetry.enabled";
    public static final String TELEMETRY_ENABLED_DOC = "True if telemetry data can to be reported to Confluent Cloud";
    public static final boolean TELEMETRY_ENABLED_DEFAULT = false;
    public static final String CONFLUENT_BALANCER_PREFIX = "confluent.balancer.";
    public static final String BALANCER_CLASS_CONFIG = "confluent.balancer.class";
    public static final String BALANCER_CLASS_DOC = "The class providing DataBalancer services for the Kafka controller.";
    public static final String BALANCER_CLASS_DEFAULT = "io.confluent.databalancer.KafkaDataBalanceManager";
    public static final String BALANCER_ENABLE_SBK_CONFIG = "enable";
    public static final String BALANCER_ENABLE_CONFIG = "confluent.balancer.enable";
    public static final boolean BALANCER_ENABLE_DEFAULT = false;
    public static final String BALANCER_ENABLE_DOC = "This config controls whether the balancer is enabled";
    public static final String BALANCER_AUTO_HEAL_MODE_SBK_CONFIG = "heal.uneven.load.trigger";
    public static final String BALANCER_AUTO_HEAL_MODE_CONFIG = "confluent.balancer.heal.uneven.load.trigger";
    public static final String BALANCER_AUTO_HEAL_MODE_DEFAULT = BalancerConfigs.BALANCER_AUTO_HEAL_MODE_DEFAULT;
    public static final String BALANCER_AUTO_HEAL_MODE_DOC = BalancerConfigs.BALANCER_AUTO_HEAL_MODE_DOC;
    public static final String BALANCER_BROKER_FAILURE_THRESHOLD_SBK_CONFIG = "heal.broker.failure.threshold.ms";
    public static final String BALANCER_BROKER_FAILURE_THRESHOLD_CONFIG = "confluent.balancer.heal.broker.failure.threshold.ms";
    public static final Long BALANCER_BROKER_FAILURE_THRESHOLD_DEFAULT = BalancerConfigs.BALANCER_BROKER_FAILURE_THRESHOLD_DEFAULT;
    public static final Long BALANCER_BROKER_FAILURE_THRESHOLD_DISABLED = BalancerConfigs.BALANCER_BROKER_FAILURE_THRESHOLD_DISABLED;
    public static final String BALANCER_BROKER_FAILURE_THRESHOLD_DOC = "This config specifies how long the balancer will wait after detecting a broker failure before triggering a balancing action. -1 means that broker failures will not trigger balancing actions";
    public static final String BALANCER_THROTTLE_SBK_CONFIG = "throttle.bytes.per.second";
    public static final String BALANCER_THROTTLE_CONFIG = "confluent.balancer.throttle.bytes.per.second";
    public static final Long BALANCER_THROTTLE_NO_THROTTLE = BalancerConfigs.BALANCER_THROTTLE_NO_THROTTLE;
    public static final Long BALANCER_THROTTLE_AUTO_THROTTLE = BalancerConfigs.BALANCER_THROTTLE_AUTO_THROTTLE;
    public static final Long BALANCER_THROTTLE_MIN = BalancerConfigs.BALANCER_THROTTLE_MIN;
    public static final Long BALANCER_THROTTLE_DEFAULT = BalancerConfigs.BALANCER_THROTTLE_DEFAULT;
    public static final String BALANCER_THROTTLE_DOC = "This config specifies the upper bound for bandwidth in bytes to move replicas around for replica reassignment. A value of -1 disables throttling entirely.";
    public static final String BALANCER_REPLICA_CAPACITY_SBK_CONFIG = "max.replicas";
    public static final String BALANCER_REPLICA_CAPACITY_CONFIG = "confluent.balancer.max.replicas";
    public static final Long BALANCER_REPLICA_CAPACITY_DEFAULT = BalancerConfigs.BALANCER_REPLICA_CAPACITY_DEFAULT;
    public static final String BALANCER_REPLICA_CAPACITY_DOC = "The replica capacity is the maximum number of replicas the balancer will place on a single broker.";
    public static final String BALANCER_DISK_CAPACITY_THRESHOLD_SBK_CONFIG = "disk.max.load";
    public static final String BALANCER_DISK_CAPACITY_THRESHOLD_CONFIG = "confluent.balancer.disk.max.load";
    public static final Double BALANCER_DISK_CAPACITY_THRESHOLD_DEFAULT = BalancerConfigs.BALANCER_DISK_CAPACITY_THRESHOLD_DEFAULT;
    public static final String BALANCER_DISK_CAPACITY_THRESHOLD_DOC = "This config specifies the maximum load for disk usage as a proportion of disk capacity. Valid values are between 0 and 1.";
    public static final String BALANCER_NETWORK_IN_CAPACITY_SBK_CONFIG = "network.in.max.bytes.per.second";
    public static final String BALANCER_NETWORK_IN_CAPACITY_CONFIG = "confluent.balancer.network.in.max.bytes.per.second";
    public static final Long BALANCER_NETWORK_IN_CAPACITY_DEFAULT = BalancerConfigs.BALANCER_NETWORK_IN_CAPACITY_DEFAULT;
    public static final Long BALANCER_NETWORK_IN_CAPACITY_MIN = BalancerConfigs.BALANCER_NETWORK_IN_CAPACITY_MIN;
    public static final String BALANCER_NETWORK_IN_CAPACITY_DOC = "This config specifies the upper capacity limit for network incoming bytes per second per broker. The Confluent DataBalancer will attempt to keep incoming data throughput below this limit.";
    public static final String BALANCER_NETWORK_OUT_CAPACITY_SBK_CONFIG = "network.out.max.bytes.per.second";
    public static final String BALANCER_NETWORK_OUT_CAPACITY_CONFIG = "confluent.balancer.network.out.max.bytes.per.second";
    public static final Long BALANCER_NETWORK_OUT_CAPACITY_DEFAULT = BalancerConfigs.BALANCER_NETWORK_OUT_CAPACITY_DEFAULT;
    public static final Long BALANCER_NETWORK_OUT_CAPACITY_MIN = BalancerConfigs.BALANCER_NETWORK_OUT_CAPACITY_MIN;
    public static final String BALANCER_NETWORK_OUT_CAPACITY_DOC = "This config specifies the upper capacity limit for network outgoing bytes per second per broker. The Confluent DataBalancer will attempt to keep outgoing data throughput below this limit.";
    public static final String BALANCER_EXCLUDE_TOPIC_NAMES_SBK_CONFIG = "exclude.topic.names";
    public static final String BALANCER_EXCLUDE_TOPIC_NAMES_CONFIG = "confluent.balancer.exclude.topic.names";
    public static final List BALANCER_EXCLUDE_TOPIC_NAMES_DEFAULT = BalancerConfigs.BALANCER_EXCLUDE_TOPIC_NAMES_DEFAULT;
    public static final String BALANCER_EXCLUDE_TOPIC_NAMES_DOC = "This config accepts a list of topic names that will be excluded from rebalancing. For example, 'confluent.balancer.exclude.topic.names=[topic1, topic2]' ";
    public static final String BALANCER_EXCLUDE_TOPIC_PREFIXES_BASE_CONFIG = "exclude.topic.prefixes";
    public static final String BALANCER_EXCLUDE_TOPIC_PREFIXES_CONFIG = "confluent.balancer.exclude.topic.prefixes";
    public static final List BALANCER_EXCLUDE_TOPIC_PREFIXES_DEFAULT = BalancerConfigs.BALANCER_EXCLUDE_TOPIC_PREFIXES_DEFAULT;
    public static final String BALANCER_EXCLUDE_TOPIC_PREFIXES_DOC = "This config accepts a list of topic prefixes that will be excluded from rebalancing. For example, 'confluent.balancer.exclude.topic.prefixes=[prefix1, prefix2]' would exclude topics 'prefix1-suffix1', 'prefix1-suffix2', 'prefix2-suffix3', but not 'abc-prefix1-xyz' and 'def-prefix2'";
    public static final String BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_MAX_RETRY_MS_CONFIG = "confluent.balancer.api.state.persistence.store.startup.max.retry.ms";
    public static final Long BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_MAX_RETRY_MS_DEFAULT = BalancerConfigs.BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_MAX_RETRY_MS_DEFAULT;
    public static final String BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_MAX_RETRY_MS_DOC = "The maximum amount of time, in milliseconds, to retry up to when the Confluent DataBalancer's Api State Persistence Store component fails starting up.";
    public static final String BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_RETRY_WAIT_MS_CONFIG = "confluent.balancer.api.state.persistence.store.startup.retry.wait.ms";
    public static final Long BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_RETRY_WAIT_MS_DEFAULT = BalancerConfigs.BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_RETRY_WAIT_MS_DEFAULT;
    public static final String BALANCER_API_STATE_PERSISTENCE_STORE_STARTUP_RETRY_WAIT_MS_DOC = "The delay, in milliseconds, to wait for in between retries of the Confluent DataBalancer's Api State Persistence Store component startup.";
    public static final String BALANCER_API_STATE_TOPIC_SBK_CONFIG = "api.state.topic";
    public static final String BALANCER_API_STATE_TOPIC_CONFIG = "confluent.balancer.api.state.topic";
    public static final String BALANCER_API_STATE_TOPIC_DEFAULT = "_confluent_balancer_api_state";
    public static final String BALANCER_API_STATE_TOPIC_DOC = "Name of topic to use to store state of Confluent DataBalancer API. The topic will be used to store progress/failure of the api and will be used in case of recovery to resume long running operations like remove or add broker.";
    public static final String BALANCER_TOPICS_REPLICATION_FACTOR_SBK_CONFIG = "topic.replication.factor";
    public static final String BALANCER_TOPICS_REPLICATION_FACTOR_CONFIG = "confluent.balancer.topic.replication.factor";
    public static final Short BALANCER_TOPICS_REPLICATION_FACTOR_DEFAULT = BalancerConfigs.BALANCER_TOPICS_REPLICATION_FACTOR_DEFAULT;
    public static final String BALANCER_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor for all topics that are created and needed by the Confluent DataBalancer. This includes Sample Store and API state topics.";
    public static final String BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_SBK_CONFIG = "task.history.retention.days";
    public static final String BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_CONFIG = "confluent.balancer.task.history.retention.days";
    public static final Integer BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DEFAULT = BalancerConfigs.BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DEFAULT;
    public static final String BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DOC = "Number of days for which self balancing cluster's task history will be retained.";
    public static final String MULTI_TENANT_SASL_SECRETS_STORE_CLASS_NAME = "io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecretsStore";
    public static final String CONFLUENT_CDC_API_KEYS_PREFIX = "confluent.cdc.api.keys.";
    public static final String CDC_API_KEYS_TOPIC_CONFIG = "confluent.cdc.api.keys.topic";
    public static final String CDC_API_KEYS_TOPIC_DEFAULT = "";
    public static final String CDC_API_KEYS_TOPIC_DOC = "Name of the internal topic holding api keys";
    public static final String CDC_TOPIC_LOAD_TIMEOUT_MS_CONFIG = "confluent.cdc.api.keys.load.timeout.ms";
    public static final Long CDC_TOPIC_LOAD_TIMEOUT_MS_DEFAULT = Duration.ofMinutes(10L).toNanos();
    public static final String CDC_TOPIC_LOAD_TIMEOUT_MS_DOC = "Time (in milliseconds) to wait before giving up on trying to consume the topics for logical clusters api keys and tenant metadata. Default is 10min";
    public static final String CONFLUENT_CDC_LKC_METADATA_PREFIX = "confluent.cdc.lkc.metadata.";
    public static final String CDC_LKC_METADATA_TOPIC_CONFIG = "confluent.cdc.lkc.metadata.topic";
    public static final String CDC_LKC_METADATA_TOPIC_DEFAULT = "";
    public static final String CDC_LKC_METADATA_TOPIC_DOC = "Name of the internal topic holding lkc metadata";
    public static final String OPERATOR_MANAGED_CONFIG = "confluent.operator.managed";
    public static final boolean OPERATOR_MANAGED_DEFAULT = false;
    public static final String OPERATOR_MANAGED_DOC = "This config indicates if the Confluent Operator was involved in generating the broker configuration.";
    public static final String ANSIBLE_MANAGED_CONFIG = "confluent.ansible.managed";
    public static final boolean ANSIBLE_MANAGED_DEFAULT = false;
    public static final String ANSIBLE_MANAGED_DOC = "This config indicates if Ansible was involved in generating the broker configuration.";
    public static final String MULTITENANT_LISTENER_NAMES_CONFIG = "confluent.multitenant.listener.names";
    public static final String MULTITENANT_LISTENER_NAMES_DEFAULT = null;
    public static final String MULTITENANT_LISTENER_NAMES_DOC = "Comma separated list of listener names used for communications with tenants. It MUST BE SPECIFIED IN MULTI-TENANT environment! It is needed to enable both broker request (time on network and IO threads)backpressure, and for a proper startup of the topic based tenant metadata plugins. Note that this should bedisjoint from inter.broker.listener.name (which should not receive connections from tenants)";
    public static final String REQUEST_LOG_FILTER_CLASS_CONFIG = "confluent.request.log.filter.class";
    public static final String REQUEST_LOG_FILTER_DEFAULT = SamplingRequestLogFilter.class.getName();
    public static final String REQUEST_LOG_FILTER_CLASS_DOC = "Class of request log filter which can be used to select a subset of requests for logging. Every request handler thread will get a separate instance of this class and it is only consulted if the request log level is set to INFO or higher. If DEBUG or TRACE logging is enabled, then all requests get logged regardless of filtering.";
    public static final String APPLY_CREATE_TOPIC_POLICY_TO_CREATE_PARTITIONS = "confluent.apply.create.topic.policy.to.create.partitions";
    public static final boolean APPLY_CREATE_TOPIC_POLICY_TO_CREATE_PARTITIONS_DEFAULT = false;
    public static final String APPLY_CREATE_TOPIC_POLICY_TO_CREATE_PARTITIONS_DOC = "If this is set, CreateTopicsPolicy will also apply to CreatePartitions.";
    public static final String VERIFY_GROUP_SUBSCRIPTION_PREFIX = "confluent.verify.group.subscription.prefix";
    public static final boolean VERIFY_GROUP_SUBSCRIPTION_PREFIX_DEFAULT = false;
    public static final String VERIFY_GROUP_SUBSCRIPTION_PREFIX_DOC = "If this is set, the group coordinator will verify that the subscriptions are prefixed with the tenant.";
    public static final String STRAY_PARTITION_DELETION_ENABLE_CONFIG = "confluent.enable.stray.partition.deletion";
    public static final boolean STRAY_PARTITION_DELETION_ENABLE_DEFAULT = false;
    public static final String STRAY_PARTITION_DELETION_ENABLE_DOC = "Whether stray partition deletion is enabled";
    public static final String CRN_AUTHORITY_PREFIX = "confluent.authorizer.authority.";
    public static final String CRN_AUTHORITY_NAME_CONFIG = "confluent.authorizer.authority.name";
    public static final String CRN_AUTHORITY_NAME_DEFAULT = "";
    public static final String CRN_AUTHORITY_NAME_DOC = "The DNS name of the authority that this clusteruses to authorize. This should be a name for the cluster hosting metadata topics.";
    public static final String EVENT_LOGGER_PREFIX = "event.logger.";
    public static final String AUDIT_PREFIX = "confluent.security.";
    public static final String AUDIT_EVENT_LOGGER_PREFIX = "confluent.security.event.logger.";
    public static final String AUDIT_EVENT_ROUTER_PREFIX = "confluent.security.event.router.";
    public static final String AUDIT_EVENT_ROUTER_CONFIG = "confluent.security.event.router.config";
    public static final String AUDIT_EVENT_ROUTER_DEFAULT = "";
    public static final String AUDIT_EVENT_ROUTER_DOC = "JSON configuration for routing events to topics";
    public static final String AUDIT_LOGGER_ENABLE_CONFIG = "confluent.security.event.logger.enable";
    public static final String AUDIT_LOGGER_ENABLE_DEFAULT = "true";
    public static final String AUDIT_LOGGER_ENABLE_DOC = "Whether the event logger is enabled";
    public static final String AUDIT_LOGGER_REPLICATION_FACTOR_CONFIG = "confluent.security.event.logger.exporter.kafka.topic.replicas";
    public static final String AUDIT_LOGGER_REPLICATION_FACTOR_DEFAULT = "3";
    public static final String AUDIT_LOGGER_REPLICATION_FACTOR_DOC = "Replication factor for audit log topics";
    public static final String ENABLE_AUTHENTICATION_AUDIT_LOGS = "confluent.security.event.logger.authentication.enable";
    public static final String ENABLE_AUTHENTICATION_AUDIT_LOGS_DEFAULT = "false";
    public static final String ENABLE_AUTHENTICATION_AUDIT_LOGS_DOC = "Enable authentication audit logs";
    public static final String CLUSTER_REGISTRY_CONFIG = "confluent.metadata.server.cluster.registry.clusters";
    public static final String CLUSTER_REGISTRY_CONFIG_DEFAULT = "[]";
    public static final String CLUSTER_REGISTRY_CONFIG_DOC = "JSON defining initial state of Cluster Registry. This should not be set manually, instead Cluster Registry http apis should be used.";
    public static final String ENABLE_FIPS_CONFIG = "enable.fips";
    public static final String ENABLE_FIPS_DEFAULT = "false";
    public static final String ENABLE_FIPS_DOC = "Enable FIPS mode on the server. If FIPS mode is enabled, broker listener security protocols, TLS versions and cipher suites will be validated based on FIPS compliance requirement.";
    public static final String CLUSTER_LINK_ENABLE_CONFIG = "confluent.cluster.link.enable";
    public static final boolean CLUSTER_LINK_ENABLE_DEFAULT = true;
    public static final String CLUSTER_LINK_ENABLE_DOC = "Enable cluster linking feature.";
    public static final String CLUSTER_LINK_FETCH_RESPONSE_TOTAL_BYTES_CONFIG = "confluent.cluster.link.fetch.response.total.bytes";
    public static final String CLUSTER_LINK_FETCH_RESPONSE_MIN_BYTES_CONFIG = "confluent.cluster.link.fetch.response.min.bytes";
    public static final String CLUSTER_LINK_FETCH_RESPONSE_TOTAL_BYTES_DOC = "Maximum amount of data fetched by all cluster link fetchers in a broker. If total 'replica.fetch.response.max.bytes' for all fetchers on the broker exceeds this value, all cluster link fetchers reduce their response size to meet this limit. Minimum value for each fetcher can be configured using 'confluent.cluster.link.fetch.response.min.bytes'.";
    public static final String CLUSTER_LINK_FETCH_RESPONSE_MIN_BYTES_DOC = "Minimum fetch response size used by cluster link fetchers if the total size is limited by 'confluent.cluster.link.fetch.response.total.bytes'.";
    public static final String CLUSTER_LINK_IO_MAX_BYTES_PER_SECOND_CONFIG = "confluent.cluster.link.io.max.bytes.per.second";
    public static final String CLUSTER_LINK_IO_MAX_BYTES_PER_SECOND_DOC = "A long value representing the upper bound (bytes/sec) on throughput for cluster link replication. It is suggested that the limit be kept above 1MB/s for accurate behaviour.";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_MODE_CONFIG = "confluent.cluster.link.replication.quota.mode";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_MODE_DOC = "The mode for cluster link quota that applies to 'confluent.cluster.link.io.max.bytes.per.second'. The mode indicates which inbound traffic is counted towards the limit. Valid values are '" + (Object)((Object)ClusterLinkQuotaMode.CLUSTER_LINK_ONLY) + "' and '" + (Object)((Object)ClusterLinkQuotaMode.TOTAL_INBOUND) + "'.";
    public static final String NUM_CLUSTER_LINK_REPLICATION_QUOTAS_SAMPLES_CONFIG = "confluent.cluster.link.replication.quota.window.num";
    public static final String NUM_CLUSTER_LINK_REPLICATION_QUOTAS_SAMPLES_DOC = "The number of samples to retain in memory for cluster link replication quotas";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_WINDOW_SIZE_SECONDS_CONFIG = "confluent.cluster.link.replication.quota.window.size.seconds";
    public static final String CLUSTER_LINK_REPLICATION_QUOTA_WINDOW_SIZE_SECONDS_DOC = "The time span of each sample for cluster link replication quotas";
    public static final String CLUSTER_LINK_METADATA_TOPIC_ENABLE_CONFIG = "confluent.cluster.link.metadata.topic.enable";
    public static final String CLUSTER_LINK_METADATA_TOPIC_ENABLE_DOC = "Whether the cluster link metadata topic should be created and (or) used.";
    public static final String CLUSTER_LINK_METADATA_TOPIC_PARTITIONS_CONFIG = "confluent.cluster.link.metadata.topic.partitions";
    public static final String CLUSTER_LINK_METADATA_TOPIC_PARTITIONS_DOC = "Number of partitions for the cluster linking metadata topic";
    public static final String CLUSTER_LINK_METADATA_TOPIC_REPLICATION_FACTOR_CONFIG = "confluent.cluster.link.metadata.topic.replication.factor";
    public static final String CLUSTER_LINK_METADATA_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor the for the cluster linking metadata topic";
    public static final String CLUSTER_LINK_METADATA_TOPIC_MIN_ISR_CONFIG = "confluent.cluster.link.metadata.topic.min.isr";
    public static final String CLUSTER_LINK_METADATA_TOPIC_MIN_ISR_DOC = "The minimum number of in sync replicas for the cluster linking metadata topic";
    public static final String CLUSTER_LINK_METADATA_TOPIC_CREATE_RETRY_DELAY_MS_CONFIG = "confluent.cluster.link.metadata.topic.create.retry.delay.ms";
    public static final String CLUSTER_LINK_METADATA_TOPIC_CREATE_RETRY_DELAY_MS_DOC = "The retry delay in milliseconds when the attempt to create cluster linking metadata topic is failed";
    public static final String INTERNAL_REST_SERVER_BIND_PORT_CONFIG = "confluent.internal.rest.server.bind.port";
    public static final Integer INTERNAL_REST_SERVER_BIND_PORT_DEFAULT = null;
    public static final String INTERNAL_REST_SERVER_BIND_PORT_DOC = "The port to bind the internal rest server to.";
    public static final String HTTP_SERVER_START_TIMEOUT_MS_CONFIG = "confluent.http.server.start.timeout.ms";
    public static final Long HTTP_SERVER_START_TIMEOUT_MS_DEFAULT = Duration.ofSeconds(60L).toMillis();
    public static final String HTTP_SERVER_START_TIMEOUT_MS_DOC = "How long to wait for the Kafka HTTP server to start up, in milliseconds. Default is 60s.";
    public static final String HTTP_SERVER_STOP_TIMEOUT_MS_CONFIG = "confluent.http.server.stop.timeout.ms";
    public static final Long HTTP_SERVER_STOP_TIMEOUT_MS_DEFAULT = Duration.ofSeconds(30L).toMillis();
    public static final String HTTP_SERVER_STOP_TIMEOUT_MS_DOC = "How long to wait for the Kafka HTTP server to shutdown, in milliseconds. Default is 30s.";
    public static final String RESOURCE_LABEL_PREFIX = "resource.";
    public static final String RESOURCE_LABEL_TYPE = "resource.type";
    public static final String RESOURCE_LABEL_VERSION = "resource.version";
    public static final String RESOURCE_LABEL_COMMIT_ID = "resource.commit.id";
    public static final String MAX_BROKER_TENANT_PRODUCER_BYTE_RATE_CONFIG = "confluent.quota.tenant.broker.max.producer.rate";
    public static final String MAX_BROKER_TENANT_PRODUCER_BYTE_RATE_DOC = "Maximum producer quota in bytes/s per tenant per broker";
    public static final long MAX_BROKER_TENANT_PRODUCER_BYTE_RATE_DEFAULT = 0xC80000L;
    public static final String MAX_BROKER_TENANT_CONSUMER_BYTE_RATE_CONFIG = "confluent.quota.tenant.broker.max.consumer.rate";
    public static final String MAX_BROKER_TENANT_CONSUMER_BYTE_RATE_DOC = "Maximum consumer quota in bytes/s per tenant per broker";
    public static final long MAX_BROKER_TENANT_CONSUMER_BYTE_RATE_DEFAULT = 0xC80000L;
    public static final String TENANT_USER_QUOTAS_ENABLE_CONFIG = "confluent.quota.tenant.user.quotas.enable";
    public static final String TENANT_USER_QUOTAS_ENABLE_DOC = "If enabled, return service-account quotas from TenantQuotaCallback.";
    public static final boolean TENANT_USER_QUOTAS_ENABLE_DEFAULT = false;
    public static final String MULTITENANT_LISTENER_PREFIX_ENABLE = "confluent.multitenant.listener.hostname.cluster.prefix.enable";
    public static final String MULTITENANT_LISTENER_PREFIX_ENABLE_DOC = "If enabled, return tenant-specific broker endpoints by prepending tenant cluster id to the advertised hostname configured for multi-tenant listeners";
    public static final boolean MULTITENANT_LISTENER_PREFIX_ENABLE_DEFAULT = false;
    public static final String PARSE_SNI_HOST_NAME_ENABLED = "confluent.multitenant.parse.sni.host.name.enable";
    public static final String PARSE_SNI_HOST_NAME_ENABLED_DOC = "When enabled, parse the SNI host name upon SASL_SSL connection establishment.";
    public static final boolean PARSE_SNI_HOST_NAME_ENABLED_DEFAULT = false;
    public static final String MULTITENANT_MAX_PARTITIONS = "confluent.multitenant.max.partitions.per.request";
    public static final String MULTITENANT_MAX_PARTITIONS_DOC = "Maximum number of partitions within a single new topic/partition creation. This setting is enforced by the TenantPartitionAssignor.";
    public static final int MULTITENANT_MAX_PARTITIONS_DEFAULT = Integer.MAX_VALUE;
    public static final String TOPIC_REPLICA_ASSIGNOR_BUILDER = "confluent.topic.replica.assignor.builder.class";
    public static final String TOPIC_REPLICA_ASSIGNOR_DOC = "The configurable builder class for the replica assignor used to assign replicas on topic/partition creation without explicit assignment.";
    public static final String TOPIC_REPLICA_ASSIGNOR_DEFAULT = "";
    public static final String DELAY_CLOSING_INVALID_REQUEST_ENABLE = "confluent.connection.invalid.request.delay.enable";
    public static final String DELAY_CLOSING_INVALID_REQUEST_ENABLE_DOC = "When enabled, delay closing connections that fail in request parsing.The delay used will be from `\"connection.failed.authentication.delay.ms\"`";
    public static final boolean DELAY_CLOSING_INVALID_REQUEST_ENABLE_DEFAULT = false;
    public static final String MAX_CONNECTION_CREATION_RATE_PER_IP = "confluent.max.connection.creation.rate.per.ip";
    public static final String MAX_CONNECTION_CREATION_RATE_PER_IP_DOC = "An int representing the upper bound of connection rate accepted for each IP. This config is a static equivalent to the dynamic connection_creation_rate quota for the default IP entity";
    public static final String IP_CONNECTION_CREATION_RATE_THROTTLE_ENABLE_THRESHOLD = "max.connection.creation.rate.per.ip.enable.threshold";
    public static final String IP_CONNECTION_CREATION_RATE_THROTTLE_ENABLE_THRESHOLD_DOC = "A double representing the proportional threshold for listener connection rate after which to apply IP rate limits";
    public static final double IP_CONNECTION_CREATION_RATE_THROTTLE_ENABLE_THRESHOLD_DEFAULT = 0.0;
    public static final String MAX_CONNECTION_THROTTLE_MS = "confluent.max.connection.throttle.ms";
    public static final String MAX_CONNECTION_THROTTLE_MS_DOC = "An int representing the max time in milliseconds to throttle accepting a connection. If not set \"quota.window.size.seconds\" will be used to bound connection acceptance throttling.";
    public static final Long MAX_CONNECTION_THROTTLE_MS_DEFAULT = null;
    public static final String CONNECTIONS_MAX_AGE_MS = "connections.max.age.ms";
    public static final Long CONNECTIONS_MAX_AGE_MS_DEFAULT;
    public static final Long CONNECTIONS_MAX_AGE_MS_MAX;
    public static final String CONNECTIONS_MAX_AGE_MS_DOC;
    public static final String CONNECTIONS_MIN_EXPIRE_INTERVAL_MS = "connection.min.expire.interval.ms";
    public static final String CONNECTIONS_MIN_EXPIRE_INTERVAL_DOC = "Minimum interval in milliseconds between closing of expired connections on a single server socket processor thread.";
    public static final Long CONNECTIONS_MIN_EXPIRE_INTERVAL_DEFAULT;
    public static final String CLOSE_CONNECTIONS_ON_CREDENTIAL_DELETE_CONFIG = "confluent.close.connections.on.credential.delete";
    public static final String CLOSE_CONNECTIONS_ON_CREDENTIAL_DELETE_DOC = "When enabled, broker will terminate all existing connections using a deleted credential if the broker is notified of a deleted credential by a broker plugin that manages credentials.";
    public static final boolean CLOSE_CONNECTIONS_ON_CREDENTIAL_DELETE_DEFAULT = false;
    public static final String PASSWORD_ENCODER_OLD_SECRET_TTL_MS_CONFIG = "confluent.password.encoder.old.secret.ttl.ms";
    public static final String PASSWORD_ENCODER_OLD_SECRET_TTL_MS_DOC = "The minimum amount of time in milliseconds that configs encrypted using old encryption secret 'password.encoder.old.secret' should be retained.";
    public static final long PASSWORD_ENCODER_OLD_SECRET_TTL_MS_DEFAULT = Long.MAX_VALUE;
    public static final String MIN_FOLLOWER_BROKER_TENANT_PRODUCER_BYTE_RATE_CONFIG = "confluent.quota.tenant.follower.broker.min.producer.rate";
    public static final String MIN_FOLLOWER_BROKER_TENANT_PRODUCER_BYTE_RATE_DOC = "Minimum producer quota in bytes/s per tenant per broker that has no leaders for tenant's partitions";
    public static final long MIN_FOLLOWER_BROKER_TENANT_PRODUCER_BYTE_RATE_DEFAULT = 0xA00000L;
    public static final String MIN_FOLLOWER_BROKER_TENANT_CONSUMER_BYTE_RATE_CONFIG = "confluent.quota.tenant.follower.broker.min.consumer.rate";
    public static final String MIN_FOLLOWER_BROKER_TENANT_CONSUMER_BYTE_RATE_DOC = "Minimum consumer quota in bytes/s per tenant per broker that has no leaders for tenant's partitions";
    public static final long MIN_FOLLOWER_BROKER_TENANT_CONSUMER_BYTE_RATE_DEFAULT = 0xA00000L;
    public static final String DURABILITY_AUDIT_ENABLE = "confluent.durability.audit.enable";
    public static final String DURABILITY_AUDIT_ENABLE_DOC = "If enabled, this will start the long-lived durability audits";
    public static final boolean DURABILITY_AUDIT_ENABLE_DEFAULT = false;
    public static final String DURABILITY_ALLOWED_EVENTS = "confluent.durability.events.allowed";
    public static final String DURABILITY_ALLOWED_EVENTS_DOC = "Comma-separated list of the event types that will be accepted by AuditManager. Should correspond to kafka.durability.events.DurabilityEventType";
    public static final String DURABILITY_ALLOWED_EVENTS_DEFAULT = "OffsetChangeType,EpochChangeType,IsrExpandType,DeleteRecordsType,RetentionChangeType,StartOffsetChangeType,DeletePartitionType,HealthCheckType";
    public static final String DURABILITY_TOPIC_REPLICATION_FACTOR = "confluent.durability.topic.replication.factor";
    public static final String DURABILITY_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor of durability audit's internal topic";
    public static final Integer DURABILITY_TOPIC_REPLICATION_FACTOR_DEFAULT;
    public static final String DURABILITY_TOPIC_PARTITION_COUNT = "confluent.durability.topic.partition.count";
    public static final String DURABILITY_TOPIC_PARTITION_COUNT_DOC = "Partition count of durability audit's internal topic";
    public static final Integer DURABILITY_TOPIC_PARTITION_COUNT_DEFAULT;
    public static final String DURABILITY_AUDIT_REPORTING_BATCH_MS = "confluent.durability.audit.reporting.batch.ms";
    public static final String DURABILITY_AUDIT_REPORTING_BATCH_MS_DOC = "Time to linger and consolidate durability audit error metrics before reporting";
    public static final Integer DURABILITY_AUDIT_REPORTING_BATCH_MS_DEFAULT;
    public static final String DURABILITY_AUDIT_BATCH_EVENTS_FLUSH_FREQUENCY_MS = "confluent.durability.audit.batch.flush.frequency.ms";
    public static final String DURABILITY_AUDIT_BATCH_EVENTS_FLUSH_FREQUENCY_MS_DOC = "Frequency of flushing batch events of durability audit";
    public static final Integer DURABILITY_AUDIT_BATCH_EVENTS_FLUSH_FREQUENCY_MS_DEFAULT;
    public static final String DURABILITY_AUDIT_INITIAL_JOB_DELAY_MS = "confluent.durability.audit.initial.job.delay.ms";
    public static final String DURABILITY_AUDIT_INITIAL_JOB_DELAY_MS_DOC = "Initial durability audit job delay";
    public static final Long DURABILITY_AUDIT_INITIAL_JOB_DELAY_MS_DEFAULT;
    public static final String DEFAULT_CONTROLLER_MUTATION_RATE_PER_TENANT_CONFIG = "confluent.quota.tenant.default.controller.mutation.rate";
    public static final String DEFAULT_CONTROLLER_MUTATION_RATE_PER_TENANT_DOC = "The rate per tenant at which mutations are accepted for the create topics request, the create partitions request and the delete topics request. The rate is accumulated by the number of partitions created or deleted.";
    public static final double DEFAULT_CONTROLLER_MUTATION_RATE_PER_TENANT_DEFAULT = 2.147483647E9;
    public static final String CELL_TAG = "confluent.cell";
    public static final String MAX_PARTITIONS_PER_TENANT_CONFIG = "confluent.plugins.topic.policy.max.partitions.per.tenant";
    public static final String MAX_PARTITIONS_PER_TENANT_DOC = "The maximum partitions per tenant.";
    public static final int MAX_PARTITIONS_PER_TENANT_DEFAULT = 512;
    public static final String MAX_DEST_LINKS_PER_TENANT_CONFIG = "confluent.plugins.cluster.link.policy.max.destination.links.per.tenant";
    public static final String MAX_DEST_LINKS_PER_TENANT_DOC = "The maximum destination cluster links per tenant.";
    public static final int MAX_DEST_LINKS_PER_TENANT_DEFAULT = 5;
    public static final String MAX_SOURCE_LINKS_PER_TENANT_CONFIG = "confluent.plugins.cluster.link.policy.max.source.links.per.tenant";
    public static final String MAX_SOURCE_LINKS_PER_TENANT_DOC = "The maximum source cluster links per tenant. This limit is only applicable to source initiated links.";
    public static final int MAX_SOURCE_LINKS_PER_TENANT_DEFAULT = 5;
    private static final String BROKER_LOAD_PREFIX = "confluent.broker.load.";
    public static final String BROKER_LOAD_ENABLED_CONFIG = "confluent.broker.load.enabled";
    public static final String BROKER_LOAD_ENABLED_DOC = "Whether the broker load metric should be customer-visible by tagging it with their logical Kafka clusters";
    public static final boolean BROKER_LOAD_ENABLED_DEFAULT = false;
    public static final String BROKER_LOAD_UPDATE_METRIC_TAGS_INTERVAL_MS_CONFIG = "confluent.broker.load.update.metric.tags.interval.ms";
    public static final String BROKER_LOAD_UPDATE_METRIC_TAGS_INTERVAL_MS_DOC = "Interval for which to update the broker load metric tags in case of Kafka LKC changes";
    public static final long BROKER_LOAD_UPDATE_METRIC_TAGS_INTERVAL_MS_DEFAULT;
    public static final String BROKER_LOAD_WINDOW_SIZE_MS_CONFIG = "confluent.broker.load.window.size.ms";
    public static final String BROKER_LOAD_WINDOW_SIZE_MS_DOC = "The interval (in milliseconds) between request or connection samples for calculating the broker load";
    public static final long BROKER_LOAD_WINDOW_SIZE_MS_DEFAULT;
    public static final String BROKER_LOAD_NUM_SAMPLES_CONFIG = "confluent.broker.load.num.samples";
    public static final String BROKER_LOAD_NUM_SAMPLES_DOC = "The number of samples to include in a calculation window";
    public static final int BROKER_LOAD_NUM_SAMPLES_DEFAULT = 60;
    public static final String BROKER_LOAD_AVERAGE_SERVICE_REQUEST_TIME_MS_CONFIG = "confluent.broker.load.average.service.request.time.ms";
    public static final String BROKER_LOAD_AVERAGE_SERVICE_REQUEST_TIME_MS_DOC = "The average time taken to service a request on the broker";
    public static final double BROKER_LOAD_AVERAGE_SERVICE_REQUEST_TIME_MS_DEFAULT = 0.1;
    public static final String BROKER_LOAD_WORKLOAD_COEFFICIENT_CONFIG = "confluent.broker.load.workload.coefficient";
    public static final String BROKER_LOAD_WORKLOAD_COEFFICIENT_DOC = "A constant to tune the broker load for a specific workload characteristic";
    public static final double BROKER_LOAD_WORKLOAD_COEFFICIENT_DEFAULT = 20.0;
    public static final String BROKER_LOAD_DELAY_METRIC_START_MS_CONFIG = "confluent.broker.load.delay.metric.start.ms";
    public static final String BROKER_LOAD_START_METRIC_DELAY_MS_DOC = "The time (in milliseconds) to delay the start of the broker load metric after we start processing requests";
    public static final long BROKER_LOAD_START_METRIC_DELAY_MS_DEFAULT;
    public static final String PROXY_PROTOCOL_VERSION = "confluent.proxy.protocol.version";
    public static final String PROXY_PROTOCOL_VERSION_DOC = "The version of the PROXY protocol that the broker will use, or NONE if the PROXY protocol will not be used. This value can be overridden for each listener by prefixing the config with the normalized listener name. For example, to enable V1 of the protocol for the EXTERNAL listener, set <code>listener.name.external.confluent.proxy.protocol.version=V1</code>. Because the inter-broker listener and any admin listeners will likely not be accessed through a proxy, the typical configuration would be to use the default value of NONE and enable the protocol explicitly for a subset of listeners. See http://www.haproxy.org/download/1.8/doc/proxy-protocol.txt for more information on the PROXY protocol.";
    public static final String PROXY_PROTOCOL_VERSION_DEFAULT;
    public static final String PROXY_PROTOCOL_FALLBACK_ENABLED = "confluent.proxy.protocol.fallback.enabled";
    public static final String PROXY_PROTOCOL_FALLBACK_ENABLED_DOC = "If true, and if <code>confluent.proxy.protocol.version</code> is not set to <code>NONE</code>, the network layer will accept both PROXY and non-PROXY protocol requests. If the PROXY header is present, it will parse it and interpret the specified client IP address and port appropriately; if not, it will fall back to a normal, non-PROXY request. This value can be overridden for each listener by prefixing the config with the normalized listener name.";
    public static final Boolean PROXY_PROTOCOL_FALLBACK_ENABLED_DEFAULT;
    public static final String CONSUMER_LAG_EMITTER_ENABLED_CONFIG = "confluent.consumer.lag.emitter.enabled";
    public static final String CONSUMER_LAG_EMITTER_ENABLED_DOC = "Enables consumer lag emitter. The emitter records lag for all consumer groups in the server.";
    public static final boolean CONSUMER_LAG_EMITTER_ENABLED_DEFAULT = false;
    public static final String CONSUMER_LAG_EMITTER_INTERVAL_MS_CONFIG = "confluent.consumer.lag.emitter.interval.ms";
    public static final String CONSUMER_LAG_EMITTER_INTERVAL_MS_DOC = "Interval in which consumer lag is recorded.";
    public static final Long CONSUMER_LAG_EMITTER_INTERVAL_MS_DEFAULT;
    public static final String CHECKSUM_ENABLED_FILES_CONFIG = "confluent.checksum.enabled.files";
    public static final String CHECKSUM_ENABLED_FILES_DOC = "Contains the list of file types in comma separated format for which checksum should be enabled. \"all\" will enable checksums for all files where available, \"none\" will disable checksums for all files, and \"tierstate\" will enable checksums for only tier state files. Currently only \"tierstate\" file type is supported .NOTE: Turning on may prevent downgrades safely to versions that don't support checksumsNOTE: This config is independent of record level batch CRCs";
    public static final String CHECKSUM_ENABLED_FILES_TIERSTATE = "tierstate";
    public static final String CHECKSUM_ENABLED_FILES_ALL = "all";
    public static final String CHECKSUM_ENABLED_FILES_NONE = "none";
    public static final String CHECKSUM_ENABLED_FILES_DEFAULT = "none";
    public static final String REQUIRE_COMPATIBLE_KEYSTORE_UPDATE_CONFIG = "confluent.require.compatible.keystore.updates";
    public static final String REQUIRE_COMPATIBLE_KEYSTORE_UPDATE_DOC = "This configuration controls whether strict compatibility is required when dynamically updating broker keystores. When enabled, dynamically updated keystores must contain the same number of certificates and each certificate must have matching distinguished names and the alternative names must be a superset of the old certificate. If disabled, then no compatibility checks will be done.";
    public static final Boolean REQUIRE_COMPATIBLE_KEYSTORE_UPDATE_DEFAULT;
    public static final String ELIGIBLE_CONTROLLERS_CONFIG = "confluent.eligible.controllers";
    public static final String ELIGIBLE_CONTROLLERS_DOC = "This configuration provides the ability for zk-based clusters to set an explicit list of the brokers that are eligible to become controller. Brokers which are not included in this list will not attempt to become controller by creating the `/controller` znode. If the current controller is not among the eligible controllers when the configuration is changed dynamicallly, it will resign so that one of the eligible controllers can be elected. Additionally, when changed dynamically, at least one of the eligible controllers must be online. The default value is an empty list, which we treat as indicating that all brokers are eligible to become controller.";
    public static final List<String> ELIGIBLE_CONTROLLERS_DEFAULT;
    public static final String FETCH_PARTITION_PRUNING_ENABLE_CONFIG = "confluent.fetch.partition.pruning.enable";
    public static final String FETCH_PARTITION_PRUNING_ENABLE_DOC = "Specifies if inactive partitions could be ignored when a fetch request from a follower is processed.";
    public static final boolean FETCH_PARTITION_PRUNING_ENABLE_DEFAULT = true;
    public static final String DEFER_ISR_SHRINK_ENABLE_CONFIG = "confluent.defer.isr.shrink.enable";
    public static final String DEFER_ISR_SHRINK_ENABLE_DOC = "Defer ISR shrinking for partitions that only have messages with acks = \"all\" if shrinking ISR would make partition fall under min ISR.";
    public static final boolean DEFER_ISR_SHRINK_ENABLE_DEFAULT = false;

    public static BrokerInterceptor buildBrokerInterceptor(Mode mode, Map<String, ?> configs) {
        if (mode == Mode.CLIENT) {
            return null;
        }
        BrokerInterceptor interceptor = new DefaultBrokerInterceptor();
        if (configs.containsKey(BROKER_INTERCEPTOR_CLASS_CONFIG)) {
            Class interceptorClass = (Class)configs.get(BROKER_INTERCEPTOR_CLASS_CONFIG);
            interceptor = (BrokerInterceptor)Utils.newInstance(interceptorClass);
        }
        interceptor.configure(configs);
        return interceptor;
    }

    public static MultiTenantMetadata buildMultitenantMetadata(Map<String, ?> configs, Metrics metrics) {
        MultiTenantMetadata meta = null;
        if (configs.get(MULTITENANT_METADATA_CLASS_CONFIG) != null) {
            Class multitenantMetadataClass = (Class)configs.get(MULTITENANT_METADATA_CLASS_CONFIG);
            try {
                meta = (MultiTenantMetadata)Utils.newParameterizedInstance(multitenantMetadataClass.getName(), Metrics.class, metrics);
            }
            catch (ClassNotFoundException e) {
                throw new KafkaException(e);
            }
            meta.configure(configs);
        }
        return meta;
    }

    public static MultiTenantSecretsStore buildMultiTenantSecretsStore(AbstractConfig config, Endpoint interBrokerEndpoint, Metrics metrics) {
        MultiTenantSecretsStore secretsStore = null;
        String topicName = config.getString(CDC_API_KEYS_TOPIC_CONFIG);
        if (topicName != null && !topicName.isEmpty()) {
            try {
                Map<String, Object> clientConfig = ConfluentConfigs.interBrokerClientConfigs(config, interBrokerEndpoint);
                secretsStore = (MultiTenantSecretsStore)Utils.newParameterizedInstance(MULTI_TENANT_SASL_SECRETS_STORE_CLASS_NAME, Map.class, clientConfig, Metrics.class, metrics);
            }
            catch (ClassNotFoundException e) {
                throw new KafkaException(e);
            }
            secretsStore.configure(config.values());
        }
        return secretsStore;
    }

    public static List<String> multitenantListenerNames(AbstractConfig config, ListenerName interBrokerListenerName) {
        return ConfluentConfigs.multitenantListenerNames(config.values(), interBrokerListenerName);
    }

    public static List<String> multitenantListenerNames(Map<String, ?> config, ListenerName interBrokerListenerName) {
        List<String> listenerNames;
        String listenerNamesString = (String)config.get(MULTITENANT_LISTENER_NAMES_CONFIG);
        if (listenerNamesString == null) {
            listenerNames = Collections.emptyList();
        } else {
            listenerNames = Arrays.stream(listenerNamesString.split("\\s*,\\s*")).filter(v -> !v.isEmpty()).map(v -> ListenerName.normalised(v).value()).collect(Collectors.toList());
            if (interBrokerListenerName != null && listenerNames.contains(interBrokerListenerName.value())) {
                throw new ConfigException("confluent.multitenant.listener.names contains the internal listener " + interBrokerListenerName.value());
            }
        }
        return listenerNames;
    }

    public static LicenseValidator buildLicenseValidator(AbstractConfig config, Endpoint interBrokerEndpoint) {
        Configurable licenseValidator = null;
        ServiceLoader<LicenseValidator> validators = ServiceLoader.load(LicenseValidator.class);
        for (LicenseValidator validator : validators) {
            if (!validator.enabled()) continue;
            licenseValidator = validator;
            break;
        }
        if (licenseValidator == null) {
            throw new IllegalStateException("License validator not found");
        }
        licenseValidator.configure(ConfluentConfigs.interBrokerClientConfigs(config, interBrokerEndpoint));
        return licenseValidator;
    }

    public static Map<String, Object> interBrokerClientConfigs(AbstractConfig brokerConfig, Endpoint interBrokerEndpoint) {
        return ConfluentConfigs.interBrokerClientConfigs(brokerConfig.originals(), brokerConfig.values(), interBrokerEndpoint);
    }

    public static Map<String, Object> interBrokerClientConfigs(Map<String, Object> originals, Endpoint interBrokerEndpoint) {
        return ConfluentConfigs.interBrokerClientConfigs(originals, Collections.emptyMap(), interBrokerEndpoint);
    }

    public static Map<String, Object> interBrokerClientConfigs(Map<String, Object> originals, Map<String, ?> values, Endpoint interBrokerEndpoint) {
        HashMap<String, Object> clientConfigs = new HashMap<String, Object>(originals);
        Set<String> brokerConfigNames = values.keySet();
        clientConfigs.keySet().removeIf(n -> brokerConfigNames.contains(n) && !AdminClientConfig.configNames().contains(n) || n.startsWith("listener.name."));
        ListenerName listenerName = new ListenerName(interBrokerEndpoint.listenerName().get());
        String listenerPrefix = listenerName.configPrefix();
        SecurityProtocol securityProtocol = interBrokerEndpoint.securityProtocol();
        if (securityProtocol == SecurityProtocol.SASL_PLAINTEXT || securityProtocol == SecurityProtocol.SASL_SSL) {
            String saslMechanism = (String)originals.get("sasl.mechanism.inter.broker.protocol");
            saslMechanism = saslMechanism != null ? saslMechanism : "GSSAPI";
            clientConfigs.put("sasl.mechanism", saslMechanism);
            String mechanismPrefix = listenerName.saslMechanismConfigPrefix(saslMechanism);
            ConfluentConfigs.updatePrefixedConfigs(originals, clientConfigs, mechanismPrefix);
            if (!clientConfigs.containsKey("sasl.jaas.config")) {
                String jaasConfig = JaasContext.listenerSaslJaasConfig(listenerName, saslMechanism);
                clientConfigs.put("sasl.jaas.config", jaasConfig);
            }
        }
        ConfluentConfigs.updatePrefixedConfigs(originals, clientConfigs, listenerPrefix);
        String ibpHost = interBrokerEndpoint.host() == null ? "" : interBrokerEndpoint.host();
        clientConfigs.put("bootstrap.servers", ibpHost + ":" + interBrokerEndpoint.port());
        clientConfigs.put("security.protocol", securityProtocol.name);
        return clientConfigs;
    }

    public static Map<String, Object> clientConfigs(AbstractConfig config, String configPrefix, ClientType clientType, String topicPrefix, String componentId) {
        Map<String, Object> srcConfigs = config.originals();
        srcConfigs.keySet().removeAll(config.values().keySet());
        HashMap<String, Object> clientConfigs = new HashMap<String, Object>(srcConfigs);
        clientConfigs.remove("metric.reporters");
        clientConfigs.remove("principal.builder.class");
        clientConfigs.put("client.id", String.format("%s-%s-%s", topicPrefix, clientType.type, componentId));
        ConfluentConfigs.updatePrefixedConfigs(srcConfigs, clientConfigs, configPrefix + clientType.type + ".");
        ConfluentConfigs.updatePrefixedConfigs(srcConfigs, clientConfigs, configPrefix);
        return clientConfigs;
    }

    public static FipsValidator buildFipsValidator() {
        FipsValidator fipsValidator = null;
        ServiceLoader<FipsValidator> validators = ServiceLoader.load(FipsValidator.class);
        for (FipsValidator validator : validators) {
            if (!validator.fipsEnabled()) continue;
            fipsValidator = validator;
            break;
        }
        if (fipsValidator == null) {
            throw new IllegalStateException("FIPS validator not found");
        }
        return fipsValidator;
    }

    private static void updatePrefixedConfigs(Map<String, Object> configs, Map<String, Object> dstConfigs, String prefix) {
        Set<String> prefixed = configs.keySet().stream().filter(n -> n.startsWith(prefix)).collect(Collectors.toSet());
        prefixed.forEach(name -> {
            dstConfigs.remove(name);
            dstConfigs.put(name.substring(prefix.length()), configs.get(name));
        });
        configs.keySet().removeAll(prefixed);
    }

    static {
        CONNECTIONS_MAX_AGE_MS_MAX = CONNECTIONS_MAX_AGE_MS_DEFAULT = Long.valueOf(TimeUnit.MILLISECONDS.convert(36500L, TimeUnit.DAYS));
        CONNECTIONS_MAX_AGE_MS_DOC = "Max connection age timeout: the server socket processor threads close connections older than this. Can be set per-listener. Must be positive and less than 100 years (" + CONNECTIONS_MAX_AGE_MS_MAX + " ms).";
        CONNECTIONS_MIN_EXPIRE_INTERVAL_DEFAULT = 250L;
        DURABILITY_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
        DURABILITY_TOPIC_PARTITION_COUNT_DEFAULT = 50;
        DURABILITY_AUDIT_REPORTING_BATCH_MS_DEFAULT = 1800000;
        DURABILITY_AUDIT_BATCH_EVENTS_FLUSH_FREQUENCY_MS_DEFAULT = 900000;
        DURABILITY_AUDIT_INITIAL_JOB_DELAY_MS_DEFAULT = 900000L;
        BROKER_LOAD_UPDATE_METRIC_TAGS_INTERVAL_MS_DEFAULT = Duration.ofSeconds(60L).toMillis();
        BROKER_LOAD_WINDOW_SIZE_MS_DEFAULT = Duration.ofSeconds(60L).toMillis();
        BROKER_LOAD_START_METRIC_DELAY_MS_DEFAULT = Duration.ofMinutes(3L).toMillis();
        PROXY_PROTOCOL_VERSION_DEFAULT = ProxyProtocol.NONE.toString();
        PROXY_PROTOCOL_FALLBACK_ENABLED_DEFAULT = false;
        CONSUMER_LAG_EMITTER_INTERVAL_MS_DEFAULT = Duration.ofSeconds(60L).toMillis();
        REQUIRE_COMPATIBLE_KEYSTORE_UPDATE_DEFAULT = true;
        ELIGIBLE_CONTROLLERS_DEFAULT = Collections.emptyList();
    }

    public static class EligibleControllersValidator
    implements ConfigDef.Validator {
        @Override
        public void ensureValid(String name, Object value) {
            if (!(value instanceof List)) {
                throw new ConfigException("Unexpected value `" + value + "` for config `" + name + "` (should be a comma-separated list of broker IDs)");
            }
            List lst = (List)value;
            for (Object item : lst) {
                if (item instanceof Integer) continue;
                if (item instanceof String) {
                    try {
                        Integer.parseInt((String)item);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new ConfigException("Unexpected list item `" + item + "` found in config `" + name + "` (each list item should be an integral broker ID)");
                    }
                }
                throw new ConfigException("Unexpected list item `" + item + "` found in config `" + name + "` (each list item should be an integral broker ID)");
            }
        }
    }

    public static enum ClientType {
        PRODUCER("producer", ProducerConfig.configNames()),
        CONSUMER("consumer", ConsumerConfig.configNames()),
        ADMIN("admin", AdminClientConfig.configNames()),
        COORDINATOR("coordinator", ConsumerConfig.configNames());

        final String type;
        final Set<String> configNames;

        private ClientType(String type, Set<String> configNames) {
            this.type = type;
            this.configNames = configNames;
        }
    }

    public static class ChecksumEnabledFilesValidator
    implements ConfigDef.Validator {
        @Override
        public void ensureValid(String name, Object value) {
            if (value == null) {
                throw new ConfigException(name, (Object)null);
            }
            ConfigDef.ValidList validList = ConfigDef.ValidList.in(ConfluentConfigs.CHECKSUM_ENABLED_FILES_ALL, ConfluentConfigs.CHECKSUM_ENABLED_FILES_TIERSTATE, "none");
            validList.ensureValid(name, value);
            List values = (List)value;
            if (values.contains(ConfluentConfigs.CHECKSUM_ENABLED_FILES_ALL) && values.contains("none")) {
                throw new ConfigException("Invalid configuration value for confluent.checksum.enabled.files. Value should only contain one of all or none");
            }
            if (values.contains(ConfluentConfigs.CHECKSUM_ENABLED_FILES_ALL) && values.size() != 1) {
                throw new ConfigException("Invalid configuration value for confluent.checksum.enabled.files. Value should only contain all");
            }
            if (values.contains("none") && values.size() != 1) {
                throw new ConfigException("Invalid configuration value for confluent.checksum.enabled.files. Value should only contain none");
            }
        }
    }

    public static enum ClusterLinkQuotaMode {
        CLUSTER_LINK_ONLY,
        TOTAL_INBOUND;

    }

    public static enum BalancerSelfHealMode {
        EMPTY_BROKER,
        ANY_UNEVEN_LOAD;

    }
}

