/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AlterMirrorTopicsRequestData
implements ApiMessage {
    List<AlterMirrorTopic> alterMirrorTopics;
    boolean validateOnly;
    int timeoutMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("alter_mirror_topics", new CompactArrayOf(AlterMirrorTopic.SCHEMA_0), "The mirror topics to modify."), new Field("validate_only", Type.BOOLEAN, "Whether to validate that the mirror topic can be updated with this request data."), new Field("timeout_ms", Type.INT32, "The time, in milliseconds, to allow for request completion."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public AlterMirrorTopicsRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public AlterMirrorTopicsRequestData() {
        this.alterMirrorTopics = new ArrayList<AlterMirrorTopic>(0);
        this.validateOnly = false;
        this.timeoutMs = 0;
    }

    @Override
    public short apiKey() {
        return 10023;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version, MessageContext _context) {
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field alterMirrorTopics was serialized as null");
        }
        ArrayList<AlterMirrorTopic> newCollection = new ArrayList<AlterMirrorTopic>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new AlterMirrorTopic(_readable, _version, _context));
        }
        this.alterMirrorTopics = newCollection;
        this.validateOnly = _readable.readByte() != 0;
        this.timeoutMs = _readable.readInt();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeUnsignedVarint(this.alterMirrorTopics.size() + 1);
        for (AlterMirrorTopic alterMirrorTopicsElement : this.alterMirrorTopics) {
            alterMirrorTopicsElement.write(_writable, _cache, _version, _context);
        }
        _writable.writeByte(this.validateOnly ? (byte)1 : 0);
        _writable.writeInt(this.timeoutMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.alterMirrorTopics.size() + 1));
        for (AlterMirrorTopic alterMirrorTopicsElement : this.alterMirrorTopics) {
            alterMirrorTopicsElement.addSize(_size, _cache, _version, _context);
        }
        _size.addBytes(1);
        _size.addBytes(4);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterMirrorTopicsRequestData)) {
            return false;
        }
        AlterMirrorTopicsRequestData other = (AlterMirrorTopicsRequestData)obj;
        if (this.alterMirrorTopics == null ? other.alterMirrorTopics != null : !this.alterMirrorTopics.equals(other.alterMirrorTopics)) {
            return false;
        }
        if (this.validateOnly != other.validateOnly) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.alterMirrorTopics == null ? 0 : this.alterMirrorTopics.hashCode());
        hashCode = 31 * hashCode + (this.validateOnly ? 1231 : 1237);
        hashCode = 31 * hashCode + this.timeoutMs;
        return hashCode;
    }

    @Override
    public AlterMirrorTopicsRequestData duplicate() {
        AlterMirrorTopicsRequestData _duplicate = new AlterMirrorTopicsRequestData();
        ArrayList<AlterMirrorTopic> newAlterMirrorTopics = new ArrayList<AlterMirrorTopic>(this.alterMirrorTopics.size());
        for (AlterMirrorTopic _element : this.alterMirrorTopics) {
            newAlterMirrorTopics.add(_element.duplicate());
        }
        _duplicate.alterMirrorTopics = newAlterMirrorTopics;
        _duplicate.validateOnly = this.validateOnly;
        _duplicate.timeoutMs = this.timeoutMs;
        return _duplicate;
    }

    public String toString() {
        return "AlterMirrorTopicsRequestData(alterMirrorTopics=" + MessageUtil.deepToString(this.alterMirrorTopics.iterator()) + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ", timeoutMs=" + this.timeoutMs + ")";
    }

    public List<AlterMirrorTopic> alterMirrorTopics() {
        return this.alterMirrorTopics;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterMirrorTopicsRequestData setAlterMirrorTopics(List<AlterMirrorTopic> v) {
        this.alterMirrorTopics = v;
        return this;
    }

    public AlterMirrorTopicsRequestData setValidateOnly(boolean v) {
        this.validateOnly = v;
        return this;
    }

    public AlterMirrorTopicsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public static class AlterMirrorTopic
    implements Message {
        String topic;
        String mirrorTopicState;
        List<Long> stoppedLogEndOffsets;
        boolean promoted;
        boolean linkLevelPause;
        boolean topicLevelPause;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic", Type.COMPACT_STRING, "The name of the mirror topic."), new Field("mirror_topic_state", Type.COMPACT_STRING, "The new state of the mirror topic. Valid States: Mirror, FailedMirror, PendingStoppedMirror, PausedMirror and StoppedMirror"), Field.TaggedFieldsSection.of(0, new Field("stopped_log_end_offsets", CompactArrayOf.nullable(Type.INT64), "List of log end offsets ordered by partition ids that the mirror topic was stopped at if mirror topic was state. Null if mirror topic is not stopped."), 1, new Field("promoted", Type.BOOLEAN, "Should the mirror synchronize with the source before stopping"), 2, new Field("link_level_pause", Type.BOOLEAN, "True if this pause transition was at the link level."), 3, new Field("topic_level_pause", Type.BOOLEAN, "True if the mirror topic was paused.")));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public AlterMirrorTopic(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public AlterMirrorTopic() {
            this.topic = "";
            this.mirrorTopicState = "";
            this.stoppedLogEndOffsets = null;
            this.promoted = false;
            this.linkLevelPause = false;
            this.topicLevelPause = false;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AlterMirrorTopic");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field mirrorTopicState was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field mirrorTopicState had invalid length " + length);
            }
            this.mirrorTopicState = _readable.readString(length);
            this.stoppedLogEndOffsets = null;
            this.promoted = false;
            this.linkLevelPause = false;
            this.topicLevelPause = false;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            block6: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 0: {
                        int arrayLength = _readable.readUnsignedVarint() - 1;
                        if (arrayLength < 0) {
                            this.stoppedLogEndOffsets = null;
                            continue block6;
                        }
                        ArrayList<Long> newCollection = new ArrayList<Long>(arrayLength);
                        for (int i = 0; i < arrayLength; ++i) {
                            newCollection.add(_readable.readLong());
                        }
                        this.stoppedLogEndOffsets = newCollection;
                        continue block6;
                    }
                    case 1: {
                        this.promoted = _readable.readByte() != 0;
                        continue block6;
                    }
                    case 2: {
                        this.linkLevelPause = _readable.readByte() != 0;
                        continue block6;
                    }
                    case 3: {
                        this.topicLevelPause = _readable.readByte() != 0;
                        continue block6;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.topic);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.mirrorTopicState);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            if (this.stoppedLogEndOffsets != null) {
                ++_numTaggedFields;
            }
            if (this.promoted) {
                ++_numTaggedFields;
            }
            if (this.linkLevelPause) {
                ++_numTaggedFields;
            }
            if (this.topicLevelPause) {
                ++_numTaggedFields;
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            if (this.stoppedLogEndOffsets != null) {
                _writable.writeUnsignedVarint(0);
                _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.stoppedLogEndOffsets));
                _writable.writeUnsignedVarint(this.stoppedLogEndOffsets.size() + 1);
                for (Long stoppedLogEndOffsetsElement : this.stoppedLogEndOffsets) {
                    _writable.writeLong(stoppedLogEndOffsetsElement);
                }
            }
            if (this.promoted) {
                _writable.writeUnsignedVarint(1);
                _writable.writeUnsignedVarint(1);
                _writable.writeByte(this.promoted ? (byte)1 : 0);
            }
            if (this.linkLevelPause) {
                _writable.writeUnsignedVarint(2);
                _writable.writeUnsignedVarint(1);
                _writable.writeByte(this.linkLevelPause ? (byte)1 : 0);
            }
            if (this.topicLevelPause) {
                _writable.writeUnsignedVarint(3);
                _writable.writeUnsignedVarint(1);
                _writable.writeByte(this.topicLevelPause ? (byte)1 : 0);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AlterMirrorTopic");
            }
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topic).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.topic, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _stringBytes = this.mirrorTopicState.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'mirrorTopicState' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.mirrorTopicState, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this.stoppedLogEndOffsets != null) {
                ++_numTaggedFields;
                _size.addBytes(1);
                int _sizeBeforeArray = _size.totalSize();
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.stoppedLogEndOffsets.size() + 1));
                _size.addBytes(this.stoppedLogEndOffsets.size() * 8);
                int _arraySize = _size.totalSize() - _sizeBeforeArray;
                _cache.setArraySizeInBytes(this.stoppedLogEndOffsets, _arraySize);
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
            }
            if (this.promoted) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(1);
            }
            if (this.linkLevelPause) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(1);
            }
            if (this.topicLevelPause) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(1);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterMirrorTopic)) {
                return false;
            }
            AlterMirrorTopic other = (AlterMirrorTopic)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.mirrorTopicState == null ? other.mirrorTopicState != null : !this.mirrorTopicState.equals(other.mirrorTopicState)) {
                return false;
            }
            if (this.stoppedLogEndOffsets == null ? other.stoppedLogEndOffsets != null : !this.stoppedLogEndOffsets.equals(other.stoppedLogEndOffsets)) {
                return false;
            }
            if (this.promoted != other.promoted) {
                return false;
            }
            if (this.linkLevelPause != other.linkLevelPause) {
                return false;
            }
            if (this.topicLevelPause != other.topicLevelPause) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.mirrorTopicState == null ? 0 : this.mirrorTopicState.hashCode());
            hashCode = 31 * hashCode + (this.stoppedLogEndOffsets == null ? 0 : this.stoppedLogEndOffsets.hashCode());
            hashCode = 31 * hashCode + (this.promoted ? 1231 : 1237);
            hashCode = 31 * hashCode + (this.linkLevelPause ? 1231 : 1237);
            hashCode = 31 * hashCode + (this.topicLevelPause ? 1231 : 1237);
            return hashCode;
        }

        @Override
        public AlterMirrorTopic duplicate() {
            AlterMirrorTopic _duplicate = new AlterMirrorTopic();
            _duplicate.topic = this.topic;
            _duplicate.mirrorTopicState = this.mirrorTopicState;
            if (this.stoppedLogEndOffsets == null) {
                _duplicate.stoppedLogEndOffsets = null;
            } else {
                ArrayList<Long> newStoppedLogEndOffsets = new ArrayList<Long>(this.stoppedLogEndOffsets.size());
                for (Long _element : this.stoppedLogEndOffsets) {
                    newStoppedLogEndOffsets.add(_element);
                }
                _duplicate.stoppedLogEndOffsets = newStoppedLogEndOffsets;
            }
            _duplicate.promoted = this.promoted;
            _duplicate.linkLevelPause = this.linkLevelPause;
            _duplicate.topicLevelPause = this.topicLevelPause;
            return _duplicate;
        }

        public String toString() {
            return "AlterMirrorTopic(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", mirrorTopicState=" + (this.mirrorTopicState == null ? "null" : "'" + this.mirrorTopicState.toString() + "'") + ", stoppedLogEndOffsets=" + (this.stoppedLogEndOffsets == null ? "null" : MessageUtil.deepToString(this.stoppedLogEndOffsets.iterator())) + ", promoted=" + (this.promoted ? "true" : "false") + ", linkLevelPause=" + (this.linkLevelPause ? "true" : "false") + ", topicLevelPause=" + (this.topicLevelPause ? "true" : "false") + ")";
        }

        public String topic() {
            return this.topic;
        }

        public String mirrorTopicState() {
            return this.mirrorTopicState;
        }

        public List<Long> stoppedLogEndOffsets() {
            return this.stoppedLogEndOffsets;
        }

        public boolean promoted() {
            return this.promoted;
        }

        public boolean linkLevelPause() {
            return this.linkLevelPause;
        }

        public boolean topicLevelPause() {
            return this.topicLevelPause;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AlterMirrorTopic setTopic(String v) {
            this.topic = v;
            return this;
        }

        public AlterMirrorTopic setMirrorTopicState(String v) {
            this.mirrorTopicState = v;
            return this;
        }

        public AlterMirrorTopic setStoppedLogEndOffsets(List<Long> v) {
            this.stoppedLogEndOffsets = v;
            return this;
        }

        public AlterMirrorTopic setPromoted(boolean v) {
            this.promoted = v;
            return this;
        }

        public AlterMirrorTopic setLinkLevelPause(boolean v) {
            this.linkLevelPause = v;
            return this;
        }

        public AlterMirrorTopic setTopicLevelPause(boolean v) {
            this.topicLevelPause = v;
            return this;
        }
    }
}

