/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.producer.internals.ProducerMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProducerMetadataTest {
    private static final long METADATA_IDLE_MS = 60000L;
    private long refreshBackoffMs = 100L;
    private long metadataExpireMs = 1000L;
    private ProducerMetadata metadata = new ProducerMetadata(this.refreshBackoffMs, this.metadataExpireMs, 60000L, new LogContext(), new ClusterResourceListeners(), Time.SYSTEM);
    private AtomicReference<Exception> backgroundError = new AtomicReference();

    @AfterEach
    public void tearDown() {
        Assertions.assertNull((Object)this.backgroundError.get(), (String)("Exception in background thread : " + this.backgroundError.get()));
    }

    @Test
    public void testMetadata() throws Exception {
        long time = Time.SYSTEM.milliseconds();
        String topic = "my-topic";
        this.metadata.add(topic, time);
        this.metadata.updateWithCurrentRequestVersion(this.responseWithTopics(Collections.emptySet()), false, time);
        Assertions.assertTrue((this.metadata.timeToNextUpdate(time) > 0L ? 1 : 0) != 0, (String)"No update needed.");
        this.metadata.requestUpdate();
        Assertions.assertTrue((this.metadata.timeToNextUpdate(time) > 0L ? 1 : 0) != 0, (String)"Still no updated needed due to backoff");
        Assertions.assertEquals((long)0L, (long)this.metadata.timeToNextUpdate(time += this.refreshBackoffMs), (String)"Update needed now that backoff time expired");
        Thread t1 = this.asyncFetch(topic, 500L);
        Thread t2 = this.asyncFetch(topic, 500L);
        Assertions.assertTrue((boolean)t1.isAlive(), (String)"Awaiting update");
        Assertions.assertTrue((boolean)t2.isAlive(), (String)"Awaiting update");
        while (t1.isAlive() || t2.isAlive()) {
            if (this.metadata.timeToNextUpdate(time) == 0L) {
                this.metadata.updateWithCurrentRequestVersion(this.responseWithCurrentTopics(), false, time);
                time += this.refreshBackoffMs;
            }
            Thread.sleep(1L);
        }
        t1.join();
        t2.join();
        Assertions.assertTrue((this.metadata.timeToNextUpdate(time) > 0L ? 1 : 0) != 0, (String)"No update needed.");
        Assertions.assertEquals((long)0L, (long)this.metadata.timeToNextUpdate(time += this.metadataExpireMs), (String)"Update needed due to stale metadata.");
    }

    @Test
    public void testMetadataAwaitAfterClose() throws InterruptedException {
        long time = 0L;
        this.metadata.updateWithCurrentRequestVersion(this.responseWithCurrentTopics(), false, time);
        Assertions.assertTrue((this.metadata.timeToNextUpdate(time) > 0L ? 1 : 0) != 0, (String)"No update needed.");
        this.metadata.requestUpdate();
        Assertions.assertTrue((this.metadata.timeToNextUpdate(time) > 0L ? 1 : 0) != 0, (String)"Still no updated needed due to backoff");
        Assertions.assertEquals((long)0L, (long)this.metadata.timeToNextUpdate(time += this.refreshBackoffMs), (String)"Update needed now that backoff time expired");
        String topic = "my-topic";
        this.metadata.close();
        Thread t1 = this.asyncFetch(topic, 500L);
        t1.join();
        Assertions.assertEquals(KafkaException.class, this.backgroundError.get().getClass());
        Assertions.assertTrue((boolean)this.backgroundError.get().toString().contains("Requested metadata update after close"));
        this.clearBackgroundError();
    }

    @Test
    public void testMetadataUpdateWaitTime() throws Exception {
        long time = 0L;
        this.metadata.updateWithCurrentRequestVersion(this.responseWithCurrentTopics(), false, time);
        Assertions.assertTrue((this.metadata.timeToNextUpdate(time) > 0L ? 1 : 0) != 0, (String)"No update needed.");
        try {
            this.metadata.awaitUpdate(this.metadata.requestUpdate(), 0L);
            Assertions.fail((String)"Wait on metadata update was expected to timeout, but it didn't");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        long twoSecondWait = 2000L;
        try {
            this.metadata.awaitUpdate(this.metadata.requestUpdate(), 2000L);
            Assertions.fail((String)"Wait on metadata update was expected to timeout, but it didn't");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Test
    public void testTimeToNextUpdateOverwriteBackoff() {
        long now = 10000L;
        this.metadata.updateWithCurrentRequestVersion(this.responseWithCurrentTopics(), false, now);
        this.metadata.add("new-topic", now);
        Assertions.assertEquals((long)0L, (long)this.metadata.timeToNextUpdate(now));
        this.metadata.updateWithCurrentRequestVersion(this.responseWithCurrentTopics(), false, now);
        this.metadata.add("new-topic", now);
        Assertions.assertEquals((long)this.metadataExpireMs, (long)this.metadata.timeToNextUpdate(now));
        this.metadata.add("another-new-topic", now);
        Assertions.assertEquals((long)0L, (long)this.metadata.timeToNextUpdate(now));
    }

    @Test
    public void testTopicExpiry() {
        long time = 0L;
        String topic1 = "topic1";
        this.metadata.add("topic1", time);
        this.metadata.updateWithCurrentRequestVersion(this.responseWithCurrentTopics(), false, time);
        Assertions.assertTrue((boolean)this.metadata.containsTopic("topic1"));
        this.metadata.updateWithCurrentRequestVersion(this.responseWithCurrentTopics(), false, time += 60000L);
        Assertions.assertFalse((boolean)this.metadata.containsTopic("topic1"), (String)"Unused topic not expired");
        String topic2 = "topic2";
        this.metadata.add("topic2", time);
        this.metadata.updateWithCurrentRequestVersion(this.responseWithCurrentTopics(), false, time);
        for (int i = 0; i < 3; ++i) {
            this.metadata.updateWithCurrentRequestVersion(this.responseWithCurrentTopics(), false, time += 30000L);
            Assertions.assertTrue((boolean)this.metadata.containsTopic("topic2"), (String)"Topic expired even though in use");
            this.metadata.add("topic2", time);
        }
        String topic3 = "topic3";
        this.metadata.add("topic3", time);
        this.metadata.updateWithCurrentRequestVersion(this.responseWithCurrentTopics(), false, time += 120000L);
        Assertions.assertTrue((boolean)this.metadata.containsTopic("topic3"), (String)"Topic expired while awaiting metadata");
    }

    @Test
    public void testMetadataWaitAbortedOnFatalException() {
        this.metadata.fatalError((KafkaException)((Object)new AuthenticationException("Fatal exception from test")));
        Assertions.assertThrows(AuthenticationException.class, () -> this.metadata.awaitUpdate(0, 1000L));
    }

    @Test
    public void testMetadataPartialUpdate() {
        long now = 10000L;
        String topic1 = "topic-one";
        this.metadata.add("topic-one", now);
        Assertions.assertTrue((boolean)this.metadata.updateRequested());
        Assertions.assertEquals((long)0L, (long)this.metadata.timeToNextUpdate(now));
        Assertions.assertEquals((Object)this.metadata.topics(), Collections.singleton("topic-one"));
        Assertions.assertEquals((Object)this.metadata.newTopics(), Collections.singleton("topic-one"));
        this.metadata.updateWithCurrentRequestVersion(this.responseWithTopics(Collections.singleton("topic-one")), true, now += 1000L);
        Assertions.assertFalse((boolean)this.metadata.updateRequested());
        Assertions.assertEquals((Object)this.metadata.topics(), Collections.singleton("topic-one"));
        Assertions.assertEquals((Object)this.metadata.newTopics(), Collections.emptySet());
        this.metadata.add("topic-one", now);
        Assertions.assertFalse((boolean)this.metadata.updateRequested());
        Assertions.assertTrue((this.metadata.timeToNextUpdate(now) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((Object)this.metadata.topics(), Collections.singleton("topic-one"));
        Assertions.assertEquals((Object)this.metadata.newTopics(), Collections.emptySet());
        String topic2 = "topic-two";
        this.metadata.add("topic-two", now += 1000L);
        String topic3 = "topic-three";
        this.metadata.add("topic-three", now += 1000L);
        Assertions.assertTrue((boolean)this.metadata.updateRequested());
        Assertions.assertEquals((long)0L, (long)this.metadata.timeToNextUpdate(now));
        Assertions.assertEquals((Object)this.metadata.topics(), new HashSet<String>(Arrays.asList("topic-one", "topic-two", "topic-three")));
        Assertions.assertEquals((Object)this.metadata.newTopics(), new HashSet<String>(Arrays.asList("topic-two", "topic-three")));
        Assertions.assertTrue((boolean)this.metadata.updateRequested());
        this.metadata.updateWithCurrentRequestVersion(this.responseWithTopics(Collections.singleton("topic-two")), true, now += 1000L);
        Assertions.assertEquals((Object)this.metadata.topics(), new HashSet<String>(Arrays.asList("topic-one", "topic-two", "topic-three")));
        Assertions.assertEquals((Object)this.metadata.newTopics(), Collections.singleton("topic-three"));
    }

    @Test
    public void testRequestUpdateForTopic() {
        long now = 10000L;
        String topic1 = "topic-1";
        String topic2 = "topic-2";
        this.metadata.add("topic-1", now);
        this.metadata.add("topic-2", now);
        Assertions.assertTrue((boolean)this.metadata.updateRequested());
        this.metadata.requestUpdateForTopic("topic-1");
        Assertions.assertTrue((boolean)this.metadata.updateRequested());
        this.metadata.updateWithCurrentRequestVersion(this.responseWithTopics(Collections.singleton("topic-1")), true, now += 1000L);
        Assertions.assertFalse((boolean)this.metadata.updateRequested());
        this.metadata.requestUpdateForTopic("topic-1");
        Assertions.assertTrue((boolean)this.metadata.updateRequested());
        this.metadata.updateWithCurrentRequestVersion(this.responseWithTopics(Collections.singleton("topic-1")), true, now += 1000L);
        Assertions.assertTrue((boolean)this.metadata.updateRequested());
        this.metadata.updateWithCurrentRequestVersion(this.responseWithTopics(new HashSet<String>(Arrays.asList("topic-1", "topic-2"))), false, now += 1000L);
        Assertions.assertFalse((boolean)this.metadata.updateRequested());
    }

    private MetadataResponse responseWithCurrentTopics() {
        return this.responseWithTopics(this.metadata.topics());
    }

    private MetadataResponse responseWithTopics(Set<String> topics) {
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        for (String topic : topics) {
            partitionCounts.put(topic, 1);
        }
        return RequestTestUtils.metadataUpdateWith(1, partitionCounts);
    }

    private void clearBackgroundError() {
        this.backgroundError.set(null);
    }

    private Thread asyncFetch(String topic, long maxWaitMs) {
        Thread thread = new Thread(() -> {
            try {
                while (this.metadata.fetch().partitionsForTopic(topic).isEmpty()) {
                    this.metadata.awaitUpdate(this.metadata.requestUpdate(), maxWaitMs);
                }
            }
            catch (Exception e) {
                this.backgroundError.set(e);
            }
        });
        thread.start();
        return thread;
    }
}

