/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ListPartitionReassignmentsResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    List<OngoingTopicReassignment> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The top-level error code, or 0 if there was no error"), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The top-level error message, or null if there was no error."), new Field("topics", new CompactArrayOf(OngoingTopicReassignment.SCHEMA_0), "The ongoing reassignments for each topic."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public ListPartitionReassignmentsResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ListPartitionReassignmentsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.topics = new ArrayList<OngoingTopicReassignment>(0);
    }

    @Override
    public short apiKey() {
        return 46;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
        }
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<OngoingTopicReassignment> newCollection = new ArrayList<OngoingTopicReassignment>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new OngoingTopicReassignment(_readable, _version, _context));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeUnsignedVarint(this.topics.size() + 1);
        _stringBytes = this.topics.iterator();
        while (_stringBytes.hasNext()) {
            OngoingTopicReassignment topicsElement = (OngoingTopicReassignment)_stringBytes.next();
            topicsElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(1);
        } else {
            byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        for (OngoingTopicReassignment topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ListPartitionReassignmentsResponseData)) {
            return false;
        }
        ListPartitionReassignmentsResponseData other = (ListPartitionReassignmentsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public ListPartitionReassignmentsResponseData duplicate() {
        ListPartitionReassignmentsResponseData _duplicate = new ListPartitionReassignmentsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        ArrayList<OngoingTopicReassignment> newTopics = new ArrayList<OngoingTopicReassignment>(this.topics.size());
        for (OngoingTopicReassignment _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "ListPartitionReassignmentsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<OngoingTopicReassignment> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ListPartitionReassignmentsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public ListPartitionReassignmentsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public ListPartitionReassignmentsResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public ListPartitionReassignmentsResponseData setTopics(List<OngoingTopicReassignment> v) {
        this.topics = v;
        return this;
    }

    public static class OngoingPartitionReassignment
    implements Message {
        int partitionIndex;
        List<Integer> replicas;
        List<Integer> observers;
        List<Integer> addingReplicas;
        List<Integer> removingReplicas;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The index of the partition."), new Field("replicas", new CompactArrayOf(Type.INT32), "The current replica set."), new Field("adding_replicas", new CompactArrayOf(Type.INT32), "The set of replicas we are currently adding."), new Field("removing_replicas", new CompactArrayOf(Type.INT32), "The set of replicas we are currently removing."), Field.TaggedFieldsSection.of(10000, new Field("observers", new CompactArrayOf(Type.INT32), "The brokers in Replicas that are observers in a partition.")));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public OngoingPartitionReassignment(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public OngoingPartitionReassignment() {
            this.partitionIndex = 0;
            this.replicas = new ArrayList<Integer>(0);
            this.observers = new ArrayList<Integer>(0);
            this.addingReplicas = new ArrayList<Integer>(0);
            this.removingReplicas = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OngoingPartitionReassignment");
            }
            this.partitionIndex = _readable.readInt();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field replicas was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.replicas = newCollection;
            this.observers = new ArrayList<Integer>(0);
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field addingReplicas was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.addingReplicas = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field removingReplicas was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.removingReplicas = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            block6: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 10000: {
                        int arrayLength2 = _readable.readUnsignedVarint() - 1;
                        if (arrayLength2 < 0) {
                            throw new RuntimeException("non-nullable field observers was serialized as null");
                        }
                        if (arrayLength2 > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        ArrayList<Integer> newCollection2 = new ArrayList<Integer>(arrayLength2);
                        for (int i2 = 0; i2 < arrayLength2; ++i2) {
                            newCollection2.add(_readable.readInt());
                        }
                        this.observers = newCollection2;
                        continue block6;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeUnsignedVarint(this.replicas.size() + 1);
            for (Integer replicasElement : this.replicas) {
                _writable.writeInt(replicasElement);
            }
            if (!this.observers.isEmpty()) {
                ++_numTaggedFields;
            }
            _writable.writeUnsignedVarint(this.addingReplicas.size() + 1);
            for (Integer addingReplicasElement : this.addingReplicas) {
                _writable.writeInt(addingReplicasElement);
            }
            _writable.writeUnsignedVarint(this.removingReplicas.size() + 1);
            for (Integer removingReplicasElement : this.removingReplicas) {
                _writable.writeInt(removingReplicasElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, 10000);
            if (!this.observers.isEmpty()) {
                _writable.writeUnsignedVarint(10000);
                _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.observers));
                _writable.writeUnsignedVarint(this.observers.size() + 1);
                for (Integer observersElement : this.observers) {
                    _writable.writeInt(observersElement);
                }
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of OngoingPartitionReassignment");
            }
            _size.addBytes(4);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.replicas.size() + 1));
            _size.addBytes(this.replicas.size() * 4);
            if (!this.observers.isEmpty()) {
                ++_numTaggedFields;
                _size.addBytes(2);
                int _sizeBeforeArray = _size.totalSize();
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.observers.size() + 1));
                _size.addBytes(this.observers.size() * 4);
                int _arraySize = _size.totalSize() - _sizeBeforeArray;
                _cache.setArraySizeInBytes(this.observers, _arraySize);
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.addingReplicas.size() + 1));
            _size.addBytes(this.addingReplicas.size() * 4);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.removingReplicas.size() + 1));
            _size.addBytes(this.removingReplicas.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OngoingPartitionReassignment)) {
                return false;
            }
            OngoingPartitionReassignment other = (OngoingPartitionReassignment)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.replicas == null ? other.replicas != null : !this.replicas.equals(other.replicas)) {
                return false;
            }
            if (this.observers == null ? other.observers != null : !this.observers.equals(other.observers)) {
                return false;
            }
            if (this.addingReplicas == null ? other.addingReplicas != null : !this.addingReplicas.equals(other.addingReplicas)) {
                return false;
            }
            if (this.removingReplicas == null ? other.removingReplicas != null : !this.removingReplicas.equals(other.removingReplicas)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + (this.replicas == null ? 0 : this.replicas.hashCode());
            hashCode = 31 * hashCode + (this.observers == null ? 0 : this.observers.hashCode());
            hashCode = 31 * hashCode + (this.addingReplicas == null ? 0 : this.addingReplicas.hashCode());
            hashCode = 31 * hashCode + (this.removingReplicas == null ? 0 : this.removingReplicas.hashCode());
            return hashCode;
        }

        @Override
        public OngoingPartitionReassignment duplicate() {
            OngoingPartitionReassignment _duplicate = new OngoingPartitionReassignment();
            _duplicate.partitionIndex = this.partitionIndex;
            ArrayList<Integer> newReplicas = new ArrayList<Integer>(this.replicas.size());
            for (Integer n : this.replicas) {
                newReplicas.add(n);
            }
            _duplicate.replicas = newReplicas;
            ArrayList<Integer> newObservers = new ArrayList<Integer>(this.observers.size());
            for (Integer n : this.observers) {
                newObservers.add(n);
            }
            _duplicate.observers = newObservers;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(this.addingReplicas.size());
            for (Integer _element : this.addingReplicas) {
                arrayList.add(_element);
            }
            _duplicate.addingReplicas = arrayList;
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>(this.removingReplicas.size());
            for (Integer _element : this.removingReplicas) {
                arrayList2.add(_element);
            }
            _duplicate.removingReplicas = arrayList2;
            return _duplicate;
        }

        public String toString() {
            return "OngoingPartitionReassignment(partitionIndex=" + this.partitionIndex + ", replicas=" + MessageUtil.deepToString(this.replicas.iterator()) + ", observers=" + MessageUtil.deepToString(this.observers.iterator()) + ", addingReplicas=" + MessageUtil.deepToString(this.addingReplicas.iterator()) + ", removingReplicas=" + MessageUtil.deepToString(this.removingReplicas.iterator()) + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public List<Integer> replicas() {
            return this.replicas;
        }

        public List<Integer> observers() {
            return this.observers;
        }

        public List<Integer> addingReplicas() {
            return this.addingReplicas;
        }

        public List<Integer> removingReplicas() {
            return this.removingReplicas;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OngoingPartitionReassignment setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public OngoingPartitionReassignment setReplicas(List<Integer> v) {
            this.replicas = v;
            return this;
        }

        public OngoingPartitionReassignment setObservers(List<Integer> v) {
            this.observers = v;
            return this;
        }

        public OngoingPartitionReassignment setAddingReplicas(List<Integer> v) {
            this.addingReplicas = v;
            return this;
        }

        public OngoingPartitionReassignment setRemovingReplicas(List<Integer> v) {
            this.removingReplicas = v;
            return this;
        }
    }

    public static class OngoingTopicReassignment
    implements Message {
        String name;
        List<OngoingPartitionReassignment> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), new Field("partitions", new CompactArrayOf(OngoingPartitionReassignment.SCHEMA_0), "The ongoing reassignments for each partition."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public OngoingTopicReassignment(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public OngoingTopicReassignment() {
            this.name = "";
            this.partitions = new ArrayList<OngoingPartitionReassignment>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of OngoingTopicReassignment");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<OngoingPartitionReassignment> newCollection = new ArrayList<OngoingPartitionReassignment>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new OngoingPartitionReassignment(_readable, _version, _context));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                OngoingPartitionReassignment partitionsElement = (OngoingPartitionReassignment)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of OngoingTopicReassignment");
            }
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.name).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            for (OngoingPartitionReassignment partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OngoingTopicReassignment)) {
                return false;
            }
            OngoingTopicReassignment other = (OngoingTopicReassignment)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public OngoingTopicReassignment duplicate() {
            OngoingTopicReassignment _duplicate = new OngoingTopicReassignment();
            _duplicate.name = this.name;
            ArrayList<OngoingPartitionReassignment> newPartitions = new ArrayList<OngoingPartitionReassignment>(this.partitions.size());
            for (OngoingPartitionReassignment _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "OngoingTopicReassignment(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<OngoingPartitionReassignment> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public OngoingTopicReassignment setName(String v) {
            this.name = v;
            return this;
        }

        public OngoingTopicReassignment setPartitions(List<OngoingPartitionReassignment> v) {
            this.partitions = v;
            return this;
        }
    }
}

