/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.utils.LogAction;

public class DetailedRequestAuditLogFilter
implements RequestLogFilter {
    public static final String ENABLE_DETAILED_AUDIT_LOGGING = "confluent.security.event.logger.enable.detailed.audit.logs";
    public static final String DISABLED_APIS_FOR_AUDIT_LOGS = "confluent.security.event.logger.detailed.audit.logs.disabled.apis";
    public static final EnumSet<ApiKeys> SUPPORTED_APIS = EnumSet.of(ApiKeys.CREATE_TOPICS, new ApiKeys[]{ApiKeys.DELETE_TOPICS, ApiKeys.CREATE_PARTITIONS, ApiKeys.CREATE_ACLS, ApiKeys.DELETE_ACLS, ApiKeys.CREATE_CLUSTER_LINKS, ApiKeys.DELETE_CLUSTER_LINKS, ApiKeys.DELETE_GROUPS, ApiKeys.ALTER_CONFIGS, ApiKeys.INCREMENTAL_ALTER_CONFIGS, ApiKeys.ALTER_MIRRORS});
    private static final Set<String> RECONFIGURABLE_CONFIGS = new HashSet<String>();
    private volatile boolean enableDetailedAuditLogs = true;
    private volatile Set<ApiKeys> disabledAPIs = new HashSet<ApiKeys>();

    @Override
    public LogAction processRequest(RequestContext ctx, long requestTimeNanos) {
        if (this.enableDetailedAuditLogs && SUPPORTED_APIS.contains((Object)ctx.header.apiKey()) && !this.disabledAPIs.contains((Object)ctx.header.apiKey())) {
            return LogAction.LOGGED;
        }
        return LogAction.NOT_LOGGED;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return RECONFIGURABLE_CONFIGS;
    }

    @Override
    public void reconfigure(Map<String, ?> configs) {
        this.configure(configs);
    }

    @Override
    public void configure(Map<String, ?> configs) {
        Config config = new Config(configs);
        this.enableDetailedAuditLogs = config.enableDetailedAuditLogging();
        this.disabledAPIs = config.disabledAPIs();
    }

    @Override
    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
        new Config(configs);
    }

    static {
        RECONFIGURABLE_CONFIGS.add(ENABLE_DETAILED_AUDIT_LOGGING);
        RECONFIGURABLE_CONFIGS.add(DISABLED_APIS_FOR_AUDIT_LOGS);
    }

    public static class Config
    extends AbstractConfig {
        public static final String ENABLE_DETAILED_AUDIT_LOGGING_CONFIG = "confluent.security.event.logger.enable.detailed.audit.logs";
        public static final String ENABLE_DETAILED_AUDIT_LOGGING_DOC = "config to enable detailed audit logs.This is disabled by default. Note that logging for a specific API can be disabled by `confluent.security.event.logger.detailed.audit.logs.disabled.apis` config.";
        public static final String DISABLED_APIS_FOR_AUDIT_LOGS_CONFIG = "confluent.security.event.logger.detailed.audit.logs.disabled.apis";
        public static final String DISABLED_APIS_FOR_AUDIT_LOGS_DOC = "config to disable selected APIs. For example, using `CreateTopics,DeleteTopics` will disable audit events for `CreateTopics` and DeleteTopics` APIs.";
        private static final ConfigDef CONFIG = new ConfigDef().define("confluent.security.event.logger.enable.detailed.audit.logs", ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.LOW, "config to enable detailed audit logs.This is disabled by default. Note that logging for a specific API can be disabled by `confluent.security.event.logger.detailed.audit.logs.disabled.apis` config.").define("confluent.security.event.logger.detailed.audit.logs.disabled.apis", ConfigDef.Type.STRING, "", DisabledAPIsConfigValidator.access$000(), ConfigDef.Importance.LOW, "config to disable selected APIs. For example, using `CreateTopics,DeleteTopics` will disable audit events for `CreateTopics` and DeleteTopics` APIs.");

        public Config(Map<?, ?> originals) {
            super(CONFIG, originals, true);
        }

        public boolean enableDetailedAuditLogging() {
            return this.getBoolean("confluent.security.event.logger.enable.detailed.audit.logs");
        }

        public Set<ApiKeys> disabledAPIs() {
            return Config.parseDisabledAPIsConfig(this.getString("confluent.security.event.logger.detailed.audit.logs.disabled.apis"));
        }

        private static Set<ApiKeys> parseDisabledAPIsConfig(String configValue) {
            HashSet<ApiKeys> disabledAPIs = new HashSet<ApiKeys>();
            if (configValue == null || configValue.isEmpty()) {
                return disabledAPIs;
            }
            for (String apiKeyString : configValue.split(",")) {
                ApiKeys apiKey = ApiKeys.findByName(apiKeyString);
                if (apiKey == null) {
                    throw new ConfigException("Invalid value `" + apiKeyString + "` found in " + "confluent.security.event.logger.detailed.audit.logs.disabled.apis" + "=`" + configValue + "`");
                }
                disabledAPIs.add(apiKey);
            }
            return disabledAPIs;
        }

        private static class DisabledAPIsConfigValidator
        implements ConfigDef.Validator {
            private static final DisabledAPIsConfigValidator INSTANCE = new DisabledAPIsConfigValidator();

            private DisabledAPIsConfigValidator() {
            }

            @Override
            public void ensureValid(String name, Object value) {
                if (!(value instanceof String)) {
                    throw new ConfigException("Invalid value `" + value + "` found for " + name + " (should be a string)");
                }
                Config.parseDisabledAPIsConfig((String)value);
            }

            static /* synthetic */ DisabledAPIsConfigValidator access$000() {
                return INSTANCE;
            }
        }
    }
}

