/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.stats;

import io.confluent.kafka.server.plugins.auth.stats.AuthenticationStatsMBean;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationStats
implements AuthenticationStatsMBean {
    private static final AuthenticationStats INSTANCE;
    private static final Logger log;
    private AtomicLong succeeded = new AtomicLong(0L);
    private AtomicLong failed = new AtomicLong(0L);

    public static AuthenticationStats getInstance() {
        return INSTANCE;
    }

    private AuthenticationStats() {
    }

    public void incrSucceeded() {
        this.succeeded.incrementAndGet();
    }

    public void incrFailed() {
        this.failed.incrementAndGet();
    }

    public void reset() {
        this.succeeded.set(0L);
        this.failed.set(0L);
    }

    @Override
    public long getTotal() {
        return this.succeeded.get() + this.failed.get();
    }

    @Override
    public long getSucceeded() {
        return this.succeeded.get();
    }

    @Override
    public long getFailed() {
        return this.failed.get();
    }

    public String toString() {
        return "AuthenticationStats{succeeded=" + this.succeeded + ", failed=" + this.failed + '}';
    }

    static {
        log = LoggerFactory.getLogger(AuthenticationStats.class);
        INSTANCE = new AuthenticationStats();
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        String objectName = "io.confluent.kafka.server.plugins:type=Authentication";
        try {
            ObjectName mbeanName = new ObjectName(objectName);
            mbeanServer.registerMBean(INSTANCE, mbeanName);
        }
        catch (InstanceAlreadyExistsException e) {
            log.error("Auth stats MBean already exists", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.error("Auth stats MBean registration failed", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            log.error("Auth stats MBean not compliant", (Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            log.error("Auth stats MBean is malformed: " + objectName, (Throwable)e);
        }
    }
}

