/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.CreateClusterLinksResponseData;
import org.apache.kafka.common.protocol.MessageUtil;

public class CreateClusterLinksResponseDataJsonConverter {
    public static CreateClusterLinksResponseData read(JsonNode _node, short _version) {
        CreateClusterLinksResponseData _object = new CreateClusterLinksResponseData();
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            throw new RuntimeException("CreateClusterLinksResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
        }
        _object.throttleTimeMs = MessageUtil.jsonNodeToInt(_throttleTimeMsNode, "CreateClusterLinksResponseData");
        JsonNode _entriesNode = _node.get("entries");
        if (_entriesNode == null) {
            throw new RuntimeException("CreateClusterLinksResponseData: unable to locate field 'entries', which is mandatory in version " + _version);
        }
        if (!_entriesNode.isArray()) {
            throw new RuntimeException("CreateClusterLinksResponseData expected a JSON array, but got " + _node.getNodeType());
        }
        ArrayList<CreateClusterLinksResponseData.EntryData> _collection = new ArrayList<CreateClusterLinksResponseData.EntryData>(_entriesNode.size());
        _object.entries = _collection;
        for (JsonNode _element : _entriesNode) {
            _collection.add(EntryDataJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(CreateClusterLinksResponseData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("throttleTimeMs", (JsonNode)new IntNode(_object.throttleTimeMs));
        ArrayNode _entriesArray = new ArrayNode(JsonNodeFactory.instance);
        for (CreateClusterLinksResponseData.EntryData _element : _object.entries) {
            _entriesArray.add(EntryDataJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("entries", (JsonNode)_entriesArray);
        return _node;
    }

    public static JsonNode write(CreateClusterLinksResponseData _object, short _version) {
        return CreateClusterLinksResponseDataJsonConverter.write(_object, _version, true);
    }

    public static class EntryDataJsonConverter {
        public static CreateClusterLinksResponseData.EntryData read(JsonNode _node, short _version) {
            CreateClusterLinksResponseData.EntryData _object = new CreateClusterLinksResponseData.EntryData();
            JsonNode _errorCodeNode = _node.get("errorCode");
            if (_errorCodeNode == null) {
                throw new RuntimeException("EntryData: unable to locate field 'errorCode', which is mandatory in version " + _version);
            }
            _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "EntryData");
            JsonNode _errorMessageNode = _node.get("errorMessage");
            if (_errorMessageNode == null) {
                throw new RuntimeException("EntryData: unable to locate field 'errorMessage', which is mandatory in version " + _version);
            }
            if (_errorMessageNode.isNull()) {
                _object.errorMessage = null;
            } else {
                if (!_errorMessageNode.isTextual()) {
                    throw new RuntimeException("EntryData expected a string type, but got " + _node.getNodeType());
                }
                _object.errorMessage = _errorMessageNode.asText();
            }
            JsonNode _linkNameNode = _node.get("linkName");
            if (_linkNameNode == null) {
                throw new RuntimeException("EntryData: unable to locate field 'linkName', which is mandatory in version " + _version);
            }
            if (!_linkNameNode.isTextual()) {
                throw new RuntimeException("EntryData expected a string type, but got " + _node.getNodeType());
            }
            _object.linkName = _linkNameNode.asText();
            JsonNode _linkIdNode = _node.get("linkId");
            if (_linkIdNode == null) {
                if (_version >= 2) {
                    throw new RuntimeException("EntryData: unable to locate field 'linkId', which is mandatory in version " + _version);
                }
                _object.linkId = Uuid.ZERO_UUID;
            } else {
                if (!_linkIdNode.isTextual()) {
                    throw new RuntimeException("EntryData expected a JSON string type, but got " + _node.getNodeType());
                }
                _object.linkId = Uuid.fromString(_linkIdNode.asText());
            }
            return _object;
        }

        public static JsonNode write(CreateClusterLinksResponseData.EntryData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
            if (_object.errorMessage == null) {
                _node.set("errorMessage", (JsonNode)NullNode.instance);
            } else {
                _node.set("errorMessage", (JsonNode)new TextNode(_object.errorMessage));
            }
            _node.set("linkName", (JsonNode)new TextNode(_object.linkName));
            if (_version >= 2) {
                _node.set("linkId", (JsonNode)new TextNode(_object.linkId.toString()));
            }
            return _node;
        }

        public static JsonNode write(CreateClusterLinksResponseData.EntryData _object, short _version) {
            return EntryDataJsonConverter.write(_object, _version, true);
        }
    }
}

