/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DeleteAclsResponseData
implements ApiMessage {
    int throttleTimeMs;
    List<DeleteAclsFilterResult> filterResults;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("filter_results", new ArrayOf(DeleteAclsFilterResult.SCHEMA_0), "The results for each filter."));
    public static final Schema SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("filter_results", new ArrayOf(DeleteAclsFilterResult.SCHEMA_1), "The results for each filter."));
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 3;

    public DeleteAclsResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DeleteAclsResponseData() {
        this.throttleTimeMs = 0;
        this.filterResults = new ArrayList<DeleteAclsFilterResult>(0);
    }

    @Override
    public short apiKey() {
        return 31;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        ArrayList<DeleteAclsFilterResult> newCollection;
        int arrayLength;
        this.throttleTimeMs = _readable.readInt();
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field filterResults was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DeleteAclsFilterResult(_readable, _version, _context));
            }
            this.filterResults = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field filterResults was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<DeleteAclsFilterResult>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new DeleteAclsFilterResult(_readable, _version, _context));
            }
            this.filterResults = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.filterResults.size() + 1);
            for (DeleteAclsFilterResult filterResultsElement : this.filterResults) {
                filterResultsElement.write(_writable, _cache, _version, _context);
            }
        } else {
            _writable.writeInt(this.filterResults.size());
            for (DeleteAclsFilterResult filterResultsElement : this.filterResults) {
                filterResultsElement.write(_writable, _cache, _version, _context);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.filterResults.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (DeleteAclsFilterResult filterResultsElement : this.filterResults) {
            filterResultsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteAclsResponseData)) {
            return false;
        }
        DeleteAclsResponseData other = (DeleteAclsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.filterResults == null ? other.filterResults != null : !this.filterResults.equals(other.filterResults)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.filterResults == null ? 0 : this.filterResults.hashCode());
        return hashCode;
    }

    @Override
    public DeleteAclsResponseData duplicate() {
        DeleteAclsResponseData _duplicate = new DeleteAclsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        ArrayList<DeleteAclsFilterResult> newFilterResults = new ArrayList<DeleteAclsFilterResult>(this.filterResults.size());
        for (DeleteAclsFilterResult _element : this.filterResults) {
            newFilterResults.add(_element.duplicate());
        }
        _duplicate.filterResults = newFilterResults;
        return _duplicate;
    }

    public String toString() {
        return "DeleteAclsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", filterResults=" + MessageUtil.deepToString(this.filterResults.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<DeleteAclsFilterResult> filterResults() {
        return this.filterResults;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DeleteAclsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DeleteAclsResponseData setFilterResults(List<DeleteAclsFilterResult> v) {
        this.filterResults = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("filter_results", new CompactArrayOf(DeleteAclsFilterResult.SCHEMA_2), "The results for each filter."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class DeleteAclsMatchingAcl
    implements Message {
        short errorCode;
        String errorMessage;
        byte resourceType;
        String resourceName;
        byte patternType;
        String principal;
        String host;
        byte operation;
        byte permissionType;
        List<Uuid> clusterLinkIds;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The deletion error code, or 0 if the deletion succeeded."), new Field("error_message", Type.NULLABLE_STRING, "The deletion error message, or null if the deletion succeeded."), new Field("resource_type", Type.INT8, "The ACL resource type."), new Field("resource_name", Type.STRING, "The ACL resource name."), new Field("principal", Type.STRING, "The ACL principal."), new Field("host", Type.STRING, "The ACL host."), new Field("operation", Type.INT8, "The ACL operation."), new Field("permission_type", Type.INT8, "The ACL permission type."));
        public static final Schema SCHEMA_1 = new Schema(new Field("error_code", Type.INT16, "The deletion error code, or 0 if the deletion succeeded."), new Field("error_message", Type.NULLABLE_STRING, "The deletion error message, or null if the deletion succeeded."), new Field("resource_type", Type.INT8, "The ACL resource type."), new Field("resource_name", Type.STRING, "The ACL resource name."), new Field("pattern_type", Type.INT8, "The ACL resource pattern type."), new Field("principal", Type.STRING, "The ACL principal."), new Field("host", Type.STRING, "The ACL host."), new Field("operation", Type.INT8, "The ACL operation."), new Field("permission_type", Type.INT8, "The ACL permission type."));
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public DeleteAclsMatchingAcl(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public DeleteAclsMatchingAcl() {
            this.errorCode = 0;
            this.errorMessage = "";
            this.resourceType = 0;
            this.resourceName = "";
            this.patternType = (byte)3;
            this.principal = "";
            this.host = "";
            this.operation = 0;
            this.permissionType = 0;
            this.clusterLinkIds = new ArrayList<Uuid>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeleteAclsMatchingAcl");
            }
            this.errorCode = _readable.readShort();
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
            }
            this.resourceType = _readable.readByte();
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field resourceName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field resourceName had invalid length " + length);
            }
            this.resourceName = _readable.readString(length);
            this.patternType = _version >= 1 ? _readable.readByte() : (byte)3;
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field principal was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field principal had invalid length " + length);
            }
            this.principal = _context.read(EntityType.ACL_PRINCIPAL, _readable.readString(length));
            length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.operation = _readable.readByte();
            this.permissionType = _readable.readByte();
            this.clusterLinkIds = new ArrayList<Uuid>(0);
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                block3: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        case 10000: {
                            int arrayLength = _readable.readUnsignedVarint() - 1;
                            if (arrayLength < 0) {
                                throw new RuntimeException("non-nullable field clusterLinkIds was serialized as null");
                            }
                            if (arrayLength > _readable.remaining()) {
                                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                            }
                            ArrayList<Uuid> newCollection = new ArrayList<Uuid>(arrayLength);
                            for (int i = 0; i < arrayLength; ++i) {
                                newCollection.add(_readable.readUuid());
                            }
                            this.clusterLinkIds = newCollection;
                            continue block3;
                        }
                        default: {
                            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        }
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.errorMessage);
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeByte(this.resourceType);
            _stringBytes = _cache.getSerializedValue(this.resourceName);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            if (_version >= 1) {
                _writable.writeByte(this.patternType);
            } else if (this.patternType != 3) {
                throw new UnsupportedVersionException("Attempted to write a non-default patternType at version " + _version);
            }
            _stringBytes = _cache.getSerializedValue(this.principal);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.host);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            _writable.writeByte(this.operation);
            _writable.writeByte(this.permissionType);
            if (_version >= 2 && !this.clusterLinkIds.isEmpty()) {
                ++_numTaggedFields;
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, 10000);
                if (!this.clusterLinkIds.isEmpty()) {
                    _writable.writeUnsignedVarint(10000);
                    _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.clusterLinkIds));
                    _writable.writeUnsignedVarint(this.clusterLinkIds.size() + 1);
                    for (Uuid clusterLinkIdsElement : this.clusterLinkIds) {
                        _writable.writeUuid(clusterLinkIdsElement);
                    }
                }
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DeleteAclsMatchingAcl");
            }
            _size.addBytes(2);
            if (this.errorMessage == null) {
                if (_version >= 2) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                if (_version >= 2) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            _size.addBytes(1);
            _stringBytes = this.resourceName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'resourceName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.resourceName, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 1) {
                _size.addBytes(1);
            }
            if ((_stringBytes = _context.write(EntityType.ACL_PRINCIPAL, this.principal).getBytes(StandardCharsets.UTF_8)).length > Short.MAX_VALUE) {
                throw new RuntimeException("'principal' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.principal, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.host, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            _size.addBytes(1);
            _size.addBytes(1);
            if (_version >= 2 && !this.clusterLinkIds.isEmpty()) {
                ++_numTaggedFields;
                _size.addBytes(2);
                int _sizeBeforeArray = _size.totalSize();
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.clusterLinkIds.size() + 1));
                _size.addBytes(this.clusterLinkIds.size() * 16);
                int _arraySize = _size.totalSize() - _sizeBeforeArray;
                _cache.setArraySizeInBytes(this.clusterLinkIds, _arraySize);
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeleteAclsMatchingAcl)) {
                return false;
            }
            DeleteAclsMatchingAcl other = (DeleteAclsMatchingAcl)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.resourceType != other.resourceType) {
                return false;
            }
            if (this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName)) {
                return false;
            }
            if (this.patternType != other.patternType) {
                return false;
            }
            if (this.principal == null ? other.principal != null : !this.principal.equals(other.principal)) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.operation != other.operation) {
                return false;
            }
            if (this.permissionType != other.permissionType) {
                return false;
            }
            if (this.clusterLinkIds == null ? other.clusterLinkIds != null : !this.clusterLinkIds.equals(other.clusterLinkIds)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + this.resourceType;
            hashCode = 31 * hashCode + (this.resourceName == null ? 0 : this.resourceName.hashCode());
            hashCode = 31 * hashCode + this.patternType;
            hashCode = 31 * hashCode + (this.principal == null ? 0 : this.principal.hashCode());
            hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
            hashCode = 31 * hashCode + this.operation;
            hashCode = 31 * hashCode + this.permissionType;
            hashCode = 31 * hashCode + (this.clusterLinkIds == null ? 0 : this.clusterLinkIds.hashCode());
            return hashCode;
        }

        @Override
        public DeleteAclsMatchingAcl duplicate() {
            DeleteAclsMatchingAcl _duplicate = new DeleteAclsMatchingAcl();
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            _duplicate.resourceType = this.resourceType;
            _duplicate.resourceName = this.resourceName;
            _duplicate.patternType = this.patternType;
            _duplicate.principal = this.principal;
            _duplicate.host = this.host;
            _duplicate.operation = this.operation;
            _duplicate.permissionType = this.permissionType;
            ArrayList<Uuid> newClusterLinkIds = new ArrayList<Uuid>(this.clusterLinkIds.size());
            for (Uuid _element : this.clusterLinkIds) {
                newClusterLinkIds.add(_element);
            }
            _duplicate.clusterLinkIds = newClusterLinkIds;
            return _duplicate;
        }

        public String toString() {
            return "DeleteAclsMatchingAcl(errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", resourceType=" + this.resourceType + ", resourceName=" + (this.resourceName == null ? "null" : "'" + this.resourceName.toString() + "'") + ", patternType=" + this.patternType + ", principal=" + (this.principal == null ? "null" : "'" + this.principal.toString() + "'") + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", operation=" + this.operation + ", permissionType=" + this.permissionType + ", clusterLinkIds=" + MessageUtil.deepToString(this.clusterLinkIds.iterator()) + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public byte resourceType() {
            return this.resourceType;
        }

        public String resourceName() {
            return this.resourceName;
        }

        public byte patternType() {
            return this.patternType;
        }

        public String principal() {
            return this.principal;
        }

        public String host() {
            return this.host;
        }

        public byte operation() {
            return this.operation;
        }

        public byte permissionType() {
            return this.permissionType;
        }

        public List<Uuid> clusterLinkIds() {
            return this.clusterLinkIds;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DeleteAclsMatchingAcl setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DeleteAclsMatchingAcl setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public DeleteAclsMatchingAcl setResourceType(byte v) {
            this.resourceType = v;
            return this;
        }

        public DeleteAclsMatchingAcl setResourceName(String v) {
            this.resourceName = v;
            return this;
        }

        public DeleteAclsMatchingAcl setPatternType(byte v) {
            this.patternType = v;
            return this;
        }

        public DeleteAclsMatchingAcl setPrincipal(String v) {
            this.principal = v;
            return this;
        }

        public DeleteAclsMatchingAcl setHost(String v) {
            this.host = v;
            return this;
        }

        public DeleteAclsMatchingAcl setOperation(byte v) {
            this.operation = v;
            return this;
        }

        public DeleteAclsMatchingAcl setPermissionType(byte v) {
            this.permissionType = v;
            return this;
        }

        public DeleteAclsMatchingAcl setClusterLinkIds(List<Uuid> v) {
            this.clusterLinkIds = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("error_code", Type.INT16, "The deletion error code, or 0 if the deletion succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The deletion error message, or null if the deletion succeeded."), new Field("resource_type", Type.INT8, "The ACL resource type."), new Field("resource_name", Type.COMPACT_STRING, "The ACL resource name."), new Field("pattern_type", Type.INT8, "The ACL resource pattern type."), new Field("principal", Type.COMPACT_STRING, "The ACL principal."), new Field("host", Type.COMPACT_STRING, "The ACL host."), new Field("operation", Type.INT8, "The ACL operation."), new Field("permission_type", Type.INT8, "The ACL permission type."), Field.TaggedFieldsSection.of(10000, new Field("cluster_link_ids", new CompactArrayOf(Type.UUID), "Cluster link IDs if this ACL was migrated from a source cluster by one or more cluster links.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }

    public static class DeleteAclsFilterResult
    implements Message {
        short errorCode;
        String errorMessage;
        List<DeleteAclsMatchingAcl> matchingAcls;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if the filter succeeded."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if the filter succeeded."), new Field("matching_acls", new ArrayOf(DeleteAclsMatchingAcl.SCHEMA_0), "The ACLs which matched this filter."));
        public static final Schema SCHEMA_1 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if the filter succeeded."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if the filter succeeded."), new Field("matching_acls", new ArrayOf(DeleteAclsMatchingAcl.SCHEMA_1), "The ACLs which matched this filter."));
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 3;

        public DeleteAclsFilterResult(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public DeleteAclsFilterResult() {
            this.errorCode = 0;
            this.errorMessage = "";
            this.matchingAcls = new ArrayList<DeleteAclsMatchingAcl>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable _readable, short _version, MessageContext _context) {
            DeleteAclsMatchingAcl _matchingAclsTransformed;
            DeleteAclsMatchingAcl _matchingAclsRawElement;
            int i;
            ArrayList<DeleteAclsMatchingAcl> newCollection;
            int arrayLength;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeleteAclsFilterResult");
            }
            this.errorCode = _readable.readShort();
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
            }
            if (_version >= 2) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field matchingAcls was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    _matchingAclsRawElement = new DeleteAclsMatchingAcl(_readable, _version, _context);
                    _matchingAclsTransformed = (DeleteAclsMatchingAcl)_context.read(EntityType.ACL_RESOURCE, _matchingAclsRawElement);
                    newCollection.add(_matchingAclsTransformed);
                }
                this.matchingAcls = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field matchingAcls was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<DeleteAclsMatchingAcl>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    _matchingAclsRawElement = new DeleteAclsMatchingAcl(_readable, _version, _context);
                    _matchingAclsTransformed = (DeleteAclsMatchingAcl)_context.read(EntityType.ACL_RESOURCE, _matchingAclsRawElement);
                    newCollection.add(_matchingAclsTransformed);
                }
                this.matchingAcls = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            ArrayList _matchingAclsTransformed;
            int _numTaggedFields = 0;
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                byte[] _stringBytes = _cache.getSerializedValue(this.errorMessage);
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.matchingAcls.size() + 1);
                _matchingAclsTransformed = (ArrayList)_cache.getTransformedValue(this.matchingAcls);
                for (DeleteAclsMatchingAcl matchingAclsElement : _matchingAclsTransformed) {
                    matchingAclsElement.write(_writable, _cache, _version, _context);
                }
            } else {
                _writable.writeInt(this.matchingAcls.size());
                _matchingAclsTransformed = (ArrayList)_cache.getTransformedValue(this.matchingAcls);
                for (DeleteAclsMatchingAcl matchingAclsElement : _matchingAclsTransformed) {
                    matchingAclsElement.write(_writable, _cache, _version, _context);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 3) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DeleteAclsFilterResult");
            }
            _size.addBytes(2);
            if (this.errorMessage == null) {
                if (_version >= 2) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                if (_version >= 2) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.matchingAcls.size() + 1));
            } else {
                _size.addBytes(4);
            }
            ArrayList<DeleteAclsMatchingAcl> _matchingAclsTransformed = new ArrayList<DeleteAclsMatchingAcl>(this.matchingAcls.size());
            for (DeleteAclsMatchingAcl matchingAclsElement : this.matchingAcls) {
                DeleteAclsMatchingAcl _transformedMessage = (DeleteAclsMatchingAcl)_context.write(EntityType.ACL_RESOURCE, matchingAclsElement);
                _matchingAclsTransformed.add(_transformedMessage);
                _transformedMessage.addSize(_size, _cache, _version, _context);
            }
            _cache.cacheTransformedValue(this.matchingAcls, _matchingAclsTransformed);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeleteAclsFilterResult)) {
                return false;
            }
            DeleteAclsFilterResult other = (DeleteAclsFilterResult)obj;
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.matchingAcls == null ? other.matchingAcls != null : !this.matchingAcls.equals(other.matchingAcls)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + (this.matchingAcls == null ? 0 : this.matchingAcls.hashCode());
            return hashCode;
        }

        @Override
        public DeleteAclsFilterResult duplicate() {
            DeleteAclsFilterResult _duplicate = new DeleteAclsFilterResult();
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            ArrayList<DeleteAclsMatchingAcl> newMatchingAcls = new ArrayList<DeleteAclsMatchingAcl>(this.matchingAcls.size());
            for (DeleteAclsMatchingAcl _element : this.matchingAcls) {
                newMatchingAcls.add(_element.duplicate());
            }
            _duplicate.matchingAcls = newMatchingAcls;
            return _duplicate;
        }

        public String toString() {
            return "DeleteAclsFilterResult(errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", matchingAcls=" + MessageUtil.deepToString(this.matchingAcls.iterator()) + ")";
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public List<DeleteAclsMatchingAcl> matchingAcls() {
            return this.matchingAcls;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DeleteAclsFilterResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public DeleteAclsFilterResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public DeleteAclsFilterResult setMatchingAcls(List<DeleteAclsMatchingAcl> v) {
            this.matchingAcls = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if the filter succeeded."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if the filter succeeded."), new Field("matching_acls", new CompactArrayOf(DeleteAclsMatchingAcl.SCHEMA_2), "The ACLs which matched this filter."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

