/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.AlterLeadershipPriorityResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class AlterLeadershipPriorityResponse
extends AbstractResponse {
    private final AlterLeadershipPriorityResponseData data;

    public AlterLeadershipPriorityResponse(AlterLeadershipPriorityResponseData data) {
        super(ApiKeys.ALTER_LEADERSHIP_PRIORITY);
        this.data = data;
    }

    @Override
    public AlterLeadershipPriorityResponseData data() {
        return this.data;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        if (this.data.errorCode() != Errors.NONE.code()) {
            if (this.data.brokerLeadershipPriorityResults().isEmpty()) {
                return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
            }
            return Collections.singletonMap(Errors.forCode(this.data.errorCode()), this.data.brokerLeadershipPriorityResults().size());
        }
        return this.errorCounts(this.data.brokerLeadershipPriorityResults().stream().map(result -> Errors.forCode(result.errorCode())).collect(Collectors.toList()));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    public static AlterLeadershipPriorityResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new AlterLeadershipPriorityResponse(new AlterLeadershipPriorityResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

