/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class UpdateMetadataRequestDataJsonConverter {
    public static UpdateMetadataRequestData read(JsonNode _node, short _version) {
        UpdateMetadataRequestData _object = new UpdateMetadataRequestData();
        JsonNode _controllerIdNode = _node.get("controllerId");
        if (_controllerIdNode == null) {
            throw new RuntimeException("UpdateMetadataRequestData: unable to locate field 'controllerId', which is mandatory in version " + _version);
        }
        _object.controllerId = MessageUtil.jsonNodeToInt(_controllerIdNode, "UpdateMetadataRequestData");
        JsonNode _isKRaftControllerNode = _node.get("isKRaftController");
        if (_isKRaftControllerNode == null) {
            if (_version >= 8) {
                throw new RuntimeException("UpdateMetadataRequestData: unable to locate field 'isKRaftController', which is mandatory in version " + _version);
            }
            _object.isKRaftController = false;
        } else {
            if (!_isKRaftControllerNode.isBoolean()) {
                throw new RuntimeException("UpdateMetadataRequestData expected Boolean type, but got " + _node.getNodeType());
            }
            _object.isKRaftController = _isKRaftControllerNode.asBoolean();
        }
        JsonNode _controllerEpochNode = _node.get("controllerEpoch");
        if (_controllerEpochNode == null) {
            throw new RuntimeException("UpdateMetadataRequestData: unable to locate field 'controllerEpoch', which is mandatory in version " + _version);
        }
        _object.controllerEpoch = MessageUtil.jsonNodeToInt(_controllerEpochNode, "UpdateMetadataRequestData");
        JsonNode _brokerEpochNode = _node.get("brokerEpoch");
        if (_brokerEpochNode == null) {
            if (_version >= 5) {
                throw new RuntimeException("UpdateMetadataRequestData: unable to locate field 'brokerEpoch', which is mandatory in version " + _version);
            }
            _object.brokerEpoch = -1L;
        } else {
            _object.brokerEpoch = MessageUtil.jsonNodeToLong(_brokerEpochNode, "UpdateMetadataRequestData");
        }
        JsonNode _brokerHealthNode = _node.get("brokerHealth");
        if (_brokerHealthNode == null) {
            _object.brokerHealth = new ArrayList<UpdateMetadataRequestData.UpdateMetadataBrokerHealthState>(0);
        } else {
            if (!_brokerHealthNode.isArray()) {
                throw new RuntimeException("UpdateMetadataRequestData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<UpdateMetadataRequestData.UpdateMetadataBrokerHealthState> _collection = new ArrayList<UpdateMetadataRequestData.UpdateMetadataBrokerHealthState>(_brokerHealthNode.size());
            _object.brokerHealth = _collection;
            for (Object _element : _brokerHealthNode) {
                _collection.add(UpdateMetadataBrokerHealthStateJsonConverter.read((JsonNode)_element, _version));
            }
        }
        JsonNode _ungroupedPartitionStatesNode = _node.get("ungroupedPartitionStates");
        if (_ungroupedPartitionStatesNode == null) {
            if (_version <= 4) {
                throw new RuntimeException("UpdateMetadataRequestData: unable to locate field 'ungroupedPartitionStates', which is mandatory in version " + _version);
            }
            _object.ungroupedPartitionStates = new ArrayList<UpdateMetadataRequestData.UpdateMetadataPartitionState>(0);
        } else {
            if (!_ungroupedPartitionStatesNode.isArray()) {
                throw new RuntimeException("UpdateMetadataRequestData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<UpdateMetadataRequestData.UpdateMetadataPartitionState> _collection = new ArrayList<UpdateMetadataRequestData.UpdateMetadataPartitionState>(_ungroupedPartitionStatesNode.size());
            _object.ungroupedPartitionStates = _collection;
            for (Object _element : _ungroupedPartitionStatesNode) {
                _collection.add(UpdateMetadataPartitionStateJsonConverter.read((JsonNode)_element, _version));
            }
        }
        JsonNode _topicStatesNode = _node.get("topicStates");
        if (_topicStatesNode == null) {
            if (_version >= 5) {
                throw new RuntimeException("UpdateMetadataRequestData: unable to locate field 'topicStates', which is mandatory in version " + _version);
            }
            _object.topicStates = new ArrayList<UpdateMetadataRequestData.UpdateMetadataTopicState>(0);
        } else {
            if (!_topicStatesNode.isArray()) {
                throw new RuntimeException("UpdateMetadataRequestData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<UpdateMetadataRequestData.UpdateMetadataTopicState> _collection = new ArrayList<UpdateMetadataRequestData.UpdateMetadataTopicState>(_topicStatesNode.size());
            _object.topicStates = _collection;
            for (Object _element : _topicStatesNode) {
                _collection.add(UpdateMetadataTopicStateJsonConverter.read((JsonNode)_element, _version));
            }
        }
        JsonNode _liveBrokersNode = _node.get("liveBrokers");
        if (_liveBrokersNode == null) {
            throw new RuntimeException("UpdateMetadataRequestData: unable to locate field 'liveBrokers', which is mandatory in version " + _version);
        }
        if (!_liveBrokersNode.isArray()) {
            throw new RuntimeException("UpdateMetadataRequestData expected a JSON array, but got " + _node.getNodeType());
        }
        ArrayList<UpdateMetadataRequestData.UpdateMetadataBroker> _collection = new ArrayList<UpdateMetadataRequestData.UpdateMetadataBroker>(_liveBrokersNode.size());
        _object.liveBrokers = _collection;
        for (JsonNode _element : _liveBrokersNode) {
            _collection.add(UpdateMetadataBrokerJsonConverter.read(_element, _version));
        }
        JsonNode _linkCoordinatorEnabledNode = _node.get("linkCoordinatorEnabled");
        if (_linkCoordinatorEnabledNode == null) {
            _object.linkCoordinatorEnabled = false;
        } else {
            if (!_linkCoordinatorEnabledNode.isBoolean()) {
                throw new RuntimeException("UpdateMetadataRequestData expected Boolean type, but got " + _node.getNodeType());
            }
            _object.linkCoordinatorEnabled = _linkCoordinatorEnabledNode.asBoolean();
        }
        JsonNode _cellsNode = _node.get("cells");
        if (_cellsNode == null) {
            _object.cells = new ArrayList<UpdateMetadataRequestData.UpdateMetadataCell>(0);
        } else {
            if (!_cellsNode.isArray()) {
                throw new RuntimeException("UpdateMetadataRequestData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<UpdateMetadataRequestData.UpdateMetadataCell> _collection2 = new ArrayList<UpdateMetadataRequestData.UpdateMetadataCell>(_cellsNode.size());
            _object.cells = _collection2;
            for (JsonNode _element : _cellsNode) {
                _collection2.add(UpdateMetadataCellJsonConverter.read(_element, _version));
            }
        }
        JsonNode _timestampNode = _node.get("timestamp");
        _object.timestamp = _timestampNode == null ? 0L : MessageUtil.jsonNodeToLong(_timestampNode, "UpdateMetadataRequestData");
        return _object;
    }

    public static JsonNode write(UpdateMetadataRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("controllerId", (JsonNode)new IntNode(_object.controllerId));
        if (_version >= 8) {
            _node.set("isKRaftController", (JsonNode)BooleanNode.valueOf((boolean)_object.isKRaftController));
        } else if (_object.isKRaftController) {
            throw new UnsupportedVersionException("Attempted to write a non-default isKRaftController at version " + _version);
        }
        _node.set("controllerEpoch", (JsonNode)new IntNode(_object.controllerEpoch));
        if (_version >= 5) {
            _node.set("brokerEpoch", (JsonNode)new LongNode(_object.brokerEpoch));
        }
        if (_version >= 7 && !_object.brokerHealth.isEmpty()) {
            ArrayNode _brokerHealthArray = new ArrayNode(JsonNodeFactory.instance);
            for (UpdateMetadataRequestData.UpdateMetadataBrokerHealthState updateMetadataBrokerHealthState : _object.brokerHealth) {
                _brokerHealthArray.add(UpdateMetadataBrokerHealthStateJsonConverter.write(updateMetadataBrokerHealthState, _version, _serializeRecords));
            }
            _node.set("brokerHealth", (JsonNode)_brokerHealthArray);
        }
        if (_version <= 4) {
            ArrayNode _ungroupedPartitionStatesArray = new ArrayNode(JsonNodeFactory.instance);
            for (UpdateMetadataRequestData.UpdateMetadataPartitionState updateMetadataPartitionState : _object.ungroupedPartitionStates) {
                _ungroupedPartitionStatesArray.add(UpdateMetadataPartitionStateJsonConverter.write(updateMetadataPartitionState, _version, _serializeRecords));
            }
            _node.set("ungroupedPartitionStates", (JsonNode)_ungroupedPartitionStatesArray);
        } else if (!_object.ungroupedPartitionStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default ungroupedPartitionStates at version " + _version);
        }
        if (_version >= 5) {
            ArrayNode _topicStatesArray = new ArrayNode(JsonNodeFactory.instance);
            for (UpdateMetadataRequestData.UpdateMetadataTopicState updateMetadataTopicState : _object.topicStates) {
                _topicStatesArray.add(UpdateMetadataTopicStateJsonConverter.write(updateMetadataTopicState, _version, _serializeRecords));
            }
            _node.set("topicStates", (JsonNode)_topicStatesArray);
        } else if (!_object.topicStates.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default topicStates at version " + _version);
        }
        ArrayNode _liveBrokersArray = new ArrayNode(JsonNodeFactory.instance);
        for (UpdateMetadataRequestData.UpdateMetadataBroker updateMetadataBroker : _object.liveBrokers) {
            _liveBrokersArray.add(UpdateMetadataBrokerJsonConverter.write(updateMetadataBroker, _version, _serializeRecords));
        }
        _node.set("liveBrokers", (JsonNode)_liveBrokersArray);
        if (_version >= 7 && _object.linkCoordinatorEnabled) {
            _node.set("linkCoordinatorEnabled", (JsonNode)BooleanNode.valueOf((boolean)_object.linkCoordinatorEnabled));
        }
        if (_version >= 7 && !_object.cells.isEmpty()) {
            ArrayNode _cellsArray = new ArrayNode(JsonNodeFactory.instance);
            for (UpdateMetadataRequestData.UpdateMetadataCell _element : _object.cells) {
                _cellsArray.add(UpdateMetadataCellJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("cells", (JsonNode)_cellsArray);
        }
        if (_version >= 6 && _object.timestamp != 0L) {
            _node.set("timestamp", (JsonNode)new LongNode(_object.timestamp));
        }
        return _node;
    }

    public static JsonNode write(UpdateMetadataRequestData _object, short _version) {
        return UpdateMetadataRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class UpdateMetadataTopicStateJsonConverter {
        public static UpdateMetadataRequestData.UpdateMetadataTopicState read(JsonNode _node, short _version) {
            UpdateMetadataRequestData.UpdateMetadataTopicState _object = new UpdateMetadataRequestData.UpdateMetadataTopicState();
            if (_version < 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of UpdateMetadataTopicState");
            }
            JsonNode _topicNameNode = _node.get("topicName");
            if (_topicNameNode == null) {
                throw new RuntimeException("UpdateMetadataTopicState: unable to locate field 'topicName', which is mandatory in version " + _version);
            }
            if (!_topicNameNode.isTextual()) {
                throw new RuntimeException("UpdateMetadataTopicState expected a string type, but got " + _node.getNodeType());
            }
            _object.topicName = _topicNameNode.asText();
            JsonNode _topicIdNode = _node.get("topicId");
            if (_topicIdNode == null) {
                if (_version >= 7) {
                    throw new RuntimeException("UpdateMetadataTopicState: unable to locate field 'topicId', which is mandatory in version " + _version);
                }
                _object.topicId = Uuid.ZERO_UUID;
            } else {
                if (!_topicIdNode.isTextual()) {
                    throw new RuntimeException("UpdateMetadataTopicState expected a JSON string type, but got " + _node.getNodeType());
                }
                _object.topicId = Uuid.fromString(_topicIdNode.asText());
            }
            JsonNode _partitionStatesNode = _node.get("partitionStates");
            if (_partitionStatesNode == null) {
                throw new RuntimeException("UpdateMetadataTopicState: unable to locate field 'partitionStates', which is mandatory in version " + _version);
            }
            if (!_partitionStatesNode.isArray()) {
                throw new RuntimeException("UpdateMetadataTopicState expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<UpdateMetadataRequestData.UpdateMetadataPartitionState> _collection = new ArrayList<UpdateMetadataRequestData.UpdateMetadataPartitionState>(_partitionStatesNode.size());
            _object.partitionStates = _collection;
            for (JsonNode _element : _partitionStatesNode) {
                _collection.add(UpdateMetadataPartitionStateJsonConverter.read(_element, _version));
            }
            JsonNode _mirrorTopicMetadataNode = _node.get("mirrorTopicMetadata");
            _object.mirrorTopicMetadata = _mirrorTopicMetadataNode == null ? new UpdateMetadataRequestData.MirrorTopicMetadata() : MirrorTopicMetadataJsonConverter.read(_mirrorTopicMetadataNode, _version);
            JsonNode _clusterLinkNameForMirrorTopicNode = _node.get("clusterLinkNameForMirrorTopic");
            if (_clusterLinkNameForMirrorTopicNode == null) {
                _object.clusterLinkNameForMirrorTopic = null;
            } else if (_clusterLinkNameForMirrorTopicNode.isNull()) {
                _object.clusterLinkNameForMirrorTopic = null;
            } else {
                if (!_clusterLinkNameForMirrorTopicNode.isTextual()) {
                    throw new RuntimeException("UpdateMetadataTopicState expected a string type, but got " + _node.getNodeType());
                }
                _object.clusterLinkNameForMirrorTopic = _clusterLinkNameForMirrorTopicNode.asText();
            }
            JsonNode _mirrorTopicStateLastUpdateTimeMsNode = _node.get("mirrorTopicStateLastUpdateTimeMs");
            _object.mirrorTopicStateLastUpdateTimeMs = _mirrorTopicStateLastUpdateTimeMsNode == null ? 0L : MessageUtil.jsonNodeToLong(_mirrorTopicStateLastUpdateTimeMsNode, "UpdateMetadataTopicState");
            JsonNode _sourceTopicIdForMirrorTopicNode = _node.get("sourceTopicIdForMirrorTopic");
            if (_sourceTopicIdForMirrorTopicNode == null) {
                _object.sourceTopicIdForMirrorTopic = Uuid.ZERO_UUID;
            } else {
                if (!_sourceTopicIdForMirrorTopicNode.isTextual()) {
                    throw new RuntimeException("UpdateMetadataTopicState expected a JSON string type, but got " + _node.getNodeType());
                }
                _object.sourceTopicIdForMirrorTopic = Uuid.fromString(_sourceTopicIdForMirrorTopicNode.asText());
            }
            JsonNode _linkLevelPauseForMirrorTopicNode = _node.get("linkLevelPauseForMirrorTopic");
            if (_linkLevelPauseForMirrorTopicNode == null) {
                _object.linkLevelPauseForMirrorTopic = false;
            } else {
                if (!_linkLevelPauseForMirrorTopicNode.isBoolean()) {
                    throw new RuntimeException("UpdateMetadataTopicState expected Boolean type, but got " + _node.getNodeType());
                }
                _object.linkLevelPauseForMirrorTopic = _linkLevelPauseForMirrorTopicNode.asBoolean();
            }
            JsonNode _topicLevelPauseForMirrorTopicNode = _node.get("topicLevelPauseForMirrorTopic");
            if (_topicLevelPauseForMirrorTopicNode == null) {
                _object.topicLevelPauseForMirrorTopic = false;
            } else {
                if (!_topicLevelPauseForMirrorTopicNode.isBoolean()) {
                    throw new RuntimeException("UpdateMetadataTopicState expected Boolean type, but got " + _node.getNodeType());
                }
                _object.topicLevelPauseForMirrorTopic = _topicLevelPauseForMirrorTopicNode.asBoolean();
            }
            JsonNode _mirrorTopicPreviousStateNode = _node.get("mirrorTopicPreviousState");
            if (_mirrorTopicPreviousStateNode == null) {
                _object.mirrorTopicPreviousState = null;
            } else if (_mirrorTopicPreviousStateNode.isNull()) {
                _object.mirrorTopicPreviousState = null;
            } else {
                if (!_mirrorTopicPreviousStateNode.isTextual()) {
                    throw new RuntimeException("UpdateMetadataTopicState expected a string type, but got " + _node.getNodeType());
                }
                _object.mirrorTopicPreviousState = _mirrorTopicPreviousStateNode.asText();
            }
            JsonNode _mirrorTopicPromotedNode = _node.get("mirrorTopicPromoted");
            if (_mirrorTopicPromotedNode == null) {
                _object.mirrorTopicPromoted = false;
            } else {
                if (!_mirrorTopicPromotedNode.isBoolean()) {
                    throw new RuntimeException("UpdateMetadataTopicState expected Boolean type, but got " + _node.getNodeType());
                }
                _object.mirrorTopicPromoted = _mirrorTopicPromotedNode.asBoolean();
            }
            JsonNode _mirrorTopicStoppedLogEndOffsetsNode = _node.get("mirrorTopicStoppedLogEndOffsets");
            if (_mirrorTopicStoppedLogEndOffsetsNode == null) {
                _object.mirrorTopicStoppedLogEndOffsets = null;
            } else if (_mirrorTopicStoppedLogEndOffsetsNode.isNull()) {
                _object.mirrorTopicStoppedLogEndOffsets = null;
            } else {
                if (!_mirrorTopicStoppedLogEndOffsetsNode.isArray()) {
                    throw new RuntimeException("UpdateMetadataTopicState expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<Long> _collection2 = new ArrayList<Long>(_mirrorTopicStoppedLogEndOffsetsNode.size());
                _object.mirrorTopicStoppedLogEndOffsets = _collection2;
                for (Object _element : _mirrorTopicStoppedLogEndOffsetsNode) {
                    _collection2.add(MessageUtil.jsonNodeToLong((JsonNode)_element, "UpdateMetadataTopicState element"));
                }
            }
            JsonNode _mirrorTopicMirrorStartOffsetsNode = _node.get("mirrorTopicMirrorStartOffsets");
            if (_mirrorTopicMirrorStartOffsetsNode == null) {
                _object.mirrorTopicMirrorStartOffsets = null;
            } else if (_mirrorTopicMirrorStartOffsetsNode.isNull()) {
                _object.mirrorTopicMirrorStartOffsets = null;
            } else {
                if (!_mirrorTopicMirrorStartOffsetsNode.isArray()) {
                    throw new RuntimeException("UpdateMetadataTopicState expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<Long> _collection3 = new ArrayList<Long>(_mirrorTopicMirrorStartOffsetsNode.size());
                _object.mirrorTopicMirrorStartOffsets = _collection3;
                for (JsonNode _element : _mirrorTopicMirrorStartOffsetsNode) {
                    _collection3.add(MessageUtil.jsonNodeToLong(_element, "UpdateMetadataTopicState element"));
                }
            }
            JsonNode _mirrorTopicErrorNode = _node.get("mirrorTopicError");
            _object.mirrorTopicError = _mirrorTopicErrorNode == null ? (short)-1 : MessageUtil.jsonNodeToShort(_mirrorTopicErrorNode, "UpdateMetadataTopicState");
            JsonNode _mirrorTopicNextStateNode = _node.get("mirrorTopicNextState");
            if (_mirrorTopicNextStateNode == null) {
                _object.mirrorTopicNextState = null;
            } else if (_mirrorTopicNextStateNode.isNull()) {
                _object.mirrorTopicNextState = null;
            } else {
                if (!_mirrorTopicNextStateNode.isTextual()) {
                    throw new RuntimeException("UpdateMetadataTopicState expected a string type, but got " + _node.getNodeType());
                }
                _object.mirrorTopicNextState = _mirrorTopicNextStateNode.asText();
            }
            return _object;
        }

        public static JsonNode write(UpdateMetadataRequestData.UpdateMetadataTopicState _object, short _version, boolean _serializeRecords) {
            if (_version < 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of UpdateMetadataTopicState");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicName", (JsonNode)new TextNode(_object.topicName));
            if (_version >= 7) {
                _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
            }
            ArrayNode _partitionStatesArray = new ArrayNode(JsonNodeFactory.instance);
            for (UpdateMetadataRequestData.UpdateMetadataPartitionState _element : _object.partitionStates) {
                _partitionStatesArray.add(UpdateMetadataPartitionStateJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("partitionStates", (JsonNode)_partitionStatesArray);
            if (_version >= 7 && !_object.mirrorTopicMetadata.equals(new UpdateMetadataRequestData.MirrorTopicMetadata())) {
                _node.set("mirrorTopicMetadata", MirrorTopicMetadataJsonConverter.write(_object.mirrorTopicMetadata, _version, _serializeRecords));
            }
            if (_version >= 8 && _object.clusterLinkNameForMirrorTopic != null) {
                _node.set("clusterLinkNameForMirrorTopic", (JsonNode)new TextNode(_object.clusterLinkNameForMirrorTopic));
            }
            if (_version >= 8 && _object.mirrorTopicStateLastUpdateTimeMs != 0L) {
                _node.set("mirrorTopicStateLastUpdateTimeMs", (JsonNode)new LongNode(_object.mirrorTopicStateLastUpdateTimeMs));
            }
            if (_version >= 8 && !_object.sourceTopicIdForMirrorTopic.equals(Uuid.ZERO_UUID)) {
                _node.set("sourceTopicIdForMirrorTopic", (JsonNode)new TextNode(_object.sourceTopicIdForMirrorTopic.toString()));
            }
            if (_version >= 8 && _object.linkLevelPauseForMirrorTopic) {
                _node.set("linkLevelPauseForMirrorTopic", (JsonNode)BooleanNode.valueOf((boolean)_object.linkLevelPauseForMirrorTopic));
            }
            if (_version >= 8 && _object.topicLevelPauseForMirrorTopic) {
                _node.set("topicLevelPauseForMirrorTopic", (JsonNode)BooleanNode.valueOf((boolean)_object.topicLevelPauseForMirrorTopic));
            }
            if (_version >= 8 && _object.mirrorTopicPreviousState != null) {
                _node.set("mirrorTopicPreviousState", (JsonNode)new TextNode(_object.mirrorTopicPreviousState));
            }
            if (_version >= 8 && _object.mirrorTopicPromoted) {
                _node.set("mirrorTopicPromoted", (JsonNode)BooleanNode.valueOf((boolean)_object.mirrorTopicPromoted));
            }
            if (_version >= 8 && _object.mirrorTopicStoppedLogEndOffsets != null) {
                ArrayNode _mirrorTopicStoppedLogEndOffsetsArray = new ArrayNode(JsonNodeFactory.instance);
                for (Long _element : _object.mirrorTopicStoppedLogEndOffsets) {
                    _mirrorTopicStoppedLogEndOffsetsArray.add((JsonNode)new LongNode(_element.longValue()));
                }
                _node.set("mirrorTopicStoppedLogEndOffsets", (JsonNode)_mirrorTopicStoppedLogEndOffsetsArray);
            }
            if (_version >= 8 && _object.mirrorTopicMirrorStartOffsets != null) {
                ArrayNode _mirrorTopicMirrorStartOffsetsArray = new ArrayNode(JsonNodeFactory.instance);
                for (Long _element : _object.mirrorTopicMirrorStartOffsets) {
                    _mirrorTopicMirrorStartOffsetsArray.add((JsonNode)new LongNode(_element.longValue()));
                }
                _node.set("mirrorTopicMirrorStartOffsets", (JsonNode)_mirrorTopicMirrorStartOffsetsArray);
            }
            if (_version >= 8 && _object.mirrorTopicError != -1) {
                _node.set("mirrorTopicError", (JsonNode)new ShortNode(_object.mirrorTopicError));
            }
            if (_version >= 8 && _object.mirrorTopicNextState != null) {
                _node.set("mirrorTopicNextState", (JsonNode)new TextNode(_object.mirrorTopicNextState));
            }
            return _node;
        }

        public static JsonNode write(UpdateMetadataRequestData.UpdateMetadataTopicState _object, short _version) {
            return UpdateMetadataTopicStateJsonConverter.write(_object, _version, true);
        }
    }

    public static class UpdateMetadataPartitionStateJsonConverter {
        public static UpdateMetadataRequestData.UpdateMetadataPartitionState read(JsonNode _node, short _version) {
            UpdateMetadataRequestData.UpdateMetadataPartitionState _object = new UpdateMetadataRequestData.UpdateMetadataPartitionState();
            JsonNode _topicNameNode = _node.get("topicName");
            if (_topicNameNode == null) {
                if (_version <= 4) {
                    throw new RuntimeException("UpdateMetadataPartitionState: unable to locate field 'topicName', which is mandatory in version " + _version);
                }
                _object.topicName = "";
            } else {
                if (!_topicNameNode.isTextual()) {
                    throw new RuntimeException("UpdateMetadataPartitionState expected a string type, but got " + _node.getNodeType());
                }
                _object.topicName = _topicNameNode.asText();
            }
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("UpdateMetadataPartitionState: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            _object.partitionIndex = MessageUtil.jsonNodeToInt(_partitionIndexNode, "UpdateMetadataPartitionState");
            JsonNode _controllerEpochNode = _node.get("controllerEpoch");
            if (_controllerEpochNode == null) {
                throw new RuntimeException("UpdateMetadataPartitionState: unable to locate field 'controllerEpoch', which is mandatory in version " + _version);
            }
            _object.controllerEpoch = MessageUtil.jsonNodeToInt(_controllerEpochNode, "UpdateMetadataPartitionState");
            JsonNode _leaderNode = _node.get("leader");
            if (_leaderNode == null) {
                throw new RuntimeException("UpdateMetadataPartitionState: unable to locate field 'leader', which is mandatory in version " + _version);
            }
            _object.leader = MessageUtil.jsonNodeToInt(_leaderNode, "UpdateMetadataPartitionState");
            JsonNode _leaderEpochNode = _node.get("leaderEpoch");
            if (_leaderEpochNode == null) {
                throw new RuntimeException("UpdateMetadataPartitionState: unable to locate field 'leaderEpoch', which is mandatory in version " + _version);
            }
            _object.leaderEpoch = MessageUtil.jsonNodeToInt(_leaderEpochNode, "UpdateMetadataPartitionState");
            JsonNode _isrNode = _node.get("isr");
            if (_isrNode == null) {
                throw new RuntimeException("UpdateMetadataPartitionState: unable to locate field 'isr', which is mandatory in version " + _version);
            }
            if (!_isrNode.isArray()) {
                throw new RuntimeException("UpdateMetadataPartitionState expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_isrNode.size());
            _object.isr = _collection;
            for (JsonNode _element : _isrNode) {
                _collection.add(MessageUtil.jsonNodeToInt(_element, "UpdateMetadataPartitionState element"));
            }
            JsonNode _zkVersionNode = _node.get("zkVersion");
            if (_zkVersionNode == null) {
                throw new RuntimeException("UpdateMetadataPartitionState: unable to locate field 'zkVersion', which is mandatory in version " + _version);
            }
            _object.zkVersion = MessageUtil.jsonNodeToInt(_zkVersionNode, "UpdateMetadataPartitionState");
            JsonNode _replicasNode = _node.get("replicas");
            if (_replicasNode == null) {
                throw new RuntimeException("UpdateMetadataPartitionState: unable to locate field 'replicas', which is mandatory in version " + _version);
            }
            if (!_replicasNode.isArray()) {
                throw new RuntimeException("UpdateMetadataPartitionState expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection2 = new ArrayList<Integer>(_replicasNode.size());
            _object.replicas = _collection2;
            for (Object _element : _replicasNode) {
                _collection2.add(MessageUtil.jsonNodeToInt((JsonNode)_element, "UpdateMetadataPartitionState element"));
            }
            JsonNode _observersNode = _node.get("observers");
            if (_observersNode == null) {
                _object.observers = new ArrayList<Integer>(0);
            } else {
                if (!_observersNode.isArray()) {
                    throw new RuntimeException("UpdateMetadataPartitionState expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<Integer> _collection3 = new ArrayList<Integer>(_observersNode.size());
                _object.observers = _collection3;
                for (JsonNode _element : _observersNode) {
                    _collection3.add(MessageUtil.jsonNodeToInt(_element, "UpdateMetadataPartitionState element"));
                }
            }
            JsonNode _offlineReplicasNode = _node.get("offlineReplicas");
            if (_offlineReplicasNode == null) {
                if (_version >= 4) {
                    throw new RuntimeException("UpdateMetadataPartitionState: unable to locate field 'offlineReplicas', which is mandatory in version " + _version);
                }
                _object.offlineReplicas = new ArrayList<Integer>(0);
            } else {
                if (!_offlineReplicasNode.isArray()) {
                    throw new RuntimeException("UpdateMetadataPartitionState expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<Integer> _collection4 = new ArrayList<Integer>(_offlineReplicasNode.size());
                _object.offlineReplicas = _collection4;
                for (JsonNode _element : _offlineReplicasNode) {
                    _collection4.add(MessageUtil.jsonNodeToInt(_element, "UpdateMetadataPartitionState element"));
                }
            }
            return _object;
        }

        public static JsonNode write(UpdateMetadataRequestData.UpdateMetadataPartitionState _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            if (_version <= 4) {
                _node.set("topicName", (JsonNode)new TextNode(_object.topicName));
            }
            _node.set("partitionIndex", (JsonNode)new IntNode(_object.partitionIndex));
            _node.set("controllerEpoch", (JsonNode)new IntNode(_object.controllerEpoch));
            _node.set("leader", (JsonNode)new IntNode(_object.leader));
            _node.set("leaderEpoch", (JsonNode)new IntNode(_object.leaderEpoch));
            ArrayNode _isrArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer n : _object.isr) {
                _isrArray.add((JsonNode)new IntNode(n.intValue()));
            }
            _node.set("isr", (JsonNode)_isrArray);
            _node.set("zkVersion", (JsonNode)new IntNode(_object.zkVersion));
            ArrayNode _replicasArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : _object.replicas) {
                _replicasArray.add((JsonNode)new IntNode(_element.intValue()));
            }
            _node.set("replicas", (JsonNode)_replicasArray);
            if (_version >= 6 && !_object.observers.isEmpty()) {
                ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
                for (Integer _element : _object.observers) {
                    arrayNode.add((JsonNode)new IntNode(_element.intValue()));
                }
                _node.set("observers", (JsonNode)arrayNode);
            }
            if (_version >= 4) {
                ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
                for (Integer _element : _object.offlineReplicas) {
                    arrayNode.add((JsonNode)new IntNode(_element.intValue()));
                }
                _node.set("offlineReplicas", (JsonNode)arrayNode);
            }
            return _node;
        }

        public static JsonNode write(UpdateMetadataRequestData.UpdateMetadataPartitionState _object, short _version) {
            return UpdateMetadataPartitionStateJsonConverter.write(_object, _version, true);
        }
    }

    public static class UpdateMetadataEndpointJsonConverter {
        public static UpdateMetadataRequestData.UpdateMetadataEndpoint read(JsonNode _node, short _version) {
            UpdateMetadataRequestData.UpdateMetadataEndpoint _object = new UpdateMetadataRequestData.UpdateMetadataEndpoint();
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of UpdateMetadataEndpoint");
            }
            JsonNode _portNode = _node.get("port");
            if (_portNode == null) {
                throw new RuntimeException("UpdateMetadataEndpoint: unable to locate field 'port', which is mandatory in version " + _version);
            }
            _object.port = MessageUtil.jsonNodeToInt(_portNode, "UpdateMetadataEndpoint");
            JsonNode _hostNode = _node.get("host");
            if (_hostNode == null) {
                throw new RuntimeException("UpdateMetadataEndpoint: unable to locate field 'host', which is mandatory in version " + _version);
            }
            if (!_hostNode.isTextual()) {
                throw new RuntimeException("UpdateMetadataEndpoint expected a string type, but got " + _node.getNodeType());
            }
            _object.host = _hostNode.asText();
            JsonNode _listenerNode = _node.get("listener");
            if (_listenerNode == null) {
                if (_version >= 3) {
                    throw new RuntimeException("UpdateMetadataEndpoint: unable to locate field 'listener', which is mandatory in version " + _version);
                }
                _object.listener = "";
            } else {
                if (!_listenerNode.isTextual()) {
                    throw new RuntimeException("UpdateMetadataEndpoint expected a string type, but got " + _node.getNodeType());
                }
                _object.listener = _listenerNode.asText();
            }
            JsonNode _securityProtocolNode = _node.get("securityProtocol");
            if (_securityProtocolNode == null) {
                throw new RuntimeException("UpdateMetadataEndpoint: unable to locate field 'securityProtocol', which is mandatory in version " + _version);
            }
            _object.securityProtocol = MessageUtil.jsonNodeToShort(_securityProtocolNode, "UpdateMetadataEndpoint");
            return _object;
        }

        public static JsonNode write(UpdateMetadataRequestData.UpdateMetadataEndpoint _object, short _version, boolean _serializeRecords) {
            if (_version < 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of UpdateMetadataEndpoint");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("port", (JsonNode)new IntNode(_object.port));
            _node.set("host", (JsonNode)new TextNode(_object.host));
            if (_version >= 3) {
                _node.set("listener", (JsonNode)new TextNode(_object.listener));
            }
            _node.set("securityProtocol", (JsonNode)new ShortNode(_object.securityProtocol));
            return _node;
        }

        public static JsonNode write(UpdateMetadataRequestData.UpdateMetadataEndpoint _object, short _version) {
            return UpdateMetadataEndpointJsonConverter.write(_object, _version, true);
        }
    }

    public static class UpdateMetadataCellJsonConverter {
        public static UpdateMetadataRequestData.UpdateMetadataCell read(JsonNode _node, short _version) {
            UpdateMetadataRequestData.UpdateMetadataCell _object = new UpdateMetadataRequestData.UpdateMetadataCell();
            if (_version < 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of UpdateMetadataCell");
            }
            JsonNode _cellIdNode = _node.get("cellId");
            if (_cellIdNode == null) {
                throw new RuntimeException("UpdateMetadataCell: unable to locate field 'cellId', which is mandatory in version " + _version);
            }
            _object.cellId = MessageUtil.jsonNodeToInt(_cellIdNode, "UpdateMetadataCell");
            JsonNode _brokersNode = _node.get("brokers");
            if (_brokersNode == null) {
                throw new RuntimeException("UpdateMetadataCell: unable to locate field 'brokers', which is mandatory in version " + _version);
            }
            if (!_brokersNode.isArray()) {
                throw new RuntimeException("UpdateMetadataCell expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_brokersNode.size());
            _object.brokers = _collection;
            for (JsonNode _element : _brokersNode) {
                _collection.add(MessageUtil.jsonNodeToInt(_element, "UpdateMetadataCell element"));
            }
            return _object;
        }

        public static JsonNode write(UpdateMetadataRequestData.UpdateMetadataCell _object, short _version, boolean _serializeRecords) {
            if (_version < 7) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of UpdateMetadataCell");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("cellId", (JsonNode)new IntNode(_object.cellId));
            ArrayNode _brokersArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : _object.brokers) {
                _brokersArray.add((JsonNode)new IntNode(_element.intValue()));
            }
            _node.set("brokers", (JsonNode)_brokersArray);
            return _node;
        }

        public static JsonNode write(UpdateMetadataRequestData.UpdateMetadataCell _object, short _version) {
            return UpdateMetadataCellJsonConverter.write(_object, _version, true);
        }
    }

    public static class UpdateMetadataBrokerHealthStateJsonConverter {
        public static UpdateMetadataRequestData.UpdateMetadataBrokerHealthState read(JsonNode _node, short _version) {
            UpdateMetadataRequestData.UpdateMetadataBrokerHealthState _object = new UpdateMetadataRequestData.UpdateMetadataBrokerHealthState();
            if (_version < 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of UpdateMetadataBrokerHealthState");
            }
            JsonNode _brokerIdNode = _node.get("brokerId");
            if (_brokerIdNode == null) {
                throw new RuntimeException("UpdateMetadataBrokerHealthState: unable to locate field 'brokerId', which is mandatory in version " + _version);
            }
            _object.brokerId = MessageUtil.jsonNodeToInt(_brokerIdNode, "UpdateMetadataBrokerHealthState");
            JsonNode _degradedComponentsNode = _node.get("degradedComponents");
            if (_degradedComponentsNode == null) {
                throw new RuntimeException("UpdateMetadataBrokerHealthState: unable to locate field 'degradedComponents', which is mandatory in version " + _version);
            }
            if (!_degradedComponentsNode.isArray()) {
                throw new RuntimeException("UpdateMetadataBrokerHealthState expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Byte> _collection = new ArrayList<Byte>(_degradedComponentsNode.size());
            _object.degradedComponents = _collection;
            for (JsonNode _element : _degradedComponentsNode) {
                _collection.add(MessageUtil.jsonNodeToByte(_element, "UpdateMetadataBrokerHealthState element"));
            }
            return _object;
        }

        public static JsonNode write(UpdateMetadataRequestData.UpdateMetadataBrokerHealthState _object, short _version, boolean _serializeRecords) {
            if (_version < 7) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of UpdateMetadataBrokerHealthState");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("brokerId", (JsonNode)new IntNode(_object.brokerId));
            ArrayNode _degradedComponentsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Byte _element : _object.degradedComponents) {
                _degradedComponentsArray.add((JsonNode)new ShortNode((short)_element.byteValue()));
            }
            _node.set("degradedComponents", (JsonNode)_degradedComponentsArray);
            return _node;
        }

        public static JsonNode write(UpdateMetadataRequestData.UpdateMetadataBrokerHealthState _object, short _version) {
            return UpdateMetadataBrokerHealthStateJsonConverter.write(_object, _version, true);
        }
    }

    public static class UpdateMetadataBrokerJsonConverter {
        public static UpdateMetadataRequestData.UpdateMetadataBroker read(JsonNode _node, short _version) {
            UpdateMetadataRequestData.UpdateMetadataBroker _object = new UpdateMetadataRequestData.UpdateMetadataBroker();
            JsonNode _idNode = _node.get("id");
            if (_idNode == null) {
                throw new RuntimeException("UpdateMetadataBroker: unable to locate field 'id', which is mandatory in version " + _version);
            }
            _object.id = MessageUtil.jsonNodeToInt(_idNode, "UpdateMetadataBroker");
            JsonNode _v0HostNode = _node.get("v0Host");
            if (_v0HostNode == null) {
                if (_version <= 0) {
                    throw new RuntimeException("UpdateMetadataBroker: unable to locate field 'v0Host', which is mandatory in version " + _version);
                }
                _object.v0Host = "";
            } else {
                if (!_v0HostNode.isTextual()) {
                    throw new RuntimeException("UpdateMetadataBroker expected a string type, but got " + _node.getNodeType());
                }
                _object.v0Host = _v0HostNode.asText();
            }
            JsonNode _v0PortNode = _node.get("v0Port");
            if (_v0PortNode == null) {
                if (_version <= 0) {
                    throw new RuntimeException("UpdateMetadataBroker: unable to locate field 'v0Port', which is mandatory in version " + _version);
                }
                _object.v0Port = 0;
            } else {
                _object.v0Port = MessageUtil.jsonNodeToInt(_v0PortNode, "UpdateMetadataBroker");
            }
            JsonNode _endpointsNode = _node.get("endpoints");
            if (_endpointsNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("UpdateMetadataBroker: unable to locate field 'endpoints', which is mandatory in version " + _version);
                }
                _object.endpoints = new ArrayList<UpdateMetadataRequestData.UpdateMetadataEndpoint>(0);
            } else {
                if (!_endpointsNode.isArray()) {
                    throw new RuntimeException("UpdateMetadataBroker expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<UpdateMetadataRequestData.UpdateMetadataEndpoint> _collection = new ArrayList<UpdateMetadataRequestData.UpdateMetadataEndpoint>(_endpointsNode.size());
                _object.endpoints = _collection;
                for (JsonNode _element : _endpointsNode) {
                    _collection.add(UpdateMetadataEndpointJsonConverter.read(_element, _version));
                }
            }
            JsonNode _rackNode = _node.get("rack");
            if (_rackNode == null) {
                if (_version >= 2) {
                    throw new RuntimeException("UpdateMetadataBroker: unable to locate field 'rack', which is mandatory in version " + _version);
                }
                _object.rack = "";
            } else if (_rackNode.isNull()) {
                _object.rack = null;
            } else {
                if (!_rackNode.isTextual()) {
                    throw new RuntimeException("UpdateMetadataBroker expected a string type, but got " + _node.getNodeType());
                }
                _object.rack = _rackNode.asText();
            }
            JsonNode _tagsNode = _node.get("tags");
            if (_tagsNode == null) {
                _object.tags = new ArrayList<UpdateMetadataRequestData.Tag>(0);
            } else {
                if (!_tagsNode.isArray()) {
                    throw new RuntimeException("UpdateMetadataBroker expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<UpdateMetadataRequestData.Tag> _collection = new ArrayList<UpdateMetadataRequestData.Tag>(_tagsNode.size());
                _object.tags = _collection;
                for (JsonNode _element : _tagsNode) {
                    _collection.add(TagJsonConverter.read(_element, _version));
                }
            }
            return _object;
        }

        public static JsonNode write(UpdateMetadataRequestData.UpdateMetadataBroker _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("id", (JsonNode)new IntNode(_object.id));
            if (_version <= 0) {
                _node.set("v0Host", (JsonNode)new TextNode(_object.v0Host));
            }
            if (_version <= 0) {
                _node.set("v0Port", (JsonNode)new IntNode(_object.v0Port));
            }
            if (_version >= 1) {
                ArrayNode _endpointsArray = new ArrayNode(JsonNodeFactory.instance);
                for (UpdateMetadataRequestData.UpdateMetadataEndpoint updateMetadataEndpoint : _object.endpoints) {
                    _endpointsArray.add(UpdateMetadataEndpointJsonConverter.write(updateMetadataEndpoint, _version, _serializeRecords));
                }
                _node.set("endpoints", (JsonNode)_endpointsArray);
            }
            if (_version >= 2) {
                if (_object.rack == null) {
                    _node.set("rack", (JsonNode)NullNode.instance);
                } else {
                    _node.set("rack", (JsonNode)new TextNode(_object.rack));
                }
            }
            if (_version >= 6 && !_object.tags.isEmpty()) {
                ArrayNode _tagsArray = new ArrayNode(JsonNodeFactory.instance);
                for (UpdateMetadataRequestData.Tag tag : _object.tags) {
                    _tagsArray.add(TagJsonConverter.write(tag, _version, _serializeRecords));
                }
                _node.set("tags", (JsonNode)_tagsArray);
            }
            return _node;
        }

        public static JsonNode write(UpdateMetadataRequestData.UpdateMetadataBroker _object, short _version) {
            return UpdateMetadataBrokerJsonConverter.write(_object, _version, true);
        }
    }

    public static class TagJsonConverter {
        public static UpdateMetadataRequestData.Tag read(JsonNode _node, short _version) {
            UpdateMetadataRequestData.Tag _object = new UpdateMetadataRequestData.Tag();
            if (_version < 6) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Tag");
            }
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("Tag: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("Tag expected a string type, but got " + _node.getNodeType());
            }
            _object.name = _nameNode.asText();
            JsonNode _valueNode = _node.get("value");
            if (_valueNode == null) {
                throw new RuntimeException("Tag: unable to locate field 'value', which is mandatory in version " + _version);
            }
            if (!_valueNode.isTextual()) {
                throw new RuntimeException("Tag expected a string type, but got " + _node.getNodeType());
            }
            _object.value = _valueNode.asText();
            return _object;
        }

        public static JsonNode write(UpdateMetadataRequestData.Tag _object, short _version, boolean _serializeRecords) {
            if (_version < 6) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of Tag");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(_object.name));
            _node.set("value", (JsonNode)new TextNode(_object.value));
            return _node;
        }

        public static JsonNode write(UpdateMetadataRequestData.Tag _object, short _version) {
            return TagJsonConverter.write(_object, _version, true);
        }
    }

    public static class MirrorTopicMetadataJsonConverter {
        public static UpdateMetadataRequestData.MirrorTopicMetadata read(JsonNode _node, short _version) {
            UpdateMetadataRequestData.MirrorTopicMetadata _object = new UpdateMetadataRequestData.MirrorTopicMetadata();
            if (_version < 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MirrorTopicMetadata");
            }
            JsonNode _linkIdNode = _node.get("linkId");
            if (_linkIdNode == null) {
                throw new RuntimeException("MirrorTopicMetadata: unable to locate field 'linkId', which is mandatory in version " + _version);
            }
            if (!_linkIdNode.isTextual()) {
                throw new RuntimeException("MirrorTopicMetadata expected a JSON string type, but got " + _node.getNodeType());
            }
            _object.linkId = Uuid.fromString(_linkIdNode.asText());
            JsonNode _stateNode = _node.get("state");
            if (_stateNode == null) {
                throw new RuntimeException("MirrorTopicMetadata: unable to locate field 'state', which is mandatory in version " + _version);
            }
            if (!_stateNode.isTextual()) {
                throw new RuntimeException("MirrorTopicMetadata expected a string type, but got " + _node.getNodeType());
            }
            _object.state = _stateNode.asText();
            return _object;
        }

        public static JsonNode write(UpdateMetadataRequestData.MirrorTopicMetadata _object, short _version, boolean _serializeRecords) {
            if (_version < 7) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MirrorTopicMetadata");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("linkId", (JsonNode)new TextNode(_object.linkId.toString()));
            _node.set("state", (JsonNode)new TextNode(_object.state));
            return _node;
        }

        public static JsonNode write(UpdateMetadataRequestData.MirrorTopicMetadata _object, short _version) {
            return MirrorTopicMetadataJsonConverter.write(_object, _version, true);
        }
    }
}

